/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductBuyCategoryEntity;
import com.bringspring.crm.entity.CrmProductBuyEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.entity.ShProductRelationEntity;
import com.bringspring.crm.model.crmcustomer.CrmCustomerInfoVO;
import com.bringspring.crm.model.crmcustomer.CrmCustomerListVO;
import com.bringspring.crm.model.crmproduct.CrmProductInfoVO;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryListVO;
import com.bringspring.crm.model.crmproductrelation.CrmProducRelationGroupByCompanyVO;
import com.bringspring.crm.model.crmproductrelation.CrmProductInspectVO;
import com.bringspring.crm.model.crmproductrelation.CrmProductRelationCrForm;
import com.bringspring.crm.model.crmproductrelation.CrmProductRelationInfoVO;
import com.bringspring.crm.model.crmproductrelation.CrmProductRelationListVO;
import com.bringspring.crm.model.crmproductrelation.CrmProductRelationPagination;
import com.bringspring.crm.model.crmproductrelation.CrmProductRelationUpForm;
import com.bringspring.crm.model.crmproductrelation.CrmProductStopVO;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductBuyCategoryService;
import com.bringspring.crm.service.CrmProductBuyService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.ShProductRelationService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u5173\u8054\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductRelation"})
public class CrmProductRelationController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductRelationController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductBuyCategoryService crmProductBuyCategoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductBuyService crmProductBuyService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private ShProductRelationService shProductRelationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductRelationPagination crmProductRelationPagination) throws IOException {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty((Object)crmProductRelationPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductRelationPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductRelationPagination.getCategoryIdList().addAll(collect);
        }
        UserInfo userInfo = this.userProvider.get();
        List<CrmProductRelationEntity> list = this.crmProductRelationService.getList(crmProductRelationPagination);
        list = list.stream().sorted(Comparator.comparing(CrmProductRelationEntity::getProductId)).collect(Collectors.toList());
        for (CrmProductRelationEntity crmProductRelationEntity : list) {
            crmProductRelationEntity.setSalesmanId(this.baseDataUtil.userSelectValue(crmProductRelationEntity.getSalesmanId()));
            crmProductRelationEntity.setEnabledMark(this.baseDataUtil.getDictName(crmProductRelationEntity.getEnabledMark(), "acceptancephase"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmProductRelationListVO.class);
        for (CrmProductRelationListVO crmProductRelationVO : listVO) {
            OrganizeCrModel jsonToBean;
            OrganizeEntity info;
            CrmProductEntity crmProductEntity = this.crmProductRelationService.getCrmProduct(crmProductRelationVO.getProductId());
            if (ObjectUtil.isNotEmpty((Object)crmProductEntity)) {
                crmProductRelationVO.setCrmProduct((CrmProductInfoVO)JsonUtil.getJsonToBean((Object)crmProductEntity, CrmProductInfoVO.class));
                CrmProductCategoryEntity productCompany = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductCategoryEntity::getId, (Object)crmProductEntity.getCategoryId()));
                if (!ObjectUtil.isEmpty((Object)productCompany)) {
                    info = this.organizeService.getInfo(productCompany.getParentId());
                    jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                    crmProductRelationVO.setProductCompany(jsonToBean.getShortName());
                }
            } else {
                CrmProductBuyEntity buyEntity = this.crmProductBuyService.getInfo(crmProductRelationVO.getProductId());
                crmProductRelationVO.setCrmProduct((CrmProductInfoVO)JsonUtil.getJsonToBean((Object)buyEntity, CrmProductInfoVO.class));
                info = this.organizeService.getInfo(crmProductRelationVO.getCompanyId());
                jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                crmProductRelationVO.setProductCompany(jsonToBean.getShortName());
            }
            CrmCustomerEntity crmCustomerEntity = this.crmProductRelationService.getCrmCustomer(crmProductRelationVO.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)crmCustomerEntity)) {
                crmProductRelationVO.setCrmCustomer((CrmCustomerInfoVO)JsonUtil.getJsonToBean((Object)crmCustomerEntity, CrmCustomerInfoVO.class));
            }
            crmProductRelationVO.setStopUser(this.baseDataUtil.userSelectValueNoAccount(crmProductRelationVO.getStopUser()));
            crmProductRelationVO.setNotInspectUser(this.baseDataUtil.userSelectValueNoAccount(crmProductRelationVO.getNotInspectUser()));
            crmProductRelationVO.setStartUser(this.baseDataUtil.userSelectValueNoAccount(crmProductRelationVO.getStartUser()));
            crmProductRelationVO.setStopReasonType(this.baseDataUtil.getDictName(crmProductRelationVO.getStopReasonType(), "productStopReasonType"));
            crmProductRelationVO.setStartReasonType(this.baseDataUtil.getDictName(crmProductRelationVO.getStartReasonType(), "productStartReasonType"));
            crmProductRelationVO.setCreatorUserId(this.baseDataUtil.userSelectValue(crmProductRelationVO.getCreatorUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductRelationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @NotCheckLogin
    @GetMapping(value={"/getByCustomerIdGroupByCompany/{customerId}"})
    public ActionResult getByCustomerIdGroupByCompany(@PathVariable(value="customerId") String customerId, String companyId) {
        List<CrmProductRelationEntity> listByCustomerId = this.crmProductRelationService.getListByCustomerId(customerId);
        List listVO = JsonUtil.getJsonToList(listByCustomerId, CrmProductRelationListVO.class);
        ArrayList newList = new ArrayList();
        listVO.stream().forEach(vo -> {
            CrmProductEntity byId = (CrmProductEntity)this.crmProductService.getById((Serializable)((Object)vo.getProductId()));
            vo.setName(byId.getProductName());
            CrmProductCategoryEntity categoryEntity = (CrmProductCategoryEntity)this.crmProductCategoryService.getById((Serializable)((Object)byId.getCategoryId()));
            if (StrUtil.isNotEmpty((CharSequence)companyId) && !StrUtil.equals((CharSequence)categoryEntity.getParentId(), (CharSequence)companyId)) {
                return;
            }
            vo.setCompanyId(categoryEntity.getParentId());
            vo.setParentId(categoryEntity.getParentId());
            vo.setId(vo.getProductId());
            newList.add(vo);
        });
        Map<String, List<CrmProductRelationListVO>> collect = newList.stream().collect(Collectors.groupingBy(CrmProductRelationListVO::getCompanyId));
        List returnList = CollectionUtil.list((boolean)false);
        for (String str : collect.keySet()) {
            CrmProductCategoryListVO vo2 = new CrmProductCategoryListVO();
            vo2.setId(str);
            vo2.setName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)str))).getFullName());
            vo2.setChild(collect.get(str));
            returnList.add(vo2);
        }
        return ActionResult.success((Object)returnList);
    }

    @GetMapping(value={"getListGroupByCompany"})
    public ActionResult getListGroupByCompany() {
        List<CrmProducRelationGroupByCompanyVO> listGroupByCompany = this.crmProductRelationService.getListGroupByCompany(null);
        Map<String, List<CrmProducRelationGroupByCompanyVO>> collect = listGroupByCompany.stream().collect(Collectors.groupingBy(CrmProducRelationGroupByCompanyVO::getParentId));
        List list = CollectionUtil.list((boolean)false);
        HashMap map2 = MapUtil.newHashMap();
        map2.put("id", "");
        map2.put("name", "\u8363\u79d1");
        list.add(map2);
        for (String str : collect.keySet()) {
            HashMap map = MapUtil.newHashMap();
            map.put("id", str);
            map.put("name", ((OrganizeEntity)this.organizeService.getById((Serializable)((Object)str))).getFullName());
            list.add(map);
        }
        return ActionResult.success((Object)list);
    }

    @PostMapping(value={"getListByCompanyId"})
    public ActionResult getListByCompanyId(@RequestBody CrmProductRelationPagination productRelationPagination) {
        List<CrmProducRelationGroupByCompanyVO> listGroupByCompany = this.crmProductRelationService.getListGroupByCompany(productRelationPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listGroupByCompany);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)productRelationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"getCustomerIdByProductId"})
    public ActionResult getCustomerIdByProductId(@RequestBody List<CrmProducRelationGroupByCompanyVO> companyVOList) {
        List collect1 = companyVOList.stream().map(CrmProducRelationGroupByCompanyVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CrmProductRelationEntity::getProductId, collect1);
        List list = this.crmProductRelationService.list((Wrapper)queryWrapper);
        List collect = list.stream().map(CrmProductRelationEntity::getCustomerId).distinct().collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    @PostMapping(value={"/stop"})
    public ActionResult stop(@RequestBody CrmProductStopVO stopVO) {
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isEmpty((CharSequence)stopVO.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u505c\u7528\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55");
        }
        if (StrUtil.isEmpty((CharSequence)stopVO.getStopReasonType())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u505c\u7528\u539f\u56e0");
        }
        CrmProductRelationEntity byId = (CrmProductRelationEntity)this.crmProductRelationService.getById((Serializable)((Object)stopVO.getId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return ActionResult.fail((String)"\u9009\u62e9\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (byId.getIsStop() == 1) {
            return ActionResult.fail((String)"\u8be5\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55\u5df2\u7ecf\u505c\u7528");
        }
        byId.setIsStop(1);
        byId.setIsInspect(0);
        byId.setNotInspectReason("\u4ea7\u54c1\u505c\u7528");
        byId.setStopRemark(stopVO.getStopRemark());
        byId.setStopReasonType(stopVO.getStopReasonType());
        byId.setStopUser(userInfo.getUserId());
        byId.setStopTime(DateUtil.getNowDate());
        this.crmProductRelationService.update(stopVO.getId(), byId);
        return ActionResult.success((String)"\u505c\u7528\u6210\u529f");
    }

    @PostMapping(value={"/start"})
    public ActionResult start(@RequestBody CrmProductStopVO stopVO) {
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isEmpty((CharSequence)stopVO.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55");
        }
        if (StrUtil.isEmpty((CharSequence)stopVO.getStopReasonType())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u542f\u7528\u539f\u56e0");
        }
        CrmProductRelationEntity byId = (CrmProductRelationEntity)this.crmProductRelationService.getById((Serializable)((Object)stopVO.getId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return ActionResult.fail((String)"\u9009\u62e9\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (byId.getIsStop() != 1) {
            return ActionResult.fail((String)"\u8be5\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55\u4e0d\u662f\u505c\u7528\u72b6\u6001");
        }
        byId.setIsStop(0);
        byId.setStartRemark(stopVO.getStopRemark());
        byId.setStartReasonType(stopVO.getStopReasonType());
        byId.setStopReasonType(null);
        byId.setNotInspectReason(null);
        byId.setStopRemark(null);
        byId.setStartUser(userInfo.getUserId());
        byId.setStartTime(DateUtil.getNowDate());
        this.crmProductRelationService.update(stopVO.getId(), byId);
        return ActionResult.success((String)"\u542f\u7528\u6210\u529f");
    }

    @PostMapping(value={"/updateInspect"})
    public ActionResult updateInspect(@RequestBody CrmProductInspectVO inspectVO) {
        if (StrUtil.isEmpty((CharSequence)inspectVO.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u505c\u7528\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55");
        }
        CrmProductRelationEntity byId = (CrmProductRelationEntity)this.crmProductRelationService.getById((Serializable)((Object)inspectVO.getId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return ActionResult.fail((String)"\u9009\u62e9\u7684\u4ea7\u54c1\u4f7f\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        byId.setIsInspect(inspectVO.getIsInspect());
        if (inspectVO.getIsInspect() == 0) {
            byId.setNotInspectTime(new Date());
            byId.setNotInspectUser(this.userProvider.get().getUserId());
        }
        byId.setNotInspectReason(inspectVO.getNotInspectReason());
        this.crmProductRelationService.update(inspectVO.getId(), byId);
        return ActionResult.success((String)"\u4fee\u6539\u662f\u5426\u5de1\u68c0\u72b6\u6001\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductRelationCrForm crmProductRelationCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            List list = this.crmProductRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)crmProductRelationCrForm.getCustomerId())).eq(CrmProductRelationEntity::getProductId, (Object)crmProductRelationCrForm.getProductId()));
            if (list.size() > 0) {
                return ActionResult.success((Object)list);
            }
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            CrmProductRelationEntity entity = (CrmProductRelationEntity)JsonUtil.getJsonToBean((Object)crmProductRelationCrForm, CrmProductRelationEntity.class);
            entity.setId(mainId);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            if (entity.getIsStop() == 1) {
                entity.setStopTime(DateUtil.getNowDate());
                entity.setStopUser(userInfo.getUserId());
            }
            this.crmProductRelationService.save(entity);
            this.crmCustomerCompanyRelationService.updateByAddProduct(crmProductRelationCrForm.getProductId(), crmProductRelationCrForm.getCustomerId());
            CrmCustomerEntity company = (CrmCustomerEntity)this.crmCustomerService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmCustomerEntity::getId, (Object)crmProductRelationCrForm.getCustomerId()));
            if (!ObjectUtil.isEmpty((Object)company) && !"company".equals(company.getEnabledMark())) {
                company.setEnabledMark("company");
                this.crmCustomerService.update(company.getId(), company);
            }
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @PostMapping(value={"/bathImportSh"})
    public ActionResult batch() throws Exception {
        List list = this.shProductRelationService.list();
        for (ShProductRelationEntity relationEntity : list) {
            if (ObjectUtil.isEmpty((Object)relationEntity.getCustomerId()) || ObjectUtil.isEmpty((Object)relationEntity.getProductId()) || ObjectUtil.isEmpty((Object)relationEntity.getSalesmanId()) || ObjectUtil.isEmpty((Object)relationEntity.getOnlineTime())) continue;
            CrmProductRelationCrForm jsonToBean = (CrmProductRelationCrForm)JsonUtil.getJsonToBean((Object)relationEntity, CrmProductRelationCrForm.class);
            this.create(jsonToBean);
        }
        return ActionResult.success();
    }

    @RequestMapping(value={"batchCreate"})
    @PostMapping
    public ActionResult batchCreate(@RequestBody @Valid HashMap map) throws DataException {
        Object data = map.get("data");
        String id = (String)map.get("customerId");
        List jsonToList = JsonUtil.getJsonToList(data, CrmProductEntity.class);
        List collect = jsonToList.stream().map(CrmProductEntity::getId).collect(Collectors.toList());
        CrmProductRelationEntity crmProductRelationEntity = new CrmProductRelationEntity();
        crmProductRelationEntity.setCustomerId(id);
        for (String s : collect) {
            crmProductRelationEntity.setProductId(s);
            String mainId = RandomUtil.uuId();
            crmProductRelationEntity.setId(mainId);
            this.crmProductRelationService.save(crmProductRelationEntity);
        }
        return ActionResult.success((String)"\u5173\u8054\u6210\u529f\uff01");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductRelationInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductRelationEntity entity = this.crmProductRelationService.getInfo(id);
        CrmProductRelationInfoVO vo = (CrmProductRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductRelationInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getSalesmanId())) {
            vo.setSalesmanPhone(this.baseDataUtil.userSelectValue(vo.getSalesmanId()));
        }
        QueryWrapper queryWrapperCrmProduct = new QueryWrapper();
        queryWrapperCrmProduct.lambda().eq(CrmProductEntity::getId, (Object)entity.getProductId());
        CrmProductEntity crm_productEntity = (CrmProductEntity)this.crmProductService.getOne((Wrapper)queryWrapperCrmProduct);
        if (ObjectUtil.isEmpty((Object)crm_productEntity)) {
            QueryWrapper queryWrapperCrmProductBuy = new QueryWrapper();
            queryWrapperCrmProductBuy.lambda().eq(CrmProductBuyEntity::getId, (Object)entity.getProductId());
            CrmProductBuyEntity crm_productBuyEntity = (CrmProductBuyEntity)this.crmProductBuyService.getOne((Wrapper)queryWrapperCrmProductBuy);
            QueryWrapper productCategoryWrapperCrmProductBuy = new QueryWrapper();
            productCategoryWrapperCrmProductBuy.lambda().eq(CrmProductBuyCategoryEntity::getId, (Object)crm_productBuyEntity.getCategoryId());
            CrmProductBuyCategoryEntity category = (CrmProductBuyCategoryEntity)this.crmProductBuyCategoryService.getOne((Wrapper)productCategoryWrapperCrmProductBuy);
            CrmProductInfoVO jsonToBean = (CrmProductInfoVO)JsonUtil.getJsonToBean((Object)crm_productBuyEntity, CrmProductInfoVO.class);
            jsonToBean.setCategoryName(category.getName());
            vo.setCrmProduct(jsonToBean);
        } else {
            QueryWrapper productCategoryWrapperCrmProduct = new QueryWrapper();
            productCategoryWrapperCrmProduct.lambda().eq(CrmProductCategoryEntity::getId, (Object)crm_productEntity.getCategoryId());
            CrmProductCategoryEntity category = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)productCategoryWrapperCrmProduct);
            CrmProductInfoVO jsonToBean = (CrmProductInfoVO)JsonUtil.getJsonToBean((Object)crm_productEntity, CrmProductInfoVO.class);
            jsonToBean.setCategoryName(category.getName());
            vo.setCrmProduct(jsonToBean);
        }
        QueryWrapper queryWrapperCrmCustomer = new QueryWrapper();
        queryWrapperCrmCustomer.lambda().eq(CrmCustomerEntity::getId, (Object)entity.getCustomerId());
        CrmCustomerEntity crm_customerEntity = (CrmCustomerEntity)this.crmCustomerService.getOne((Wrapper)queryWrapperCrmCustomer);
        vo.setCrmCustomer((CrmCustomerInfoVO)JsonUtil.getJsonToBean((Object)crm_customerEntity, CrmCustomerInfoVO.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductRelationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductRelationEntity entity = this.crmProductRelationService.getInfo(id);
        CrmProductRelationInfoVO vo = (CrmProductRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductRelationUpForm crmProductRelationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductRelationEntity entity = this.crmProductRelationService.getInfo(id);
        if (entity != null) {
            CrmProductRelationEntity subentity = (CrmProductRelationEntity)JsonUtil.getJsonToBean((Object)crmProductRelationUpForm, CrmProductRelationEntity.class);
            if (subentity.getIsStop() == 1) {
                subentity.setStopTime(DateUtil.getNowDate());
                subentity.setStopUser(userInfo.getUserId());
            }
            this.crmProductRelationService.update(id, subentity);
            if (!StrUtil.equals((CharSequence)crmProductRelationUpForm.getProductId(), (CharSequence)entity.getProductId()) || !StrUtil.equals((CharSequence)crmProductRelationUpForm.getCustomerId(), (CharSequence)entity.getCustomerId())) {
                this.crmCustomerCompanyRelationService.updateByRemoveProduct(entity.getProductId(), entity.getCustomerId());
                this.crmCustomerCompanyRelationService.updateByAddProduct(crmProductRelationUpForm.getProductId(), crmProductRelationUpForm.getCustomerId());
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"delete"})
    @DSTransactional
    public ActionResult delete(@RequestBody CrmProductInfoVO crmProductInfoVO) {
        CrmProductRelationEntity entity = this.crmProductRelationService.getInfoByProductId(crmProductInfoVO.getId(), crmProductInfoVO.getProductCode());
        if (entity != null) {
            this.crmProductRelationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductRelationEntity entity = this.crmProductRelationService.getInfo(id);
        if (entity != null) {
            this.crmProductRelationService.delete(entity);
            this.crmCustomerCompanyRelationService.updateByRemoveProduct(entity.getProductId(), entity.getCustomerId());
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/judgeCompanyProduct/{productId}"})
    @DSTransactional
    public ActionResult judgeCompanyProduct(@PathVariable(value="productId") String productId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(UserRelationEntity::getUserId, (Object)userInfo.getUserId());
        query.lambda().eq(UserRelationEntity::getObjectType, (Object)"Organize");
        ArrayList organizeIds = new ArrayList();
        this.userRelationService.list((Wrapper)query).forEach(u -> organizeIds.add(u.getObjectId()));
        List orgIdsTree = PermissionUtil.getOrgIdsTree(organizeIds, (Integer)1, (OrganizeService)this.organizeService);
        CrmProductEntity oneProduct = (CrmProductEntity)this.crmProductService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductEntity::getId, (Object)productId));
        CrmProductCategoryEntity oneCategory = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductCategoryEntity::getId, (Object)oneProduct.getCategoryId()));
        Boolean flag = false;
        for (LinkedList organizeId : orgIdsTree) {
            if (!organizeId.contains(oneCategory.getParentId())) continue;
            flag = true;
        }
        CrmProductInfoVO vo = (CrmProductInfoVO)JsonUtil.getJsonToBean((Object)oneProduct, CrmProductInfoVO.class);
        vo.setCategoryName(oneCategory.getName());
        if (flag.booleanValue()) {
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success();
    }

    @PostMapping(value={"judgeProductRepeat"})
    @DSTransactional
    public ActionResult judgeProductRepeat(@RequestBody CrmProductRelationCrForm crmProductRelationCrForm) {
        List list = this.crmProductRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)crmProductRelationCrForm.getCustomerId())).eq(CrmProductRelationEntity::getCustomerId, (Object)crmProductRelationCrForm.getProductId()));
        if (list.size() > 0) {
            return ActionResult.success((Object)list);
        }
        return ActionResult.success();
    }

    @PostMapping(value={"getProductBelongCustomer"})
    public ActionResult getProductBelongCustomer(@RequestBody List<CrmCustomerListVO> customerList) {
        customerList.stream().forEach(customer -> {
            List<HashMap> productList;
            List<String> id1;
            String id = customer.getId();
            List<CrmProductRelationEntity> listByCustomerIdAndProductList = this.crmProductRelationService.getListByCustomerIdAndProductList(id, id1 = (productList = customer.getProductList()).stream().map(map -> map.get("id").toString()).collect(Collectors.toList()));
            if (CollectionUtil.isNotEmpty(listByCustomerIdAndProductList)) {
                List collect = listByCustomerIdAndProductList.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
                List<HashMap> id2 = productList.stream().filter(map -> collect.contains(map.get("id").toString())).collect(Collectors.toList());
                String productName = id2.stream().map(map -> map.get("productName").toString()).collect(Collectors.joining(","));
                customer.setProductList(id2);
                customer.setProductNames(productName);
                customer.setIsInspect(1);
            } else {
                customer.setIsInspect(0);
            }
        });
        List collect = customerList.stream().filter(customer -> customer.getIsInspect() == 1).collect(Collectors.toList());
        return ActionResult.success(collect);
    }
}

