/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductUserEntity;
import com.bringspring.crm.model.crmproductuser.CrmProductUserCrForm;
import com.bringspring.crm.model.crmproductuser.CrmProductUserInfoVO;
import com.bringspring.crm.model.crmproductuser.CrmProductUserListVO;
import com.bringspring.crm.model.crmproductuser.CrmProductUserPagination;
import com.bringspring.crm.model.crmproductuser.CrmProductUserUpForm;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductUserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"crm_product_user"}, value="system")
@RequestMapping(value={"/api/crm/CrmProductUser"})
public class CrmProductUserController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductUserController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductUserService crmProductUserService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductUserPagination crmProductUserPagination) throws IOException {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty(crmProductUserPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductUserPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductUserPagination.getCategoryIdList().addAll(collect);
        }
        List<CrmProductUserEntity> list = this.crmProductUserService.getList(crmProductUserPagination);
        for (CrmProductUserEntity entity : list) {
            entity.setProductManager(this.baseDataUtil.userSelectValues(entity.getProductManager()));
            entity.setExploitHead(this.baseDataUtil.userSelectValues(entity.getExploitHead()));
            entity.setProjectProblemId(this.baseDataUtil.getDictName(entity.getProjectProblemId(), "656791136572130245"));
            entity.setTestHead(this.baseDataUtil.userSelectValues(entity.getTestHead()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmProductUserListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductUserPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmProductUserCrForm crmProductUserCrForm) throws DataException {
        if (CollectionUtil.isNotEmpty(crmProductUserCrForm.getProductList())) {
            for (String productId : crmProductUserCrForm.getProductList()) {
                CrmProductUserEntity byProductId = this.crmProductUserService.getByProductId(productId);
                if (!ObjectUtil.isNotEmpty((Object)byProductId)) continue;
                return ActionResult.fail((String)("[" + byProductId.getProductName() + "]\u4ea7\u54c1\u8d1f\u8d23\u4eba\u7528\u6237\u5df2\u5b58\u5728"));
            }
        }
        this.crmProductUserService.create(crmProductUserCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/byProductId/{id}"})
    public ActionResult byProductId(@PathVariable(value="id") String id) {
        List<CrmProductUserEntity> entity = this.crmProductUserService.getByProjectProblemId(id);
        List jsonToList = JsonUtil.getJsonToList(entity, CrmProductUserListVO.class);
        return ActionResult.success((Object)jsonToList);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductUserInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductUserEntity entity = this.crmProductUserService.getInfo(id);
        CrmProductUserInfoVO vo = (CrmProductUserInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductUserInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductUserInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductUserEntity entity = this.crmProductUserService.getInfo(id);
        CrmProductUserInfoVO vo = (CrmProductUserInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductUserInfoVO.class);
        vo.setProductManager(this.baseDataUtil.userSelectValues(vo.getProductManager()));
        vo.setExploitHead(this.baseDataUtil.userSelectValues(vo.getExploitHead()));
        vo.setProjectProblemId(this.baseDataUtil.getDictName(vo.getProjectProblemId(), "656791136572130245"));
        vo.setTestHead(this.baseDataUtil.userSelectValues(vo.getTestHead()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductUserUpForm crmProductUserUpForm) throws DataException {
        this.crmProductUserService.update(id, crmProductUserUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductUserEntity entity = this.crmProductUserService.getInfo(id);
        if (entity != null) {
            this.crmProductUserService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

