/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionCrForm;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionInfoVO;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionPagination;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionUpForm;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u7248\u672c\u7ba1\u7406"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductVersion"})
public class CrmProductVersionController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductVersionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductVersionService crmProductVersionService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductVersionPagination crmProductVersionPagination) throws IOException {
        List<CrmProductVersionEntity> list = this.crmProductVersionService.getList(crmProductVersionPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductVersionListVO.class);
        for (CrmProductVersionListVO crmProductVersionVO : listVO) {
            crmProductVersionVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(crmProductVersionVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductVersionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductVersionCrForm crmProductVersionCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmProductVersionEntity entity = (CrmProductVersionEntity)JsonUtil.getJsonToBean((Object)crmProductVersionCrForm, CrmProductVersionEntity.class);
        entity.setId(mainId);
        this.crmProductVersionService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductVersionInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductVersionEntity entity = this.crmProductVersionService.getInfo(id);
        CrmProductVersionInfoVO vo = (CrmProductVersionInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductVersionInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/byProductIdList/{id}"})
    public ActionResult ByProductIdList(@PathVariable(value="id") String id) {
        List<CrmProductVersionEntity> list = this.crmProductVersionService.getListByProductId(id);
        List listVO = JsonUtil.getJsonToList(list, CrmProductVersionListVO.class);
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductVersionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductVersionEntity entity = this.crmProductVersionService.getInfo(id);
        CrmProductVersionInfoVO vo = (CrmProductVersionInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductVersionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductVersionUpForm crmProductVersionUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductVersionEntity entity = this.crmProductVersionService.getInfo(id);
        if (entity != null) {
            CrmProductVersionEntity subentity = (CrmProductVersionEntity)JsonUtil.getJsonToBean((Object)crmProductVersionUpForm, CrmProductVersionEntity.class);
            this.crmProductVersionService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductVersionEntity entity = this.crmProductVersionService.getInfo(id);
        if (entity != null) {
            this.crmProductVersionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

