/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmFileEntity;
import com.bringspring.crm.entity.CrmQualificationLibraryEntity;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryCrForm;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryInfoVO;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryListVO;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryPagination;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryPaginationExportModel;
import com.bringspring.crm.model.crmQualificationLibrary.CrmQualificationLibraryUpForm;
import com.bringspring.crm.service.CrmQualificationLibraryService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u8d28\u5e93"}, value="crm")
@RequestMapping(value={"/api/crm/CrmQualificationLibrary"})
public class CrmQualificationLibraryController {
    private static final Logger log = LoggerFactory.getLogger(CrmQualificationLibraryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmQualificationLibraryService crmQualificationLibraryService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmQualificationLibraryPagination crmQualificationLibraryPagination) throws IOException {
        List<CrmQualificationLibraryEntity> list = this.crmQualificationLibraryService.getList(crmQualificationLibraryPagination);
        for (CrmQualificationLibraryEntity crmQualificationLibraryEntity : list) {
            crmQualificationLibraryEntity.setAttachments(this.baseDataUtil.getFileNameInJson(crmQualificationLibraryEntity.getAttachments()));
            crmQualificationLibraryEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmQualificationLibraryEntity.getCreatorUserId()));
            crmQualificationLibraryEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmQualificationLibraryEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmQualificationLibraryListVO.class);
        for (CrmQualificationLibraryListVO crmQualificationLibraryVO : listVO) {
            crmQualificationLibraryVO.setCompanyName(this.baseDataUtil.getDictName(crmQualificationLibraryVO.getCompanyId(), "companyName"));
            List attList = JsonUtil.getJsonToList((String)crmQualificationLibraryVO.getAttachments(), CrmFileEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)attList)) {
                crmQualificationLibraryVO.setAttachmentsStatus("\u5df2\u4e0a\u4f20");
                continue;
            }
            crmQualificationLibraryVO.setAttachmentsStatus("\u672a\u4e0a\u4f20");
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmQualificationLibraryPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException {
        CrmQualificationLibraryCrForm crmQualificationLibraryCrForm = (CrmQualificationLibraryCrForm)JsonUtil.getJsonToBean(crData, CrmQualificationLibraryCrForm.class);
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmQualificationLibraryCrForm.setCreatorUserId(userInfo.getUserId());
        crmQualificationLibraryCrForm.setCreatorTime(DateUtil.getNow());
        crmQualificationLibraryCrForm.setOwnerName(this.baseDataUtil.getDictName(crmQualificationLibraryCrForm.getOwner(), "ownerNameType"));
        CrmQualificationLibraryEntity entity = (CrmQualificationLibraryEntity)JsonUtil.getJsonToBean((Object)crmQualificationLibraryCrForm, CrmQualificationLibraryEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setEnabledMark(0);
        this.crmQualificationLibraryService.save(entity);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmQualificationLibraryPaginationExportModel crmQualificationLibraryPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmQualificationLibraryPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmQualificationLibraryPagination crmQualificationLibraryPagination = (CrmQualificationLibraryPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmQualificationLibraryPaginationExportModel), CrmQualificationLibraryPagination.class));
        List<CrmQualificationLibraryEntity> list = this.crmQualificationLibraryService.getTypeList(crmQualificationLibraryPagination, crmQualificationLibraryPaginationExportModel.getDataType());
        for (CrmQualificationLibraryEntity crmQualificationLibraryEntity : list) {
            crmQualificationLibraryEntity.setOwner(this.baseDataUtil.getDictName(crmQualificationLibraryEntity.getOwner(), "ownerNameType"));
            crmQualificationLibraryEntity.setAttachments(this.baseDataUtil.getFileNameInJson(crmQualificationLibraryEntity.getAttachments()));
            crmQualificationLibraryEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmQualificationLibraryEntity.getCreatorUserId()));
            crmQualificationLibraryEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmQualificationLibraryEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmQualificationLibraryListVO.class);
        for (CrmQualificationLibraryListVO crmQualificationLibraryVO : listVO) {
            List attList = JsonUtil.getJsonToList((String)crmQualificationLibraryVO.getAttachments(), CrmFileEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)attList)) {
                crmQualificationLibraryVO.setAttachmentsStatus("\u5df2\u4e0a\u4f20");
                continue;
            }
            crmQualificationLibraryVO.setAttachmentsStatus("\u672a\u4e0a\u4f20");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmQualificationLibraryPaginationExportModel.getSelectKey()) ? crmQualificationLibraryPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "qualificationName": {
                        entitys.add(new ExcelExportEntity("\u8d44\u8d28\u540d\u79f0", (Object)"qualificationName"));
                        continue block40;
                    }
                    case "issueNumber": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u4e66\u7f16\u53f7", (Object)"issueNumber"));
                        continue block40;
                    }
                    case "issueDate": {
                        entitys.add(new ExcelExportEntity("\u53d1\u8bc1\u65e5\u671f", (Object)"issueDate"));
                        continue block40;
                    }
                    case "deadLineDate": {
                        entitys.add(new ExcelExportEntity("\u5230\u671f\u65e5\u671f", (Object)"deadLineDate"));
                        continue block40;
                    }
                    case "owner": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u7167\u4e3b\u4f53", (Object)"owner"));
                        continue block40;
                    }
                    case "number": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u7167\u6570\u91cf", (Object)"number"));
                        continue block40;
                    }
                    case "attachments": {
                        entitys.add(new ExcelExportEntity("\u9644\u4ef6", (Object)"attachments"));
                        continue block40;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block40;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u4eba", (Object)"creatorUserId"));
                        continue block40;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u65e5\u671f", (Object)"creatorTime"));
                        continue block40;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block40;
                    }
                    case "deleteTime": {
                        entitys.add(new ExcelExportEntity("\u5220\u9664\u65f6\u95f4", (Object)"deleteTime"));
                        continue block40;
                    }
                    case "ownerName": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u7167\u4e3b\u4f53", (Object)"ownerName"));
                        continue block40;
                    }
                    case "attachmentsStatus": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"attachmentsStatus"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmQualificationLibraryInfoVO> info(@PathVariable(value="id") String id) {
        CrmQualificationLibraryEntity entity = this.crmQualificationLibraryService.getInfo(id);
        CrmQualificationLibraryInfoVO vo = (CrmQualificationLibraryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmQualificationLibraryInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getDeleteTime() != null) {
            vo.setDeleteTime(vo.getDeleteTime());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        CrmQualificationLibraryUpForm crmQualificationLibraryUpForm = (CrmQualificationLibraryUpForm)JsonUtil.getJsonToBean(upData, CrmQualificationLibraryUpForm.class);
        UserInfo userInfo = this.userProvider.get();
        CrmQualificationLibraryEntity entity = this.crmQualificationLibraryService.getInfo(id);
        if (entity != null) {
            crmQualificationLibraryUpForm.setLastModifyUserId(userInfo.getUserId());
            crmQualificationLibraryUpForm.setDeleteTime(DateUtil.getNow());
            crmQualificationLibraryUpForm.setOwnerName(this.baseDataUtil.getDictName(crmQualificationLibraryUpForm.getOwner(), "ownerNameType"));
            CrmQualificationLibraryEntity subentity = (CrmQualificationLibraryEntity)JsonUtil.getJsonToBean((Object)crmQualificationLibraryUpForm, CrmQualificationLibraryEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCompanyId(entity.getCompanyId());
            subentity.setEnabledMark(0);
            this.crmQualificationLibraryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmQualificationLibraryEntity entity = this.crmQualificationLibraryService.getInfo(id);
        if (entity != null) {
            this.crmQualificationLibraryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

