/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmSupplierEntity;
import com.bringspring.crm.model.crmsupplier.CrmSupplierCrForm;
import com.bringspring.crm.model.crmsupplier.CrmSupplierInfoVO;
import com.bringspring.crm.model.crmsupplier.CrmSupplierListVO;
import com.bringspring.crm.model.crmsupplier.CrmSupplierPagination;
import com.bringspring.crm.model.crmsupplier.CrmSupplierUpForm;
import com.bringspring.crm.service.CrmSupplierService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f9b\u5e94\u5546\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/CrmSupplier"})
public class CrmSupplierController {
    private static final Logger log = LoggerFactory.getLogger(CrmSupplierController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmSupplierService crmSupplierService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmSupplierPagination crmSupplierPagination) throws IOException {
        List<CrmSupplierEntity> list = this.crmSupplierService.getList(crmSupplierPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmSupplierListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmSupplierPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmSupplierCrForm crmSupplierCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmSupplierEntity entity = (CrmSupplierEntity)JsonUtil.getJsonToBean((Object)crmSupplierCrForm, CrmSupplierEntity.class);
        entity.setId(mainId);
        this.crmSupplierService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmSupplierInfoVO> info(@PathVariable(value="id") String id) {
        CrmSupplierEntity entity = this.crmSupplierService.getInfo(id);
        CrmSupplierInfoVO vo = (CrmSupplierInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmSupplierInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmSupplierInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmSupplierEntity entity = this.crmSupplierService.getInfo(id);
        CrmSupplierInfoVO vo = (CrmSupplierInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmSupplierInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmSupplierUpForm crmSupplierUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmSupplierEntity entity = this.crmSupplierService.getInfo(id);
        if (entity != null) {
            CrmSupplierEntity subentity = (CrmSupplierEntity)JsonUtil.getJsonToBean((Object)crmSupplierUpForm, CrmSupplierEntity.class);
            this.crmSupplierService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmSupplierEntity entity = this.crmSupplierService.getInfo(id);
        if (entity != null) {
            this.crmSupplierService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

