/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmproductmessageEntity;
import com.bringspring.crm.model.crmproductmessage.CrmproductmessageCrForm;
import com.bringspring.crm.model.crmproductmessage.CrmproductmessageInfoVO;
import com.bringspring.crm.model.crmproductmessage.CrmproductmessageListVO;
import com.bringspring.crm.model.crmproductmessage.CrmproductmessagePagination;
import com.bringspring.crm.model.crmproductmessage.CrmproductmessageUpForm;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmproductmessageService;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.message.model.message.NoticeInfoVO;
import com.bringspring.system.message.model.message.PaginationMessage;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u53d1\u7248\u516c\u544a"}, value="crm")
@RequestMapping(value={"/api/crm/Crmproductmessage"})
public class CrmproductmessageController {
    private static final Logger log = LoggerFactory.getLogger(CrmproductmessageController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmproductmessageService crmproductmessageService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmProductService crmProductService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u5217\u8868")
    public ActionResult list(@RequestBody CrmproductmessagePagination crmproductmessagePagination) throws IOException {
        List<CrmproductmessageEntity> list = this.crmproductmessageService.getList(crmproductmessagePagination);
        for (CrmproductmessageEntity crmproductmessageEntity : list) {
            crmproductmessageEntity.setFiles(this.baseDataUtil.getFileNameInJson(crmproductmessageEntity.getFiles()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmproductmessageListVO.class);
        for (CrmproductmessageListVO crmproductmessageVO : listVO) {
            crmproductmessageVO.setCreatorUserName(this.baseDataUtil.userSelectValue(crmproductmessageVO.getCreatorUserId()));
            CrmProductEntity info = this.crmProductService.getInfo(crmproductmessageVO.getProductId());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            crmproductmessageVO.setProductName(info.getProductName());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmproductmessagePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmproductmessageCrForm crmproductmessageCrForm) throws DataException {
        this.crmproductmessageService.create(crmproductmessageCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<CrmproductmessageInfoVO> info(@PathVariable(value="id") String id) {
        CrmproductmessageEntity entity = this.crmproductmessageService.getInfo(id);
        CrmproductmessageInfoVO vo = (CrmproductmessageInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmproductmessageInfoVO.class);
        CrmProductEntity info = this.crmProductService.getInfo(vo.getProductId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            vo.setProductName(info.getProductName());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmproductmessageInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmproductmessageEntity entity = this.crmproductmessageService.getInfo(id);
        CrmproductmessageInfoVO vo = (CrmproductmessageInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmproductmessageInfoVO.class);
        vo.setFiles(this.baseDataUtil.getFileNameInJson(vo.getFiles()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmproductmessageUpForm crmproductmessageUpForm) throws DataException {
        this.crmproductmessageService.update(id, crmproductmessageUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u53d1\u7248\u516c\u544a\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmproductmessageEntity entity = this.crmproductmessageService.getInfo(id);
        if (entity != null) {
            this.crmproductmessageService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u53d1\u5e03\u7cfb\u7edf\u516c\u544a")
    @Transactional
    @PutMapping(value={"/sendRelease/{id}"})
    public ActionResult sendRelease(@PathVariable(value="id") String id) throws BaseException {
        this.crmproductmessageService.sendRelease(id);
        return ActionResult.success((String)"\u53d1\u5e03\u6210\u529f");
    }

    @ApiOperation(value="\u53ea\u83b7\u53d6\u516c\u544a\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/getNoticeListByType"})
    public ActionResult<PageListVO> getNoticeListByType(PaginationMessage pagination) {
        List<CrmproductmessageEntity> list = this.crmproductmessageService.getNoticeListByType((Pagination)pagination, pagination.getType());
        List userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (CrmproductmessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8bfb\u53d6\u6d88\u606f")
    @NotCheckLogin
    @GetMapping(value={"/ReadInfo/{id}"})
    public ActionResult readInfo(@PathVariable(value="id") String id) throws DataException {
        CrmproductmessageEntity entity = this.crmproductmessageService.getInfo(id);
        NoticeInfoVO vo = (NoticeInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, NoticeInfoVO.class);
        CrmproductmessageEntity getinfo = new CrmproductmessageEntity();
        getinfo.setId(id);
        getinfo.setIsRead(1);
        this.crmproductmessageService.updateById(getinfo);
        return ActionResult.success((Object)vo);
    }
}

