/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmproductsuggestionEntity;
import com.bringspring.crm.entity.CrmproductsuggestionhistoryEntity;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionCrForm;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionInfoVO;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionListVO;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionPagination;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionUpForm;
import com.bringspring.crm.model.crmproductsuggestion.CrmproductsuggestionhistoryModel;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmproductsuggestionService;
import com.bringspring.crm.service.CrmproductsuggestionhistoryService;
import com.bringspring.crm.util.CrmProductSuggesEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u5efa\u8bae"}, value="crm")
@RequestMapping(value={"/api/crm/Crmproductsuggestion"})
public class CrmproductsuggestionController {
    private static final Logger log = LoggerFactory.getLogger(CrmproductsuggestionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmproductsuggestionService crmproductsuggestionService;
    @Autowired
    private CrmproductsuggestionhistoryService crmproductsuggestionhistoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u5217\u8868")
    public ActionResult list(@RequestBody CrmproductsuggestionPagination crmproductsuggestionPagination) throws IOException {
        List<CrmproductsuggestionEntity> list = this.crmproductsuggestionService.getList(crmproductsuggestionPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmproductsuggestionListVO.class);
        for (CrmproductsuggestionListVO crmproductsuggestionVO : listVO) {
            CrmProductCategoryEntity productCategoryInfo;
            crmproductsuggestionVO.setCreatorUserName(this.baseDataUtil.userSelectValue(crmproductsuggestionVO.getCreatorUserId()));
            crmproductsuggestionVO.setEnabledMarkName(CrmProductSuggesEnum.getByCode(crmproductsuggestionVO.getEnabledMark()));
            crmproductsuggestionVO.setFile(this.baseDataUtil.getFileNameInJson(crmproductsuggestionVO.getFile()));
            CrmProductEntity productInfo = this.crmProductService.getInfo(crmproductsuggestionVO.getProductId());
            if (ObjectUtil.isNotEmpty((Object)productInfo)) {
                crmproductsuggestionVO.setProductName(productInfo.getProductName());
            }
            if (!ObjectUtil.isNotEmpty((Object)(productCategoryInfo = this.crmProductCategoryService.getInfo(crmproductsuggestionVO.getProductCategoryId())))) continue;
            crmproductsuggestionVO.setProductCategoryName(productCategoryInfo.getName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmproductsuggestionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmproductsuggestionCrForm crmproductsuggestionCrForm) throws DataException {
        this.crmproductsuggestionService.create(crmproductsuggestionCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<CrmproductsuggestionInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity productCategoryInfo;
        CrmproductsuggestionEntity entity = this.crmproductsuggestionService.getInfo(id);
        CrmproductsuggestionInfoVO vo = (CrmproductsuggestionInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmproductsuggestionInfoVO.class);
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        CrmProductEntity productInfo = this.crmProductService.getInfo(vo.getProductId());
        if (ObjectUtil.isNotEmpty((Object)productInfo)) {
            vo.setProductName(productInfo.getProductName());
        }
        if (ObjectUtil.isNotEmpty((Object)(productCategoryInfo = this.crmProductCategoryService.getInfo(vo.getProductCategoryId())))) {
            vo.setProductCategoryName(productCategoryInfo.getName());
        }
        List<CrmproductsuggestionhistoryEntity> CrmproductsuggestionhistoryList = this.crmproductsuggestionService.getCrmproductsuggestionhistoryList(id);
        List jsonToList = JsonUtil.getJsonToList(CrmproductsuggestionhistoryList, CrmproductsuggestionhistoryModel.class);
        for (CrmproductsuggestionhistoryModel crmproductsuggestionhistoryEntity : jsonToList) {
            crmproductsuggestionhistoryEntity.setCreatorUserName(this.baseDataUtil.userSelectValue(crmproductsuggestionhistoryEntity.getCreatorUserId()));
            crmproductsuggestionhistoryEntity.setPhaseName(CrmProductSuggesEnum.getByCode(crmproductsuggestionhistoryEntity.getPhase()));
        }
        vo.setCrmProductSuggestionHistoryList(jsonToList);
        vo.setEnabledMarkName(CrmProductSuggesEnum.getByCode(vo.getEnabledMark()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmproductsuggestionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmproductsuggestionEntity entity = this.crmproductsuggestionService.getInfo(id);
        CrmproductsuggestionInfoVO vo = (CrmproductsuggestionInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmproductsuggestionInfoVO.class);
        List<CrmproductsuggestionhistoryEntity> crmproductsuggestionhistoryList = this.crmproductsuggestionService.getCrmproductsuggestionhistoryList(id);
        List crmproductsuggestionhistoryModelList = JsonUtil.getJsonToList(crmproductsuggestionhistoryList, CrmproductsuggestionhistoryModel.class);
        for (CrmproductsuggestionhistoryModel crmproductsuggestionhistoryModel : crmproductsuggestionhistoryModelList) {
        }
        vo.setCrmProductSuggestionHistoryList(crmproductsuggestionhistoryModelList);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setFile(this.baseDataUtil.getFileNameInJson(vo.getFile()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u8f6c\u6d3e")
    @PutMapping(value={"/assign/{id}"})
    public ActionResult assign(@PathVariable(value="id") String id, @RequestBody @Valid CrmproductsuggestionUpForm crmproductsuggestionUpForm) throws DataException {
        this.crmproductsuggestionService.assign(id, crmproductsuggestionUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmproductsuggestionUpForm crmproductsuggestionUpForm) throws DataException {
        this.crmproductsuggestionService.update(id, crmproductsuggestionUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u5efa\u8bae\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmproductsuggestionEntity entity = this.crmproductsuggestionService.getInfo(id);
        if (entity != null) {
            this.crmproductsuggestionService.delete(entity);
            QueryWrapper queryWrapperCrmproductsuggestionhistory = new QueryWrapper();
            queryWrapperCrmproductsuggestionhistory.lambda().eq(CrmproductsuggestionhistoryEntity::getProductSuggestionId, (Object)entity.getId());
            this.crmproductsuggestionhistoryService.remove((Wrapper)queryWrapperCrmproductsuggestionhistory);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

