/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmtenderanalyEntity;
import com.bringspring.crm.entity.CrmtenderanalyproductEntity;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyCrForm;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyInfoVO;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyListVO;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyPagination;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyPaginationExportModel;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyUpForm;
import com.bringspring.crm.model.crmtenderanaly.CrmtenderanalyproductModel;
import com.bringspring.crm.service.CrmtenderanalyService;
import com.bringspring.crm.service.CrmtenderanalyproductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62db\u6807\u7ebf\u7d22\u5ba1\u6838"}, value="crm")
@RequestMapping(value={"/api/crm/Crmtenderanaly"})
public class CrmtenderanalyController {
    private static final Logger log = LoggerFactory.getLogger(CrmtenderanalyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmtenderanalyService crmtenderanalyService;
    @Autowired
    private CrmtenderanalyproductService crmtenderanalyproductService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u5217\u8868")
    public ActionResult list(@RequestBody CrmtenderanalyPagination crmtenderanalyPagination) throws IOException {
        List<CrmtenderanalyEntity> list = this.crmtenderanalyService.getList(crmtenderanalyPagination);
        for (CrmtenderanalyEntity crmtenderanalyEntity : list) {
            crmtenderanalyEntity.setProvince(this.baseDataUtil.provinceData(crmtenderanalyEntity.getProvince()));
            crmtenderanalyEntity.setCity(this.baseDataUtil.provinceData(crmtenderanalyEntity.getCity()));
            crmtenderanalyEntity.setFilePath(this.baseDataUtil.getFileNameInJson(crmtenderanalyEntity.getFilePath()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmtenderanalyListVO.class);
        for (CrmtenderanalyListVO crmtenderanalyListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmtenderanalyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmtenderanalyCrForm crmtenderanalyCrForm) throws DataException {
        this.crmtenderanalyService.create(crmtenderanalyCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmtenderanalyPaginationExportModel crmtenderanalyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmtenderanalyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmtenderanalyPagination crmtenderanalyPagination = (CrmtenderanalyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmtenderanalyPaginationExportModel), CrmtenderanalyPagination.class));
        List<CrmtenderanalyEntity> list = this.crmtenderanalyService.getTypeList(crmtenderanalyPagination, crmtenderanalyPaginationExportModel.getDataType());
        for (CrmtenderanalyEntity crmtenderanalyEntity : list) {
            crmtenderanalyEntity.setProvince(this.baseDataUtil.provinceData(crmtenderanalyEntity.getProvince()));
            crmtenderanalyEntity.setCity(this.baseDataUtil.provinceData(crmtenderanalyEntity.getCity()));
            crmtenderanalyEntity.setFilePath(this.baseDataUtil.getFileNameInJson(crmtenderanalyEntity.getFilePath()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmtenderanalyListVO.class);
        for (CrmtenderanalyListVO crmtenderanalyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmtenderanalyPaginationExportModel.getSelectKey()) ? crmtenderanalyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "hospitalName": {
                        entitys.add(new ExcelExportEntity("\u533b\u9662\u540d\u79f0", (Object)"hospitalName"));
                        continue block34;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u62db\u6807\u7c7b\u578b", (Object)"type"));
                        continue block34;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block34;
                    }
                    case "searchKey": {
                        entitys.add(new ExcelExportEntity("\u5173\u952e\u5b57", (Object)"searchKey"));
                        continue block34;
                    }
                    case "time": {
                        entitys.add(new ExcelExportEntity("\u53d1\u5e03\u65e5\u671f", (Object)"time"));
                        continue block34;
                    }
                    case "province": {
                        entitys.add(new ExcelExportEntity("\u7701\u4efd", (Object)"province"));
                        continue block34;
                    }
                    case "city": {
                        entitys.add(new ExcelExportEntity("\u57ce\u5e02", (Object)"city"));
                        continue block34;
                    }
                    case "source": {
                        entitys.add(new ExcelExportEntity("\u4fe1\u606f\u6765\u6e90", (Object)"source"));
                        continue block34;
                    }
                    case "sourceUrl": {
                        entitys.add(new ExcelExportEntity("\u6765\u6e90\u5730\u5740", (Object)"sourceUrl"));
                        continue block34;
                    }
                    case "filePath": {
                        entitys.add(new ExcelExportEntity("\u6587\u4ef6\u4e0a\u4f20", (Object)"filePath"));
                        continue block34;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u5185\u5bb9", (Object)"content"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/batchRemove/{ids}"})
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        boolean i = this.crmtenderanalyService.removeBatchByIds(allIdList);
        if (i) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<CrmtenderanalyInfoVO> info(@PathVariable(value="id") String id) {
        CrmtenderanalyEntity entity = this.crmtenderanalyService.getInfo(id);
        CrmtenderanalyInfoVO vo = (CrmtenderanalyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmtenderanalyInfoVO.class);
        List<CrmtenderanalyproductEntity> CrmtenderanalyproductList = this.crmtenderanalyService.getCrmtenderanalyproductList(id);
        for (CrmtenderanalyproductEntity crmtenderanalyproductEntity : CrmtenderanalyproductList) {
        }
        vo.setCrmZhaobiaoReviewProductList(JsonUtil.getJsonToList(CrmtenderanalyproductList, CrmtenderanalyproductModel.class));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmtenderanalyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmtenderanalyEntity entity = this.crmtenderanalyService.getInfo(id);
        CrmtenderanalyInfoVO vo = (CrmtenderanalyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmtenderanalyInfoVO.class);
        List<CrmtenderanalyproductEntity> crmtenderanalyproductList = this.crmtenderanalyService.getCrmtenderanalyproductList(id);
        List crmtenderanalyproductModelList = JsonUtil.getJsonToList(crmtenderanalyproductList, CrmtenderanalyproductModel.class);
        for (CrmtenderanalyproductModel crmtenderanalyproductModel : crmtenderanalyproductModelList) {
        }
        vo.setCrmZhaobiaoReviewProductList(crmtenderanalyproductModelList);
        vo.setProvince(this.baseDataUtil.provinceData(vo.getProvince()));
        vo.setCity(this.baseDataUtil.provinceData(vo.getCity()));
        vo.setFilePath(this.baseDataUtil.getFileNameInJson(vo.getFilePath()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmtenderanalyUpForm crmtenderanalyUpForm) throws DataException {
        this.crmtenderanalyService.update(id, crmtenderanalyUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u62db\u6807\u7ebf\u7d22\u5ba1\u6838\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmtenderanalyEntity entity = this.crmtenderanalyService.getInfo(id);
        if (entity != null) {
            this.crmtenderanalyService.delete(entity);
            QueryWrapper queryWrapperCrmtenderanalyproduct = new QueryWrapper();
            queryWrapperCrmtenderanalyproduct.lambda().eq(CrmtenderanalyproductEntity::getReviewId, (Object)entity.getId());
            this.crmtenderanalyproductService.remove((Wrapper)queryWrapperCrmtenderanalyproduct);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

