/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.model.crmcustomeropportunity.CrmDashboardGatherVO;
import com.bringspring.crm.model.crmcustomeropportunity.CrmDashboardInfoVO;
import com.bringspring.crm.model.crmcustomeropportunity.CrmDashboardopporActualVO;
import com.bringspring.crm.model.crmcustomeropportunity.CrmDashboardopporCompanyVO;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerOpportunityTrendsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9996\u9875\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/dashboardInfo"})
public class DashboardInfoController {
    private static final Logger log = LoggerFactory.getLogger(DashboardInfoController.class);
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmCustomerOpportunityTrendsService crmCustomerOpportunityTrendsService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;

    @PostMapping(value={"/saleDetail"})
    public ActionResult saleDetail() {
        Date beginDayOfMonth = DateUtil.getBeginDayOfMonth();
        CrmDashboardInfoVO outPutVo = new CrmDashboardInfoVO();
        outPutVo.setCreateOppoTotal(this.crmCustomerOpportunityService.createOppoCount());
        long oppoTurnTotal = this.crmCustomerOpportunityService.oppoTurnTotal(7L);
        outPutVo.setOppoTurnTotal(oppoTurnTotal);
        long oppoYetFourTurnTotal = this.crmCustomerOpportunityService.oppoTurnTotal(4L);
        long oppoYetiveTurnTotal = this.crmCustomerOpportunityService.oppoTurnTotal(5L);
        long oppoYetSixTurnTotal = this.crmCustomerOpportunityService.oppoTurnTotal(6L);
        long yetTotal = oppoYetSixTurnTotal + oppoYetiveTurnTotal + oppoYetFourTurnTotal;
        outPutVo.setOppoYetTotal(yetTotal);
        BigDecimal failConfirm = new BigDecimal(yetTotal);
        BigDecimal oppoTurnTotalBig = new BigDecimal(oppoTurnTotal);
        BigDecimal add = oppoTurnTotalBig.add(failConfirm);
        BigDecimal turnRate = new BigDecimal(0);
        if (add.compareTo(new BigDecimal(0)) > 0) {
            turnRate = oppoTurnTotalBig.divide(oppoTurnTotalBig.add(failConfirm), 2, 4);
        }
        outPutVo.setOppoTurnRate(turnRate);
        outPutVo.setOppoInteractionQuantity(this.crmCustomerOpportunityTrendsService.oppoInteractionQuantity(beginDayOfMonth, new Date(), null));
        outPutVo.setSalesFollowQuantity(this.crmCustomerOpportunityTrendsService.oppoInteractionQuantity(beginDayOfMonth, new Date(), "assistance"));
        return ActionResult.success((Object)outPutVo);
    }

    @PostMapping(value={"/saleGather"})
    public ActionResult saleGather() {
        CrmDashboardGatherVO outPutVo = new CrmDashboardGatherVO();
        outPutVo.setCustomerOppoTotal(this.crmCustomerService.getCustomerOppoTotal("company"));
        outPutVo.setOppoTotal(this.crmCustomerOpportunityService.count());
        outPutVo.setCustomerContacts(this.crmCustomerContactsService.count());
        outPutVo.setCustomerNoProduct(this.crmCustomerService.count());
        return ActionResult.success((Object)outPutVo);
    }

    @PostMapping(value={"/opportunityActual"})
    public ActionResult opportunityActual() {
        CrmDashboardopporActualVO outPutVo = new CrmDashboardopporActualVO();
        List frontDate = DateUtil.getFrontDate((Date)new Date(), (int)15);
        Collections.reverse(frontDate);
        outPutVo.setDataList(frontDate);
        ArrayList<Long> oppoInteractionList = new ArrayList<Long>();
        Integer i = 0;
        while (i < frontDate.size()) {
            oppoInteractionList.add(this.crmCustomerOpportunityTrendsService.oppoInteractionQuantityByDate((String)frontDate.get(i), "follow"));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        outPutVo.setOppoInteraction(oppoInteractionList);
        return ActionResult.success((Object)outPutVo);
    }

    @PostMapping(value={"/opportunityCompany"})
    public ActionResult opportunityCompany() {
        List allCompanyList = this.organizeService.getList(null);
        List outPutVo = JsonUtil.getJsonToList((Object)allCompanyList, CrmDashboardopporCompanyVO.class);
        String today = DateUtil.daFormat((Date)new Date());
        List<CrmDashboardopporCompanyVO> todayCount = this.crmCustomerOpportunityService.getCountByCreateDate(today + " 00:00:00", today + " 23:59:59");
        String monthStartDate = DateUtil.daFormat((Date)DateUtil.getBeginDayOfMonth());
        List<CrmDashboardopporCompanyVO> monthCount = this.crmCustomerOpportunityService.getCountByCreateDate(monthStartDate + " 00:00:00", today + " 23:59:59");
        List<CrmDashboardopporCompanyVO> totalCount = this.crmCustomerOpportunityService.getCountByCreateDate(null, null);
        outPutVo.stream().forEach(item -> {
            if (!ObjectUtil.isEmpty((Object)todayCount)) {
                todayCount.stream().forEach(todayItem -> {
                    if (item.getId().equals(todayItem.getId().split(",")[1])) {
                        item.setDayTotal(todayItem.getAllTotal());
                    }
                });
            }
            if (!ObjectUtil.isEmpty((Object)monthCount)) {
                monthCount.stream().forEach(todayItem -> {
                    if (item.getId().equals(todayItem.getId().split(",")[1])) {
                        item.setMonthTotal(todayItem.getAllTotal());
                    }
                });
            }
            if (!ObjectUtil.isEmpty((Object)totalCount)) {
                totalCount.stream().forEach(todayItem -> {
                    if (item.getId().equals(todayItem.getId().split(",")[1])) {
                        item.setAllTotal(todayItem.getAllTotal());
                    }
                });
            }
        });
        return ActionResult.success((Object)outPutVo);
    }
}

