/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.StrUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.crm.entity.MarketExhibitionEntity;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionCrUeForm;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionInfoVO;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionListVO;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionPagination;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionUpForm;
import com.bringspring.crm.model.marketExhibition.QrCodeDto;
import com.bringspring.crm.service.MarketExhibitionService;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectModel;
import com.bringspring.system.base.model.dictionarytype.DictionaryTypeSelectVO;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5e02\u573a\u5c55\u4f1a\u57fa\u672c\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/MarketExhibition"})
public class MarketExhibitionController {
    private static final Logger log = LoggerFactory.getLogger(MarketExhibitionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private MarketExhibitionService marketExhibitionService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody MarketExhibitionPagination marketExhibitionPagination) throws IOException {
        List<MarketExhibitionEntity> list = this.marketExhibitionService.getList(marketExhibitionPagination);
        for (MarketExhibitionEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, MarketExhibitionListVO.class);
        for (MarketExhibitionListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)marketExhibitionPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801")
    @PostMapping(value={"/getQRCode"})
    @NotCheckLogin
    public ActionResult getQRCode(@RequestBody QrCodeDto qrCodeDto) throws Exception {
        String qrCode = this.marketExhibitionService.generateQrCode(qrCodeDto);
        return ActionResult.success((String)qrCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u5b57\u5178\u6570\u636e\u4e0b\u62c9\u6846\u5217\u8868")
    @NotCheckLogin
    @GetMapping(path={"/getDictionary/{dictionaryTypeId}/Data/Selector/{companyId}", "{dictionaryTypeId}/Data/Selector"})
    public ActionResult<ListVO<DictionaryTypeSelectVO>> selectorOneTreeView(@PathVariable(value="dictionaryTypeId") String dictionaryTypeId, @PathVariable(value="companyId", required=false) String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            companyId = this.userProvider.get().getOrganizeId();
        }
        List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true), companyId);
        List voListVO = JsonUtil.getJsonToList((Object)data, DictionaryTypeSelectModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)voListVO);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DictionaryTypeSelectVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid MarketExhibitionCrUeForm marketExhibitionCrForm) throws DataException {
        this.marketExhibitionService.create(marketExhibitionCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    @NotCheckLogin
    public ActionResult<MarketExhibitionInfoVO> info(@PathVariable(value="id") String id) {
        MarketExhibitionEntity entity = this.marketExhibitionService.getInfo(id);
        MarketExhibitionInfoVO vo = (MarketExhibitionInfoVO)JsonUtil.getJsonToBean((Object)entity, MarketExhibitionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @GetMapping(value={"/info/{companyId}"})
    public ActionResult<MarketExhibitionInfoVO> getByCompanyId(@PathVariable(value="companyId") String companyId) {
        MarketExhibitionEntity entity = this.marketExhibitionService.getByCompanyId(companyId);
        MarketExhibitionInfoVO vo = (MarketExhibitionInfoVO)JsonUtil.getJsonToBean((Object)entity, MarketExhibitionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    @NotCheckLogin
    public ActionResult<MarketExhibitionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        MarketExhibitionEntity entity = this.marketExhibitionService.getInfo(id);
        MarketExhibitionInfoVO vo = (MarketExhibitionInfoVO)JsonUtil.getJsonToBean((Object)entity, MarketExhibitionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid MarketExhibitionUpForm marketExhibitionUpForm) throws DataException {
        this.marketExhibitionService.update(id, marketExhibitionUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/state/{id}"})
    public ActionResult getByState(@PathVariable(value="id") String id, @RequestBody @Valid MarketExhibitionUpForm marketExhibitionUpForm) throws DataException {
        this.marketExhibitionService.getByState(id, marketExhibitionUpForm);
        if (StrUtil.equals((CharSequence)marketExhibitionUpForm.getState(), (CharSequence)"0") || StrUtil.equals((CharSequence)marketExhibitionUpForm.getHasPrize(), (CharSequence)"0")) {
            return ActionResult.success((String)"\u542f\u7528\u6210\u529f");
        }
        return ActionResult.success((String)"\u505c\u7528\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        MarketExhibitionEntity entity = this.marketExhibitionService.getInfo(id);
        if (entity != null) {
            this.marketExhibitionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"countByState"})
    public ActionResult countByEnabledMark(@RequestBody MarketExhibitionPagination pagination) {
        List<Map<String, Object>> maps = this.marketExhibitionService.countByState(pagination);
        return ActionResult.success(maps);
    }
}

