/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.MarketExhibitionUserEntity;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserCrForm;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserInfoVO;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserListVO;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserPagination;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserPaginationExportModel;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserUpForm;
import com.bringspring.crm.service.MarketExhibitionService;
import com.bringspring.crm.service.MarketExhibitionUserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.utils.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5c55\u4f1a\u7528\u6237\u4eba\u5458"}, value="crm")
@RequestMapping(value={"/api/crm/MarketExhibitionUser"})
public class MarketExhibitionUserController {
    private static final Logger log = LoggerFactory.getLogger(MarketExhibitionUserController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private MarketExhibitionUserService marketExhibitionUserService;
    @Autowired
    private MarketExhibitionService marketExhibitionService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody MarketExhibitionUserPagination marketExhibitionUserPagination) throws IOException {
        List<MarketExhibitionUserEntity> list = this.marketExhibitionUserService.getList(marketExhibitionUserPagination);
        List listVO = JsonUtil.getJsonToList(list, MarketExhibitionUserListVO.class);
        for (MarketExhibitionUserListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)marketExhibitionUserPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @NotCheckLogin
    public ActionResult create(@RequestBody @Valid MarketExhibitionUserCrForm marketExhibitionUserCrForm) throws DataException {
        this.marketExhibitionUserService.create(marketExhibitionUserCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<MarketExhibitionUserInfoVO> info(@PathVariable(value="id") String id) {
        MarketExhibitionUserEntity entity = this.marketExhibitionUserService.getInfo(id);
        MarketExhibitionUserInfoVO vo = (MarketExhibitionUserInfoVO)JsonUtil.getJsonToBean((Object)entity, MarketExhibitionUserInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<MarketExhibitionUserInfoVO> detailInfo(@PathVariable(value="id") String id) {
        MarketExhibitionUserEntity entity = this.marketExhibitionUserService.getInfo(id);
        MarketExhibitionUserInfoVO vo = (MarketExhibitionUserInfoVO)JsonUtil.getJsonToBean((Object)entity, MarketExhibitionUserInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid MarketExhibitionUserUpForm marketExhibitionUserUpForm) throws DataException {
        this.marketExhibitionUserService.update(id, marketExhibitionUserUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        MarketExhibitionUserEntity entity = this.marketExhibitionUserService.getInfo(id);
        if (entity != null) {
            this.marketExhibitionUserService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(MarketExhibitionUserPaginationExportModel marketExhibitionUserPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)marketExhibitionUserPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        MarketExhibitionUserPagination marketExhibitionUserPagination = (MarketExhibitionUserPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)marketExhibitionUserPaginationExportModel), MarketExhibitionUserPagination.class));
        List<MarketExhibitionUserEntity> list = this.marketExhibitionUserService.getTypeList(marketExhibitionUserPagination, marketExhibitionUserPaginationExportModel.getDataType());
        for (MarketExhibitionUserEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, MarketExhibitionUserListVO.class);
        for (MarketExhibitionUserListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            if (!ObjectUtil.isNull((Object)vo.getProductName())) continue;
            vo.setProductName("\u65e0");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)marketExhibitionUserPaginationExportModel.getSelectKey()) ? marketExhibitionUserPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"name"));
                        continue block30;
                    }
                    case "province": {
                        entitys.add(new ExcelExportEntity("\u6240\u5728\u7701\u4efd", (Object)"province"));
                        continue block30;
                    }
                    case "nosocomium": {
                        entitys.add(new ExcelExportEntity("\u6240\u5728\u533b\u9662/\u5355\u4f4d", (Object)"nosocomium"));
                        continue block30;
                    }
                    case "administrativeOffice": {
                        entitys.add(new ExcelExportEntity("\u6240\u5728\u79d1\u5ba4/\u90e8\u95e8", (Object)"administrativeOffice"));
                        continue block30;
                    }
                    case "userPhone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"userPhone"));
                        continue block30;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block30;
                    }
                    case "exhibitionName": {
                        entitys.add(new ExcelExportEntity("\u5c55\u4f1a\u6807\u9898", (Object)"exhibitionName"));
                        continue block30;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u540d\u79f0", (Object)"productName"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u5c55\u4f1a\u4eba\u5458\u4fe1\u606f" + DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

