/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.model.rkCollege.RkCollegeConfigModel;
import com.bringspring.crm.service.SsoRongKeCollegeService;
import com.bringspring.system.base.exception.BaseException;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8363\u79d1\u5b66\u9662"}, value="crm")
@RequestMapping(value={"/api/crm/rkCollege"})
public class SsoRongKeCollegeController {
    private static final Logger log = LoggerFactory.getLogger(SsoRongKeCollegeController.class);
    @Autowired
    private SsoRongKeCollegeService ssoRongKeCollegeService;
    @Autowired
    private UserProvider userProvider;

    @GetMapping(value={"/{type}"})
    public ActionResult<RkCollegeConfigModel> getConfigsByCategory(@PathVariable(value="type") String type) throws BaseException {
        RkCollegeConfigModel model = this.ssoRongKeCollegeService.byCategory(type);
        return ActionResult.success((Object)model);
    }

    @PostMapping(value={"/rKeCollegeUrl"})
    public ActionResult<String> getUrl() throws BaseException, UnsupportedEncodingException {
        RkCollegeConfigModel rkCollegeConfigModel = this.ssoRongKeCollegeService.byCategory("RongKeCollege");
        if (StrUtil.isBlank((CharSequence)rkCollegeConfigModel.getEln4SSOUrl()) || StrUtil.isBlank((CharSequence)rkCollegeConfigModel.getCorpCode()) || StrUtil.isBlank((CharSequence)rkCollegeConfigModel.getRkSecret())) {
            return ActionResult.fail((String)"\u8363\u79d1\u5b66\u9662\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u7cfb\u7edf\u8d26\u53f7\u4e3a\u7a7a");
        }
        String url = this.ssoRongKeCollegeService.getUrl(rkCollegeConfigModel);
        return ActionResult.success((String)url);
    }
}

