/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.crm.entity.CrmCustomerUserPointsEntity;
import com.bringspring.crm.entity.MarketExhibitionUserEntity;
import com.bringspring.crm.model.crmWechat.WechatLoginForm;
import com.bringspring.crm.service.WechatVisitService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8363\u79d1\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"}, value="crm")
@RequestMapping(value={"/api/crm/wechatVisit"})
public class WechatVisitController {
    private static final Logger log = LoggerFactory.getLogger(WechatVisitController.class);
    @Autowired
    private WechatVisitService wechatVisitService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @NotCheckLogin
    @PostMapping(value={"/loginAdd"})
    public ActionResult<CrmCustomerUserPointsEntity> login(@RequestBody @Valid WechatLoginForm form) throws IOException {
        CrmCustomerUserPointsEntity entity = this.wechatVisitService.getAccountByWxMiniappCodeName(form.getAppid(), form.getCode(), form.getPhoneCode(), form.getIv(), form.getEncryptedData());
        return ActionResult.success((Object)entity);
    }

    @NotCheckLogin
    @PostMapping(value={"/marketExhibitionLogin"})
    public ActionResult<MarketExhibitionUserEntity> marketExhibitionLogin(@RequestBody @Valid WechatLoginForm form) throws IOException {
        String phone = this.wechatVisitService.marketExhibitionLogin(form.getAppid(), form.getCode(), form.getPhoneCode(), form.getIv(), form.getEncryptedData(), form.getCompanyId(), form.getExhibitionId());
        return ActionResult.success((String)phone);
    }

    @NotCheckLogin
    @GetMapping(value={"/review"})
    public ActionResult<MarketExhibitionUserEntity> review() throws IOException {
        String reviewType = this.baseDataUtil.getDictName("is", "review");
        return ActionResult.success((String)reviewType);
    }
}

