/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmAuthorizationModuleEntity;
import com.bringspring.crm.entity.CrmProductCarryEntity;
import com.bringspring.crm.mapper.CrmAuthorizationModuleMapper;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleCrForm;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModulePagination;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleUpForm;
import com.bringspring.crm.service.CrmAuthorizationModuleService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmAuthorizationModuleServiceImpl
extends ServiceImpl<CrmAuthorizationModuleMapper, CrmAuthorizationModuleEntity>
implements CrmAuthorizationModuleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<CrmAuthorizationModuleEntity> getList(CrmAuthorizationModulePagination crmAuthorizationModulePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmAuthorizationModuleNum = 0;
        QueryWrapper crmAuthorizationModuleQueryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object crmCustomerVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmAuthorizationModuleQueryWrapper, crmAuthorizationModulePagination.getMenuId(), "crm_qualification_library"));
            if (ObjectUtil.isEmpty((Object)crmCustomerVerifyObj)) {
                ++crmAuthorizationModuleNum;
                crmAuthorizationModuleQueryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
            } else {
                crmAuthorizationModuleQueryWrapper = (QueryWrapper)crmCustomerVerifyObj;
                ++crmAuthorizationModuleNum;
            }
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getProductId())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getProductId, (Object)crmAuthorizationModulePagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getModuleName())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getModuleName, (Object)crmAuthorizationModulePagination.getModuleName());
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getEncode())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getEncode, (Object)crmAuthorizationModulePagination.getEncode());
        }
        if (CollectionUtil.isNotEmpty(crmAuthorizationModulePagination.getCompanyIdList())) {
            crmAuthorizationModuleQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w1 -> {
                w1.apply("find_in_set('" + crmAuthorizationModulePagination.getCompanyIdList().get(0) + "',company_id)", new Object[0]);
                for (int i = 1; i < crmAuthorizationModulePagination.getCompanyIdList().size(); ++i) {
                    ((LambdaQueryWrapper)w1.or()).apply("find_in_set('" + crmAuthorizationModulePagination.getCompanyIdList().get(i) + "',company_id)", new Object[0]);
                }
            })).or(w2 -> w2.in(CrmAuthorizationModuleEntity::getCompanyId, crmAuthorizationModulePagination.getCompanyIdList())));
        } else if (StrUtil.isNotEmpty((CharSequence)crmAuthorizationModulePagination.getCompanyId())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getCompanyId, (Object)crmAuthorizationModulePagination.getCompanyId());
        }
        crmAuthorizationModuleQueryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getEnabledMark, (Object)0);
        if (AllIdList.size() > 0) {
            crmAuthorizationModuleQueryWrapper.lambda().in(CrmAuthorizationModuleEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmAuthorizationModulePagination.getSidx())) {
            crmAuthorizationModuleQueryWrapper.lambda().orderByDesc(CrmAuthorizationModuleEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmAuthorizationModulePagination.getSidx();
                CrmAuthorizationModuleEntity crmAuthorizationModuleEntity = new CrmAuthorizationModuleEntity();
                Field declaredField = crmAuthorizationModuleEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmAuthorizationModuleQueryWrapper = "asc".equals(crmAuthorizationModulePagination.getSort().toLowerCase()) ? (QueryWrapper)crmAuthorizationModuleQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmAuthorizationModuleQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmAuthorizationModulePagination.getCurrentPage(), crmAuthorizationModulePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmAuthorizationModuleQueryWrapper);
            return crmAuthorizationModulePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmAuthorizationModulePagination.setData(list, list.size());
    }

    @Override
    public List<CrmAuthorizationModuleEntity> getTypeList(CrmAuthorizationModulePagination crmAuthorizationModulePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmAuthorizationModuleNum = 0;
        QueryWrapper crmAuthorizationModuleQueryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object crmCustomerVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmAuthorizationModuleQueryWrapper, crmAuthorizationModulePagination.getMenuId(), "crm_qualification_library"));
            if (ObjectUtil.isEmpty((Object)crmCustomerVerifyObj)) {
                ++crmAuthorizationModuleNum;
                crmAuthorizationModuleQueryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
            } else {
                crmAuthorizationModuleQueryWrapper = (QueryWrapper)crmCustomerVerifyObj;
                ++crmAuthorizationModuleNum;
            }
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getProductId())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getProductId, (Object)crmAuthorizationModulePagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getModuleName())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getModuleName, (Object)crmAuthorizationModulePagination.getModuleName());
        }
        if (StringUtils.isNotEmpty((String)crmAuthorizationModulePagination.getEncode())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().like(CrmAuthorizationModuleEntity::getEncode, (Object)crmAuthorizationModulePagination.getEncode());
        }
        if (CollectionUtil.isNotEmpty(crmAuthorizationModulePagination.getCompanyIdList())) {
            ++crmAuthorizationModuleNum;
            crmAuthorizationModuleQueryWrapper.lambda().in(CrmAuthorizationModuleEntity::getCompanyId, crmAuthorizationModulePagination.getCompanyIdList());
        }
        crmAuthorizationModuleQueryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getEnabledMark, (Object)0);
        if (AllIdList.size() > 0) {
            crmAuthorizationModuleQueryWrapper.lambda().in(CrmAuthorizationModuleEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmAuthorizationModulePagination.getSidx())) {
            crmAuthorizationModuleQueryWrapper.lambda().orderByDesc(CrmAuthorizationModuleEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmAuthorizationModulePagination.getSidx();
                CrmAuthorizationModuleEntity crmAuthorizationModuleEntity = new CrmAuthorizationModuleEntity();
                Field declaredField = crmAuthorizationModuleEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmAuthorizationModuleQueryWrapper = "asc".equals(crmAuthorizationModulePagination.getSort().toLowerCase()) ? (QueryWrapper)crmAuthorizationModuleQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmAuthorizationModuleQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmAuthorizationModulePagination.getCurrentPage(), crmAuthorizationModulePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmAuthorizationModuleQueryWrapper);
                return crmAuthorizationModulePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmAuthorizationModulePagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmAuthorizationModuleQueryWrapper);
    }

    @Override
    public CrmAuthorizationModuleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getId, (Object)id);
        return (CrmAuthorizationModuleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmAuthorizationModuleEntity> getByIds(String ids) {
        if (StringUtils.isNotEmpty((String)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmAuthorizationModuleEntity::getId, idsList);
            return this.list((Wrapper)queryWrapper);
        }
        return CollectionUtil.list((boolean)false);
    }

    @Override
    @Transactional
    public void create(CrmAuthorizationModuleCrForm crmAuthorizationModuleCrForm) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmAuthorizationModuleCrForm.setCreatorUserId(userInfo.getUserId());
        crmAuthorizationModuleCrForm.setCreatorTime(DateUtil.getNow());
        CrmAuthorizationModuleEntity entity = (CrmAuthorizationModuleEntity)JsonUtil.getJsonToBean((Object)crmAuthorizationModuleCrForm, CrmAuthorizationModuleEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setEnabledMark(0);
        this.save(entity);
    }

    @Override
    @Transactional
    public void update(String id, CrmAuthorizationModuleUpForm crmAuthorizationModuleUpForm) {
        UserInfo userInfo = this.userProvider.get();
        CrmAuthorizationModuleEntity entity = this.getInfo(id);
        if (entity != null) {
            crmAuthorizationModuleUpForm.setLastModifyUserId(userInfo.getUserId());
            crmAuthorizationModuleUpForm.setLastModifyTime(DateUtil.getNow());
            CrmAuthorizationModuleEntity subentity = (CrmAuthorizationModuleEntity)JsonUtil.getJsonToBean((Object)crmAuthorizationModuleUpForm, CrmAuthorizationModuleEntity.class);
            subentity.setId(id);
            subentity.setCompanyId(userInfo.getOrganizeId());
            subentity.setEnabledMark(0);
            this.updateById(subentity);
        }
    }

    @Override
    public List<CrmAuthorizationModuleEntity> getProductList(CrmAuthorizationModulePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(pagination.getProductList())) {
            for (String zhi : pagination.getProductList()) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(CrmAuthorizationModuleEntity::getProductId, (Object)zhi)).or()).in(CrmAuthorizationModuleEntity::getProductId, pagination.getProductList());
            }
        } else {
            queryWrapper.lambda().in(CrmAuthorizationModuleEntity::getProductId, new Object[]{""});
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public CrmAuthorizationModuleEntity getByProduct(CrmProductCarryEntity form) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmAuthorizationModuleEntity::getProductId, (Object)form.getProductId())).eq(CrmAuthorizationModuleEntity::getId, (Object)form.getAuthorizationModule());
        CrmAuthorizationModuleEntity entity = (CrmAuthorizationModuleEntity)this.getOne((Wrapper)queryWrapper);
        return entity;
    }

    @Override
    @Transactional
    public void delete(CrmAuthorizationModuleEntity entity) {
        if (entity != null) {
            entity.setEnabledMark(1);
            this.updateById(entity);
        }
    }
}

