/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmClueTrendsEntity;
import com.bringspring.crm.mapper.CrmClueInfoMapper;
import com.bringspring.crm.model.crmclueinfo.CrmClueAssignUpForm;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoPagination;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoUpForm;
import com.bringspring.crm.model.crmclueinfo.CrmClueNullifyUpForm;
import com.bringspring.crm.model.crmclueinfo.StatisticsSalePagination;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmClueTrendsService;
import com.bringspring.crm.util.CrmClueStateEnum;
import com.bringspring.crm.util.CrmClueTrendsTypeEnum;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.utils.MessageUtils;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmClueInfoServiceImpl
extends ServiceImpl<CrmClueInfoMapper, CrmClueInfoEntity>
implements CrmClueInfoService {
    private static final Logger log = LoggerFactory.getLogger(CrmClueInfoServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmClueTrendsService crmClueTrendsService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmClueInfoMapper crmClueInfoMapper;

    @Override
    public List<CrmClueInfoEntity> getList(CrmClueInfoPagination crmClueInfoPagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmClueInfoQueryWrapper = this.appendWrapper(crmClueInfoPagination);
        if (ObjectUtil.isNull(crmClueInfoQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            crmClueInfoQueryWrapper.lambda().in(CrmClueInfoEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)crmClueInfoPagination.getSidx())) {
            crmClueInfoQueryWrapper.lambda().orderByDesc(CrmClueInfoEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmClueInfoPagination.getSidx();
                CrmClueInfoEntity crmClueInfoEntity = new CrmClueInfoEntity();
                Field declaredField = crmClueInfoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmClueInfoQueryWrapper = "asc".equals(crmClueInfoPagination.getSort().toLowerCase()) ? (QueryWrapper)crmClueInfoQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmClueInfoQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmClueInfoPagination.getCurrentPage(), crmClueInfoPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmClueInfoQueryWrapper);
            return crmClueInfoPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmClueInfoPagination.setData(list, list.size());
    }

    @Override
    public List<CrmClueInfoEntity> getTypeList(CrmClueInfoPagination crmClueInfoPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmClueInfoQueryWrapper = this.appendWrapper(crmClueInfoPagination);
        if (ObjectUtil.isNull(crmClueInfoQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            crmClueInfoQueryWrapper.lambda().in(CrmClueInfoEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)crmClueInfoPagination.getSidx())) {
            crmClueInfoQueryWrapper.lambda().orderByDesc(CrmClueInfoEntity::getId);
        } else {
            try {
                String sidx = crmClueInfoPagination.getSidx();
                CrmClueInfoEntity crmClueInfoEntity = new CrmClueInfoEntity();
                Field declaredField = crmClueInfoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmClueInfoQueryWrapper = "asc".equals(crmClueInfoPagination.getSort().toLowerCase()) ? (QueryWrapper)crmClueInfoQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmClueInfoQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmClueInfoPagination.getCurrentPage(), crmClueInfoPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmClueInfoQueryWrapper);
                return crmClueInfoPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmClueInfoPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmClueInfoQueryWrapper);
    }

    private QueryWrapper<CrmClueInfoEntity> appendWrapper(CrmClueInfoPagination crmClueInfoPagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper crmClueInfoQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (!StrUtil.equals((CharSequence)crmClueInfoPagination.getSearchType(), (CharSequence)"self")) {
            Object crmClueInfoObj;
            if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                crmClueInfoObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmClueInfoQueryWrapper, crmClueInfoPagination.getMenuId(), "crm_clue_info"));
                if (ObjectUtil.isEmpty((Object)crmClueInfoObj)) {
                    return null;
                }
                crmClueInfoQueryWrapper = (QueryWrapper)crmClueInfoObj;
            }
            if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                crmClueInfoObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmClueInfoQueryWrapper, crmClueInfoPagination.getMenuId(), "crm_clue_info"));
                if (ObjectUtil.isEmpty((Object)crmClueInfoObj)) {
                    return null;
                }
                crmClueInfoQueryWrapper = (QueryWrapper)crmClueInfoObj;
            }
        } else {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getFollowUser, (Object)userInfo.getUserId());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCustomerId())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getCustomerId, (Object)crmClueInfoPagination.getCustomerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getName())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getName, (Object)crmClueInfoPagination.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getUserId())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getFollowUser, (Object)crmClueInfoPagination.getUserId());
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoPagination.getUserIdList())) {
            crmClueInfoQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.or()).in(CrmClueInfoEntity::getFollowUser, crmClueInfoPagination.getUserIdList())).or()).in(CrmClueInfoEntity::getCreatorUserId, crmClueInfoPagination.getUserIdList()));
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getState())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getState, (Object)crmClueInfoPagination.getState());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCreatorUserId())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getCreatorUserId, (Object)crmClueInfoPagination.getCreatorUserId());
        }
        if (StrUtil.isNotBlank((CharSequence)crmClueInfoPagination.getDepartment())) {
            List listByOraganizetionId = this.userService.getListByOraganizetionId(crmClueInfoPagination.getDepartment());
            if (CollectionUtil.isEmpty((Collection)listByOraganizetionId)) {
                return null;
            }
            List collect = listByOraganizetionId.stream().map(UserEntity::getId).collect(Collectors.toList());
            crmClueInfoQueryWrapper.lambda().in(CrmClueInfoEntity::getCreatorUserId, collect);
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoPagination.getStateList())) {
            crmClueInfoQueryWrapper.lambda().in(CrmClueInfoEntity::getState, crmClueInfoPagination.getStateList());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getSource())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getSource, (Object)crmClueInfoPagination.getSource());
        }
        if (StringUtils.isNotEmpty(crmClueInfoPagination.getCreatorTime())) {
            List<String> CreatorTimeList = crmClueInfoPagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)crmClueInfoQueryWrapper.lambda().ge(CrmClueInfoEntity::getCreatorTime, (Object)new Date(fir))).le(CrmClueInfoEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCustomerType())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getCustomerType, (Object)crmClueInfoPagination.getCustomerType());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCustomerName())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getCustomerName, (Object)crmClueInfoPagination.getCustomerName());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCustomerContacts())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getCustomerContacts, (Object)crmClueInfoPagination.getCustomerContacts());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getContactsPhone())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getContactsPhone, (Object)crmClueInfoPagination.getContactsPhone());
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoPagination.getAddress())) {
            List addressList = JsonUtil.getJsonToList(crmClueInfoPagination.getAddress(), String.class);
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getAddress, addressList.get(addressList.size() - 1));
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getProductType())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getProductType, (Object)crmClueInfoPagination.getProductType());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCompanyId())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getCompanyId, (Object)crmClueInfoPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoPagination.getCompanyIdList())) {
            crmClueInfoQueryWrapper.lambda().in(CrmClueInfoEntity::getCompanyId, crmClueInfoPagination.getCompanyIdList());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getProjectStages())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getProjectStages, (Object)crmClueInfoPagination.getProjectStages());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getCompetitor())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getCompetitor, (Object)crmClueInfoPagination.getCompetitor());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getIsSecondarySale())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getIsSecondarySale, (Object)crmClueInfoPagination.getIsSecondarySale());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getInvestWay())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueInfoEntity::getInvestWay, (Object)crmClueInfoPagination.getInvestWay());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getAgentName())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getAgentName, (Object)crmClueInfoPagination.getAgentName());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getDescription())) {
            crmClueInfoQueryWrapper.lambda().like(CrmClueInfoEntity::getDescription, (Object)crmClueInfoPagination.getDescription());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueInfoPagination.getKeyword())) {
            crmClueInfoQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.or()).like(CrmClueInfoEntity::getCustomerName, (Object)crmClueInfoPagination.getKeyword())).or()).like(CrmClueInfoEntity::getName, (Object)crmClueInfoPagination.getKeyword()));
        }
        return crmClueInfoQueryWrapper;
    }

    @Override
    public CrmClueInfoEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmClueInfoEntity::getId, (Object)id);
        return (CrmClueInfoEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmClueInfoEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmClueInfoEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmClueInfoEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void follow(CrmClueInfoUpForm crmClueInfoUpForm) {
        List jsonToList;
        Date lastFollowTime;
        UserInfo userInfo = this.userProvider.get();
        CrmClueInfoEntity subentity = (CrmClueInfoEntity)this.getById((Serializable)((Object)crmClueInfoUpForm.getId()));
        CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setClueId(crmClueInfoUpForm.getId());
        trendsEntity.setFormData(JsonUtil.getObjectToString((Object)subentity));
        trendsEntity.setType(CrmClueTrendsTypeEnum.FOLLOW_TYPE.getType());
        trendsEntity.setFollowMethod(crmClueInfoUpForm.getFollowMethod());
        if (crmClueInfoUpForm.getFollowTime() != null && crmClueInfoUpForm.getFollowTime() > 0L) {
            trendsEntity.setFollowTime((Date)DateUtil.date((long)crmClueInfoUpForm.getFollowTime()));
        }
        if (ObjectUtil.isNull((Object)trendsEntity.getFollowTime())) {
            trendsEntity.setFollowTime(DateUtil.getNowDate());
        }
        trendsEntity.setDescription(crmClueInfoUpForm.getDescription());
        this.crmClueTrendsService.save(trendsEntity);
        if (ObjectUtil.isNotNull((Object)crmClueInfoUpForm.getFollowTime()) && (ObjectUtil.isNull((Object)(lastFollowTime = subentity.getLastFollowTime())) || lastFollowTime.before(trendsEntity.getFollowTime()))) {
            subentity.setLastFollowTime((Date)DateUtil.date((long)crmClueInfoUpForm.getFollowTime()));
            this.updateById(subentity);
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoUpForm.getAttachmentList()) && CollectionUtil.isNotEmpty((Collection)(jsonToList = JsonUtil.getJsonToList(crmClueInfoUpForm.getAttachmentList(), RkAttachmentEntity.class)))) {
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(trendsEntity.getId());
                att.setFileType(AttachmentTypeEnum.CRM_CLUE_FOLLOW_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(jsonToList);
        }
        if (CollectionUtil.isNotEmpty(crmClueInfoUpForm.getUserIdList())) {
            String taskCode = MessageTypeEnum.CRM_CLUE_FOLLOW.getMessage();
            String sendCode = MessageTypeEnum.CRM_CLUE_FOLLOW.getTemplateCode();
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", "\u6709\u65b0\u7684\u8ddf\u8fdb\u9500\u552e\u7ebf\u7d22\u8bf7\u60a8\u67e5\u770b");
            keys.put("content", userInfo.getUserName() + "\u8ddf\u8fdb\u4e86\u9500\u552e\u7ebf\u7d22\u3010" + crmClueInfoUpForm.getName() + "\u3011");
            keys.put("name", crmClueInfoUpForm.getName());
            keys.put("followUser", userInfo.getUserName());
            keys.put("messageTime", DateUtil.getNow());
            String appUrl = "/#/pages/crm/clue/index/form?jurisdictionType=btn_detail&id=" + crmClueInfoUpForm.getId();
            String pcUrl = "/#/crm/clue/index.vue?id=" + crmClueInfoUpForm.getId();
            String type = TermTypeEnum.TERM_APP_PC.getCode();
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join(crmClueInfoUpForm.getUserIdList(), (CharSequence)","), type, null);
        }
    }

    @Override
    @DSTransactional
    public void assign(CrmClueAssignUpForm crmClueAssignUpForm) {
        UserInfo userInfo = this.userProvider.get();
        CrmClueInfoEntity byId = (CrmClueInfoEntity)this.getById((Serializable)((Object)crmClueAssignUpForm.getId()));
        byId.setFollowUser(crmClueAssignUpForm.getUserIdList());
        byId.setState(CrmClueStateEnum.ASSIGNED_STATE.getState());
        this.updateById(byId);
        CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setClueId(crmClueAssignUpForm.getId());
        trendsEntity.setFormData(JsonUtil.getObjectToString((Object)byId));
        trendsEntity.setType(CrmClueTrendsTypeEnum.ASSIGNED_TYPE.getType());
        trendsEntity.setFollowTime(new Date());
        if (StrUtil.isBlank((CharSequence)crmClueAssignUpForm.getDescription())) {
            trendsEntity.setDescription(userInfo.getUserName() + "\u5206\u6d3e\u7ed9\u3010" + ((UserEntity)this.userService.getById((Serializable)((Object)crmClueAssignUpForm.getUserIdList()))).getRealName() + "\u3011");
        } else {
            trendsEntity.setDescription(crmClueAssignUpForm.getDescription());
        }
        this.crmClueTrendsService.save(trendsEntity);
        if (StrUtil.isNotEmpty((CharSequence)crmClueAssignUpForm.getUserIdList())) {
            String taskCode = MessageTypeEnum.CRM_CLUE_ASSIGN.getMessage();
            String sendCode = MessageTypeEnum.CRM_CLUE_ASSIGN.getTemplateCode();
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", "\u6709\u5206\u6d3e\u7ed9\u60a8\u7684\u9500\u552e\u7ebf\u7d22\u8bf7\u60a8\u67e5\u770b");
            keys.put("content", userInfo.getUserName() + "\u5206\u6d3e\u7ed9\u60a8\u7684\u9500\u552e\u7ebf\u7d22\u3010" + byId.getName() + "\u3011");
            keys.put("name", byId.getName());
            keys.put("assignUser", userInfo.getUserName());
            keys.put("messageTime", DateUtil.getNow());
            String appUrl = "/#/pages/crm/clue/index/form?jurisdictionType=btn_detail&id=" + crmClueAssignUpForm.getId();
            String pcUrl = "/#/crm/clue/index.vue?id=" + crmClueAssignUpForm.getId();
            String type = TermTypeEnum.TERM_APP_PC.getCode();
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, crmClueAssignUpForm.getUserIdList(), type, null);
        }
    }

    @Override
    @DSTransactional
    public void nullify(CrmClueNullifyUpForm crmClueNullifyUpForm) {
        UserInfo userInfo = this.userProvider.get();
        CrmClueInfoEntity byId = (CrmClueInfoEntity)this.getById((Serializable)((Object)crmClueNullifyUpForm.getId()));
        byId.setState(CrmClueStateEnum.NULLIFY_STATE.getState());
        byId.setNullifyRemark(crmClueNullifyUpForm.getNullifyRemark());
        this.updateById(byId);
        CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setClueId(crmClueNullifyUpForm.getId());
        trendsEntity.setFormData(JsonUtil.getObjectToString((Object)byId));
        trendsEntity.setFollowTime(new Date());
        trendsEntity.setType(CrmClueTrendsTypeEnum.NULLIFY_TYPE.getType());
        if (StrUtil.isBlank((CharSequence)crmClueNullifyUpForm.getNullifyRemark())) {
            trendsEntity.setDescription(userInfo.getUserName() + "\u4f5c\u5e9f\u4e86\u7ebf\u7d22");
        } else {
            trendsEntity.setDescription(crmClueNullifyUpForm.getNullifyRemark());
        }
        this.crmClueTrendsService.save(trendsEntity);
    }

    @Override
    public long countByState(CrmClueInfoPagination crmClueInfoPagination) {
        QueryWrapper<CrmClueInfoEntity> queryWrapper = this.appendWrapper(crmClueInfoPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public BigDecimal countAmount(CrmClueInfoPagination crmClueInfoPagination) {
        QueryWrapper<CrmClueInfoEntity> queryWrapper = this.appendWrapper(crmClueInfoPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return BigDecimal.ZERO;
        }
        queryWrapper.select(new String[]{"sum(contract_amount) as contractAmount"});
        Map map = this.getMap((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)map) || ObjectUtil.isNull(map.get("contractAmount"))) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(map.get("contractAmount").toString());
    }

    @Override
    public void updateByReporting(String clueId, String type) {
        CrmClueInfoEntity byId = (CrmClueInfoEntity)this.getById((Serializable)((Object)clueId));
        if (ObjectUtil.isNotNull((Object)byId)) {
            if (StrUtil.equals((CharSequence)type, (CharSequence)"1")) {
                byId.setState(CrmClueStateEnum.TRANSFERRED_STATE.getState());
                this.updateById(byId);
                CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
                trendsEntity.setId(RandomUtil.uuId());
                trendsEntity.setClueId(clueId);
                trendsEntity.setFormData(JsonUtil.getObjectToString((Object)byId));
                trendsEntity.setType(CrmClueTrendsTypeEnum.TRANSFERRED_TYPE.getType());
                trendsEntity.setFollowTime(new Date());
                trendsEntity.setDescription("\u8f6c\u5546\u673a");
                this.crmClueTrendsService.save(trendsEntity);
            } else {
                byId.setState(CrmClueStateEnum.ASSIGNED_STATE.getState());
                this.updateById(byId);
                CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
                trendsEntity.setId(RandomUtil.uuId());
                trendsEntity.setClueId(clueId);
                trendsEntity.setFormData(JsonUtil.getObjectToString((Object)byId));
                trendsEntity.setType(CrmClueTrendsTypeEnum.TRANSFERRED_TYPE.getType());
                trendsEntity.setFollowTime(new Date());
                trendsEntity.setDescription("\u8f6c\u5546\u673a\u5931\u8d25");
                this.crmClueTrendsService.save(trendsEntity);
            }
        }
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            log.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    @Override
    @FlowCallBackMethod(fullName="\u7ebf\u7d22\u7ebf\u7d22", description="crmClueFlowCallBackMethod")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        CrmClueInfoEntity byId = (CrmClueInfoEntity)this.getById((Serializable)((Object)id));
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNotNull((Object)byId)) {
            Map formData = model.getFormData();
            CrmClueTrendsEntity trendsEntity = new CrmClueTrendsEntity();
            trendsEntity.setId(RandomUtil.uuId());
            trendsEntity.setClueId(id);
            trendsEntity.setFormData(JsonUtil.getObjectToString((Object)formData));
            trendsEntity.setFollowTime(new Date());
            if (enableMark == 1) {
                byId.setState(CrmClueStateEnum.AUDIT_STATE.getState());
                trendsEntity.setType(CrmClueTrendsTypeEnum.CREATE_TYPE.getType());
                trendsEntity.setDescription(userInfo.getUserName() + "\u65b0\u5efa\u9500\u552e\u7ebf\u7d22");
            }
            if (enableMark == 2) {
                byId.setState(CrmClueStateEnum.UNASSIGNED_STATE.getState());
                trendsEntity.setType(CrmClueTrendsTypeEnum.AUDIT_TYPE.getType());
                trendsEntity.setDescription(userInfo.getUserName() + "\u5ba1\u6838\u901a\u8fc7");
            }
            if (enableMark == 3) {
                byId.setState(CrmClueStateEnum.DRAFT_STATE.getState());
                trendsEntity.setType(CrmClueTrendsTypeEnum.WITHDRAW_TYPE.getType());
                trendsEntity.setDescription(userInfo.getUserName() + "\u64a4\u56de");
            }
            if (enableMark == 5) {
                byId.setState(CrmClueStateEnum.REFUSE_STATE.getState());
                trendsEntity.setType(CrmClueTrendsTypeEnum.REFUSE_TYPE.getType());
                trendsEntity.setDescription(userInfo.getUserName() + "\u5ba1\u6838\u62d2\u7edd");
            }
            this.updateById(byId);
            this.crmClueTrendsService.save(trendsEntity);
        }
        return false;
    }

    @Override
    public List<CrmClueInfoEntity> notFollowByUserIdAndDay(String userId, Integer day) {
        List list = CollectionUtil.list((boolean)false, (Object[])new String[]{"unassigned", "assigned"});
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(CrmClueInfoEntity::getFollowUser, (Object)userId)).in(CrmClueInfoEntity::getState, (Collection)list)).lt(CrmClueInfoEntity::getLastFollowTime, (Object)DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)(day * -1)));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmClueInfoEntity> getListByCustomerIdAndStateIn(String customerId, List<String> stateIn) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CrmClueInfoEntity::getCustomerId, (Object)customerId);
        if (CollectionUtil.isNotEmpty(stateIn)) {
            queryWrapper.in(CrmClueInfoEntity::getState, stateIn);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List getStatisticsSale(StatisticsSalePagination pagination) {
        Object crmClueInfoObj;
        UserInfo userInfo = this.userProvider.get();
        List userEntities = CollectionUtil.list((boolean)false);
        if (!userInfo.getIsAdministrator().booleanValue()) {
            QueryWrapper userEntityQueryWrapper = new QueryWrapper();
            crmClueInfoObj = this.authorizeService.getCondition(new AuthorizeConditionModel(userEntityQueryWrapper, pagination.getMenuId(), "base_user"));
            if (ObjectUtil.isEmpty((Object)crmClueInfoObj)) {
                userEntities = this.userService.getListByOraganizetionId(userInfo.getOrganizeId());
            } else {
                userEntityQueryWrapper = (QueryWrapper)crmClueInfoObj;
                userEntities = this.userService.list((Wrapper)userEntityQueryWrapper);
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            List<String> companyArray = Arrays.asList(pagination.getCompanyId().split(","));
            crmClueInfoObj = companyArray.iterator();
            while (crmClueInfoObj.hasNext()) {
                String companyId = (String)crmClueInfoObj.next();
                userEntities.addAll(this.userService.getListByOraganizetionId(companyId));
            }
        }
        if (CollectionUtil.isNotEmpty(pagination.getCompanyIdList())) {
            for (String companyId : pagination.getCompanyIdList()) {
                userEntities.addAll(this.userService.getListByOraganizetionId(companyId));
            }
        }
        if (StringUtils.isEmpty((String)pagination.getDataType()) || !StringUtils.equals((CharSequence)pagination.getDataType(), (CharSequence)"1")) {
            PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
        }
        String startDate = "";
        String endDate = "";
        if (CollectionUtil.isNotEmpty(pagination.getCreatorTime())) {
            startDate = DateUtil.formatDate((Date)pagination.getCreatorTime().get(0)) + " 00:00:00";
            endDate = DateUtil.formatDate((Date)pagination.getCreatorTime().get(1)) + " 23:59:59";
        }
        List collect = userEntities.stream().map(UserEntity::getId).collect(Collectors.toList());
        if (StrUtil.isNotEmpty((CharSequence)pagination.getUserId())) {
            if (CollectionUtil.contains(collect, (Object)pagination.getUserId()) || userInfo.getIsAdministrator().booleanValue()) {
                collect = CollectionUtil.list((boolean)false, (Object[])new String[]{pagination.getUserId()});
            } else {
                PageInfo pageInfo = new PageInfo(CollectionUtil.list((boolean)false));
                return pagination.setData(pageInfo.getList(), pageInfo.getTotal());
            }
        }
        List statisticsSale = this.crmClueInfoMapper.getStatisticsSale(startDate, endDate, collect);
        PageInfo pageInfo = new PageInfo(statisticsSale);
        return pagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }
}

