/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmClueTrendsEntity;
import com.bringspring.crm.mapper.CrmClueTrendsMapper;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsPagination;
import com.bringspring.crm.service.CrmClueTrendsService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visit.model.rkMarketLog.VisitFollowUpForm;
import com.bringspring.visit.utils.HolidayUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmClueTrendsServiceImpl
extends ServiceImpl<CrmClueTrendsMapper, CrmClueTrendsEntity>
implements CrmClueTrendsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<CrmClueTrendsEntity> getList(CrmClueTrendsPagination crmClueTrendsPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmClueTrendsQueryWrapper = this.appendWrapper(crmClueTrendsPagination);
        if (ObjectUtil.isNull(crmClueTrendsQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            crmClueTrendsQueryWrapper.lambda().in(CrmClueTrendsEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)crmClueTrendsPagination.getSidx())) {
            crmClueTrendsQueryWrapper.lambda().orderByDesc(CrmClueTrendsEntity::getFollowTime);
        } else {
            try {
                String sidx = crmClueTrendsPagination.getSidx();
                CrmClueTrendsEntity crmClueTrendsEntity = new CrmClueTrendsEntity();
                Field declaredField = crmClueTrendsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmClueTrendsQueryWrapper = "asc".equals(crmClueTrendsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmClueTrendsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmClueTrendsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmClueTrendsPagination.getCurrentPage(), crmClueTrendsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmClueTrendsQueryWrapper);
            return crmClueTrendsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmClueTrendsPagination.setData(list, list.size());
    }

    @Override
    public List<CrmClueTrendsEntity> getListByClueId(String clueId) {
        QueryWrapper crmClueTrendsQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)crmClueTrendsQueryWrapper.lambda().eq(CrmClueTrendsEntity::getClueId, (Object)clueId)).orderByDesc(CrmClueTrendsEntity::getFollowTime);
        return this.list((Wrapper)crmClueTrendsQueryWrapper);
    }

    @Override
    public List<CrmClueTrendsEntity> getTypeList(CrmClueTrendsPagination crmClueTrendsPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmClueTrendsQueryWrapper = this.appendWrapper(crmClueTrendsPagination);
        if (ObjectUtil.isNull(crmClueTrendsQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            crmClueTrendsQueryWrapper.lambda().in(CrmClueTrendsEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)crmClueTrendsPagination.getSidx())) {
            crmClueTrendsQueryWrapper.lambda().orderByDesc(CrmClueTrendsEntity::getId);
        } else {
            try {
                String sidx = crmClueTrendsPagination.getSidx();
                CrmClueTrendsEntity crmClueTrendsEntity = new CrmClueTrendsEntity();
                Field declaredField = crmClueTrendsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmClueTrendsQueryWrapper = "asc".equals(crmClueTrendsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmClueTrendsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmClueTrendsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmClueTrendsPagination.getCurrentPage(), crmClueTrendsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmClueTrendsQueryWrapper);
                return crmClueTrendsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmClueTrendsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmClueTrendsQueryWrapper);
    }

    private QueryWrapper<CrmClueTrendsEntity> appendWrapper(CrmClueTrendsPagination crmClueTrendsPagination) {
        Long sec;
        Long fir;
        List<String> CreatorTimeList;
        Object crmClueTrendsObj;
        QueryWrapper crmClueTrendsQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmClueTrendsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmClueTrendsQueryWrapper, crmClueTrendsPagination.getMenuId(), "crmClueTrends"));
            if (ObjectUtil.isEmpty((Object)crmClueTrendsObj)) {
                return null;
            }
            crmClueTrendsQueryWrapper = (QueryWrapper)crmClueTrendsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmClueTrendsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmClueTrendsQueryWrapper, crmClueTrendsPagination.getMenuId(), "crmClueTrends"));
            if (ObjectUtil.isEmpty((Object)crmClueTrendsObj)) {
                return null;
            }
            crmClueTrendsQueryWrapper = (QueryWrapper)crmClueTrendsObj;
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueTrendsPagination.getClueId())) {
            crmClueTrendsQueryWrapper.lambda().like(CrmClueTrendsEntity::getClueId, (Object)crmClueTrendsPagination.getClueId());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueTrendsPagination.getType())) {
            crmClueTrendsQueryWrapper.lambda().like(CrmClueTrendsEntity::getType, (Object)crmClueTrendsPagination.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueTrendsPagination.getFollowMethod())) {
            crmClueTrendsQueryWrapper.lambda().eq(CrmClueTrendsEntity::getFollowMethod, (Object)crmClueTrendsPagination.getFollowMethod());
        }
        if (StringUtils.isNotEmpty(crmClueTrendsPagination.getCreatorTime())) {
            CreatorTimeList = crmClueTrendsPagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)crmClueTrendsQueryWrapper.lambda().ge(CrmClueTrendsEntity::getCreatorTime, (Object)new Date(fir))).le(CrmClueTrendsEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(crmClueTrendsPagination.getFollowTime())) {
            CreatorTimeList = crmClueTrendsPagination.getFollowTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)crmClueTrendsQueryWrapper.lambda().ge(CrmClueTrendsEntity::getFollowTime, (Object)new Date(fir))).le(CrmClueTrendsEntity::getFollowTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueTrendsPagination.getDescription())) {
            crmClueTrendsQueryWrapper.lambda().like(CrmClueTrendsEntity::getDescription, (Object)crmClueTrendsPagination.getDescription());
        }
        if (StrUtil.isNotEmpty((CharSequence)crmClueTrendsPagination.getFormData())) {
            crmClueTrendsQueryWrapper.lambda().like(CrmClueTrendsEntity::getFormData, (Object)crmClueTrendsPagination.getFormData());
        }
        return crmClueTrendsQueryWrapper;
    }

    @Override
    public CrmClueTrendsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmClueTrendsEntity::getId, (Object)id);
        return (CrmClueTrendsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmClueTrendsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmClueTrendsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<CrmClueTrendsEntity> getUserIdDate(VisitFollowUpForm visitFollowUpForm) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper crmClueInfoQueryWrapper = new QueryWrapper();
        if (Objects.nonNull(visitFollowUpForm.getId())) {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueTrendsEntity::getCreatorUserId, (Object)visitFollowUpForm.getId());
        } else {
            crmClueInfoQueryWrapper.lambda().eq(CrmClueTrendsEntity::getCreatorUserId, (Object)userInfo.getUserId());
        }
        if (visitFollowUpForm.getLogType().equals("519482164182535109")) {
            crmClueInfoQueryWrapper.lambda().between(CrmClueTrendsEntity::getCreatorTime, (Object)HolidayUtil.getBeginDayOfWeek(visitFollowUpForm.getOptionDate()), (Object)HolidayUtil.getEndDayOfWeek(visitFollowUpForm.getOptionDate()));
        } else if (visitFollowUpForm.getStartTime() != null && visitFollowUpForm.getStartTime().size() > 0) {
            visitFollowUpForm.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(visitFollowUpForm.getStartTime().get(0))));
            visitFollowUpForm.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(visitFollowUpForm.getStartTime().get(1) + 86400000L)));
            crmClueInfoQueryWrapper.lambda().between(CrmClueTrendsEntity::getCreatorTime, (Object)visitFollowUpForm.getStartTimes(), (Object)visitFollowUpForm.getEndTime());
        } else {
            crmClueInfoQueryWrapper.lambda().in(CrmClueTrendsEntity::getId, new Object[]{""});
        }
        return this.list((Wrapper)crmClueInfoQueryWrapper);
    }

    @Override
    public void delete(CrmClueTrendsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

