/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCompetitorEntity;
import com.bringspring.crm.mapper.CrmCompetitorMapper;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorCrForm;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorPagination;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorUpForm;
import com.bringspring.crm.service.CrmCompetitorService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmCompetitorServiceImpl
extends ServiceImpl<CrmCompetitorMapper, CrmCompetitorEntity>
implements CrmCompetitorService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<CrmCompetitorEntity> getList(CrmCompetitorPagination crmCompetitorPagination) {
        QueryWrapper<CrmCompetitorEntity> crmCompetitorQueryWrapper = this.appendWrapper(crmCompetitorPagination);
        Page page = new Page(crmCompetitorPagination.getCurrentPage(), crmCompetitorPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)crmCompetitorQueryWrapper);
        return crmCompetitorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<CrmCompetitorEntity> appendWrapper(CrmCompetitorPagination crmCompetitorPagination) {
        Object competitorObj;
        QueryWrapper crmCompetitorQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            competitorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCompetitorQueryWrapper, crmCompetitorPagination.getMenuId(), "crm_competitor"));
            if (ObjectUtil.isEmpty((Object)competitorObj)) {
                crmCompetitorQueryWrapper.and(this.defaultWrapper());
            } else {
                crmCompetitorQueryWrapper = (QueryWrapper)competitorObj;
            }
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            competitorObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCompetitorQueryWrapper, crmCompetitorPagination.getMenuId(), "crm_competitor"));
            if (ObjectUtil.isEmpty((Object)competitorObj)) {
                crmCompetitorQueryWrapper.and(this.defaultWrapper());
            } else {
                crmCompetitorQueryWrapper = (QueryWrapper)competitorObj;
            }
        }
        crmCompetitorQueryWrapper.lambda().eq(CrmCompetitorEntity::getDeleteFlag, (Object)0);
        if (StringUtils.isNotEmpty((String)crmCompetitorPagination.getCompetitorName())) {
            crmCompetitorQueryWrapper.lambda().like(CrmCompetitorEntity::getCompetitorName, (Object)crmCompetitorPagination.getCompetitorName());
        }
        if (StringUtils.isNotEmpty((String)crmCompetitorPagination.getAdvantageState())) {
            crmCompetitorQueryWrapper.lambda().eq(CrmCompetitorEntity::getAdvantageState, (Object)crmCompetitorPagination.getAdvantageState());
        }
        if (StringUtils.isNotEmpty((String)crmCompetitorPagination.getCompanyId())) {
            crmCompetitorQueryWrapper.lambda().eq(CrmCompetitorEntity::getCompanyId, (Object)crmCompetitorPagination.getCompanyId());
        }
        if (StringUtils.isEmpty((String)crmCompetitorPagination.getSidx())) {
            crmCompetitorQueryWrapper.lambda().orderByDesc(CrmCompetitorEntity::getId);
        } else {
            try {
                String sidx = crmCompetitorPagination.getSidx();
                CrmCompetitorEntity crmCompetitorEntity = new CrmCompetitorEntity();
                Field declaredField = crmCompetitorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmCompetitorQueryWrapper = "asc".equals(crmCompetitorPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCompetitorQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCompetitorQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return crmCompetitorQueryWrapper;
    }

    private Consumer<QueryWrapper<CrmCompetitorEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<CrmCompetitorEntity>>(){

            @Override
            public void accept(QueryWrapper<CrmCompetitorEntity> rkContractProjectEntityQueryWrapper) {
                rkContractProjectEntityQueryWrapper.lambda().and(x -> x.eq(CrmCompetitorEntity::getCreatorUserId, (Object)userId));
            }
        };
    }

    @Override
    public List<CrmCompetitorEntity> getTypeList(CrmCompetitorPagination crmCompetitorPagination, String dataType) {
        QueryWrapper<CrmCompetitorEntity> crmCompetitorQueryWrapper = this.appendWrapper(crmCompetitorPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(crmCompetitorPagination.getCurrentPage(), crmCompetitorPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmCompetitorQueryWrapper);
            return crmCompetitorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)crmCompetitorQueryWrapper);
    }

    @Override
    public CrmCompetitorEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCompetitorEntity::getId, (Object)id);
        return (CrmCompetitorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmCompetitorCrForm crmCompetitorCrForm) {
        String mainId = RandomUtil.uuId();
        CrmCompetitorEntity entity = (CrmCompetitorEntity)JsonUtil.getJsonToBean((Object)crmCompetitorCrForm, CrmCompetitorEntity.class);
        entity.setId(mainId);
        UserInfo userInfo = this.userProvider.get();
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDeleteFlag(0);
        this.save(entity);
    }

    @Override
    public void update(String id, CrmCompetitorUpForm crmCompetitorUpForm) {
        CrmCompetitorEntity entity = this.getInfo(id);
        if (entity != null) {
            CrmCompetitorEntity subentity = (CrmCompetitorEntity)JsonUtil.getJsonToBean((Object)crmCompetitorUpForm, CrmCompetitorEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void delete(CrmCompetitorEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

