/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerCompanyRelationEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.mapper.CrmCustomerCompanyRelationMapper;
import com.bringspring.crm.model.crmcustomercompanyrelation.CrmCustomerCompanyRelationPagination;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmCustomerCompanyRelationServiceImpl
extends ServiceImpl<CrmCustomerCompanyRelationMapper, CrmCustomerCompanyRelationEntity>
implements CrmCustomerCompanyRelationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @Override
    public List<CrmCustomerCompanyRelationEntity> getList(CrmCustomerCompanyRelationPagination crmCustomerCompanyRelationPagination) {
        Object crmCustomerCompanyRelationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmCustomerCompanyRelationNum = 0;
        QueryWrapper crmCustomerCompanyRelationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerCompanyRelationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerCompanyRelationQueryWrapper, crmCustomerCompanyRelationPagination.getMenuId(), "crmCustomerCompanyRelation"));
            if (ObjectUtil.isEmpty((Object)crmCustomerCompanyRelationObj)) {
                return new ArrayList<CrmCustomerCompanyRelationEntity>();
            }
            crmCustomerCompanyRelationQueryWrapper = (QueryWrapper)crmCustomerCompanyRelationObj;
            ++crmCustomerCompanyRelationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerCompanyRelationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerCompanyRelationQueryWrapper, crmCustomerCompanyRelationPagination.getMenuId(), "crmCustomerCompanyRelation"));
            if (ObjectUtil.isEmpty((Object)crmCustomerCompanyRelationObj)) {
                return new ArrayList<CrmCustomerCompanyRelationEntity>();
            }
            crmCustomerCompanyRelationQueryWrapper = (QueryWrapper)crmCustomerCompanyRelationObj;
            ++crmCustomerCompanyRelationNum;
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getCustomerId())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getCustomerId, (Object)crmCustomerCompanyRelationPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getCompanyId())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getCompanyId, (Object)crmCustomerCompanyRelationPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getSource())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getSource, (Object)crmCustomerCompanyRelationPagination.getSource());
        }
        if (AllIdList.size() > 0) {
            crmCustomerCompanyRelationQueryWrapper.lambda().in(CrmCustomerCompanyRelationEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmCustomerCompanyRelationPagination.getSidx())) {
            crmCustomerCompanyRelationQueryWrapper.lambda().orderByDesc(CrmCustomerCompanyRelationEntity::getId);
        } else {
            try {
                String sidx = crmCustomerCompanyRelationPagination.getSidx();
                CrmCustomerCompanyRelationEntity crmCustomerCompanyRelationEntity = new CrmCustomerCompanyRelationEntity();
                Field declaredField = crmCustomerCompanyRelationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmCustomerCompanyRelationQueryWrapper = "asc".equals(crmCustomerCompanyRelationPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCustomerCompanyRelationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCustomerCompanyRelationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmCustomerCompanyRelationPagination.getCurrentPage(), crmCustomerCompanyRelationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerCompanyRelationQueryWrapper);
            return crmCustomerCompanyRelationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmCustomerCompanyRelationPagination.setData(list, list.size());
    }

    @Override
    public List<CrmCustomerCompanyRelationEntity> getTypeList(CrmCustomerCompanyRelationPagination crmCustomerCompanyRelationPagination, String dataType) {
        Object crmCustomerCompanyRelationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmCustomerCompanyRelationNum = 0;
        QueryWrapper crmCustomerCompanyRelationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerCompanyRelationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerCompanyRelationQueryWrapper, crmCustomerCompanyRelationPagination.getMenuId(), "crmCustomerCompanyRelation"));
            if (ObjectUtil.isEmpty((Object)crmCustomerCompanyRelationObj)) {
                return new ArrayList<CrmCustomerCompanyRelationEntity>();
            }
            crmCustomerCompanyRelationQueryWrapper = (QueryWrapper)crmCustomerCompanyRelationObj;
            ++crmCustomerCompanyRelationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerCompanyRelationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerCompanyRelationQueryWrapper, crmCustomerCompanyRelationPagination.getMenuId(), "crmCustomerCompanyRelation"));
            if (ObjectUtil.isEmpty((Object)crmCustomerCompanyRelationObj)) {
                return new ArrayList<CrmCustomerCompanyRelationEntity>();
            }
            crmCustomerCompanyRelationQueryWrapper = (QueryWrapper)crmCustomerCompanyRelationObj;
            ++crmCustomerCompanyRelationNum;
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getCustomerId())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getCustomerId, (Object)crmCustomerCompanyRelationPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getCompanyId())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getCompanyId, (Object)crmCustomerCompanyRelationPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerCompanyRelationPagination.getSource())) {
            ++crmCustomerCompanyRelationNum;
            crmCustomerCompanyRelationQueryWrapper.lambda().like(CrmCustomerCompanyRelationEntity::getSource, (Object)crmCustomerCompanyRelationPagination.getSource());
        }
        if (AllIdList.size() > 0) {
            crmCustomerCompanyRelationQueryWrapper.lambda().in(CrmCustomerCompanyRelationEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmCustomerCompanyRelationPagination.getSidx())) {
            crmCustomerCompanyRelationQueryWrapper.lambda().orderByDesc(CrmCustomerCompanyRelationEntity::getId);
        } else {
            try {
                String sidx = crmCustomerCompanyRelationPagination.getSidx();
                CrmCustomerCompanyRelationEntity crmCustomerCompanyRelationEntity = new CrmCustomerCompanyRelationEntity();
                Field declaredField = crmCustomerCompanyRelationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmCustomerCompanyRelationQueryWrapper = "asc".equals(crmCustomerCompanyRelationPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCustomerCompanyRelationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCustomerCompanyRelationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmCustomerCompanyRelationPagination.getCurrentPage(), crmCustomerCompanyRelationPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerCompanyRelationQueryWrapper);
                return crmCustomerCompanyRelationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmCustomerCompanyRelationPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmCustomerCompanyRelationQueryWrapper);
    }

    @Override
    public CrmCustomerCompanyRelationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerCompanyRelationEntity::getId, (Object)id);
        return (CrmCustomerCompanyRelationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmCustomerCompanyRelationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmCustomerCompanyRelationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmCustomerCompanyRelationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<CrmCustomerCompanyRelationEntity> getByCustomerAndCompanyIdAndSource(String customerId, String companyId, String source) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)customerId)) {
            queryWrapper.lambda().eq(CrmCustomerCompanyRelationEntity::getCustomerId, (Object)customerId);
        }
        if (StringUtils.isNotEmpty((String)companyId)) {
            queryWrapper.lambda().eq(CrmCustomerCompanyRelationEntity::getCompanyId, (Object)companyId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateByRemoveProduct(String productId, String customerId) {
        List<CrmCustomerCompanyRelationEntity> list;
        String companyId = this.crmProductService.getCompanyId(productId);
        List<Map> customerIdByCompanyId = this.crmProductRelationService.getCustomerIdByCompanyId(companyId);
        List list2 = customerIdByCompanyId.stream().filter(map -> StrUtil.equals((CharSequence)map.get("customerId").toString(), (CharSequence)customerId)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(list2) && CollectionUtil.isNotEmpty(list = this.getByCustomerAndCompanyIdAndSource(customerId, companyId, null))) {
            CrmCustomerCompanyRelationEntity relationEntity = list.get(0);
            String source = relationEntity.getSource();
            if (source.equals("1")) {
                this.removeById((Serializable)((Object)relationEntity.getId()));
            } else if (relationEntity.getSource().contains("1")) {
                String[] split = source.split(",");
                List<String> list1 = Arrays.asList(split);
                List ll = list1.stream().filter(s -> !StrUtil.equals((CharSequence)s, (CharSequence)"1")).collect(Collectors.toList());
                String join = CollectionUtil.join(ll, (CharSequence)",");
                relationEntity.setSource(join);
                this.update(relationEntity.getId(), relationEntity);
            }
        }
        return true;
    }

    @Override
    public boolean updateByAddProduct(String productId, String customerId) {
        List<CrmCustomerCompanyRelationEntity> byCustomerAndCompanyIdAndSource;
        String companyId = "";
        CrmProductEntity one = (CrmProductEntity)this.crmProductService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductEntity::getId, (Object)productId));
        CrmProductCategoryEntity productCompany = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductCategoryEntity::getId, (Object)one.getCategoryId()));
        if (!ObjectUtil.isEmpty((Object)productCompany)) {
            companyId = productCompany.getParentId();
        }
        if (CollectionUtil.isEmpty(byCustomerAndCompanyIdAndSource = this.getByCustomerAndCompanyIdAndSource(customerId, companyId, "1"))) {
            CrmCustomerCompanyRelationEntity relationEntity = new CrmCustomerCompanyRelationEntity();
            relationEntity.setCustomerId(customerId);
            relationEntity.setCompanyId(companyId);
            relationEntity.setSource("1");
            relationEntity.setId(RandomUtil.uuId());
            this.save(relationEntity);
        } else {
            CrmCustomerCompanyRelationEntity relationEntity = byCustomerAndCompanyIdAndSource.get(0);
            if (!StrUtil.contains((CharSequence)relationEntity.getSource(), (CharSequence)"1")) {
                relationEntity.setSource(relationEntity.getSource() + ",1");
                this.update(relationEntity.getCompanyId(), relationEntity);
            }
        }
        return false;
    }
}

