/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.mapper.CrmCustomerContactsMapper;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsPagination;
import com.bringspring.crm.model.datacenter.SaleDataSummaryVo;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmDepartConnectService;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmCustomerContactsServiceImpl
extends ServiceImpl<CrmCustomerContactsMapper, CrmCustomerContactsEntity>
implements CrmCustomerContactsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CrmDepartConnectService crmDepartConnectService;

    @Override
    public List<CrmCustomerContactsEntity> getList(CrmCustomerContactsPagination crmCustomerContactsPagination) {
        QueryWrapper crmCustomerContactsQueryWrapper = this.appendWrapper(crmCustomerContactsPagination);
        if (ObjectUtil.isNull(crmCustomerContactsQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (StringUtils.isEmpty((String)crmCustomerContactsPagination.getSidx())) {
            crmCustomerContactsQueryWrapper.lambda().orderByDesc(CrmCustomerContactsEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmCustomerContactsPagination.getSidx();
                CrmCustomerContactsEntity crmCustomerContactsEntity = new CrmCustomerContactsEntity();
                Field declaredField = crmCustomerContactsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmCustomerContactsQueryWrapper = "asc".equals(crmCustomerContactsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCustomerContactsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCustomerContactsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(crmCustomerContactsPagination.getCurrentPage(), crmCustomerContactsPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerContactsQueryWrapper);
        return crmCustomerContactsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<CrmCustomerContactsEntity> appendWrapper(CrmCustomerContactsPagination crmCustomerContactsPagination) {
        DictionaryDataEntity swapInfo;
        List<CrmCustomerEntity> listByCustomerAddress;
        Object crmCustomerContactsObj;
        UserInfo userInfo = this.userProvider.get();
        String userId = userInfo.getUserId();
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"2")) {
            List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
            List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            List listByIds = this.roleService.getListByIds(roleIds);
            List collect = listByIds.stream().map(PermissionEntityBase::getEnCode).collect(Collectors.toList());
            List typeCollect = listByIds.stream().map(RoleEntity::getType).collect(Collectors.toList());
            if (collect.contains("AfterSalesPersonnel")) {
                crmCustomerContactsPagination.setIsAfterSalesPersonnel(1);
            }
            if (typeCollect.contains("afterSale")) {
                crmCustomerContactsPagination.setIsAfterSalesPersonnel(1);
            }
        }
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmCustomerContactsNum = 0;
        int crmCustomerNum = 0;
        QueryWrapper crmCustomerContactsQueryWrapper = new QueryWrapper();
        QueryWrapper crmCustomerEntityQueryWrapper = new QueryWrapper();
        boolean authFlag = false;
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !userInfo.getIsAdministrator().booleanValue() && !ObjectUtil.isEmpty((Object)(crmCustomerContactsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerContactsQueryWrapper, crmCustomerContactsPagination.getMenuId(), "crm_customer_contacts"))))) {
            authFlag = true;
            crmCustomerContactsQueryWrapper = (QueryWrapper)crmCustomerContactsObj;
            ++crmCustomerContactsNum;
        }
        if (!isPc && appPermission && !userInfo.getIsAdministrator().booleanValue() && !ObjectUtil.isEmpty((Object)(crmCustomerContactsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerContactsQueryWrapper, crmCustomerContactsPagination.getMenuId(), "crm_customer_contacts"))))) {
            authFlag = true;
            crmCustomerContactsQueryWrapper = (QueryWrapper)crmCustomerContactsObj;
            ++crmCustomerContactsNum;
        }
        if (ObjectUtil.isNotEmpty(crmCustomerContactsPagination.getCustomerAddress()) && ObjectUtil.isNotEmpty(listByCustomerAddress = this.crmCustomerService.getListByCustomerAddress(crmCustomerContactsPagination.getCustomerAddress()))) {
            crmCustomerContactsQueryWrapper.lambda().in(CrmCustomerContactsEntity::getCustomerId, (Collection)listByCustomerAddress.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerId())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)crmCustomerContactsPagination.getCustomerId());
        }
        if (!userInfo.getIsAdministrator().booleanValue() && !authFlag) {
            crmCustomerContactsQueryWrapper.lambda().and(x -> {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(CrmCustomerContactsEntity::getCreatorUserId, (Object)userInfo.getUserId())).or(a -> ((LambdaQueryWrapper)a.eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getPublicType, (Object)CrmConstants.CONTACT_PUBLIC_GROUP))).or(a -> ((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getPublicType, (Object)CrmConstants.CONTACT_PUBLIC_COMPANY)).eq(CrmCustomerContactsEntity::getObjectId, (Object)userInfo.getOrganizeId()))).or(a -> ((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getPublicType, (Object)CrmConstants.CONTACT_PUBLIC_DEPARTMENT)).eq(CrmCustomerContactsEntity::getObjectId, (Object)userInfo.getDepartmentId()));
                if (crmCustomerContactsPagination.getIsAfterSalesPersonnel() == 1) {
                    String id = "488760535479749253";
                    DictionaryDataEntity swapInfo = this.dictionaryDataService.getSwapInfo("afterSales", "484641641202843205");
                    if (!ObjectUtil.isEmpty((Object)swapInfo)) {
                        id = swapInfo.getId();
                    }
                    String finalId = id;
                    ((LambdaQueryWrapper)x.or()).eq(CrmCustomerContactsEntity::getClassification, (Object)finalId);
                }
            });
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getClassification()) && !ObjectUtil.isEmpty((Object)(swapInfo = this.dictionaryDataService.getSwapInfo(crmCustomerContactsPagination.getClassification(), "484641641202843205")))) {
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getClassification, (Object)swapInfo.getId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCompanyId())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCompanyId, (Object)crmCustomerContactsPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getPublicMark())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getPublicMark, (Object)Integer.valueOf(crmCustomerContactsPagination.getPublicMark()));
        }
        if (ObjectUtil.isNotEmpty((Object)crmCustomerContactsPagination.getConnectType())) {
            if (crmCustomerContactsPagination.getConnectType() == 3) {
                crmCustomerContactsQueryWrapper.lambda().isNull(CrmCustomerContactsEntity::getConnectType);
            } else {
                crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getConnectType, (Object)crmCustomerContactsPagination.getConnectType());
            }
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getName())) {
            ++crmCustomerContactsNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)crmCustomerContactsQueryWrapper.lambda().like(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName())).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerName())) {
            ++crmCustomerNum;
            crmCustomerEntityQueryWrapper.lambda().like(CrmCustomerEntity::getName, (Object)crmCustomerContactsPagination.getCustomerName());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerSource())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().like(CrmCustomerContactsEntity::getCustomerSource, (Object)crmCustomerContactsPagination.getCustomerSource());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getAgentId())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(CrmCustomerContactsEntity::getAgentId, (Object)crmCustomerContactsPagination.getAgentId())).or()).eq(CrmCustomerContactsEntity::getAgentManagerId, (Object)crmCustomerContactsPagination.getAgentId());
            });
        }
        if (crmCustomerNum > 0) {
            List crm_customerIdList = this.crmCustomerService.list((Wrapper)crmCustomerEntityQueryWrapper).stream().filter(t -> StringUtils.isNotEmpty((String)t.getId())).map(t -> t.getId()).collect(Collectors.toList());
            AllIdList.addAll(crm_customerIdList);
        }
        total += crmCustomerNum;
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCreatorTime())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().like(CrmCustomerContactsEntity::getCreatorTime, (Object)crmCustomerContactsPagination.getCreatorTime());
        }
        if (AllIdList.size() > 0) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)crmCustomerContactsQueryWrapper.lambda().in(CrmCustomerContactsEntity::getCustomerId, AllIdList)).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName());
        }
        return crmCustomerContactsQueryWrapper;
    }

    @Override
    public List<CrmCustomerContactsEntity> getTypeList(CrmCustomerContactsPagination crmCustomerContactsPagination, String dataType) {
        DictionaryDataEntity swapInfo;
        Object crmCustomerContactsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmCustomerContactsNum = 0;
        int crmCustomerNum = 0;
        QueryWrapper crmCustomerContactsQueryWrapper = new QueryWrapper();
        QueryWrapper crmCustomerEntityQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerContactsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerContactsQueryWrapper, crmCustomerContactsPagination.getMenuId(), "crmCustomerContacts"));
            if (ObjectUtil.isEmpty((Object)crmCustomerContactsObj)) {
                return new ArrayList<CrmCustomerContactsEntity>();
            }
            crmCustomerContactsQueryWrapper = (QueryWrapper)crmCustomerContactsObj;
            ++crmCustomerContactsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmCustomerContactsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmCustomerContactsQueryWrapper, crmCustomerContactsPagination.getMenuId(), "crmCustomerContacts"));
            if (ObjectUtil.isEmpty((Object)crmCustomerContactsObj)) {
                return new ArrayList<CrmCustomerContactsEntity>();
            }
            crmCustomerContactsQueryWrapper = (QueryWrapper)crmCustomerContactsObj;
            ++crmCustomerContactsNum;
        }
        if (crmCustomerContactsPagination.getIsAfterSalesPersonnel() == 1) {
            String id = "484642160457678405";
            DictionaryDataEntity swapInfo2 = this.dictionaryDataService.getSwapInfo("afterSales", "484641641202843205");
            if (!ObjectUtil.isEmpty((Object)swapInfo2)) {
                id = swapInfo2.getId();
            }
            String finalId = id;
            crmCustomerContactsQueryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(CrmCustomerContactsEntity::getCreatorUserId, (Object)userId)).or()).eq(CrmCustomerContactsEntity::getClassification, (Object)finalId));
        } else {
            crmCustomerContactsQueryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(CrmCustomerContactsEntity::getCreatorUserId, (Object)userId)).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)1));
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getClassification()) && !ObjectUtil.isEmpty((Object)(swapInfo = this.dictionaryDataService.getSwapInfo(crmCustomerContactsPagination.getClassification(), "484641641202843205")))) {
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getClassification, (Object)swapInfo.getId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerId())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)crmCustomerContactsPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getPublicMark())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getPublicMark, (Object)Integer.valueOf(crmCustomerContactsPagination.getPublicMark()));
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getUserId())) {
            ++crmCustomerContactsNum;
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getName())) {
            ++crmCustomerContactsNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)crmCustomerContactsQueryWrapper.lambda().like(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName())).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerName())) {
            ++crmCustomerNum;
            crmCustomerEntityQueryWrapper.lambda().like(CrmCustomerEntity::getName, (Object)crmCustomerContactsPagination.getCustomerName());
        }
        if (crmCustomerNum > 0) {
            List crm_customerIdList = this.crmCustomerService.list((Wrapper)crmCustomerEntityQueryWrapper).stream().filter(t -> StringUtils.isNotEmpty((String)t.getId())).map(t -> t.getId()).collect(Collectors.toList());
            AllIdList.addAll(crm_customerIdList);
        }
        total += crmCustomerNum;
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCreatorTime())) {
            ++crmCustomerContactsNum;
            crmCustomerContactsQueryWrapper.lambda().like(CrmCustomerContactsEntity::getCreatorTime, (Object)crmCustomerContactsPagination.getCreatorTime());
        }
        if (AllIdList.size() > 0) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)crmCustomerContactsQueryWrapper.lambda().in(CrmCustomerContactsEntity::getCustomerId, AllIdList)).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).eq(CrmCustomerContactsEntity::getName, (Object)crmCustomerContactsPagination.getName());
        }
        if (StringUtils.isEmpty((String)crmCustomerContactsPagination.getSidx())) {
            crmCustomerContactsQueryWrapper.lambda().orderByDesc(CrmCustomerContactsEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmCustomerContactsPagination.getSidx();
                CrmCustomerContactsEntity crmCustomerContactsEntity = new CrmCustomerContactsEntity();
                Field declaredField = crmCustomerContactsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmCustomerContactsQueryWrapper = "asc".equals(crmCustomerContactsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCustomerContactsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCustomerContactsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmCustomerContactsPagination.getCurrentPage(), crmCustomerContactsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerContactsQueryWrapper);
                return crmCustomerContactsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmCustomerContactsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmCustomerContactsQueryWrapper);
    }

    @Override
    public CrmCustomerContactsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getId, (Object)id);
        return (CrmCustomerContactsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmCustomerContactsEntity> getListByCustomerId(CrmCustomerContactsPagination crmCustomerContactsPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)crmCustomerContactsPagination.getCustomerId());
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getEnabledMark, (Object)1);
        if (StrUtil.isNotEmpty((CharSequence)crmCustomerContactsPagination.getClassification())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getClassification, (Object)crmCustomerContactsPagination.getClassification());
        }
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getProjectId())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)crmCustomerContactsPagination.getProjectId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmCustomerContactsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmCustomerContactsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmCustomerContactsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public CrmCustomerEntity getCrmCustomer(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getId, (Object)id);
        return (CrmCustomerEntity)this.crmCustomerService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public long countByCustomerId(String customerId) {
        return this.countByCustomerIdAndMenuId(customerId, "");
    }

    @Override
    public long countByCustomerIdAndMenuId(String customerId, String menuId) {
        CrmCustomerContactsPagination crmCustomerContactsPagination = new CrmCustomerContactsPagination();
        if (!StrUtil.isBlank((CharSequence)menuId)) {
            crmCustomerContactsPagination.setMenuId(menuId);
        }
        crmCustomerContactsPagination.setCustomerId(customerId);
        QueryWrapper<CrmCustomerContactsEntity> queryWrapper = this.appendWrapper(crmCustomerContactsPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long countBySaleDataSummary(SaleDataSummaryVo saleDataSummaryVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(saleDataSummaryVo.getUserIdList())) {
            queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(CrmCustomerContactsEntity::getPublicMark, (Object)1)).or()).eq(CrmCustomerContactsEntity::getPublicMark, (Object)0)).in(CrmCustomerContactsEntity::getCreatorUserId, saleDataSummaryVo.getUserIdList()));
        } else {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getPublicMark, (Object)1);
        }
        if (!ObjectUtil.isEmpty((Object)saleDataSummaryVo.getStartDate())) {
            queryWrapper.lambda().ge(CrmCustomerContactsEntity::getCreatorTime, (Object)saleDataSummaryVo.getStartDate());
        }
        if (!ObjectUtil.isEmpty((Object)saleDataSummaryVo.getEndDate())) {
            queryWrapper.lambda().le(CrmCustomerContactsEntity::getCreatorTime, (Object)saleDataSummaryVo.getEndDate());
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long getCustomerContactsCountByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)projectId);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateCustomerId(String oldCustomerId, String newCustomerId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmCustomerContactsEntity::getCustomerId, (Object)newCustomerId)).eq(CrmCustomerContactsEntity::getCustomerId, (Object)oldCustomerId);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<CrmCustomerContactsEntity> getListByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)projectId);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByAgentrId(String customerId, String customerSource) {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerContactsPagination crmCustomerContactsPagination = new CrmCustomerContactsPagination();
        crmCustomerContactsPagination.setAgentId(customerId);
        crmCustomerContactsPagination.setCustomerSource(customerSource);
        QueryWrapper<CrmCustomerContactsEntity> queryWrapper = this.appendWrapper(crmCustomerContactsPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmCustomerContactsEntity> connectContactResource(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser())) {
            return new ArrayList<CrmCustomerContactsEntity>();
        }
        List<String> idsList = Arrays.asList(connectEntity.getObjectId().split(","));
        if (CollectionUtil.isNotEmpty(idsList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCustomerContactsEntity::getId, idsList);
            List contactsEntities = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)contactsEntities)) {
                contactsEntities.forEach(x -> {
                    x.setCreatorUserId(connectEntity.getConnectUser());
                    x.setConnectType(connectEntity.getConnectType());
                    if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                        ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                        connectEntityList.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString(connectEntityList));
                    } else {
                        List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                        departConnectEntities.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                    }
                });
            }
            this.updateBatchById(contactsEntities);
            return contactsEntities;
        }
        return new ArrayList<CrmCustomerContactsEntity>();
    }

    @Override
    public boolean getByCustomerIdAndNameAndPhone(String customerId, String name, String phone) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)objectQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)customerId)).eq(CrmCustomerContactsEntity::getName, (Object)name)).eq(CrmCustomerContactsEntity::getPhone, (Object)phone);
        List list = this.list((Wrapper)objectQueryWrapper);
        return !CollectionUtil.isNotEmpty((Collection)list);
    }
}

