/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.SystemCodeUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCustomerCompanyRelationEntity;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerMyEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.entity.CrmCustomerUserRelationEntity;
import com.bringspring.crm.entity.CrmCustomerVerifyEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.mapper.CrmCustomerMapper;
import com.bringspring.crm.model.crmcustomer.CrmCustomerPagination;
import com.bringspring.crm.model.crmcustomer.CustomerExportVO;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerMyService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmCustomerUserRelationService;
import com.bringspring.crm.service.CrmCustomerVerifyService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.util.ChineseWordUtils;
import com.bringspring.crm.util.CrmCustomerEnableMarkEnum;
import com.bringspring.crm.util.LatLongUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.utils.CoordinateTransform;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.VisitFollowUpService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmCustomerServiceImpl
extends ServiceImpl<CrmCustomerMapper, CrmCustomerEntity>
implements CrmCustomerService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private CrmCustomerVerifyService crmCustomerVerifyService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmCustomerUserRelationService crmCustomerUserRelationService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private CrmCustomerMapper crmCustomerMapper;
    @Autowired
    private CrmCustomerMyService crmCustomerMyService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private VisitFollowUpService visitFollowUpService;

    public static <T> String toSql(QueryWrapper<T> queryWrapper) {
        String customSqlSegment = queryWrapper.getCustomSqlSegment();
        for (Map.Entry entry : queryWrapper.getParamNameValuePairs().entrySet()) {
            if (ObjectUtil.isEmpty(entry) || ObjectUtil.isEmpty(entry.getKey()) || ObjectUtil.isEmpty(entry.getValue())) continue;
            customSqlSegment = customSqlSegment.replace("#{ew.paramNameValuePairs." + (String)entry.getKey() + "}", CrmCustomerServiceImpl.formatParamValue(entry.getValue()));
        }
        return customSqlSegment;
    }

    public static String formatParamValue(Object arg) {
        String paramValue = arg instanceof String ? "'" + arg.toString().replace("'", "\\'") + "'" : (arg instanceof Date ? "'" + DateUtil.format((Date)((Date)arg), (String)"yyyy-MM-dd HH:mm:ss") + "'" : (arg != null ? arg.toString() : null));
        return paramValue;
    }

    @Override
    public List<CrmCustomerEntity> getList(CrmCustomerPagination crmCustomerPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<CrmCustomerEntity> crmCustomerQueryWrapper = this.appendWhere(crmCustomerPagination);
        if (ObjectUtil.isEmpty(crmCustomerQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmCustomerPagination.getCurrentPage(), crmCustomerPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerQueryWrapper);
            return crmCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmCustomerPagination.setData(list, list.size());
    }

    private QueryWrapper<CrmCustomerEntity> appendWhere(CrmCustomerPagination crmCustomerPagination) {
        String[] split;
        Boolean flag;
        List ids;
        List list;
        RkContractProjectEntity info;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper crmCustomerQueryWrapper = new QueryWrapper();
        crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        crmCustomerQueryWrapper.lambda().ne(CrmCustomerEntity::getEnabledMark, (Object)CrmCustomerEnableMarkEnum.POTENTIAL_CUSTOMER.getEnableMark());
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getProjectId()) && ObjectUtil.isNotEmpty((Object)(info = this.rkContractProjectService.getInfo(crmCustomerPagination.getProjectId()))) && StringUtils.isNotEmpty((String)info.getCustomerId())) {
            crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getId, (Object)info.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getCreatorUserId())) {
            list = this.crmCustomerUserRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getUserId, (Object)userInfo.getUserId()));
            if (ObjectUtil.isEmpty((Object)list)) {
                return null;
            }
            ids = list.stream().map(CrmCustomerUserRelationEntity::getCustomerId).collect(Collectors.toList());
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, ids);
        }
        if (ObjectUtil.equals((Object)crmCustomerPagination.getMyCustomer(), (Object)1)) {
            list = this.crmCustomerMyService.getListByUserId(userInfo.getUserId());
            if (CollectionUtil.isEmpty(list)) {
                return null;
            }
            ids = list.stream().map(CrmCustomerMyEntity::getCustomerId).collect(Collectors.toList());
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, ids);
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getName())) {
            if (crmCustomerPagination.getName().contains(" ")) {
                crmCustomerQueryWrapper.and(wrapper -> wrapper.lambda().apply(" MATCH(alias_query) AGAINST('" + crmCustomerPagination.getName() + "' IN NATURAL LANGUAGE MODE) ", new Object[0]));
            } else {
                crmCustomerQueryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().like(CrmCustomerEntity::getName, (Object)crmCustomerPagination.getName())).or()).like(CrmCustomerEntity::getAlias, (Object)crmCustomerPagination.getName())).or()).like(CrmCustomerEntity::getAliasQuery, (Object)crmCustomerPagination.getName())).or()).like(CrmCustomerEntity::getSystemCode, (Object)crmCustomerPagination.getName())).or()).like(CrmCustomerEntity::getPinyin, (Object)crmCustomerPagination.getName().toUpperCase()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)crmCustomerPagination.getIsmMedicalUser())) {
            if (crmCustomerPagination.getIsmMedicalUser() == 1) {
                crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getClassificationCode, (Object)"medicalUser");
            } else {
                crmCustomerQueryWrapper.lambda().ne(CrmCustomerEntity::getClassificationCode, (Object)"medicalUser");
            }
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getHideResourceCustomer())) {
            crmCustomerQueryWrapper.lambda().ne(CrmCustomerEntity::getEnabledMark, (Object)crmCustomerPagination.getHideResourceCustomer());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getAppFlag()) || StringUtils.isNotEmpty((String)crmCustomerPagination.getCreatorUserId()) || StringUtils.isNotEmpty((String)crmCustomerPagination.getSuboId())) {
            crmCustomerPagination.setAuthorizeAddressFlag(null);
        }
        if (ObjectUtil.notEqual((Object)crmCustomerPagination.getMyCustomer(), (Object)1) && StringUtils.isNotEmpty((String)crmCustomerPagination.getAuthorizeAddressFlag())) {
            List listByUserId = this.userRelationService.getListByUserId(userInfo.getUserId(), "Area");
            List areaList = listByUserId.stream().filter(s -> s.getObjectType().equals("Area")).map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(areaList)) {
                return null;
            }
            if (areaList.size() == 1) {
                crmCustomerQueryWrapper.lambda().like(CrmCustomerEntity::getAddress, (Object)((String)areaList.get(0)).replaceAll("]", ""));
            } else {
                String s1 = ((String)areaList.get(0)).replaceAll("]", "");
                areaList.remove(0);
                crmCustomerQueryWrapper.lambda().and(wq -> {
                    wq.like(CrmCustomerEntity::getAddress, (Object)s1);
                    if (!ObjectUtil.isEmpty((Object)areaList)) {
                        for (String s : areaList) {
                            ((LambdaQueryWrapper)wq.or()).like(CrmCustomerEntity::getAddress, (Object)s.replaceAll("]", ""));
                        }
                    }
                });
            }
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getAuthorizeAddressFlag()) && StringUtils.isNotEmpty(crmCustomerPagination.getAddress()) && !(flag = this.userRelationService.judgeAuthorize(crmCustomerPagination.getAddress(), userInfo.getUserId())).booleanValue()) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getEnabledMark())) {
            split = crmCustomerPagination.getEnabledMark().split(",");
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getEnabledMark, Arrays.asList(split));
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getCollaboratorId())) {
            crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getCollaboratorId, (Object)crmCustomerPagination.getCollaboratorId());
        }
        if (StringUtils.isNotEmpty((Collection)crmCustomerPagination.getActorList())) {
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getCollaboratorId, (Collection)crmCustomerPagination.getActorList());
        }
        if (StringUtils.isNotEmpty(crmCustomerPagination.getAddress()) && crmCustomerPagination.getAddress().size() < 2 && crmCustomerPagination.getAddress().get(0).equals("10")) {
            crmCustomerPagination.setAddress(null);
        }
        if (StringUtils.isNotEmpty(crmCustomerPagination.getAddress())) {
            List addressList = JsonUtil.getJsonToList(crmCustomerPagination.getAddress(), String.class);
            if (addressList.size() > 1) {
                String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                collect = "[" + collect;
                crmCustomerQueryWrapper.lambda().like(CrmCustomerEntity::getAddress, (Object)collect);
            } else {
                String s2 = (String)addressList.get(addressList.size() - 1);
                s2 = "[\"" + s2 + "\"";
                crmCustomerQueryWrapper.lambda().like(CrmCustomerEntity::getAddress, (Object)s2);
            }
        }
        if (CollectionUtil.isNotEmpty(crmCustomerPagination.getCustomerIdList())) {
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, crmCustomerPagination.getCustomerIdList());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getOrganizeFlag())) {
            ArrayList allIds = new ArrayList();
            List list2 = this.crmProductCategoryService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductCategoryEntity::getParentId, (Object)crmCustomerPagination.getOrganizeFlag()));
            for (CrmProductCategoryEntity crmProductCategoryEntity : list2) {
                List list22 = this.crmProductService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductEntity::getCategoryId, (Object)crmProductCategoryEntity.getId()));
                if (ObjectUtil.isEmpty((Object)list22)) continue;
                List list1 = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().in(CrmProductRelationEntity::getProductId, (Collection)list22.stream().map(CrmProductEntity::getId).collect(Collectors.toList())));
                List collect = list1.stream().map(CrmProductRelationEntity::getCustomerId).collect(Collectors.toList());
                allIds.addAll(collect);
            }
            if (ObjectUtil.isEmpty(allIds)) {
                return null;
            }
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, allIds);
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getConduct())) {
            crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getConduct, (Object)crmCustomerPagination.getConduct());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getGrade())) {
            split = crmCustomerPagination.getGrade().split(",");
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getGrade, Arrays.asList(split));
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getCompanyId())) {
            split = crmCustomerPagination.getCompanyId().split(",");
            for (int i = 0; i < split.length; ++i) {
                List<CrmCustomerCompanyRelationEntity> list3 = this.crmCustomerCompanyRelationService.getByCustomerAndCompanyIdAndSource(null, split[i], null);
                if (CollectionUtil.isEmpty(list3)) {
                    return null;
                }
                List companyIdList = CollectionUtil.list((boolean)false);
                list3.stream().forEach(entity -> companyIdList.add(entity.getCustomerId()));
                crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, (Collection)companyIdList);
            }
        }
        if (CollectionUtil.isNotEmpty(crmCustomerPagination.getCompanyIdList()) || CollectionUtil.isNotEmpty(crmCustomerPagination.getRegionIdList())) {
            if (CollectionUtil.isEmpty(crmCustomerPagination.getCompanyIdList())) {
                crmCustomerPagination.setCompanyIdList(Stream.of("2", "3", "9", "14").collect(Collectors.toList()));
            }
            List<String> companyIdList = crmCustomerPagination.getCompanyIdList();
            String collect = companyIdList.stream().collect(Collectors.joining(","));
            String[] split2 = collect.split(",");
            ArrayList companyIds = CollectionUtil.list((boolean)false);
            for (int i = 0; i < split2.length; ++i) {
                List<CrmCustomerCompanyRelationEntity> list4 = this.crmCustomerCompanyRelationService.getByCustomerAndCompanyIdAndSource(null, split2[i], null);
                if (!CollectionUtil.isNotEmpty(list4)) continue;
                list4.stream().forEach(entity -> companyIds.add(entity.getCustomerId()));
            }
            List regionIds = CollectionUtil.list((boolean)false);
            if (CollectionUtil.isNotEmpty(crmCustomerPagination.getRegionIdList())) {
                List<String> regionIdList = crmCustomerPagination.getRegionIdList();
                String collect1 = regionIdList.stream().collect(Collectors.joining(","));
                String[] split1 = collect1.split(",");
                for (int i = 0; i < split1.length; ++i) {
                    List<CrmCustomerEntity> listByRegion = this.getListByRegion(split1[i]);
                    if (!CollectionUtil.isNotEmpty(listByRegion)) continue;
                    listByRegion.stream().forEach(entity -> regionIds.add(entity.getId()));
                }
            }
            List<Object> filterCompanyIds = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)regionIds)) {
                filterCompanyIds = companyIds.stream().filter(regionIds::contains).collect(Collectors.toList());
            }
            ArrayList arrayList = filterCompanyIds = ObjectUtil.isEmpty(filterCompanyIds) ? companyIds : filterCompanyIds;
            if (CollectionUtil.isEmpty(filterCompanyIds)) {
                return null;
            }
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, filterCompanyIds);
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getType())) {
            crmCustomerQueryWrapper.lambda().eq(CrmCustomerEntity::getType, (Object)crmCustomerPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getSuboId())) {
            if (userInfo.getSubordinateIds().size() < 1) {
                return null;
            }
            list = this.crmCustomerUserRelationService.list((Wrapper)Wrappers.lambdaQuery().in(CrmCustomerUserRelationEntity::getUserId, (Collection)userInfo.getSubordinateIds()));
            if (ObjectUtil.isEmpty((Object)list)) {
                return null;
            }
            List ids2 = list.stream().map(CrmCustomerUserRelationEntity::getCustomerId).collect(Collectors.toList());
            crmCustomerQueryWrapper.lambda().in(CrmCustomerEntity::getId, ids2);
        }
        if (StringUtils.isNotEmpty((String)crmCustomerPagination.getImperfectData())) {
            crmCustomerQueryWrapper.apply(" (address like concat('%','\"\"','%') or length(address)<=11 or conduct is null or grade is null or type is null or address is null)", new Object[0]);
        }
        if (StringUtils.isEmpty((String)crmCustomerPagination.getSidx())) {
            crmCustomerQueryWrapper.lambda().orderByAsc(CrmCustomerEntity::getSystemCode);
        } else {
            try {
                String sidx = crmCustomerPagination.getSidx();
                if (StrUtil.equals((CharSequence)sidx, (CharSequence)"grade")) {
                    List list5 = this.dictionaryDataService.getList("361888069978164485");
                    String collect = list5.stream().map(DictionaryDataEntity::getId).collect(Collectors.joining(","));
                    if ("asc".equals(crmCustomerPagination.getSort().toLowerCase())) {
                        crmCustomerQueryWrapper.last("ORDER BY FIELD(grade, " + collect + ") desc ");
                    } else {
                        crmCustomerQueryWrapper.last("ORDER BY FIELD(grade, " + collect + ") asc ");
                    }
                } else if (StrUtil.equals((CharSequence)sidx, (CharSequence)"name")) {
                    crmCustomerQueryWrapper.last(" ORDER BY CONVERT(name USING gbk) COLLATE gbk_chinese_ci  " + crmCustomerPagination.getSort().toLowerCase() + " ");
                } else {
                    RkProjectReportingEntity rkProjectReportingEntity = new RkProjectReportingEntity();
                    Field declaredField = rkProjectReportingEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    crmCustomerQueryWrapper = "asc".equals(crmCustomerPagination.getSort().toLowerCase()) ? (QueryWrapper)crmCustomerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmCustomerQueryWrapper.orderByDesc((Object)value);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return crmCustomerQueryWrapper;
    }

    @Override
    public List<CrmCustomerEntity> getListBySql(CrmCustomerPagination crmCustomerPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        boolean total = false;
        QueryWrapper<CrmCustomerEntity> crmCustomerQueryWrapper = this.appendWhere(crmCustomerPagination);
        if (ObjectUtil.isEmpty(crmCustomerQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        List arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        List orderArea = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty((Collection)arealist)) {
            List authAreaIdList = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(authAreaIdList)) {
                authAreaIdList.stream().forEach(s -> {
                    String h = s.split(",")[0];
                    h = h.replace("[", "");
                    h = h.replace("]", "").replaceAll("\"", "");
                    orderArea.add(h);
                });
            }
            String join = CollectionUtil.join((Iterable)orderArea, (CharSequence)",");
            crmCustomerPagination.setAuthArea(join);
        }
        PageHelper.startPage((int)((int)crmCustomerPagination.getCurrentPage()), (int)((int)crmCustomerPagination.getPageSize()));
        crmCustomerPagination.setCreatorUserId(userInfo.getUserId());
        List<CrmCustomerEntity> listBySql = this.crmCustomerMapper.getListBySql(crmCustomerPagination, (Wrapper<CrmCustomerEntity>)crmCustomerQueryWrapper);
        PageInfo pageInfo = new PageInfo(listBySql);
        return crmCustomerPagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<CrmCustomerEntity> getTypeList(CrmCustomerPagination crmCustomerPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean crmCustomerNum = false;
        QueryWrapper<CrmCustomerEntity> crmCustomerQueryWrapper = this.appendWhere(crmCustomerPagination);
        if (ObjectUtil.isEmpty(crmCustomerQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmCustomerPagination.getCurrentPage(), crmCustomerPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmCustomerQueryWrapper);
                return crmCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmCustomerPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmCustomerQueryWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getInfoByCustomerName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(CrmCustomerEntity::getName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public CrmCustomerEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getId, (Object)id);
        return (CrmCustomerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean judgeCorrelativeData(String id) {
        List<CrmCustomerContactsEntity> listCrmCustomerContactsEntities = this.getContactByCustomeId(id);
        List listCrmCustomerOpportunityEntity = this.crmCustomerOpportunityService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmCustomerOpportunityEntity::getCustomerId, (Object)id));
        List listCrmProductRelationEntity = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)id));
        List<RkContractEntity> rkContractEntities = this.rkContractService.listSimpleByCustomerIdAndEnableMarkIn(id, CollectionUtil.list((boolean)false));
        if (CollectionUtil.isNotEmpty(rkContractEntities)) {
            return false;
        }
        long repotingNUm = this.rkProjectReportingService.countByCustomerId(id);
        if (repotingNUm > 0L) {
            return false;
        }
        List<CrmClueInfoEntity> listByCustomerIdAndStateIn = this.crmClueInfoService.getListByCustomerIdAndStateIn(id, CollectionUtil.list((boolean)false));
        if (CollectionUtil.isNotEmpty(listByCustomerIdAndStateIn)) {
            return false;
        }
        List<AfterSalesQuestionEntity> listByCustomerId = this.afterSalesQuestionService.getListByCustomerId(id);
        if (CollectionUtil.isNotEmpty(listByCustomerId)) {
            return false;
        }
        long l = this.visitFollowUpService.countByCustomerId(id);
        if (l > 0L) {
            return false;
        }
        long l1 = this.crmCustomerContactsService.countByCustomerId(id);
        if (l1 > 0L) {
            return false;
        }
        return ObjectUtil.isEmpty(listCrmCustomerContactsEntities) && ObjectUtil.isEmpty((Object)listCrmCustomerOpportunityEntity) && ObjectUtil.isEmpty((Object)listCrmProductRelationEntity);
    }

    @Override
    public void create(CrmCustomerEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmCustomerEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateAliasQuery() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().isNull(CrmCustomerEntity::getAliasQuery)).or()).eq(CrmCustomerEntity::getAliasQuery, (Object)"");
        List list = this.list((Wrapper)queryWrapper);
        for (CrmCustomerEntity crmCustomerEntity : list) {
            String chineseWordSegmentationPku = ChineseWordUtils.getChineseWordSegmentationPku(crmCustomerEntity.getName());
            crmCustomerEntity.setAliasQuery(chineseWordSegmentationPku);
            this.updateById(crmCustomerEntity);
        }
        return false;
    }

    @Override
    public void updateLongLatQuery(String ajaxtimestamp) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().isNull(CrmCustomerEntity::getAddressLatitude)).or()).eq(CrmCustomerEntity::getAddressLatitude, (Object)"");
        List list = this.list((Wrapper)queryWrapper);
        for (CrmCustomerEntity crmCustomerEntity : list) {
            try {
                JSONObject latLng = LatLongUtils.getLatLongByChineseText(crmCustomerEntity.getName(), ajaxtimestamp);
                System.out.println(crmCustomerEntity.getName() + "\u83b7\u53d6\u7ecf\u7eac\u5ea6\uff1a" + latLng.toString());
                System.out.println(DateUtil.now());
                crmCustomerEntity.setAddressLatitude(latLng.getString("lat"));
                crmCustomerEntity.setAddressLongitude(latLng.getString("lng"));
                this.updateById(crmCustomerEntity);
                Thread.sleep(300000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    @Override
    public void delete(CrmCustomerEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<CrmCustomerContactsEntity> getContactByCustomeId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)id);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.crmCustomerContactsService.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        CrmCustomerEntity crmCustomerEntity = this.getInfo(id);
        crmCustomerEntity.setEnabledMark(String.valueOf(enableMark));
        return this.updateById(crmCustomerEntity);
    }

    @Override
    public CrmCustomerEntity getInfoByFullName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getName, (Object)name);
        return (CrmCustomerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getInfoByName(String name) {
        ArrayList<String> customerId = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getName, (Object)name);
        customerId.addAll(this.list((Wrapper)queryWrapper).stream().map(CrmCustomerEntity::getId).collect(Collectors.toList()));
        QueryWrapper verifyQueryWrapper = new QueryWrapper();
        verifyQueryWrapper.lambda().eq(CrmCustomerVerifyEntity::getName, (Object)name);
        List collect = this.crmCustomerVerifyService.list((Wrapper)verifyQueryWrapper).stream().map(CrmCustomerVerifyEntity::getId).collect(Collectors.toList());
        if (!ObjectUtil.isEmpty(collect)) {
            customerId.addAll(collect);
        }
        return customerId;
    }

    @Override
    public String judgeUnique(String str) {
        QueryWrapper queryWrapper;
        CrmCustomerEntity one;
        String randomId = null;
        do {
            randomId = SystemCodeUtil.getRandomId((String)str);
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(CrmCustomerEntity::getSystemCode, (Object)randomId);
        } while (!ObjectUtil.isEmpty((Object)(one = (CrmCustomerEntity)this.getOne((Wrapper)queryWrapper))));
        return randomId;
    }

    @Override
    public Map<String, Object> importPreview(List<CustomerExportVO> personList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < personList.size(); ++i) {
            HashMap<String, String> dataRowMap = new HashMap<String, String>();
            CustomerExportVO model = personList.get(i);
            dataRowMap.put("code", model.getCode());
            dataRowMap.put("name", model.getName());
            dataRowMap.put("address", model.getAddress());
            dataRowMap.put("alias", model.getAlias());
            dataRowMap.put("conduct", model.getConduct());
            dataRowMap.put("grade", model.getGrade());
            dataRowMap.put("type", model.getType());
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= personList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", personList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u673a\u6784\u7f16\u7801");
        map.put(2, "\u5ba2\u6237\u540d\u79f0");
        map.put(3, "\u522b\u540d");
        map.put(4, "\u7ecf\u8425\u6027\u8d28");
        map.put(5, "\u5ba2\u6237\u7b49\u7ea7");
        map.put(6, "\u5ba2\u6237\u7c7b\u578b");
        map.put(7, "\u5ba2\u6237\u5730\u5740");
        return (String)map.get(key);
    }

    @Override
    public List<CrmCustomerEntity> importData(List<CustomerExportVO> dataList) {
        ArrayList<CrmCustomerEntity> list = new ArrayList<CrmCustomerEntity>();
        for (CustomerExportVO customerExportVO : dataList) {
            CrmCustomerEntity jsonToBean = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)customerExportVO, CrmCustomerEntity.class);
            CrmCustomerEntity customerEntity = this.handleCreate(jsonToBean);
            list.add(customerEntity);
        }
        return list;
    }

    @Override
    public String generateSystemCode(String address) {
        String[] split = address.replace("\"", "").replace("[", "").replace("]", "").split(",");
        String collectAddr = Arrays.stream(split).filter(i -> i.length() == 4).collect(Collectors.joining());
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)customerQueryWrapper.lambda().likeRight(CrmCustomerEntity::getSystemCode, (Object)collectAddr)).last("order by SUBSTRING_INDEX(system_code,'-',-1)*1 desc limit 1");
        CrmCustomerEntity one = (CrmCustomerEntity)this.getOne((Wrapper)customerQueryWrapper);
        Long i2 = Long.valueOf(one.getSystemCode().replace("-", "")) + 1L;
        StringBuilder str = new StringBuilder(i2.toString());
        return str.insert(6, "-").toString();
    }

    public CrmCustomerEntity handleCreate(CrmCustomerEntity customerEntity) {
        if (!ObjectUtil.isEmpty((Object)customerEntity)) {
            String mainId = RandomUtil.uuId();
            customerEntity.setId(mainId);
            String areaIds = this.provinceService.getAreaIds(customerEntity.getAddress());
            customerEntity.setAddress(areaIds);
            return customerEntity;
        }
        return null;
    }

    @Override
    public long getCustomerOppoTotal(String enableMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getEnabledMark, (Object)enableMark);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public String handleAddress(List<String> address) {
        List addressList = JsonUtil.getJsonToList(address, String.class);
        String collect = null;
        if (addressList.size() > 1) {
            collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
            collect = "[" + collect;
        } else {
            collect = (String)addressList.get(addressList.size() - 1);
            collect = "[\"" + collect + "\"";
        }
        return collect;
    }

    @Override
    public List<CrmCustomerEntity> getListByGradeAndCreateDate(String grade, List<Date> createDate) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!ObjectUtil.isEmpty((Object)grade)) {
            String[] split = grade.split(",");
            queryWrapper.in(CrmCustomerEntity::getGrade, Arrays.asList(split));
        }
        if (!ObjectUtil.isEmpty(createDate)) {
            queryWrapper.between(CrmCustomerEntity::getCreatorTime, (Object)createDate.get(0), (Object)createDate.get(1));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateReject(String customerId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmCustomerEntity::getEnabledMark, (Object)CrmCustomerEnableMarkEnum.REJECT_CUSTOMER.getEnableMark())).eq(CrmCustomerEntity::getId, (Object)customerId);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getListByCompanyAndProvAndCity(String prov, String city, String lng, String lat, String keyword) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id", "name", "st_distance_sphere(point(address_longitude,address_latitude),point(" + lng + "," + lat + ")) as juli"});
        if (StrUtil.isNotEmpty((CharSequence)keyword)) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().like(CrmCustomerEntity::getName, (Object)keyword)).or()).like(CrmCustomerEntity::getAlias, (Object)keyword)).or()).like(CrmCustomerEntity::getAliasQuery, (Object)keyword)).or()).like(CrmCustomerEntity::getSystemCode, (Object)keyword)).or()).like(CrmCustomerEntity::getPinyin, (Object)keyword.toUpperCase()));
        }
        if (StrUtil.isBlank((CharSequence)keyword)) {
            String str = "";
            if (StrUtil.isNotEmpty((CharSequence)prov)) {
                str = str + "\"" + prov + "\",";
            }
            if (StrUtil.isNotEmpty((CharSequence)city)) {
                str = str + "\"" + city + "\"";
            }
            if (StrUtil.isNotEmpty((CharSequence)str)) {
                queryWrapper.lambda().like(CrmCustomerEntity::getAddress, (Object)str);
                queryWrapper.orderByAsc((Object)"(juli is null )", (Object[])new String[]{"juli"});
            }
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getListByCustomerAddress(List<List<String>> address) {
        if (CollectionUtil.isEmpty(address)) {
            return new ArrayList<CrmCustomerEntity>();
        }
        QueryWrapper crmCustomerWrapper = new QueryWrapper();
        crmCustomerWrapper.lambda().and(x -> {
            for (List ll : address) {
                List addressList = JsonUtil.getJsonToList((Object)ll, String.class);
                if (addressList.size() > 1) {
                    String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                    collect = "[" + collect;
                    ((LambdaQueryWrapper)x.or()).like(CrmCustomerEntity::getAddress, (Object)collect);
                    continue;
                }
                String s2 = (String)addressList.get(addressList.size() - 1);
                s2 = "[\"" + s2 + "\"";
                ((LambdaQueryWrapper)x.or()).like(CrmCustomerEntity::getAddress, (Object)s2);
            }
        });
        return this.list((Wrapper)crmCustomerWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getListByRegion(String region) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(CrmCustomerEntity::getAddress, (Object)region);
        ArrayList<CrmCustomerEntity> regionList = new ArrayList<CrmCustomerEntity>();
        List list = this.list((Wrapper)queryWrapper);
        list.forEach(customer -> {
            String[] split = customer.getAddress().replace("[", "").replace("]", "").replace("\"", "").split(",");
            if (region.equals(split[1])) {
                regionList.add((CrmCustomerEntity)customer);
            }
        });
        return regionList;
    }

    @Override
    public void CoordinateTransform() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().isNotNull(CrmCustomerEntity::getAddressLongitude)).isNotNull(CrmCustomerEntity::getAddressLatitude);
        List list = this.list((Wrapper)queryWrapper);
        ArrayList<CrmCustomerEntity> crmCustomerEntityList = new ArrayList<CrmCustomerEntity>();
        for (CrmCustomerEntity customer : list) {
            if (StrUtil.isBlank((CharSequence)customer.getAddressLatitude()) || StrUtil.isBlank((CharSequence)customer.getAddressLongitude())) continue;
            double[] doubles = CoordinateTransform.gcj02ToWgs84(Double.valueOf(customer.getAddressLatitude()), Double.valueOf(customer.getAddressLongitude()));
            customer.setAddressLatitude(String.valueOf(doubles[0]));
            customer.setAddressLongitude(String.valueOf(doubles[1]));
            crmCustomerEntityList.add(customer);
        }
        this.updateBatchById(crmCustomerEntityList);
    }

    @Override
    public List<CrmCustomerEntity> getCompanyCustomer() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerEntity::getEnabledMark, (Object)"company");
        queryWrapper.select(new String[]{"id", "name"});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmCustomerEntity> getListBylngAndLatTrajectory(String prov, String city, String lng, String lat, String keyword) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)keyword)) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().like(CrmCustomerEntity::getName, (Object)keyword)).or()).like(CrmCustomerEntity::getAlias, (Object)keyword)).or()).like(CrmCustomerEntity::getAliasQuery, (Object)keyword)).or()).like(CrmCustomerEntity::getSystemCode, (Object)keyword)).or()).like(CrmCustomerEntity::getPinyin, (Object)keyword.toUpperCase()));
        }
        String str = "";
        if (StrUtil.isNotEmpty((CharSequence)prov)) {
            str = str + "\"" + prov + "\",";
        }
        if (StrUtil.isNotEmpty((CharSequence)city)) {
            str = str + "\"" + city + "\"";
        }
        if (StrUtil.isNotEmpty((CharSequence)str)) {
            // empty if block
        }
        queryWrapper.lambda().eq(CrmCustomerEntity::getEnabledMark, (Object)"company");
        return this.list((Wrapper)queryWrapper);
    }
}

