/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.mapper.CrmDepartConnectMapper;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectCrForm;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectPagination;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectUpForm;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmDepartConnectService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.RkProjectReportingService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmDepartConnectServiceImpl
extends ServiceImpl<CrmDepartConnectMapper, CrmDepartConnectEntity>
implements CrmDepartConnectService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkProjectReportingService reportingService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;

    @Override
    public List<CrmDepartConnectEntity> getList(CrmDepartConnectPagination crmDepartConnectPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmDepartConnectNum = 0;
        QueryWrapper crmDepartConnectQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)crmDepartConnectPagination.getResignUser())) {
            ++crmDepartConnectNum;
            crmDepartConnectQueryWrapper.lambda().eq(CrmDepartConnectEntity::getResignUser, (Object)crmDepartConnectPagination.getResignUser());
        }
        if (StringUtils.isNotEmpty((String)crmDepartConnectPagination.getConnectType())) {
            ++crmDepartConnectNum;
            crmDepartConnectQueryWrapper.lambda().like(CrmDepartConnectEntity::getConnectType, (Object)crmDepartConnectPagination.getConnectType());
        }
        if (AllIdList.size() > 0) {
            crmDepartConnectQueryWrapper.lambda().in(CrmDepartConnectEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmDepartConnectPagination.getSidx())) {
            crmDepartConnectQueryWrapper.lambda().orderByDesc(CrmDepartConnectEntity::getId);
        } else {
            try {
                String sidx = crmDepartConnectPagination.getSidx();
                CrmDepartConnectEntity crmDepartConnectEntity = new CrmDepartConnectEntity();
                Field declaredField = crmDepartConnectEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmDepartConnectQueryWrapper = "asc".equals(crmDepartConnectPagination.getSort().toLowerCase()) ? (QueryWrapper)crmDepartConnectQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmDepartConnectQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmDepartConnectPagination.getCurrentPage(), crmDepartConnectPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmDepartConnectQueryWrapper);
            return crmDepartConnectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmDepartConnectPagination.setData(list, list.size());
    }

    @Override
    public List<CrmDepartConnectEntity> getTypeList(CrmDepartConnectPagination crmDepartConnectPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmDepartConnectNum = 0;
        QueryWrapper crmDepartConnectQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)crmDepartConnectPagination.getResignUser())) {
            ++crmDepartConnectNum;
            crmDepartConnectQueryWrapper.lambda().eq(CrmDepartConnectEntity::getResignUser, (Object)crmDepartConnectPagination.getResignUser());
        }
        if (StringUtils.isNotEmpty((String)crmDepartConnectPagination.getConnectType())) {
            ++crmDepartConnectNum;
            crmDepartConnectQueryWrapper.lambda().like(CrmDepartConnectEntity::getConnectType, (Object)crmDepartConnectPagination.getConnectType());
        }
        if (AllIdList.size() > 0) {
            crmDepartConnectQueryWrapper.lambda().in(CrmDepartConnectEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmDepartConnectPagination.getSidx())) {
            crmDepartConnectQueryWrapper.lambda().orderByDesc(CrmDepartConnectEntity::getId);
        } else {
            try {
                String sidx = crmDepartConnectPagination.getSidx();
                CrmDepartConnectEntity crmDepartConnectEntity = new CrmDepartConnectEntity();
                Field declaredField = crmDepartConnectEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmDepartConnectQueryWrapper = "asc".equals(crmDepartConnectPagination.getSort().toLowerCase()) ? (QueryWrapper)crmDepartConnectQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmDepartConnectQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmDepartConnectPagination.getCurrentPage(), crmDepartConnectPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmDepartConnectQueryWrapper);
                return crmDepartConnectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmDepartConnectPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmDepartConnectQueryWrapper);
    }

    @Override
    public CrmDepartConnectEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmDepartConnectEntity::getId, (Object)id);
        return (CrmDepartConnectEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(CrmDepartConnectCrForm crmDepartConnectCrForm) {
        String mainId = RandomUtil.uuId();
        CrmDepartConnectEntity entity = (CrmDepartConnectEntity)JsonUtil.getJsonToBean((Object)crmDepartConnectCrForm, CrmDepartConnectEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, CrmDepartConnectUpForm crmDepartConnectUpForm) {
        UserInfo userInfo = this.userProvider.get();
        CrmDepartConnectEntity entity = this.getInfo(id);
        if (entity != null) {
            CrmDepartConnectEntity subentity = (CrmDepartConnectEntity)JsonUtil.getJsonToBean((Object)crmDepartConnectUpForm, CrmDepartConnectEntity.class);
            subentity.setResignUser(DateUtil.getNow());
            subentity.setConnectType(crmDepartConnectUpForm.getConnectType());
            this.updateById(subentity);
        }
    }

    @Override
    public Boolean connectResource(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectModule())) {
            return false;
        }
        connectEntity.setId(RandomUtil.uuId());
        this.save(connectEntity);
        connectEntity.setLastModifyTime(null);
        connectEntity.setLastModifyUserId(null);
        switch (connectEntity.getConnectModule()) {
            case "customerContact": {
                this.crmCustomerContactsService.connectContactResource(connectEntity);
                break;
            }
            case "reportOpportunity": {
                this.reportingService.connectContactResource(connectEntity);
                break;
            }
            case "contract": {
                this.rkContractService.connectContactResource(connectEntity);
                break;
            }
            case "project": {
                this.rkContractProjectService.rkContractProjectResource(connectEntity);
                break;
            }
            case "returnMoney": {
                this.rkContractReturnPlanService.connectReturnMoney(connectEntity);
                break;
            }
            case "afterSalesList": {
                this.afterSalesQuestionService.connectAfterSaleQuestion(connectEntity);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    @DSTransactional
    public void delete(CrmDepartConnectEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

