/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmAuthorizationModuleEntity;
import com.bringspring.crm.entity.CrmProductCarryEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.mapper.CrmProductCarryMapper;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryCrForm;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryPagination;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryUpForm;
import com.bringspring.crm.service.CrmAuthorizationModuleService;
import com.bringspring.crm.service.CrmProductCarryService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductCarryServiceImpl
extends ServiceImpl<CrmProductCarryMapper, CrmProductCarryEntity>
implements CrmProductCarryService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductCarryService crmProductCarryService;
    @Autowired
    private CrmAuthorizationModuleService crmAuthorizationModuleService;

    @Override
    public List<CrmProductCarryEntity> getList(CrmProductCarryPagination crmProductCarryPagination) {
        Object crmProductObj;
        boolean isPc;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductUserNum = 0;
        QueryWrapper crmProductCarryQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)crmProductCarryPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductCarryQueryWrapper, crmProductCarryPagination.getMenuId(), "crm_product_carry"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductCarryEntity>();
            }
            crmProductCarryQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductCarryQueryWrapper, crmProductCarryPagination.getMenuId(), "crm_product_carry"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductCarryEntity>();
            }
            crmProductCarryQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (StringUtils.isNotEmpty(crmProductCarryPagination.getCategoryIdList())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.in(CrmProductCarryEntity::getCategoryId, crmProductCarryPagination.getCategoryIdList())).or()).in(CrmProductCarryEntity::getProductId, crmProductCarryPagination.getCategoryIdList()));
        }
        if (StringUtils.isNotEmpty((String)crmProductCarryPagination.getProductCode())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().like(CrmProductCarryEntity::getProductCode, (Object)crmProductCarryPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)crmProductCarryPagination.getProductName())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().like(CrmProductCarryEntity::getProductName, (Object)crmProductCarryPagination.getProductName());
        }
        if (AllIdList.size() > 0) {
            crmProductCarryQueryWrapper.lambda().in(CrmProductCarryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductCarryPagination.getSidx())) {
            crmProductCarryQueryWrapper.lambda().orderByDesc(CrmProductCarryEntity::getId);
        } else {
            try {
                String sidx = crmProductCarryPagination.getSidx();
                CrmProductCarryEntity crmProductCarryEntity = new CrmProductCarryEntity();
                Field declaredField = crmProductCarryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductCarryQueryWrapper = "asc".equals(crmProductCarryPagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductCarryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductCarryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmProductCarryPagination.getCurrentPage(), crmProductCarryPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductCarryQueryWrapper);
            return crmProductCarryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmProductCarryPagination.setData(list, list.size());
    }

    @Override
    public List<CrmProductCarryEntity> getTypeList(CrmProductCarryPagination crmProductCarryPagination, String dataType) {
        Object crmProductObj;
        boolean isPc;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductUserNum = 0;
        QueryWrapper crmProductCarryQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)crmProductCarryPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductCarryQueryWrapper, crmProductCarryPagination.getMenuId(), "crm_product_user"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductCarryEntity>();
            }
            crmProductCarryQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductCarryQueryWrapper, crmProductCarryPagination.getMenuId(), "crm_product_user"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductCarryEntity>();
            }
            crmProductCarryQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (StringUtils.isNotEmpty(crmProductCarryPagination.getCategoryIdList())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.in(CrmProductCarryEntity::getCategoryId, crmProductCarryPagination.getCategoryIdList())).or()).in(CrmProductCarryEntity::getProductId, crmProductCarryPagination.getCategoryIdList()));
        }
        if (StringUtils.isNotEmpty((String)crmProductCarryPagination.getProductCode())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().like(CrmProductCarryEntity::getProductCode, (Object)crmProductCarryPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)crmProductCarryPagination.getProductName())) {
            ++crmProductUserNum;
            crmProductCarryQueryWrapper.lambda().like(CrmProductCarryEntity::getProductName, (Object)crmProductCarryPagination.getProductName());
        }
        if (AllIdList.size() > 0) {
            crmProductCarryQueryWrapper.lambda().in(CrmProductCarryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductCarryPagination.getSidx())) {
            crmProductCarryQueryWrapper.lambda().orderByDesc(CrmProductCarryEntity::getId);
        } else {
            try {
                String sidx = crmProductCarryPagination.getSidx();
                CrmProductCarryEntity crmProductCarryEntity = new CrmProductCarryEntity();
                Field declaredField = crmProductCarryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductCarryQueryWrapper = "asc".equals(crmProductCarryPagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductCarryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductCarryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmProductCarryPagination.getCurrentPage(), crmProductCarryPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmProductCarryQueryWrapper);
                return crmProductCarryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmProductCarryPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmProductCarryQueryWrapper);
    }

    @Override
    public CrmProductCarryEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductCarryEntity::getId, (Object)id);
        return (CrmProductCarryEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public Boolean create(CrmProductCarryCrForm form) {
        if (CollectionUtil.isNotEmpty(form.getProductList())) {
            for (String projectId : form.getProductList()) {
                CrmProductEntity info;
                form.setProductId(projectId);
                form.setStartDate(form.getTimeScope().get(0));
                form.setEndDate(form.getTimeScope().get(1));
                String mainId = RandomUtil.uuId();
                CrmProductCarryEntity entity = (CrmProductCarryEntity)JsonUtil.getJsonToBean((Object)form, CrmProductCarryEntity.class);
                CrmAuthorizationModuleEntity moduleEntity = this.crmAuthorizationModuleService.getByProduct(entity);
                if (ObjectUtil.isNull((Object)moduleEntity)) {
                    entity.setAuthorizationModule("");
                }
                if (ObjectUtil.isNotEmpty((Object)(info = this.crmProductService.getInfo(projectId)))) {
                    entity.setProductCode(info.getProductCode());
                    entity.setProductName(info.getProductName());
                    CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(info.getCategoryId());
                    if (ObjectUtil.isNotEmpty((Object)categoryEntity)) {
                        entity.setCategoryId(categoryEntity.getId());
                        entity.setCategoryName(categoryEntity.getName());
                        entity.setCompanyId(categoryEntity.getParentId());
                    }
                }
                entity.setId(mainId);
                boolean state = this.crmProductCarryService.getTimeCycle(entity);
                if (state) {
                    return true;
                }
                this.save(entity);
            }
        }
        return false;
    }

    @Override
    @DSTransactional
    public Boolean update(String id, CrmProductCarryUpForm form) {
        UserInfo userInfo = this.userProvider.get();
        CrmProductCarryEntity entity = this.getInfo(id);
        if (entity != null) {
            boolean state;
            form.setStartDate(form.getTimeScope().get(0));
            form.setEndDate(form.getTimeScope().get(1));
            CrmProductCarryEntity subentity = (CrmProductCarryEntity)JsonUtil.getJsonToBean((Object)form, CrmProductCarryEntity.class);
            CrmProductEntity info = this.crmProductService.getInfo(subentity.getProductId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                subentity.setProductCode(info.getProductCode());
                subentity.setProductName(info.getProductName());
                CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(info.getCategoryId());
                if (ObjectUtil.isNotEmpty((Object)categoryEntity)) {
                    subentity.setCategoryId(categoryEntity.getId());
                    subentity.setCategoryName(categoryEntity.getName());
                    subentity.setCompanyId(categoryEntity.getParentId());
                }
            }
            if (state = this.crmProductCarryService.getTimeCycle(subentity)) {
                return true;
            }
            this.updateById(subentity);
        }
        return false;
    }

    @Override
    public boolean getTimeCycle(CrmProductCarryEntity form) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductCarryEntity::getProductId, (Object)form.getProductId());
        ((LambdaQueryWrapper)queryWrapper.lambda().ge(CrmProductCarryEntity::getStartDate, (Object)form.getStartDate())).ge(CrmProductCarryEntity::getEndDate, (Object)form.getEndDate());
        List list = this.list((Wrapper)queryWrapper);
        boolean contains = list.stream().map(CrmProductCarryEntity::getIsDefault).collect(Collectors.toList()).contains("0");
        if (form.getIsDefault().equals("0")) {
            contains = true;
        }
        return CollectionUtil.isNotEmpty((Collection)list) && !contains;
    }

    @Override
    @DSTransactional
    public void delete(CrmProductCarryEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

