/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductPriceEntity;
import com.bringspring.crm.mapper.CrmProductPriceMapper;
import com.bringspring.crm.model.crmproductprice.CrmProductPriceInfoVO;
import com.bringspring.crm.model.crmproductprice.CrmProductPricePagination;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductPriceService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductPriceServiceImpl
extends ServiceImpl<CrmProductPriceMapper, CrmProductPriceEntity>
implements CrmProductPriceService {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CrmProductPriceMapper crmProductPriceMapper;

    @Override
    public List<CrmProductPriceEntity> getList(CrmProductPricePagination crmProductPricePagination) {
        QueryWrapper<CrmProductPriceEntity> crmProductPriceQueryWrapper = this.appendWrapper(crmProductPricePagination);
        Page page = new Page(crmProductPricePagination.getCurrentPage(), crmProductPricePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)crmProductPriceQueryWrapper);
        return crmProductPricePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<CrmProductPriceEntity> appendWrapper(CrmProductPricePagination crmProductPricePagination) {
        QueryWrapper crmProductPriceQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getProductId())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getProductId, (Object)crmProductPricePagination.getProductId());
        } else if (StringUtils.isNotEmpty((String)crmProductPricePagination.getProductName())) {
            List productList;
            QueryWrapper productWrapper = new QueryWrapper();
            productWrapper.lambda().like(CrmProductEntity::getProductName, (Object)crmProductPricePagination.getProductName());
            if (StringUtils.isNotEmpty((String)crmProductPricePagination.getCompanyId())) {
                productWrapper.lambda().eq(CrmProductEntity::getCompanyId, (Object)crmProductPricePagination.getCompanyId());
            }
            if (CollectionUtil.isNotEmpty((Collection)(productList = this.crmProductService.list((Wrapper)productWrapper)))) {
                List productIdList = productList.stream().map(CrmProductEntity::getId).collect(Collectors.toList());
                crmProductPriceQueryWrapper.lambda().in(CrmProductPriceEntity::getProductId, productIdList);
            }
        }
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getChannelType())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getChannelType, (Object)crmProductPricePagination.getChannelType());
        }
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getHospitalLevel())) {
            crmProductPriceQueryWrapper.lambda().like(CrmProductPriceEntity::getHospitalLevel, (Object)crmProductPricePagination.getHospitalLevel());
        }
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getEnabledMark())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getEnabledMark, (Object)crmProductPricePagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getCategoryId())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getCategoryId, (Object)crmProductPricePagination.getCategoryId());
        }
        if (StringUtils.isNotEmpty((String)crmProductPricePagination.getCompanyId())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getCompanyId, (Object)crmProductPricePagination.getCompanyId());
        }
        if ("1".equals(crmProductPricePagination.getIsActive())) {
            crmProductPriceQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(CrmProductPriceEntity::getIsUnLimitUse, (Object)"1")).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(CrmProductPriceEntity::getActiveStartTime, (Object)new Date())).ge(CrmProductPriceEntity::getActiveEndTime, (Object)new Date());
                });
            });
        } else if ("0".equals(crmProductPricePagination.getIsActive())) {
            crmProductPriceQueryWrapper.lambda().eq(CrmProductPriceEntity::getIsUnLimitUse, (Object)"0");
            crmProductPriceQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.gt(CrmProductPriceEntity::getActiveStartTime, (Object)new Date())).or()).lt(CrmProductPriceEntity::getActiveEndTime, (Object)new Date());
            });
        }
        if (StringUtils.isEmpty((String)crmProductPricePagination.getSidx())) {
            crmProductPriceQueryWrapper.lambda().orderByDesc(CrmProductPriceEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmProductPricePagination.getSidx();
                CrmProductPriceEntity crmProductPriceEntity = new CrmProductPriceEntity();
                Field declaredField = crmProductPriceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductPriceQueryWrapper = "asc".equals(crmProductPricePagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductPriceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductPriceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return crmProductPriceQueryWrapper;
    }

    @Override
    public List<CrmProductPriceEntity> getTypeList(CrmProductPricePagination crmProductPricePagination, String dataType) {
        QueryWrapper<CrmProductPriceEntity> crmProductPriceQueryWrapper = this.appendWrapper(crmProductPricePagination);
        if ("0".equals(dataType)) {
            Page page = new Page(crmProductPricePagination.getCurrentPage(), crmProductPricePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductPriceQueryWrapper);
            return crmProductPricePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)crmProductPriceQueryWrapper);
    }

    @Override
    public CrmProductPriceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductPriceEntity::getId, (Object)id);
        return (CrmProductPriceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmProductPriceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmProductPriceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List getListByProductPrice(CrmProductPricePagination crmProductPricePagination) {
        PageHelper.startPage((int)((int)crmProductPricePagination.getCurrentPage()), (int)((int)crmProductPricePagination.getPageSize()));
        List<CrmProductPriceInfoVO> listByProductPrice = this.crmProductPriceMapper.getListByProductPrice(crmProductPricePagination);
        for (CrmProductPriceInfoVO crmProductPriceVO : listByProductPrice) {
            crmProductPriceVO.setHospitalLevel(this.baseDataUtil.getDictName(crmProductPriceVO.getHospitalLevel(), "CustomerGrade"));
            crmProductPriceVO.setChannelType(this.baseDataUtil.getDictName(crmProductPriceVO.getChannelType(), "channelType"));
            if (StrUtil.isBlank((CharSequence)crmProductPriceVO.getCategoryId())) continue;
            CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(crmProductPriceVO.getCategoryId());
            crmProductPriceVO.setCategoryId(categoryEntity.getName());
        }
        PageInfo pageInfo = new PageInfo(listByProductPrice);
        return crmProductPricePagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public void delete(CrmProductPriceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

