/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductQuoteEntity;
import com.bringspring.crm.mapper.CrmProductQuoteMapper;
import com.bringspring.crm.model.crmproductquote.CrmProductQuotePagination;
import com.bringspring.crm.service.CrmProductQuoteService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductQuoteServiceImpl
extends ServiceImpl<CrmProductQuoteMapper, CrmProductQuoteEntity>
implements CrmProductQuoteService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<CrmProductQuoteEntity> getList(CrmProductQuotePagination crmProductQuotePagination) {
        Object crmProductQuoteObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductQuoteNum = 0;
        QueryWrapper crmProductQuoteQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductQuoteObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQuoteQueryWrapper, crmProductQuotePagination.getMenuId(), "crmProductQuote"));
            if (ObjectUtil.isEmpty((Object)crmProductQuoteObj)) {
                return new ArrayList<CrmProductQuoteEntity>();
            }
            crmProductQuoteQueryWrapper = (QueryWrapper)crmProductQuoteObj;
            ++crmProductQuoteNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductQuoteObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQuoteQueryWrapper, crmProductQuotePagination.getMenuId(), "crmProductQuote"));
            if (ObjectUtil.isEmpty((Object)crmProductQuoteObj)) {
                return new ArrayList<CrmProductQuoteEntity>();
            }
            crmProductQuoteQueryWrapper = (QueryWrapper)crmProductQuoteObj;
            ++crmProductQuoteNum;
        }
        if (StringUtils.isNotEmpty((String)crmProductQuotePagination.getSaleId())) {
            ++crmProductQuoteNum;
            crmProductQuoteQueryWrapper.lambda().like(CrmProductQuoteEntity::getSaleId, (Object)crmProductQuotePagination.getSaleId());
        }
        if (AllIdList.size() > 0) {
            crmProductQuoteQueryWrapper.lambda().in(CrmProductQuoteEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductQuotePagination.getSidx())) {
            crmProductQuoteQueryWrapper.lambda().orderByDesc(CrmProductQuoteEntity::getId);
        } else {
            try {
                String sidx = crmProductQuotePagination.getSidx();
                CrmProductQuoteEntity crmProductQuoteEntity = new CrmProductQuoteEntity();
                Field declaredField = crmProductQuoteEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductQuoteQueryWrapper = "asc".equals(crmProductQuotePagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductQuoteQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductQuoteQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmProductQuotePagination.getCurrentPage(), crmProductQuotePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductQuoteQueryWrapper);
            return crmProductQuotePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmProductQuotePagination.setData(list, list.size());
    }

    @Override
    public List<CrmProductQuoteEntity> getTypeList(CrmProductQuotePagination crmProductQuotePagination, String dataType) {
        Object crmProductQuoteObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductQuoteNum = 0;
        QueryWrapper crmProductQuoteQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductQuoteObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQuoteQueryWrapper, crmProductQuotePagination.getMenuId(), "crmProductQuote"));
            if (ObjectUtil.isEmpty((Object)crmProductQuoteObj)) {
                return new ArrayList<CrmProductQuoteEntity>();
            }
            crmProductQuoteQueryWrapper = (QueryWrapper)crmProductQuoteObj;
            ++crmProductQuoteNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductQuoteObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQuoteQueryWrapper, crmProductQuotePagination.getMenuId(), "crmProductQuote"));
            if (ObjectUtil.isEmpty((Object)crmProductQuoteObj)) {
                return new ArrayList<CrmProductQuoteEntity>();
            }
            crmProductQuoteQueryWrapper = (QueryWrapper)crmProductQuoteObj;
            ++crmProductQuoteNum;
        }
        if (StringUtils.isNotEmpty((String)crmProductQuotePagination.getSaleId())) {
            ++crmProductQuoteNum;
            crmProductQuoteQueryWrapper.lambda().like(CrmProductQuoteEntity::getSaleId, (Object)crmProductQuotePagination.getSaleId());
        }
        if (AllIdList.size() > 0) {
            crmProductQuoteQueryWrapper.lambda().in(CrmProductQuoteEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductQuotePagination.getSidx())) {
            crmProductQuoteQueryWrapper.lambda().orderByDesc(CrmProductQuoteEntity::getId);
        } else {
            try {
                String sidx = crmProductQuotePagination.getSidx();
                CrmProductQuoteEntity crmProductQuoteEntity = new CrmProductQuoteEntity();
                Field declaredField = crmProductQuoteEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductQuoteQueryWrapper = "asc".equals(crmProductQuotePagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductQuoteQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductQuoteQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmProductQuotePagination.getCurrentPage(), crmProductQuotePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmProductQuoteQueryWrapper);
                return crmProductQuotePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmProductQuotePagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmProductQuoteQueryWrapper);
    }

    @Override
    public CrmProductQuoteEntity calculateQuote(CrmProductQuotePagination crmProductQuotePagination) {
        QueryWrapper crmProductQuoteQueryWrapper = new QueryWrapper();
        crmProductQuoteQueryWrapper.select(new String[]{"sum(AMOUNT) as amount", "sum(TOTAL_PRICE) as totalPrice", "sum(STANDARD_PRICE) as standardPrice"});
        crmProductQuoteQueryWrapper.lambda().like(CrmProductQuoteEntity::getSaleId, (Object)crmProductQuotePagination.getSaleId());
        return (CrmProductQuoteEntity)this.getOne((Wrapper)crmProductQuoteQueryWrapper);
    }

    @Override
    public CrmProductQuoteEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductQuoteEntity::getId, (Object)id);
        return (CrmProductQuoteEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmProductQuoteEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmProductQuoteEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmProductQuoteEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

