/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.mapper.CrmProductMapper;
import com.bringspring.crm.model.crmproduct.CrmProductPagination;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductServiceImpl
extends ServiceImpl<CrmProductMapper, CrmProductEntity>
implements CrmProductService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @Override
    public List<CrmProductEntity> getList(CrmProductPagination crmProductPagination) {
        QueryWrapper<CrmProductEntity> crmProductQueryWrapper = this.appendWrapper(crmProductPagination);
        if (null != crmProductQueryWrapper) {
            Page page = new Page(crmProductPagination.getCurrentPage(), crmProductPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductQueryWrapper);
            return crmProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return new ArrayList<CrmProductEntity>();
    }

    private QueryWrapper<CrmProductEntity> appendWrapper(CrmProductPagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (ObjectUtil.equals((Object)pagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "crm_product"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                queryWrapper.lambda().eq(CrmProductEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)crmProductObj;
            }
        }
        queryWrapper.lambda().eq(CrmProductEntity::getDeleteFlag, (Object)0);
        if (StringUtils.isNotEmpty((String)pagination.getCustomerId())) {
            List list = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)pagination.getCustomerId()));
            if (list.isEmpty()) {
                return null;
            }
            List ids = list.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
            queryWrapper.lambda().in(CrmProductEntity::getId, ids);
        }
        if (!ObjectUtil.isEmpty((Object)pagination.getCategoryIdList())) {
            queryWrapper.lambda().in(CrmProductEntity::getCategoryId, (Collection)pagination.getCategoryIdList());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            queryWrapper.lambda().eq(CrmProductEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(pagination.getCategoryIds())) {
            queryWrapper.lambda().in(CrmProductEntity::getCategoryId, pagination.getCategoryIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getProductCode())) {
            queryWrapper.lambda().like(CrmProductEntity::getProductCode, (Object)pagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)pagination.getProductName()))) {
            queryWrapper.lambda().like(CrmProductEntity::getProductName, (Object)StringUtils.trim((String)pagination.getProductName()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getDescription())) {
            queryWrapper.lambda().like(CrmProductEntity::getDescription, (Object)pagination.getDescription());
        }
        if (null != pagination.getEnabledMark()) {
            queryWrapper.lambda().eq(CrmProductEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorTime())) {
            queryWrapper.lambda().like(CrmProductEntity::getCreatorTime, (Object)pagination.getCreatorTime());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorUserId())) {
            queryWrapper.lambda().like(CrmProductEntity::getCreatorUserId, (Object)pagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getLastModifyUserId())) {
            queryWrapper.lambda().like(CrmProductEntity::getLastModifyUserId, (Object)pagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getLastModifyTime())) {
            queryWrapper.lambda().like(CrmProductEntity::getLastModifyTime, (Object)pagination.getLastModifyTime());
        }
        if (StringUtils.isNotEmpty((String)pagination.getProductIds())) {
            queryWrapper.lambda().in(CrmProductEntity::getId, Arrays.asList(pagination.getProductIds().split(",")));
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByAsc(CrmProductEntity::getProductCode);
        } else {
            try {
                String sidx = pagination.getSidx();
                CrmProductEntity crmProductEntity = new CrmProductEntity();
                Field declaredField = crmProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return queryWrapper;
    }

    @Override
    public List<CrmProductEntity> getCusProductList(CrmProductPagination crmProductPagination) {
        ArrayList list;
        Object crmProductObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductNum = 0;
        QueryWrapper crmProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQueryWrapper, crmProductPagination.getMenuId(), "crmProduct"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductEntity>();
            }
            crmProductQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductQueryWrapper, crmProductPagination.getMenuId(), "crmProduct"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductEntity>();
            }
            crmProductQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductNum;
        }
        if (StringUtils.isNotEmpty((String)crmProductPagination.getCustomerId())) {
            ++crmProductNum;
            list = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)crmProductPagination.getCustomerId()));
            if (list.isEmpty()) {
                return new ArrayList<CrmProductEntity>();
            }
            List ids = list.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
            crmProductQueryWrapper.lambda().notIn(CrmProductEntity::getId, ids);
        }
        if (!ObjectUtil.isEmpty((Object)crmProductPagination.getCategoryIdList())) {
            ++crmProductNum;
            crmProductQueryWrapper.lambda().in(CrmProductEntity::getCategoryId, (Collection)crmProductPagination.getCategoryIdList());
        }
        if (StringUtils.isNotEmpty((String)crmProductPagination.getProductCode())) {
            ++crmProductNum;
            crmProductQueryWrapper.lambda().like(CrmProductEntity::getProductCode, (Object)crmProductPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)crmProductPagination.getProductName())) {
            ++crmProductNum;
            crmProductQueryWrapper.lambda().like(CrmProductEntity::getProductName, (Object)crmProductPagination.getProductName());
        }
        if (AllIdList.size() > 0) {
            crmProductQueryWrapper.lambda().in(CrmProductEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductPagination.getSidx())) {
            crmProductQueryWrapper.lambda().orderByDesc(CrmProductEntity::getId);
        } else {
            try {
                String sidx = crmProductPagination.getSidx();
                CrmProductEntity crmProductEntity = new CrmProductEntity();
                Field declaredField = crmProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductQueryWrapper = "asc".equals(crmProductPagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmProductPagination.getCurrentPage(), crmProductPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductQueryWrapper);
            return crmProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        list = new ArrayList();
        return crmProductPagination.setData(list, list.size());
    }

    @Override
    public List<CrmProductEntity> getTypeList(CrmProductPagination crmProductPagination, String dataType) {
        QueryWrapper<CrmProductEntity> crmProductQueryWrapper = this.appendWrapper(crmProductPagination);
        if (null != crmProductQueryWrapper) {
            if ("0".equals(dataType)) {
                Page page = new Page(crmProductPagination.getCurrentPage(), crmProductPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmProductQueryWrapper);
                return crmProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            return this.list((Wrapper)crmProductQueryWrapper);
        }
        return new ArrayList<CrmProductEntity>();
    }

    @Override
    public CrmProductEntity getInfo(String id) {
        if (ObjectUtil.isEmpty((Object)id)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductEntity::getId, (Object)id);
        return (CrmProductEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmProductEntity> getInfoByListId(String idList) {
        List<String> list = this.strToList(idList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CrmProductEntity::getId, list);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmProductEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmProductEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<CrmProductEntity> getListByProductIds(List<String> productIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CrmProductEntity::getId, productIds);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmProductEntity> getListByCategoryId(String categoryId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductEntity::getCategoryId, (Object)categoryId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void delete(CrmProductEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<CrmProductEntity> getListByNameAndCompanyId(String name, String companyId) {
        List<CrmProductCategoryEntity> infoByParentId = this.crmProductCategoryService.getInfoByParentId(CollectionUtil.list((boolean)false, (Object[])new String[]{companyId}));
        if (CollectionUtil.isNotEmpty(infoByParentId)) {
            List collect = infoByParentId.stream().map(CrmProductCategoryEntity::getId).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmProductEntity::getProductName, (Object)name)).in(CrmProductEntity::getCategoryId, collect);
            List list = this.list((Wrapper)queryWrapper);
            return list;
        }
        return CollectionUtil.list((boolean)false);
    }

    @Override
    public String getCompanyId(String productId) {
        CrmProductEntity one = (CrmProductEntity)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductEntity::getId, (Object)productId));
        CrmProductCategoryEntity productCompany = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(CrmProductCategoryEntity::getId, (Object)one.getCategoryId()));
        if (!ObjectUtil.isEmpty((Object)productCompany)) {
            return productCompany.getParentId();
        }
        return null;
    }

    public List<String> strToList(String str) {
        str = str.replaceAll("\"", "").replace("[", "").replace("]", "");
        String[] split = str.split(",");
        return JsonUtil.getJsonToList((Object)split, String.class);
    }

    @Override
    public String getNameByIds(String productId) {
        if (StringUtils.isNotEmpty((String)productId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmProductEntity::getId, Arrays.asList(productId.split(",")));
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                return list.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
            }
        }
        return "";
    }
}

