/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductUserEntity;
import com.bringspring.crm.mapper.CrmProductUserMapper;
import com.bringspring.crm.model.crmproductuser.CrmProductUserCrForm;
import com.bringspring.crm.model.crmproductuser.CrmProductUserPagination;
import com.bringspring.crm.model.crmproductuser.CrmProductUserUpForm;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductUserService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmProductUserServiceImpl
extends ServiceImpl<CrmProductUserMapper, CrmProductUserEntity>
implements CrmProductUserService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<CrmProductUserEntity> getList(CrmProductUserPagination crmProductUserPagination) {
        Object crmProductObj;
        boolean isPc;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductUserNum = 0;
        QueryWrapper crmProductUserQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)crmProductUserPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductUserQueryWrapper, crmProductUserPagination.getMenuId(), "crm_product_user"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductUserEntity>();
            }
            crmProductUserQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmProductUserQueryWrapper, crmProductUserPagination.getMenuId(), "crm_product_user"));
            if (ObjectUtil.isEmpty((Object)crmProductObj)) {
                return new ArrayList<CrmProductUserEntity>();
            }
            crmProductUserQueryWrapper = (QueryWrapper)crmProductObj;
            ++crmProductUserNum;
        }
        if (StringUtils.isNotEmpty(crmProductUserPagination.getCategoryIdList())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.in(CrmProductUserEntity::getCategoryId, crmProductUserPagination.getCategoryIdList())).or()).in(CrmProductUserEntity::getProductId, crmProductUserPagination.getCategoryIdList()));
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getProductCode())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().like(CrmProductUserEntity::getProductCode, (Object)crmProductUserPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getProductName())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().like(CrmProductUserEntity::getProductName, (Object)crmProductUserPagination.getProductName());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getProductManager())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().eq(CrmProductUserEntity::getProductManager, (Object)crmProductUserPagination.getProductManager());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getExploitHead())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().eq(CrmProductUserEntity::getExploitHead, (Object)crmProductUserPagination.getExploitHead());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getTestHead())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().eq(CrmProductUserEntity::getTestHead, (Object)crmProductUserPagination.getTestHead());
        }
        if (AllIdList.size() > 0) {
            crmProductUserQueryWrapper.lambda().in(CrmProductUserEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductUserPagination.getSidx())) {
            crmProductUserQueryWrapper.lambda().orderByDesc(CrmProductUserEntity::getId);
        } else {
            try {
                String sidx = crmProductUserPagination.getSidx();
                CrmProductUserEntity crmProductUserEntity = new CrmProductUserEntity();
                Field declaredField = crmProductUserEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductUserQueryWrapper = "asc".equals(crmProductUserPagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductUserQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductUserQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmProductUserPagination.getCurrentPage(), crmProductUserPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmProductUserQueryWrapper);
            return crmProductUserPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmProductUserPagination.setData(list, list.size());
    }

    @Override
    public List<CrmProductUserEntity> getTypeList(CrmProductUserPagination crmProductUserPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmProductUserNum = 0;
        QueryWrapper crmProductUserQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(crmProductUserPagination.getCategoryIdList())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().in(CrmProductUserEntity::getCategoryId, crmProductUserPagination.getCategoryIdList());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getProductManager())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().like(CrmProductUserEntity::getProductManager, (Object)crmProductUserPagination.getProductManager());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getExploitHead())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().like(CrmProductUserEntity::getExploitHead, (Object)crmProductUserPagination.getExploitHead());
        }
        if (StringUtils.isNotEmpty((String)crmProductUserPagination.getTestHead())) {
            ++crmProductUserNum;
            crmProductUserQueryWrapper.lambda().like(CrmProductUserEntity::getTestHead, (Object)crmProductUserPagination.getTestHead());
        }
        if (AllIdList.size() > 0) {
            crmProductUserQueryWrapper.lambda().in(CrmProductUserEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmProductUserPagination.getSidx())) {
            crmProductUserQueryWrapper.lambda().orderByDesc(CrmProductUserEntity::getId);
        } else {
            try {
                String sidx = crmProductUserPagination.getSidx();
                CrmProductUserEntity crmProductUserEntity = new CrmProductUserEntity();
                Field declaredField = crmProductUserEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmProductUserQueryWrapper = "asc".equals(crmProductUserPagination.getSort().toLowerCase()) ? (QueryWrapper)crmProductUserQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmProductUserQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmProductUserPagination.getCurrentPage(), crmProductUserPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmProductUserQueryWrapper);
                return crmProductUserPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmProductUserPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmProductUserQueryWrapper);
    }

    @Override
    public CrmProductUserEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductUserEntity::getId, (Object)id);
        return (CrmProductUserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(CrmProductUserCrForm crmProductUserCrForm) {
        if (CollectionUtil.isNotEmpty(crmProductUserCrForm.getProductList())) {
            for (String productId : crmProductUserCrForm.getProductList()) {
                CrmProductCategoryEntity crmProductEntity;
                String mainId = RandomUtil.uuId();
                CrmProductUserEntity entity = (CrmProductUserEntity)JsonUtil.getJsonToBean((Object)crmProductUserCrForm, CrmProductUserEntity.class);
                CrmProductEntity info = this.crmProductService.getInfo(productId);
                if (ObjectUtil.isNotEmpty((Object)info)) {
                    entity.setProductName(info.getProductName());
                    entity.setProductCode(info.getProductCode());
                }
                if (ObjectUtil.isNotEmpty((Object)(crmProductEntity = this.crmProductCategoryService.getInfo(entity.getCategoryId())))) {
                    entity.setCategoryName(crmProductEntity.getName());
                    entity.setCompanyId(crmProductEntity.getParentId());
                }
                entity.setProjectProblemName(this.baseDataUtil.getDictName(entity.getProjectProblemId(), "4404794028919386291"));
                entity.setProductId(productId);
                entity.setId(mainId);
                this.save(entity);
            }
        }
    }

    @Override
    @DSTransactional
    public void update(String id, CrmProductUserUpForm crmProductUserUpForm) {
        UserInfo userInfo = this.userProvider.get();
        CrmProductUserEntity entity = this.getInfo(id);
        if (entity != null) {
            CrmProductCategoryEntity crmProductEntity;
            CrmProductUserEntity subentity = (CrmProductUserEntity)JsonUtil.getJsonToBean((Object)crmProductUserUpForm, CrmProductUserEntity.class);
            CrmProductEntity info = this.crmProductService.getInfo(subentity.getProductId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                subentity.setProductName(info.getProductName());
                subentity.setProductCode(info.getProductCode());
            }
            if (ObjectUtil.isNotEmpty((Object)(crmProductEntity = this.crmProductCategoryService.getInfo(subentity.getCategoryId())))) {
                subentity.setCategoryName(crmProductEntity.getName());
                subentity.setCompanyId(crmProductEntity.getParentId());
            }
            subentity.setProjectProblemName(this.baseDataUtil.getDictName(subentity.getProjectProblemId(), "4404794028919386291"));
            this.updateById(subentity);
        }
    }

    @Override
    public List<CrmProductUserEntity> getByProjectProblemId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductUserEntity::getProjectProblemId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public CrmProductUserEntity getByProductId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmProductUserEntity::getProductId, (Object)id);
        return (CrmProductUserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void delete(CrmProductUserEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

