/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.MarketExhibitionEntity;
import com.bringspring.crm.mapper.MarketExhibitionMapper;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionCrUeForm;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionPagination;
import com.bringspring.crm.model.marketExhibition.MarketExhibitionUpForm;
import com.bringspring.crm.model.marketExhibition.QrCodeDto;
import com.bringspring.crm.service.MarketExhibitionService;
import com.bringspring.crm.util.WeixinAuthUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketExhibitionServiceImpl
extends ServiceImpl<MarketExhibitionMapper, MarketExhibitionEntity>
implements MarketExhibitionService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private MarketExhibitionService marketExhibitionService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<MarketExhibitionEntity> getList(MarketExhibitionPagination marketExhibitionPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper marketExhibitionQueryWrapper = this.appendWrapper(marketExhibitionPagination);
        if (AllIdList.size() > 0) {
            marketExhibitionQueryWrapper.lambda().in(MarketExhibitionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)marketExhibitionPagination.getSidx())) {
            marketExhibitionQueryWrapper.lambda().orderByDesc(MarketExhibitionEntity::getId);
        } else {
            try {
                String sidx = marketExhibitionPagination.getSidx();
                MarketExhibitionEntity marketExhibitionEntity = new MarketExhibitionEntity();
                Field declaredField = marketExhibitionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                marketExhibitionQueryWrapper = "asc".equals(marketExhibitionPagination.getSort().toLowerCase()) ? (QueryWrapper)marketExhibitionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)marketExhibitionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(marketExhibitionPagination.getCurrentPage(), marketExhibitionPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)marketExhibitionQueryWrapper);
            return marketExhibitionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return marketExhibitionPagination.setData(list, list.size());
    }

    private QueryWrapper<MarketExhibitionEntity> appendWrapper(MarketExhibitionPagination marketExhibitionPagination) {
        Object marketExhibitionObJ;
        int marketExhibitionNum = 0;
        QueryWrapper marketExhibitionQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            marketExhibitionObJ = this.authorizeService.getCondition(new AuthorizeConditionModel(marketExhibitionQueryWrapper, marketExhibitionPagination.getMenuId(), "market_exhibition"));
            if (ObjectUtil.isEmpty((Object)marketExhibitionObJ)) {
                return null;
            }
            marketExhibitionQueryWrapper = (QueryWrapper)marketExhibitionObJ;
            ++marketExhibitionNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            marketExhibitionObJ = this.authorizeService.getCondition(new AuthorizeConditionModel(marketExhibitionQueryWrapper, marketExhibitionPagination.getMenuId(), "market_exhibition"));
            if (ObjectUtil.isEmpty((Object)marketExhibitionObJ)) {
                return null;
            }
            marketExhibitionQueryWrapper = (QueryWrapper)marketExhibitionObJ;
            ++marketExhibitionNum;
        }
        if (StringUtils.isNotEmpty((String)marketExhibitionPagination.getTitle())) {
            ++marketExhibitionNum;
            marketExhibitionQueryWrapper.lambda().like(MarketExhibitionEntity::getTitle, (Object)marketExhibitionPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)marketExhibitionPagination.getCompanyId())) {
            ++marketExhibitionNum;
            marketExhibitionQueryWrapper.lambda().eq(MarketExhibitionEntity::getCompanyId, (Object)marketExhibitionPagination.getCompanyId());
        }
        return marketExhibitionQueryWrapper;
    }

    @Override
    public List<MarketExhibitionEntity> getTypeList(MarketExhibitionPagination marketExhibitionPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int marketExhibitionNum = 0;
        QueryWrapper marketExhibitionQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)marketExhibitionPagination.getTitle())) {
            ++marketExhibitionNum;
            marketExhibitionQueryWrapper.lambda().like(MarketExhibitionEntity::getTitle, (Object)marketExhibitionPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)marketExhibitionPagination.getCompanyId())) {
            ++marketExhibitionNum;
            marketExhibitionQueryWrapper.lambda().like(MarketExhibitionEntity::getCompanyId, (Object)marketExhibitionPagination.getCompanyId());
        }
        if (AllIdList.size() > 0) {
            marketExhibitionQueryWrapper.lambda().in(MarketExhibitionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)marketExhibitionPagination.getSidx())) {
            marketExhibitionQueryWrapper.lambda().orderByDesc(MarketExhibitionEntity::getId);
        } else {
            try {
                String sidx = marketExhibitionPagination.getSidx();
                MarketExhibitionEntity marketExhibitionEntity = new MarketExhibitionEntity();
                Field declaredField = marketExhibitionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                marketExhibitionQueryWrapper = "asc".equals(marketExhibitionPagination.getSort().toLowerCase()) ? (QueryWrapper)marketExhibitionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)marketExhibitionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(marketExhibitionPagination.getCurrentPage(), marketExhibitionPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)marketExhibitionQueryWrapper);
                return marketExhibitionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return marketExhibitionPagination.setData(list, list.size());
        }
        return this.list((Wrapper)marketExhibitionQueryWrapper);
    }

    @Override
    public MarketExhibitionEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MarketExhibitionEntity::getId, (Object)id);
        return (MarketExhibitionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(MarketExhibitionCrUeForm marketExhibitionCrForm) {
        String mainId = RandomUtil.uuId();
        MarketExhibitionEntity entity = (MarketExhibitionEntity)JsonUtil.getJsonToBean((Object)marketExhibitionCrForm, MarketExhibitionEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, MarketExhibitionUpForm marketExhibitionUpForm) {
        UserInfo userInfo = this.userProvider.get();
        MarketExhibitionEntity entity = this.getInfo(id);
        if (entity != null) {
            MarketExhibitionEntity subentity = (MarketExhibitionEntity)JsonUtil.getJsonToBean((Object)marketExhibitionUpForm, MarketExhibitionEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public List<Map<String, Object>> countByState(MarketExhibitionPagination pagination) {
        QueryWrapper<MarketExhibitionEntity> queryWrapper = this.appendWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.select(new String[]{"count(*) as count,company_id as companyId"});
        queryWrapper.groupBy((Object)"company_id");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    public MarketExhibitionEntity getByCompanyId(String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MarketExhibitionEntity::getCompanyId, (Object)companyId);
        queryWrapper.lambda().eq(MarketExhibitionEntity::getState, (Object)"0");
        return (MarketExhibitionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void getByState(String id, MarketExhibitionUpForm marketExhibitionUpForm) {
        MarketExhibitionEntity info = this.marketExhibitionService.getInfo(id);
        if (ObjectUtil.isNotEmpty((Object)info)) {
            info.setState(marketExhibitionUpForm.getState());
            info.setHasPrize(marketExhibitionUpForm.getHasPrize());
            this.updateById(info);
        }
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String generateQrCode(QrCodeDto qrCodeDto) throws Exception {
        String accessToken = WeixinAuthUtils.getAccessToken();
        try {
            URL url = new URL("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + accessToken);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            JSONObject paramJson = new JSONObject();
            paramJson.put("scene", (Object)qrCodeDto.getScene());
            paramJson.put("page", (Object)qrCodeDto.getPage());
            paramJson.put("env_version", (Object)qrCodeDto.getEnvVersion());
            paramJson.put("width", (Object)200);
            paramJson.put("is_hyaline", (Object)true);
            paramJson.put("auto_color", (Object)true);
            httpURLConnection.setDoOutput(true);
            try (OutputStream os = httpURLConnection.getOutputStream();){
                byte[] input = paramJson.toJSONString().getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) return null;
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                byte[] bytes = MarketExhibitionServiceImpl.toByteArray(inputStream);
                String base64Image = Base64.getEncoder().encodeToString(bytes);
                this.redisUtil.insert(qrCodeDto.getScene(), (Object)base64Image, 3600L);
                String string = base64Image;
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @DSTransactional
    public void delete(MarketExhibitionEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

