/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.MarketExhibitionEntity;
import com.bringspring.crm.entity.MarketExhibitionUserEntity;
import com.bringspring.crm.mapper.MarketExhibitionUserMapper;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserCrForm;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserPagination;
import com.bringspring.crm.model.marketexhibitionuser.MarketExhibitionUserUpForm;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.MarketExhibitionService;
import com.bringspring.crm.service.MarketExhibitionUserService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketExhibitionUserServiceImpl
extends ServiceImpl<MarketExhibitionUserMapper, MarketExhibitionUserEntity>
implements MarketExhibitionUserService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private MarketExhibitionService marketExhibitionService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<MarketExhibitionUserEntity> getList(MarketExhibitionUserPagination marketExhibitionUserPagination) {
        Object marketExhibitionObJ;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int marketExhibitionUserNum = 0;
        QueryWrapper marketExhibitionUserQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            marketExhibitionObJ = this.authorizeService.getCondition(new AuthorizeConditionModel(marketExhibitionUserQueryWrapper, marketExhibitionUserPagination.getMenuId(), "market_exhibition_user"));
            if (ObjectUtil.isEmpty((Object)marketExhibitionObJ)) {
                return null;
            }
            marketExhibitionUserQueryWrapper = (QueryWrapper)marketExhibitionObJ;
            ++marketExhibitionUserNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            marketExhibitionObJ = this.authorizeService.getCondition(new AuthorizeConditionModel(marketExhibitionUserQueryWrapper, marketExhibitionUserPagination.getMenuId(), "market_exhibition_user"));
            if (ObjectUtil.isEmpty((Object)marketExhibitionObJ)) {
                return null;
            }
            marketExhibitionUserQueryWrapper = (QueryWrapper)marketExhibitionObJ;
            ++marketExhibitionUserNum;
        }
        if (StringUtils.isNotEmpty((String)marketExhibitionUserPagination.getKeyword())) {
            ++marketExhibitionUserNum;
            marketExhibitionUserQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(MarketExhibitionUserEntity::getName, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getNosocomium, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getUserPhone, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getProvince, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getExhibitionName, (Object)marketExhibitionUserPagination.getKeyword());
            });
        }
        if (StringUtils.isNotEmpty((String)marketExhibitionUserPagination.getCompanyId())) {
            ++marketExhibitionUserNum;
            marketExhibitionUserQueryWrapper.lambda().like(MarketExhibitionUserEntity::getCompanyId, (Object)marketExhibitionUserPagination.getCompanyId());
        }
        if (AllIdList.size() > 0) {
            marketExhibitionUserQueryWrapper.lambda().in(MarketExhibitionUserEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)marketExhibitionUserPagination.getSidx())) {
            marketExhibitionUserQueryWrapper.lambda().orderByDesc(MarketExhibitionUserEntity::getId);
        } else {
            try {
                String sidx = marketExhibitionUserPagination.getSidx();
                MarketExhibitionUserEntity marketExhibitionUserEntity = new MarketExhibitionUserEntity();
                Field declaredField = marketExhibitionUserEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                marketExhibitionUserQueryWrapper = "asc".equals(marketExhibitionUserPagination.getSort().toLowerCase()) ? (QueryWrapper)marketExhibitionUserQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)marketExhibitionUserQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(marketExhibitionUserPagination.getCurrentPage(), marketExhibitionUserPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)marketExhibitionUserQueryWrapper);
            return marketExhibitionUserPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return marketExhibitionUserPagination.setData(list, list.size());
    }

    @Override
    public List<MarketExhibitionUserEntity> getTypeList(MarketExhibitionUserPagination marketExhibitionUserPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int marketExhibitionUserNum = 0;
        QueryWrapper marketExhibitionUserQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)marketExhibitionUserPagination.getKeyword())) {
            ++marketExhibitionUserNum;
            marketExhibitionUserQueryWrapper.lambda().and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(MarketExhibitionUserEntity::getName, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getNosocomium, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getUserPhone, (Object)marketExhibitionUserPagination.getKeyword())).or()).like(MarketExhibitionUserEntity::getProvince, (Object)marketExhibitionUserPagination.getKeyword());
            });
        }
        if (AllIdList.size() > 0) {
            marketExhibitionUserQueryWrapper.lambda().in(MarketExhibitionUserEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)marketExhibitionUserPagination.getSidx())) {
            marketExhibitionUserQueryWrapper.lambda().orderByDesc(MarketExhibitionUserEntity::getId);
        } else {
            try {
                String sidx = marketExhibitionUserPagination.getSidx();
                MarketExhibitionUserEntity marketExhibitionUserEntity = new MarketExhibitionUserEntity();
                Field declaredField = marketExhibitionUserEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                marketExhibitionUserQueryWrapper = "asc".equals(marketExhibitionUserPagination.getSort().toLowerCase()) ? (QueryWrapper)marketExhibitionUserQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)marketExhibitionUserQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(marketExhibitionUserPagination.getCurrentPage(), marketExhibitionUserPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)marketExhibitionUserQueryWrapper);
                return marketExhibitionUserPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return marketExhibitionUserPagination.setData(list, list.size());
        }
        return this.list((Wrapper)marketExhibitionUserQueryWrapper);
    }

    @Override
    public MarketExhibitionUserEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MarketExhibitionUserEntity::getId, (Object)id);
        return (MarketExhibitionUserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public MarketExhibitionUserEntity getByPhone(String phone, String companyId, String exhibitionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MarketExhibitionUserEntity::getUserPhone, (Object)phone);
        queryWrapper.lambda().eq(MarketExhibitionUserEntity::getCompanyId, (Object)companyId);
        queryWrapper.lambda().eq(MarketExhibitionUserEntity::getExhibitionId, (Object)exhibitionId);
        return (MarketExhibitionUserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(MarketExhibitionUserCrForm marketExhibitionUserCrForm) {
        MarketExhibitionEntity info;
        String mainId = RandomUtil.uuId();
        MarketExhibitionUserEntity entity = (MarketExhibitionUserEntity)JsonUtil.getJsonToBean((Object)marketExhibitionUserCrForm, MarketExhibitionUserEntity.class);
        if (StrUtil.isNotEmpty((CharSequence)marketExhibitionUserCrForm.getProductId())) {
            entity.setProductName(this.baseDataUtil.getDictName(marketExhibitionUserCrForm.getProductId(), "productListJC"));
        }
        if (StringUtils.isNotEmpty((String)entity.getExhibitionId()) && ObjectUtil.isNotEmpty((Object)(info = this.marketExhibitionService.getInfo(entity.getExhibitionId())))) {
            entity.setExhibitionName(info.getTitle());
        }
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, MarketExhibitionUserUpForm marketExhibitionUserUpForm) {
        UserInfo userInfo = this.userProvider.get();
        MarketExhibitionUserEntity entity = this.getInfo(id);
        if (entity != null) {
            MarketExhibitionUserEntity subentity = (MarketExhibitionUserEntity)JsonUtil.getJsonToBean((Object)marketExhibitionUserUpForm, MarketExhibitionUserEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(MarketExhibitionUserEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

