/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.model.rkCollege.RkCollegeConfigModel;
import com.bringspring.crm.service.SsoRongKeCollegeService;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.mapper.SynThirdInfoMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SsoRongKeCollegeServiceImpl
implements SsoRongKeCollegeService {
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoMapper synThirdInfoMapper;

    @Override
    public String getUrl(RkCollegeConfigModel rkCollegeConfigModel) throws BaseException, UnsupportedEncodingException {
        return this.byUrl(rkCollegeConfigModel);
    }

    @Override
    public RkCollegeConfigModel byCategory(String type) throws BaseException {
        Map map = this.sysConfigService.getConfigsByCategory(type);
        RkCollegeConfigModel rkCollegeConfigModel = (RkCollegeConfigModel)JsonUtil.getJsonToBean((Object)map, RkCollegeConfigModel.class);
        return rkCollegeConfigModel;
    }

    public String byUrl(RkCollegeConfigModel rkCollegeConfigModel) throws UnsupportedEncodingException {
        UserInfo userInfo = this.userProvider.get();
        String eln4SSOUrl = rkCollegeConfigModel.getEln4SSOUrl();
        String corpCode = rkCollegeConfigModel.getCorpCode();
        String secret = rkCollegeConfigModel.getRkSecret();
        long timestamp = System.currentTimeMillis();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SynThirdInfoEntity::getThirdType, (Object)1);
        queryWrapper.lambda().eq(SynThirdInfoEntity::getSystemObjectId, (Object)userInfo.getUserId());
        SynThirdInfoEntity synThirdInfoEntity = (SynThirdInfoEntity)this.synThirdInfoMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)synThirdInfoEntity)) {
            throw new LoginException("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8d26\u53f7\u4e3a\u7a7a");
        }
        String loginName = synThirdInfoEntity.getThirdObjectId();
        String action = "sso";
        String signingText = secret + "|" + action + "|" + corpCode + "|" + loginName + "|" + timestamp + "|" + secret;
        String md5 = Md5Util.getStringMd5((String)signingText);
        String url = eln4SSOUrl + "?userName=" + URLEncoder.encode(loginName, "utf-8") + "&timestamp=" + timestamp + "&corpCode=" + corpCode + "&sign=" + md5;
        return url;
    }
}

