/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.util.WxMaConfigHolder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.crm.entity.CrmCustomerUserPointsEntity;
import com.bringspring.crm.entity.MarketExhibitionUserEntity;
import com.bringspring.crm.service.CrmCustomerUserPointsService;
import com.bringspring.crm.service.MarketExhibitionUserService;
import com.bringspring.crm.service.WechatVisitService;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.config.mutil.WxMaConfiguration;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.service.UserService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatVisitServiceImpl
implements WechatVisitService {
    protected Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private WxMaConfiguration wxMaConfiguration;
    private WxMaService wxMaService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private CrmCustomerUserPointsService crmCustomerUserPointsService;
    @Autowired
    private MarketExhibitionUserService marketExhibitionUserService;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public CrmCustomerUserPointsEntity getAccountByWxMiniappCodeName(String appid, String code, String phoneCode, String iv, String encryptedData) {
        CrmCustomerUserPointsEntity userPointsEntity;
        block11: {
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new LoginException("empty jscode");
            }
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appid);
            userPointsEntity = new CrmCustomerUserPointsEntity();
            try {
                WxMaJscode2SessionResult session = this.wxMaService.getUserService().getSessionInfo(code);
                String thirdObjid = session.getOpenid();
                WxMaUserInfo userInfo = this.wxMaService.getUserService().getUserInfo(session.getSessionKey(), encryptedData, iv);
                if (StringUtils.isEmpty((String)thirdObjid)) {
                    throw new LoginException("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01");
                }
                if (StringUtils.isNotEmpty((String)phoneCode)) {
                    try {
                        userPointsEntity = this.bindingWxMiniappCode(appid, thirdObjid, phoneCode, userInfo);
                        break block11;
                    }
                    catch (LoginException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + e);
                    }
                }
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237(openid)\u672a\u7ed1\u5b9a\u7cfb\u7edf\u8d26\u6237", 901, (Object)session);
            }
            catch (WxErrorException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + (Object)((Object)e));
            }
            finally {
                WxMaConfigHolder.remove();
            }
        }
        return userPointsEntity;
    }

    @Override
    public String marketExhibitionLogin(String appid, String code, String phoneCode, String iv, String encryptedData, String companyId, String exhibitionId) {
        String phone;
        block11: {
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new LoginException("empty jscode");
            }
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appid);
            phone = "";
            try {
                WxMaJscode2SessionResult session = this.wxMaService.getUserService().getSessionInfo(code);
                String thirdObjid = session.getOpenid();
                if (StringUtils.isEmpty((String)thirdObjid)) {
                    throw new LoginException("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01");
                }
                if (StringUtils.isNotEmpty((String)phoneCode)) {
                    try {
                        phone = this.wxMinMarketExhibition(appid, thirdObjid, phoneCode, companyId, exhibitionId);
                        break block11;
                    }
                    catch (LoginException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + e);
                    }
                }
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237(openid)\u672a\u7ed1\u5b9a\u7cfb\u7edf\u8d26\u6237", 901, (Object)session);
            }
            catch (WxErrorException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + (Object)((Object)e));
            }
            finally {
                WxMaConfigHolder.remove();
            }
        }
        return phone;
    }

    private String wxMinMarketExhibition(String appid, String openid, String phoneCode, String companyId, String exhibitionId) throws Exception {
        if (StringUtils.isBlank((CharSequence)openid) || StringUtils.isBlank((CharSequence)phoneCode)) {
            throw new LoginException("empty phoneCode \u65e0\u6cd5\u7ed1\u5b9a");
        }
        WxMaPhoneNumberInfo phoneNumberInfo = this.wxMaService.getUserService().getPhoneNumber(phoneCode);
        CrmCustomerUserPointsEntity userPointsEntity = new CrmCustomerUserPointsEntity();
        if (ObjectUtil.isNotEmpty((Object)phoneNumberInfo) && StringUtils.isNotEmpty((String)phoneNumberInfo.getPhoneNumber())) {
            String phoneNumber = phoneNumberInfo.getPhoneNumber();
            MarketExhibitionUserEntity byPhone = this.marketExhibitionUserService.getByPhone(phoneNumber, companyId, exhibitionId);
            if (ObjectUtil.isNotEmpty((Object)byPhone)) {
                throw new LoginException("\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4");
            }
            return phoneNumber;
        }
        throw new LoginException("\u5c06phoneCode\u6362\u53d6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff01", 903, (Object)phoneNumberInfo);
    }

    private CrmCustomerUserPointsEntity bindingWxMiniappCode(String appid, String openid, String phoneCode, WxMaUserInfo userInfo) throws Exception {
        if (StringUtils.isBlank((CharSequence)openid) || StringUtils.isBlank((CharSequence)phoneCode)) {
            throw new LoginException("empty phoneCode \u65e0\u6cd5\u7ed1\u5b9a");
        }
        WxMaPhoneNumberInfo phoneNumberInfo = this.wxMaService.getUserService().getPhoneNumber(phoneCode);
        CrmCustomerUserPointsEntity userPointsEntity = new CrmCustomerUserPointsEntity();
        if (ObjectUtil.isNotEmpty((Object)phoneNumberInfo) && StringUtils.isNotEmpty((String)phoneNumberInfo.getPhoneNumber())) {
            String phoneNumber = phoneNumberInfo.getPhoneNumber();
            CrmCustomerUserPointsEntity pointsEntity = this.crmCustomerUserPointsService.getByOpenid(openid);
            if (ObjectUtil.isEmpty((Object)pointsEntity)) {
                CrmCustomerUserPointsEntity pointsEntity2;
                CrmCustomerUserPointsEntity customerUserPointsEntity = this.crmCustomerUserPointsService.getByPhone(phoneNumber);
                CrmCustomerUserPointsEntity newPoints = new CrmCustomerUserPointsEntity();
                newPoints.setOpenid(openid);
                newPoints.setAppId(appid);
                newPoints.setPoints(0);
                newPoints.setId(RandomUtil.uuId());
                newPoints.setPhone(phoneNumber);
                newPoints.setType("1");
                if (ObjectUtil.isNotEmpty((Object)customerUserPointsEntity)) {
                    newPoints.setPoints(customerUserPointsEntity.getPoints());
                    newPoints.setCustomerId(customerUserPointsEntity.getCustomerId());
                    newPoints.setCustomerName(customerUserPointsEntity.getCustomerName());
                    newPoints.setName(customerUserPointsEntity.getName());
                    newPoints.setDuties(customerUserPointsEntity.getDuties());
                }
                this.crmCustomerUserPointsService.create(newPoints);
                userPointsEntity = pointsEntity2 = this.crmCustomerUserPointsService.getByOpenid(openid);
            } else {
                if (StrUtil.isEmpty((CharSequence)pointsEntity.getPhone())) {
                    pointsEntity.setPhone(phoneNumber);
                    this.crmCustomerUserPointsService.updateById(pointsEntity);
                }
                userPointsEntity = pointsEntity;
            }
        } else {
            throw new LoginException("\u5c06phoneCode\u6362\u53d6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff01", 903, (Object)phoneNumberInfo);
        }
        return userPointsEntity;
    }

    public String getDefaultPassword(String secretKey) {
        BaseSystemInfo baseSystemInfo = this.sysConfigService.getSysInfo();
        return Md5Util.getStringMd5((String)(Md5Util.getStringMd5((String)baseSystemInfo.getDefaultPassword()).toLowerCase() + secretKey.toLowerCase()));
    }

    public static JSONObject getUserInfo(String accessToken, String openid) {
        String url = accessToken + "+&openid" + openid;
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)response.toString());
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

