/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.crm.config.OpportunityPushConfig;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityTrendsEntity;
import com.bringspring.crm.model.crmcustomeropportunity.CrmCustomerOpportunityStatisticsListVo;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerOpportunityTrendsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workitem.service.CrmWorkitemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrmTimeUtil {
    Logger logger = LoggerFactory.getLogger(CrmTimeUtil.class);
    @Autowired
    private OpportunityPushConfig opportunityPushConfig;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmCustomerOpportunityTrendsService crmCustomerOpportunityTrendsService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;

    @JsbosTask(fullName="\u5b9a\u65f6\u751f\u6210\u5ba2\u6237\u4e2d\u6587\u522b\u540d\u67e5\u8be2\u4efb\u52a1", description="CustomerChinessAliasQueryTask", cron="0 0 4 * * ?")
    public void CustomerChinessAliasQueryTask() {
        this.crmCustomerService.updateAliasQuery();
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u751f\u6210\u5ba2\u6237\u4e2d\u6587\u540d\u7ecf\u7eac\u5ea6\u6570\u636e", description="CustomerLongLatTask")
    public void CustomerLongLatTask(String ajaxtimestamp) {
        this.crmCustomerService.updateLongLatQuery(ajaxtimestamp);
    }

    @JsbosTask(fullName="\u5de5\u4f5c\u9879\u5b9a\u65f6\u4efb\u52a1", description="workitemSchduleTask", cron="0 0 8 * * ?")
    public void scheduletask() {
        this.crmWorkitemService.workItemSchdule();
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u63a8\u9001\u5546\u673a", description="opportunityPushSchduleTask", cron="0 0 10 * * ?")
    public void pushOpportunityToLeaderTask() {
        int diffDays = com.bringspring.common.util.DateUtil.getDiffDays((Date)com.bringspring.common.util.DateUtil.stringToDates((String)this.opportunityPushConfig.getFirstPushDate()), (Date)com.bringspring.common.util.DateUtil.getNowDate());
        if (this.opportunityPushConfig.getIsTest() == 1) {
            this.pushOpportunityToLeader();
        } else if (diffDays > 0 && Math.floorMod(diffDays, (int)this.opportunityPushConfig.getIntervalDay()) == 0) {
            this.pushOpportunityToLeader();
        }
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u63d0\u9192\u9500\u552e\u8ddf\u8fdb\u5546\u673a", description="opportunityPushToSalerFollowSchduleTask", cron="0 0 15 * * ?")
    public void pushToSalerTask() {
        Date date = com.bringspring.common.util.DateUtil.dateAddDays((Date)com.bringspring.common.util.DateUtil.getNowDate(), (int)-8);
        String s = com.bringspring.common.util.DateUtil.daFormat((Date)date);
        List<CrmCustomerOpportunityTrendsEntity> needToNoticeSaler = this.crmCustomerOpportunityService.getNeedToNoticeSaler(s, this.opportunityPushConfig.getSearchSalerId());
        if (CollectionUtil.isEmpty(needToNoticeSaler)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u8ddf\u8fdb\u7684\u5546\u673a");
        } else {
            needToNoticeSaler.stream().forEach(entity -> this.pushToSaler((CrmCustomerOpportunityTrendsEntity)entity));
        }
    }

    public void pushBeforeSalerFollowRecord() {
        if (this.opportunityPushConfig.getIsTest() == 1) {
            this.pushSalerFollowToBeforeSaler();
        } else {
            String weekStr = DateUtil.thisDayOfWeekEnum().toChinese();
            if (weekStr.equals("\u661f\u671f\u4e94")) {
                this.pushSalerFollowToBeforeSaler();
            }
        }
    }

    private void pushOpportunityToLeader() {
        Object[] split;
        Date endDayOfYesterday = com.bringspring.common.util.DateUtil.getEndDayOfYesterday();
        String yesterdayStr = com.bringspring.common.util.DateUtil.daFormat((Date)endDayOfYesterday);
        List<CrmCustomerOpportunityStatisticsListVo> list = this.crmCustomerOpportunityService.statisticsList(yesterdayStr);
        Map<Object, Integer> sum = list.stream().collect(Collectors.groupingBy(CrmCustomerOpportunityStatisticsListVo::getEnabledMark, Collectors.summingInt(p -> 1)));
        Integer auditNum = sum.get("1") == null ? Integer.valueOf(0) : sum.get("1");
        Integer failNum = sum.get("5") == null ? Integer.valueOf(0) : sum.get("5");
        Integer total = list.size();
        String msg = "";
        if (total <= 0) {
            msg = "\u6682\u65e0\u5546\u673a";
        } else {
            Integer approvedNum = total - auditNum - failNum;
            msg = "\u5171\u63d0\u62a5\u4e86" + total + "\u6761\u5546\u673a";
            if (approvedNum > 0) {
                msg = msg + ",\u5ba1\u6838\u901a\u8fc7" + approvedNum + "\u6761";
            }
            if (failNum > 0) {
                msg = msg + ",\u5ba1\u6838\u672a\u901a\u8fc7" + failNum + "\u6761";
            }
            if (auditNum > 0) {
                msg = msg + "\uff0c\u5ba1\u6838\u4e2d" + auditNum + "\u6761";
            }
        }
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        } else {
            split = this.opportunityPushConfig.getToUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        }
        String startDate = com.bringspring.common.util.DateUtil.daFormat((Date)com.bringspring.common.util.DateUtil.dateAddDays((Date)new Date(), (int)(this.opportunityPushConfig.getIntervalDay() * -1)));
        String statisticalDate = startDate + "--" + yesterdayStr;
        String taskCode = MessageTypeEnum.OPPORTUNITY_PUSH_MESSAGE_TEMPLATECODE.getMessage();
        String sendCode = MessageTypeEnum.OPPORTUNITY_PUSH_MESSAGE_TEMPLATECODE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", "\u65b0\u589e\u5546\u673a\u7edf\u8ba1\u6c47\u603b\uff08\u6bcf\u4e24\u5468\u63a8\u9001\u4e00\u6b21\uff09");
        keys.put("content", msg);
        keys.put("summaryInfo", msg);
        keys.put("statisticalDate", statisticalDate);
        keys.put("MessageTime", com.bringspring.common.util.DateUtil.getNow());
        String appUrl = "/#/pages/crm/crmStatistics/index?parameter=" + yesterdayStr;
        String pcUrl = "/#/model/shangjitotal";
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), termType, null);
    }

    private void pushToSaler(CrmCustomerOpportunityTrendsEntity entity) {
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            Object[] split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        } else {
            toUserIds = CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getObjectId()});
        }
        int diffDays = com.bringspring.common.util.DateUtil.getDiffDays((Date)entity.getCreatorTime(), (Date)com.bringspring.common.util.DateUtil.getNowDate());
        if (diffDays <= 7) {
            return;
        }
        CrmCustomerOpportunityEntity byId = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)entity.getCustomerOpportunityId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return;
        }
        CrmCustomerEntity byId1 = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()));
        String customerName = byId1.getName();
        String fenPeiName = "";
        if (StrUtil.equals((CharSequence)entity.getType(), (CharSequence)"follow")) {
            CrmCustomerOpportunityTrendsEntity maxRecord = this.crmCustomerOpportunityTrendsService.getMaxRecord(entity.getCustomerOpportunityId(), entity.getType());
            if (ObjectUtil.isEmpty((Object)maxRecord)) {
                return;
            }
            fenPeiName = this.baseDataUtil.userSelectValueNoAccount(maxRecord.getCreatorUserId());
        } else {
            fenPeiName = this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId());
        }
        String saler = this.baseDataUtil.userSelectValueNoAccount(entity.getObjectId());
        StringBuffer msg = new StringBuffer();
        msg.append(fenPeiName + "\u5206\u914d\u5546\u673a\u7ed9" + saler + "\uff0c\u8bf7\u586b\u5199\u6700\u65b0\u7684\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u5982\u9700\u534f\u52a9\u53ef\u7533\u8bf7\u534f\u52a9\u3002");
        String taskCode = MessageTypeEnum.OPPORTUNITY_PUSH_TO_SALER_MESSAGE_TEMPLATECODE.getMessage();
        String sendCode = MessageTypeEnum.OPPORTUNITY_PUSH_TO_SALER_MESSAGE_TEMPLATECODE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u5546\u673a\u5df2\u8d85\u8fc77\u5929\u672a\u66f4\u65b0\u52a8\u6001\uff0c\u8bf7\u70b9\u51fb\u586b\u5199\u6700\u65b0\u8fdb\u5c55\u60c5\u51b5\uff01");
        keys.put("content", msg.toString());
        keys.put("customerName", customerName);
        keys.put("assignDate", com.bringspring.common.util.DateUtil.dateFormat((Date)entity.getCreatorTime()));
        keys.put("MessageTime", com.bringspring.common.util.DateUtil.getNow());
        String appUrl = "/#/pages/crm/opportunity/oppDetail?id=" + entity.getCustomerOpportunityId();
        String pcUrl = "/#/crm/crmcustomeropportunity?id=" + entity.getCustomerOpportunityId();
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), termType, null);
    }

    private void pushSalerFollowToBeforeSaler() {
        SentMessageForm sentMessageForm;
        String nowStr = com.bringspring.common.util.DateUtil.daFormat((Date)new Date());
        Date date = com.bringspring.common.util.DateUtil.dateAddDays((Date)com.bringspring.common.util.DateUtil.getNowDate(), (int)-7);
        String startDate = com.bringspring.common.util.DateUtil.daFormat((Date)date);
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            Object[] split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        }
        if (ObjectUtil.isEmpty((Object)(sentMessageForm = this.getMessageForm(32, "pushOppFollowRecordToBeforeSalerTemplate")))) {
            return;
        }
        sentMessageForm.setToUserIds(toUserIds);
        sentMessageForm.setTitle("\u5546\u673a\u8ddf\u8fdb\u4fe1\u606f\u7edf\u8ba1\u6c47\u603b\uff08\u6bcf\u5468\u63a8\u9001\u4e00\u6b21\uff09");
        HashMap<String, String> map = new HashMap<String, String>();
        String statisticalDate = startDate + "--" + nowStr;
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getTitle());
        map.put("statisticalDate", statisticalDate);
        String messageTime = com.bringspring.common.util.DateUtil.dateFormat((Date)new Date());
        map.put("MessageTime", messageTime);
        StringBuffer contentWechat = new StringBuffer();
        contentWechat.append("\n\u7edf\u8ba1\u5468\u671f:" + statisticalDate);
        contentWechat.append("\n\u901a\u77e5\u65f6\u95f4:" + messageTime);
        map.put("content", contentWechat.toString());
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    @JsbosTask(fullName="\u5546\u673a\u62a5\u5907\u8ddf\u8fdb\u63d0\u9192", description="reportingFollowWarnTask", cron="0 0 10 * * ?")
    public void reportingFollowWarnTask() {
        Date date = com.bringspring.common.util.DateUtil.dateAddDays((Date)com.bringspring.common.util.DateUtil.getNowDate(), (int)-7);
        String s = com.bringspring.common.util.DateUtil.daFormat((Date)date);
        List<RkProjectReportingEntity> needToWarnList = this.rkProjectReportingService.getNeedToWarnListGroupBy(s, this.opportunityPushConfig.getSearchSalerId());
        if (CollectionUtil.isEmpty(needToWarnList)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u8ddf\u8fdb\u7684\u5546\u673a\u62a5\u5907");
        } else {
            needToWarnList.stream().forEach(entity -> this.pushToWarn((RkProjectReportingEntity)entity));
        }
    }

    private void pushToWarn(RkProjectReportingEntity entity) {
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            Object[] split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        } else {
            toUserIds = CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getCreatorUserId()});
        }
        String taskCode = MessageTypeEnum.REPORTING_FOLLOW_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.REPORTING_FOLLOW_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", "\u60a8\u62a5\u5907\u7684\u5546\u673a\u5df2\u8d85\u8fc77\u5929\u672a\u8ddf\u8fdb\uff0c\u8bf7\u70b9\u51fb\u586b\u5199\u6700\u65b0\u8ddf\u8fdb\u8bb0\u5f55\uff01\u5171" + entity.getByCreatorUserIdCount() + "\u6761\u6570\u636e");
        keys.put("content", "\u8bf7\u586b\u5199\u6700\u65b0\u7684\u8ddf\u8fdb\u8bb0\u5f55\u3002");
        keys.put("MessageTime", com.bringspring.common.util.DateUtil.getNow());
        String appUrl = "/#/pages/crm/crmReporting/index";
        String pcUrl = "/#/reporting/list";
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), termType, null);
    }

    @JsbosTask(fullName="\u56de\u6b3e\u8d85\u8fc7\u4e00\u4e2a\u6708\u672a\u8ddf\u8fdb\u63d0\u9192", description="contractReturnPlanWarnTask", cron="0 0 9 * * ?")
    public void pushToReturnPayment() {
        String type = "moreThanOneMonth";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByNotFollowOneMonth = this.rkContractReturnPlanService.getListByNotFollowOneMonth(nowDate);
        ArrayList needToWarnList = new ArrayList();
        listByNotFollowOneMonth.stream().forEach(t -> {
            Date actualDate;
            int residueDays;
            if (nowDate.after(com.bringspring.common.util.DateUtil.dateAddDays((Date)t.getFollowTime(), (int)30)) && (residueDays = com.bringspring.common.util.DateUtil.getDiffDays((Date)(actualDate = com.bringspring.common.util.DateUtil.dateAddDays((Date)t.getFollowTime(), (int)30)), (Date)nowDate)) % 7 == 0) {
                needToWarnList.add(t);
            }
        });
        if (CollectionUtil.isEmpty(needToWarnList)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            needToWarnList.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u5269\u4f59\u4e24\u5468\u5230\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f\u63d0\u9192", description="returnPlanWarnAdvanceTwoWeeksTask", cron="0 0 9 * * ?")
    public void pushToAdvanceTwoWeeksReturnPayment() {
        String type = "advanceTwoWeeks";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByTwoWeekNextFollowDate = this.rkContractReturnPlanService.getListByTwoWeekNextFollowDate(nowDate);
        if (CollectionUtil.isEmpty(listByTwoWeekNextFollowDate)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            listByTwoWeekNextFollowDate.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u5269\u4f59\u4e00\u5468\u5230\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f\u63d0\u9192", description="returnPlanWarnAdvanceOneWeeksTask", cron="0 0 9 * * ?")
    public void pushToAdvanceOneWeeksReturnPayment() {
        String type = "advanceOneWeeks";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByOneWeekNextFollowDate = this.rkContractReturnPlanService.getListByOneWeekNextFollowDate(nowDate);
        if (CollectionUtil.isEmpty(listByOneWeekNextFollowDate)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            listByOneWeekNextFollowDate.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u5269\u4f59\u4e09\u5929\u5230\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f\u63d0\u9192", description="returnPlanWarnAdvanceThreeDaysTask", cron="0 0 9 * * ?")
    public void pushToAdvanceThreeDaysReturnPayment() {
        String type = "advanceThreeDays";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByThreeDaysNextFollowDate = this.rkContractReturnPlanService.getListByThreeDaysNextFollowDate(nowDate);
        if (CollectionUtil.isEmpty(listByThreeDaysNextFollowDate)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            listByThreeDaysNextFollowDate.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u5269\u4f59\u4e24\u5929\u5230\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f\u63d0\u9192", description="returnPlanWarnAdvanceTwoDaysTask", cron="0 0 9 * * ?")
    public void pushToAdvanceTwoDaysReturnPayment() {
        String type = "advanceTwoDays";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByTwoDaysNextFollowDate = this.rkContractReturnPlanService.getListByTwoDaysNextFollowDate(nowDate);
        if (CollectionUtil.isEmpty(listByTwoDaysNextFollowDate)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            listByTwoDaysNextFollowDate.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u5269\u4f59\u4e00\u5929\u5230\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f\u63d0\u9192", description="returnPlanWarnAdvanceOneDaysTask", cron="0 0 9 * * ?")
    public void pushToAdvanceOneDaysReturnPayment() {
        String type = "advanceOneDays";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByOneDaysNextFollowDate = this.rkContractReturnPlanService.getListByOneDaysNextFollowDate(nowDate);
        if (CollectionUtil.isEmpty(listByOneDaysNextFollowDate)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            listByOneDaysNextFollowDate.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    @JsbosTask(fullName="\u56de\u6b3e\u8d85\u8fc7\u4e00\u5468\u672a\u8ddf\u8fdb\u63d0\u9192", description="returnPlanWarnMoreThanOneWeekTask", cron="0 0 9 * * ?")
    public void pushToMoreThanOneWeekReturnPayment() {
        String type = "moreThanOneWeek";
        Date nowDate = com.bringspring.common.util.DateUtil.getNowDate();
        List<RkContractReturnPlanEntity> listByMoreThanAgainDate = this.rkContractReturnPlanService.getListByMoreThanAgainDate(nowDate);
        ArrayList needToWarnList = new ArrayList();
        listByMoreThanAgainDate.stream().forEach(t -> {
            Date actualDate;
            int residueDays;
            if (nowDate.after(com.bringspring.common.util.DateUtil.dateAddDays((Date)t.getAgainDate(), (int)7)) && (residueDays = com.bringspring.common.util.DateUtil.getDiffDays((Date)(actualDate = com.bringspring.common.util.DateUtil.dateAddDays((Date)t.getAgainDate(), (int)7)), (Date)nowDate)) % 7 == 0) {
                needToWarnList.add(t);
            }
        });
        if (CollectionUtil.isEmpty(needToWarnList)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u56de\u6b3e\u8ddf\u8fdb");
        } else {
            needToWarnList.stream().forEach(entity -> this.pushToReturnPaymentWarn((RkContractReturnPlanEntity)entity, type));
        }
    }

    public void pushToReturnPaymentWarn(RkContractReturnPlanEntity entity, String type) {
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds = CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getSalerId()});
        String taskCode = MessageTypeEnum.CONTRACT_RETURN_PLAN_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.CONTRACT_RETURN_PLAN_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        if (type.equals("moreThanOneMonth")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u5df2\u8d85\u8fc71\u4e2a\u6708\u672a\u8ddf\u8fdb\uff0c\u8bf7\u70b9\u51fb\u586b\u5199\u6700\u65b0\u8ddf\u8fdb\u8bb0\u5f55\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u586b\u5199\u6700\u65b0\u7684\u8ddf\u8fdb\u8bb0\u5f55\u3002");
        } else if (type.equals("advanceTwoWeeks")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u8fd8\u6709\u4e24\u5468\u5230\u6700\u8fd1\u8ddf\u8fdb\u65e5\u671f\uff0c\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\u3002");
        } else if (type.equals("advanceOneWeeks")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u8fd8\u6709\u4e00\u5468\u5230\u6700\u8fd1\u8ddf\u8fdb\u65e5\u671f\uff0c\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\u3002");
        } else if (type.equals("advanceThreeDays")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u8fd8\u6709\u4e09\u5929\u5230\u6700\u8fd1\u8ddf\u8fdb\u65e5\u671f\uff0c\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\u3002");
        } else if (type.equals("advanceTwoDays")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u8fd8\u6709\u4e24\u5929\u5230\u6700\u8fd1\u8ddf\u8fdb\u65e5\u671f\uff0c\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\u3002");
        } else if (type.equals("advanceOneDays")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u8fd8\u6709\u4e00\u5929\u5230\u6700\u8fd1\u8ddf\u8fdb\u65e5\u671f\uff0c\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u6ce8\u610f\u8ddf\u8fdb\u65e5\u671f\u3002");
        } else if (type.equals("moreThanOneWeek")) {
            keys.put("title", "\u60a8\u8d1f\u8d23\u7684\u56de\u6b3e\u8ba1\u5212\u5df2\u8d85\u8fc7\u4e00\u5468\u672a\u8ddf\u8fdb\uff0c\u8bf7\u70b9\u51fb\u586b\u5199\u6700\u65b0\u8ddf\u8fdb\u8bb0\u5f55\uff01\u5408\u540c\u7f16\u53f7:" + entity.getContractCode());
            keys.put("content", "\u8bf7\u586b\u5199\u6700\u65b0\u7684\u8ddf\u8fdb\u8bb0\u5f55\u3002");
        }
        keys.put("MessageTime", com.bringspring.common.util.DateUtil.getNow());
        String appUrl = "/#/pages/crm/contractReturnPlan/index";
        String pcUrl = "/#/contract/returnPlan/list";
        String termType = TermTypeEnum.TERM_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), termType, null);
    }
}

