/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.util;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.crm.util.Sensitive;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private DesensitizedUtil.DesensitizedType type;
    @Autowired
    private HttpServletRequest request;

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String requestURI = this.request.getRequestURI();
        String sensitive = this.request.getHeader("sensitive");
        if (StrUtil.equals((CharSequence)sensitive, (CharSequence)"true")) {
            gen.writeString(DesensitizedUtil.desensitized((CharSequence)value, (DesensitizedUtil.DesensitizedType)this.type));
        } else {
            gen.writeString(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation = (Sensitive)property.getAnnotation(Sensitive.class);
        if (Objects.nonNull(annotation) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.type = annotation.type();
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }
}

