/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.data.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.model.datacenter.SaleDataSummaryVo;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.data.model.SaleDataSummaryRtVo;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visit.service.AfterSalesInspectTaskService;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskDetailService;
import com.bringspring.visit.service.BeforeSaleSupportListService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.VisitFollowUpService;
import com.bringspring.visit.utils.RoleVisitUtils;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/data"})
public class CustomerViewController {
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private VisitFollowUpService visitFollowUpService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RoleVisitUtils roleVisitUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractInvoiceDetailService contractInvoiceDetailService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private AfterSalesInspectTaskService afterSalesInspectTaskService;
    @Autowired
    private AfterSalesTelephoneTaskDetailService afterSalesTelephoneTaskDetailService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private BeforeSaleSupportListService beforeSaleSupportListService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;

    @GetMapping(value={"/customer/summary/{customerId}"})
    public ActionResult customerSummary(@PathVariable(value="customerId") String customerId) {
        HashMap map = MapUtil.newHashMap();
        map.put("visitCount", this.visitFollowUpService.countByCustomerId(customerId));
        map.put("productCount", this.crmProductRelationService.countByCustomerId(customerId));
        map.put("contactsCount", this.crmCustomerContactsService.countByCustomerId(customerId));
        map.put("contractCount", this.contractService.countByCustomerId(customerId));
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"countCustomerPanorama/{id}"})
    public ActionResult countCustomerPanorama(@PathVariable(value="id") String id, String menuId) {
        HashMap map = MapUtil.newHashMap();
        long questionCount = this.afterSalesQuestionService.countByCustomer(id);
        long inspectCount = this.afterSalesInspectTaskService.countCustomerId(id);
        long telephoneCount = this.afterSalesTelephoneTaskDetailService.countByCustomerId(id);
        long visitCount = 0L;
        long contractCount = 0L;
        long reportingCount = 0L;
        long beforeSaleCount = 0L;
        long productCount = 0L;
        long projectCount = 0L;
        long projectQuestionCount = 0L;
        if (StrUtil.isNotEmpty((CharSequence)menuId)) {
            contractCount = this.contractService.countByCustomerId(id, menuId);
            visitCount = this.visitFollowUpService.countByCustomerId(id, menuId);
            reportingCount = this.rkProjectReportingService.countByCustomerId(id, menuId);
            projectCount = this.rkContractProjectService.countByCustomerId(id, menuId);
        } else {
            contractCount = this.contractService.countByCustomerId(id);
            visitCount = this.visitFollowUpService.countByCustomerId(id);
            reportingCount = this.rkProjectReportingService.countByCustomerId(id);
        }
        productCount = this.crmProductRelationService.countByCustomerId(id);
        beforeSaleCount = this.beforeSaleSupportListService.countByCustomerId(id);
        long contactsCount = this.crmCustomerContactsService.countByCustomerIdAndMenuId(id, menuId);
        projectQuestionCount = this.rkProjectQuestionService.countByProjectId(null, id);
        long customerProductCount = this.afterSalesMaintenanceService.countByCustomerId(id);
        long oppCount = this.crmCustomerOpportunityService.countByCustomerId(id);
        map.put("questionCount", questionCount);
        map.put("inspectCount", inspectCount);
        map.put("telephoneCount", telephoneCount);
        map.put("visitCount", visitCount);
        map.put("contractCount", contractCount);
        map.put("contactsCount", contactsCount);
        map.put("beforeSaleCount", beforeSaleCount);
        map.put("productCount", productCount);
        map.put("oppCount", oppCount);
        map.put("reportingCount", reportingCount);
        map.put("projectCount", projectCount);
        map.put("projectQuestionCount", projectQuestionCount);
        map.put("customerProductCount", customerProductCount);
        return ActionResult.success((Object)map);
    }

    @PostMapping(value={"/sale/summary"})
    public ActionResult saleSummary(@RequestBody SaleDataSummaryVo saleDataSummaryVo) {
        UserInfo userInfo = this.userProvider.get();
        List<String> userIdList = this.getUserIdList(saleDataSummaryVo);
        saleDataSummaryVo.setUserIdList(userIdList);
        saleDataSummaryVo.setCompanyId(userInfo.getOrganizeId());
        this.getStartAndEdnDate(saleDataSummaryVo);
        List saleDataSummaryList = CollectionUtil.list((boolean)false);
        SaleDataSummaryRtVo genjin = new SaleDataSummaryRtVo("edit-pen-fill", "\u8ddf\u8fdb\u8bb0\u5f55", "--", "");
        saleDataSummaryList.add(genjin);
        SaleDataSummaryRtVo baobei = new SaleDataSummaryRtVo("email-fill", "\u65b0\u589e\u62a5\u5907", "--", "");
        saleDataSummaryList.add(baobei);
        long visitAddCount = this.visitFollowUpService.countBySaleDataSummary(saleDataSummaryVo);
        SaleDataSummaryRtVo visitAdd = new SaleDataSummaryRtVo("map-fill", "\u62dc\u8bbf\u8bb0\u5f55", String.valueOf(visitAddCount), "");
        saleDataSummaryList.add(visitAdd);
        long oppAddCount = this.crmCustomerOpportunityService.countBySaleDataSummary(saleDataSummaryVo);
        SaleDataSummaryRtVo oppAdd = new SaleDataSummaryRtVo("rmb-circle-fill", "\u65b0\u589e\u5546\u673a", String.valueOf(oppAddCount), "");
        saleDataSummaryList.add(oppAdd);
        long contractAddCount = this.contractService.countBySaleDataSummary(saleDataSummaryVo);
        SaleDataSummaryRtVo contractAdd = new SaleDataSummaryRtVo("order", "\u65b0\u589e\u5408\u540c", String.valueOf(contractAddCount), "\u4efd");
        saleDataSummaryList.add(contractAdd);
        Object totalContractAmount = "--";
        Object totalProfit = "--";
        Map<String, Object> contractAddAmountMap = this.contractService.sumAmountBySaleDataSummary(saleDataSummaryVo);
        if (CollectionUtil.isNotEmpty(contractAddAmountMap)) {
            String divide;
            totalContractAmount = contractAddAmountMap.get("totalContractAmount");
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (!ObjectUtil.isEmpty((Object)totalContractAmount)) {
                divide = MathUtils.divide(String.valueOf(totalContractAmount.toString()), "10000", 2);
                totalContractAmount = numberFormat.format(Double.valueOf(divide));
            }
            if (!ObjectUtil.isEmpty((Object)(totalProfit = contractAddAmountMap.get("totalProfit")))) {
                divide = MathUtils.divide(String.valueOf(totalProfit.toString()), "10000", 2);
                totalProfit = numberFormat.format(Double.valueOf(divide));
            }
        }
        SaleDataSummaryRtVo totalContractAmountAdd = new SaleDataSummaryRtVo("order", "\u65b0\u589e\u5408\u540c", String.valueOf(totalContractAmount), "(\u4e07\u5143)");
        saleDataSummaryList.add(totalContractAmountAdd);
        SaleDataSummaryRtVo jihua = new SaleDataSummaryRtVo("rmb-circle", "\u8ba1\u5212\u5408\u540c\u6bdb\u5229", "--", "(\u4e07\u5143)");
        saleDataSummaryList.add(jihua);
        SaleDataSummaryRtVo totalProfitAdd = new SaleDataSummaryRtVo("checkmark-circle-fill", "\u5b9e\u9645\u5408\u540c\u6bdb\u5229", String.valueOf(totalProfit), "(\u4e07\u5143)");
        saleDataSummaryList.add(totalProfitAdd);
        long contactsAddCount = this.crmCustomerContactsService.countBySaleDataSummary(saleDataSummaryVo);
        SaleDataSummaryRtVo contactsAdd = new SaleDataSummaryRtVo("calendar-fill", "\u65b0\u589e\u8054\u7cfb\u4eba", String.valueOf(contactsAddCount), "");
        saleDataSummaryList.add(contactsAdd);
        return ActionResult.success((Object)saleDataSummaryList);
    }

    @PostMapping(value={"/contract/Return"})
    public ActionResult contractReturn(@RequestBody SaleDataSummaryVo saleDataSummaryVo) {
        UserInfo userInfo = this.userProvider.get();
        List<String> userIdList = this.getUserIdList(saleDataSummaryVo);
        saleDataSummaryVo.setUserIdList(userIdList);
        saleDataSummaryVo.setCompanyId(userInfo.getOrganizeId());
        this.getStartAndEdnDate(saleDataSummaryVo);
        List saleDataSummaryList = CollectionUtil.list((boolean)false);
        SaleDataSummaryRtVo jihua = new SaleDataSummaryRtVo("rmb-circle", "\u8ba1\u5212(\u4e07\u5143)", "--", "");
        saleDataSummaryList.add(jihua);
        Map<String, Object> map = this.contractCollectionRecordService.sumAmountBySaleDataSummary(saleDataSummaryVo);
        Map<String, Object> map1 = this.contractInvoiceDetailService.sumAmountBySaleDataSummary(saleDataSummaryVo);
        NumberFormat numberFormat = NumberFormat.getInstance();
        Object totalReturnAmount = "--";
        if (CollectionUtil.isNotEmpty(map)) {
            totalReturnAmount = map.get("totalReturnAmount");
            String divide = MathUtils.divide(String.valueOf(totalReturnAmount.toString()), "10000", 2);
            totalReturnAmount = numberFormat.format(Double.valueOf(divide));
        }
        Object totalInvoiceAmount = "--";
        if (CollectionUtil.isNotEmpty(map1)) {
            totalInvoiceAmount = map1.get("totalInvoiceAmount");
            String divide = MathUtils.divide(String.valueOf(totalInvoiceAmount.toString()), "10000", 2);
            totalInvoiceAmount = numberFormat.format(Double.valueOf(divide));
        }
        SaleDataSummaryRtVo action = new SaleDataSummaryRtVo("rmb-circle-fill", "\u5b9e\u9645(\u4e07\u5143)", String.valueOf(totalReturnAmount), "");
        SaleDataSummaryRtVo coupon = new SaleDataSummaryRtVo("coupon", "\u5f00\u7968(\u4e07\u5143)", String.valueOf(totalInvoiceAmount), "");
        saleDataSummaryList.add(action);
        saleDataSummaryList.add(coupon);
        return ActionResult.success((Object)saleDataSummaryList);
    }

    private List<String> getUserIdList(SaleDataSummaryVo saleDataSummaryVo) {
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        if (ObjectUtil.isNull((Object)saleDataSummaryVo.getDataRange())) {
            HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
            boolean isAll = (Boolean)map.get("isAll");
            if (!isAll) {
                userIdList.add(userInfo.getUserId());
                List list = (List)map.get("idList");
                userIdList.addAll(list);
            }
        } else {
            List<UserEntity> listByDataRange = this.getListByDataRange(saleDataSummaryVo.getDataRange());
            if (CollectionUtil.isNotEmpty(listByDataRange)) {
                userIdList = listByDataRange.stream().map(UserEntity::getId).collect(Collectors.toList());
            } else {
                userIdList.add(userInfo.getUserId());
            }
        }
        return userIdList;
    }

    private void getStartAndEdnDate(SaleDataSummaryVo saleDataSummaryVo) {
        if (saleDataSummaryVo.getDayType() != null && saleDataSummaryVo.getDayType() == 1) {
            saleDataSummaryVo.setStartDate(com.bringspring.common.util.DateUtil.getBeginDayOfWeek());
            saleDataSummaryVo.setEndDate(com.bringspring.common.util.DateUtil.getEndDayOfWeek());
        }
        if (saleDataSummaryVo.getDayType() != null && saleDataSummaryVo.getDayType() == 2) {
            saleDataSummaryVo.setStartDate(com.bringspring.common.util.DateUtil.getBeginDayOfMonth());
            saleDataSummaryVo.setEndDate(com.bringspring.common.util.DateUtil.getEndDayOfMonth());
        }
        if (saleDataSummaryVo.getDayType() != null && saleDataSummaryVo.getDayType() == 3) {
            saleDataSummaryVo.setStartDate(com.bringspring.common.util.DateUtil.getBeginDayOfSeason((Date)com.bringspring.common.util.DateUtil.getNowDate()));
            saleDataSummaryVo.setEndDate(com.bringspring.common.util.DateUtil.getEndDayOfSeason((Date)com.bringspring.common.util.DateUtil.getNowDate()));
        }
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.lastWeek());
    }

    private List<UserEntity> getListByDataRange(Integer dataRange) {
        HashMap map;
        boolean isAll;
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        if (dataRange == 1 && !(isAll = ((Boolean)(map = this.roleVisitUtils.canSeeUserId(userInfo)).get("isAll")).booleanValue())) {
            List list = (List)map.get("idList");
            userIdList.addAll(list);
        }
        if (dataRange == 2) {
            List listByManagerId = this.userService.getListByManagerId(userInfo.getUserId(), "");
            UserIdListVo userIdListVo = new UserIdListVo();
            userIdListVo.setId(userInfo.getUserId());
            listByManagerId.add(userIdListVo);
            if (CollectionUtil.isNotEmpty((Collection)listByManagerId)) {
                List collect1 = listByManagerId.stream().map(UserBaseVO::getId).collect(Collectors.toList());
                userIdList.addAll(collect1);
            } else {
                userIdList.add(userInfo.getUserId());
            }
        }
        if (dataRange == 3) {
            userIdList.add(userInfo.getUserId());
        }
        if (CollectionUtil.isEmpty((Collection)userIdList)) {
            return CollectionUtil.list((boolean)false);
        }
        List userEntities = this.userService.listByIds((Collection)userIdList);
        return userEntities;
    }
}

