/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.demo.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.demo.entity.DemoProductEntity;
import com.bringspring.demo.model.demoproduct.DemoProductCrForm;
import com.bringspring.demo.model.demoproduct.DemoProductInfoVO;
import com.bringspring.demo.model.demoproduct.DemoProductListVO;
import com.bringspring.demo.model.demoproduct.DemoProductPagination;
import com.bringspring.demo.model.demoproduct.DemoProductSelector;
import com.bringspring.demo.model.demoproduct.DemoProductTreeModel;
import com.bringspring.demo.model.demoproduct.DemoProductUpForm;
import com.bringspring.demo.service.DemoProductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406"}, value="example")
@RequestMapping(value={"/api/demo/DemoProduct"})
public class DemoProductController {
    private static final Logger log = LoggerFactory.getLogger(DemoProductController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DemoProductService demoProductService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u5217\u8868")
    public ActionResult list(@RequestBody DemoProductPagination demoProductPagination) throws IOException {
        List<DemoProductEntity> list = this.demoProductService.getList(demoProductPagination);
        for (DemoProductEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, DemoProductListVO.class);
        for (DemoProductListVO demoProductListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)demoProductPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<DemoProductSelector>> getSelector(DemoProductPagination demoProductPagination) {
        List<DemoProductEntity> data = this.demoProductService.getList(demoProductPagination);
        String keyword = demoProductPagination.getKeyword();
        if (!StringUtils.isEmpty((String)keyword)) {
            data = data.stream().filter(t -> t.getName().contains(keyword)).collect(Collectors.toList());
        }
        List models = JsonUtil.getJsonToList(data, DemoProductTreeModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, DemoProductSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DemoProductCrForm demoProductCrForm) throws DataException {
        this.demoProductService.create(demoProductCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DemoProductInfoVO> info(@PathVariable(value="id") String id) {
        DemoProductEntity entity = this.demoProductService.getInfo(id);
        DemoProductInfoVO vo = (DemoProductInfoVO)JsonUtil.getJsonToBean((Object)entity, DemoProductInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DemoProductInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DemoProductEntity entity = this.demoProductService.getInfo(id);
        DemoProductInfoVO vo = (DemoProductInfoVO)JsonUtil.getJsonToBean((Object)entity, DemoProductInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DemoProductUpForm demoProductUpForm) throws DataException {
        this.demoProductService.update(id, demoProductUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u6f14\u793a\u4ea7\u54c1\u7ba1\u7406\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DemoProductEntity entity = this.demoProductService.getInfo(id);
        if (entity != null) {
            this.demoProductService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

