/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.demo.controller;

import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.demo.entity.DemoProductLogsEntity;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsAnaly;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsCrForm;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsGenerorForm;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsInfoVO;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsListVO;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsPagination;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsUpForm;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsVerifyForm;
import com.bringspring.demo.service.DemoProductLogsService;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55"}, value="example")
@RequestMapping(value={"/api/demo/DemoProductLogs"})
public class DemoProductLogsController {
    private static final Logger log = LoggerFactory.getLogger(DemoProductLogsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DemoProductLogsService demoProductLogsService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u5217\u8868")
    public ActionResult list(@RequestBody DemoProductLogsPagination demoProductLogsPagination) throws IOException {
        List<DemoProductLogsEntity> list = this.demoProductLogsService.getList(demoProductLogsPagination);
        for (DemoProductLogsEntity demoProductLogsEntity : list) {
            demoProductLogsEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(demoProductLogsEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DemoProductLogsListVO.class);
        for (DemoProductLogsListVO demoProductLogsListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)demoProductLogsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getProductLogsCount"})
    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u603b\u6570")
    public ActionResult getProductLogsCount(@RequestBody DemoProductLogsPagination demoProductLogsPagination) {
        long count = this.demoProductLogsService.getProductLogsCount(demoProductLogsPagination);
        return ActionResult.success((Object)count);
    }

    @PostMapping(value={"/getProductCount"})
    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u603b\u6570")
    public ActionResult getProductCount(@RequestBody DemoProductLogsAnaly demoProductLogsAnaly) {
        long count = this.demoProductLogsService.getProductCount(demoProductLogsAnaly).intValue();
        return ActionResult.success((Object)count);
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u521b\u5efa")
    @NotCheckLogin
    public ActionResult create(@RequestBody @Valid DemoProductLogsCrForm demoProductLogsCrForm) throws BaseException {
        this.demoProductLogsService.create(demoProductLogsCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DemoProductLogsInfoVO> info(@PathVariable(value="id") String id) {
        DemoProductLogsEntity entity = this.demoProductLogsService.getInfo(id);
        DemoProductLogsInfoVO vo = (DemoProductLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, DemoProductLogsInfoVO.class);
        if (vo.getExpireTime() != null) {
            vo.setExpireTime(vo.getExpireTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DemoProductLogsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DemoProductLogsEntity entity = this.demoProductLogsService.getInfo(id);
        DemoProductLogsInfoVO vo = (DemoProductLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, DemoProductLogsInfoVO.class);
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DemoProductLogsUpForm demoProductLogsUpForm) throws DataException {
        this.demoProductLogsService.update(id, demoProductLogsUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u751f\u6210\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/generateCode"})
    @NotCheckLogin
    public ActionResult generateCode(@RequestBody @Valid DemoProductLogsGenerorForm demoProductLogsGenerorForm) throws BaseException, PermissionException {
        DemoProductLogsCrForm demoProductLogsCrForm = (DemoProductLogsCrForm)JsonUtil.getJsonToBean((Object)demoProductLogsGenerorForm, DemoProductLogsCrForm.class);
        this.demoProductLogsService.generateCode(demoProductLogsCrForm);
        return ActionResult.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u9a8c\u8bc1\u7801\u6838\u9500")
    @PutMapping(value={"/verifyCode/{productCode}"})
    @NotCheckLogin
    public ActionResult verifyCode(@PathVariable(value="productCode") String productCode, @RequestBody @Valid DemoProductLogsVerifyForm demoProductLogsVerifyForm) throws DataException, BaseException {
        boolean flag = this.demoProductLogsService.verifyCode(productCode, demoProductLogsVerifyForm);
        if (!flag) {
            ActionResult actionResult = new ActionResult();
            actionResult.setCode(Integer.valueOf(400));
            actionResult.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef/\u8fc7\u671f\uff0c\u8bf7\u91cd\u91cd\u8bd5");
            actionResult.setData((Object)String.valueOf(flag));
            return actionResult;
        }
        return ActionResult.success((String)"\u9a8c\u8bc1\u6210\u529f", (Object)String.valueOf(flag));
    }

    @ApiOperation(value="\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DemoProductLogsEntity entity = this.demoProductLogsService.getInfo(id);
        if (entity != null) {
            this.demoProductLogsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55")
    @PostMapping(value={"/userAnalysis"})
    @NotCheckLogin
    public ActionResult userAnalysis(@RequestBody @Valid DemoProductLogsAnaly demoProductLogsAnaly) {
        List<DemoProductLogsAnaly> result = this.demoProductLogsService.userAnalysis(demoProductLogsAnaly);
        PageListVO vo = new PageListVO();
        vo.setList(result);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)demoProductLogsAnaly), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u8bbf\u95ee\u8bb0\u5f55")
    @PostMapping(value={"/productAnalysis"})
    @NotCheckLogin
    public ActionResult productAnalysis(@RequestBody @Valid DemoProductLogsAnaly demoProductLogsAnaly) {
        List<DemoProductLogsAnaly> demoProductLogsAnalies = this.demoProductLogsService.productAnalysis(demoProductLogsAnaly);
        PageListVO vo = new PageListVO();
        vo.setList(demoProductLogsAnalies);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)demoProductLogsAnaly), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

