/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.demo.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.demo.entity.DemoProductLogsEntity;
import com.bringspring.demo.mapper.DemoProductLogsMapper;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsAnaly;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsCrForm;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsPagination;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsUpForm;
import com.bringspring.demo.model.demoProductLogs.DemoProductLogsVerifyForm;
import com.bringspring.demo.service.DemoProductLogsService;
import com.bringspring.demo.service.DemoProductService;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.utils.MessageUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemoProductLogsServiceImpl
extends ServiceImpl<DemoProductLogsMapper, DemoProductLogsEntity>
implements DemoProductLogsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private DemoProductService demoProductService;
    @Autowired
    private DemoProductLogsMapper demoProductLogsMapper;

    @Override
    public List<DemoProductLogsEntity> getList(DemoProductLogsPagination demoProductLogsPagination) {
        Long sec;
        Long fir;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int demoProductLogsNum = 0;
        QueryWrapper demoProductLogsQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductName())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductName, (Object)demoProductLogsPagination.getProductName());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductCode())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductCode, (Object)demoProductLogsPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductId())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductId, (Object)demoProductLogsPagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getClientIp())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getClientIp, (Object)demoProductLogsPagination.getClientIp());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getEnabledMark())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)demoProductLogsPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getLastModifyUserId())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getLastModifyUserId, (Object)demoProductLogsPagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getLastModifyTime())) {
            ++demoProductLogsNum;
            List<String> LastModifyTimeList = demoProductLogsPagination.getLastModifyTime();
            fir = Long.valueOf(LastModifyTimeList.get(0));
            sec = Long.valueOf(LastModifyTimeList.get(1));
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getLastModifyTime, (Object)new Date(fir))).le(DemoProductLogsEntity::getLastModifyTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getCreatorTime())) {
            ++demoProductLogsNum;
            List<String> CreatorTimeList = demoProductLogsPagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getCreatorTime, (Object)new Date(fir))).le(DemoProductLogsEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getCode())) {
            ++demoProductLogsNum;
            List<String> CodeList = demoProductLogsPagination.getCode();
            for (int i = 0; i < CodeList.size(); ++i) {
                String id = CodeList.get(i);
                boolean idAll = StringUtils.isNotEmpty((String)id);
                if (!idAll) continue;
                BigDecimal b = new BigDecimal(id);
                if (i == 0) {
                    demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getCode, (Object)b);
                    continue;
                }
                demoProductLogsQueryWrapper.lambda().le(DemoProductLogsEntity::getCode, (Object)b);
            }
        }
        if (AllIdList.size() > 0) {
            demoProductLogsQueryWrapper.lambda().in(DemoProductLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)demoProductLogsPagination.getSidx())) {
            demoProductLogsQueryWrapper.lambda().orderByDesc(DemoProductLogsEntity::getId);
        } else {
            try {
                String sidx = demoProductLogsPagination.getSidx();
                DemoProductLogsEntity demoProductLogsEntity = new DemoProductLogsEntity();
                Field declaredField = demoProductLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                demoProductLogsQueryWrapper = "asc".equals(demoProductLogsPagination.getSort().toLowerCase()) ? (QueryWrapper)demoProductLogsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)demoProductLogsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(demoProductLogsPagination.getCurrentPage(), demoProductLogsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)demoProductLogsQueryWrapper);
            return demoProductLogsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return demoProductLogsPagination.setData(list, list.size());
    }

    @Override
    public Long getProductLogsCount(DemoProductLogsPagination demoProductLogsPagination) {
        QueryWrapper demoProductLogsQueryWrapper = new QueryWrapper();
        demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)"1");
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductName())) {
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductName, (Object)demoProductLogsPagination.getProductName());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductCode())) {
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductCode, (Object)demoProductLogsPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductId())) {
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductId, (Object)demoProductLogsPagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getClientIp())) {
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getClientIp, (Object)demoProductLogsPagination.getClientIp());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getEnabledMark())) {
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)demoProductLogsPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getLastModifyUserId())) {
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getLastModifyUserId, (Object)demoProductLogsPagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getLastModifyTime())) {
            List<String> LastModifyTimeList = demoProductLogsPagination.getLastModifyTime();
            Long fir = Long.valueOf(LastModifyTimeList.get(0));
            Long sec = Long.valueOf(LastModifyTimeList.get(1));
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getLastModifyTime, (Object)new Date(fir))).le(DemoProductLogsEntity::getLastModifyTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getCreatorTime())) {
            List<String> CreatorTimeList = demoProductLogsPagination.getCreatorTime();
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getCreatorTime, (Object)CreatorTimeList.get(0))).le(DemoProductLogsEntity::getCreatorTime, (Object)CreatorTimeList.get(1));
        }
        return this.count((Wrapper)demoProductLogsQueryWrapper);
    }

    @Override
    public List<DemoProductLogsEntity> getTypeList(DemoProductLogsPagination demoProductLogsPagination, String dataType) {
        Long sec;
        Long fir;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int demoProductLogsNum = 0;
        QueryWrapper demoProductLogsQueryWrapper = new QueryWrapper();
        demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)"1");
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductName())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductName, (Object)demoProductLogsPagination.getProductName());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductCode())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductCode, (Object)demoProductLogsPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getProductId())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getProductId, (Object)demoProductLogsPagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getClientIp())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().like(DemoProductLogsEntity::getClientIp, (Object)demoProductLogsPagination.getClientIp());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getEnabledMark())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)demoProductLogsPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)demoProductLogsPagination.getLastModifyUserId())) {
            ++demoProductLogsNum;
            demoProductLogsQueryWrapper.lambda().eq(DemoProductLogsEntity::getLastModifyUserId, (Object)demoProductLogsPagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getLastModifyTime())) {
            ++demoProductLogsNum;
            List<String> LastModifyTimeList = demoProductLogsPagination.getLastModifyTime();
            fir = Long.valueOf(LastModifyTimeList.get(0));
            sec = Long.valueOf(LastModifyTimeList.get(1));
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getLastModifyTime, (Object)new Date(fir))).le(DemoProductLogsEntity::getLastModifyTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getCreatorTime())) {
            ++demoProductLogsNum;
            List<String> CreatorTimeList = demoProductLogsPagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getCreatorTime, (Object)new Date(fir))).le(DemoProductLogsEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(demoProductLogsPagination.getCode())) {
            ++demoProductLogsNum;
            List<String> CodeList = demoProductLogsPagination.getCode();
            for (int i = 0; i < CodeList.size(); ++i) {
                String id = CodeList.get(i);
                boolean idAll = StringUtils.isNotEmpty((String)id);
                if (!idAll) continue;
                BigDecimal b = new BigDecimal(id);
                if (i == 0) {
                    demoProductLogsQueryWrapper.lambda().ge(DemoProductLogsEntity::getCode, (Object)b);
                    continue;
                }
                demoProductLogsQueryWrapper.lambda().le(DemoProductLogsEntity::getCode, (Object)b);
            }
        }
        if (AllIdList.size() > 0) {
            demoProductLogsQueryWrapper.lambda().in(DemoProductLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)demoProductLogsPagination.getSidx())) {
            demoProductLogsQueryWrapper.lambda().orderByDesc(DemoProductLogsEntity::getId);
        } else {
            try {
                String sidx = demoProductLogsPagination.getSidx();
                DemoProductLogsEntity demoProductLogsEntity = new DemoProductLogsEntity();
                Field declaredField = demoProductLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                demoProductLogsQueryWrapper = "asc".equals(demoProductLogsPagination.getSort().toLowerCase()) ? (QueryWrapper)demoProductLogsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)demoProductLogsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(demoProductLogsPagination.getCurrentPage(), demoProductLogsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)demoProductLogsQueryWrapper);
                return demoProductLogsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return demoProductLogsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)demoProductLogsQueryWrapper);
    }

    @Override
    public DemoProductLogsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DemoProductLogsEntity::getId, (Object)id);
        return (DemoProductLogsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(DemoProductLogsCrForm demoProductLogsCrForm) throws BaseException {
        UserInfo userInfo = this.userProvider.get();
        if (userInfo == null) {
            throw new BaseException("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductName())) {
            throw new BaseException("\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductCode())) {
            throw new BaseException("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductId())) {
            demoProductLogsCrForm.setProductId(demoProductLogsCrForm.getProductCode());
        }
        DemoProductLogsEntity entity = (DemoProductLogsEntity)JsonUtil.getJsonToBean((Object)demoProductLogsCrForm, DemoProductLogsEntity.class);
        entity.setCode(RandomUtil.getRandomCode());
        entity.setId(RandomUtil.uuId());
        entity.setEnabledMark(EnabledMarkEnum.NOT_ENABLE.getCode().toString());
        this.save(entity);
        this.sendDemoProductLogsMessage(entity);
    }

    public void sendDemoProductLogsMessage(DemoProductLogsEntity entity) {
        try {
            String taskCode = MessageTypeEnum.DEMO_PRODUCT_CODE.getMessage();
            String sendCode = MessageTypeEnum.DEMO_PRODUCT_CODE.getTemplateCode();
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", "\u6f14\u793a\u5e73\u53f0\u9a8c\u8bc1\u7801\u63d0\u9192");
            keys.put("content", "\u4ea7\u54c1\u540d\u79f0\uff1a" + entity.getProductName() + "\n\u9a8c\u8bc1\u7801\uff1a" + entity.getCode());
            String termType = TermTypeEnum.TERM_PC.getCode();
            String termTypeDesc = "\u8bf7\u4e0d\u8981\u628a\u9a8c\u8bc1\u7801\u6cc4\u9732\u7ed9\u5176\u4ed6\u4eba";
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, null, null, entity.getCreatorUserId(), termType, termTypeDesc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @DSTransactional
    public void update(String id, DemoProductLogsUpForm demoProductLogsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        DemoProductLogsEntity entity = this.getInfo(id);
        if (entity != null) {
            demoProductLogsUpForm.setExpireTime(DateUtil.getNow());
            demoProductLogsUpForm.setLastModifyUserId(userInfo.getUserId());
            demoProductLogsUpForm.setLastModifyTime(DateUtil.getNow());
            DemoProductLogsEntity subentity = (DemoProductLogsEntity)JsonUtil.getJsonToBean((Object)demoProductLogsUpForm, DemoProductLogsEntity.class);
            subentity.setCreatorTime(entity.getCreatorTime());
            this.updateById(subentity);
        }
    }

    @Override
    public boolean verifyCode(String productCode, DemoProductLogsVerifyForm demoProductLogsVerifyForm) throws BaseException {
        if (productCode.equals("TestProductCode") && demoProductLogsVerifyForm.getCode().equals("888888")) {
            return true;
        }
        if (productCode.equals("TestProductCode") && !demoProductLogsVerifyForm.getCode().equals("888888")) {
            return false;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DemoProductLogsEntity::getProductCode, (Object)productCode);
        queryWrapper.lambda().eq(DemoProductLogsEntity::getCode, (Object)demoProductLogsVerifyForm.getCode());
        queryWrapper.lambda().eq(DemoProductLogsEntity::getEnabledMark, (Object)EnabledMarkEnum.NOT_ENABLE.getCode().toString());
        DemoProductLogsEntity demoProductLogsEntity = (DemoProductLogsEntity)this.getOne((Wrapper)queryWrapper);
        if (demoProductLogsEntity != null) {
            Date expireTime = demoProductLogsEntity.getExpireTime();
            if (expireTime != null && expireTime.before(new Date())) {
                return false;
            }
            demoProductLogsEntity.setEnabledMark(EnabledMarkEnum.ENABLE.getCode().toString());
            this.updateById(demoProductLogsEntity);
            return true;
        }
        return false;
    }

    @Override
    public void generateCode(DemoProductLogsCrForm demoProductLogsCrForm) throws BaseException, PermissionException {
        UserInfo userInfo = this.userProvider.get();
        if (userInfo == null) {
            throw new PermissionException("\u7528\u6237\u672a\u767b\u5f55");
        }
        UserEntity userByAccount = this.userService.getUserByAccount(demoProductLogsCrForm.getCreatorUserId());
        if (userByAccount == null) {
            throw new PermissionException("\u8d26\u6237/\u90ae\u7bb1/\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductCode())) {
            throw new BaseException("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductName())) {
            throw new BaseException("\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)demoProductLogsCrForm.getProductId())) {
            demoProductLogsCrForm.setProductId(demoProductLogsCrForm.getProductCode());
        }
        DemoProductLogsEntity entity = (DemoProductLogsEntity)JsonUtil.getJsonToBean((Object)demoProductLogsCrForm, DemoProductLogsEntity.class);
        entity.setCreatorUserId(userByAccount.getId());
        entity.setCode(RandomUtil.getRandomCode());
        String ipAddr = IpUtil.getIpAddr();
        if (StringUtils.isNotEmpty((String)ipAddr) && !IpUtil.ipIsInner((String)ipAddr)) {
            String ipCity = IpUtil.getIpCity((String)ipAddr);
            entity.setClientIp(ipCity + ":" + ipAddr);
        }
        entity.setId(RandomUtil.uuId());
        entity.setProductId(demoProductLogsCrForm.getProductId());
        entity.setProductCode(demoProductLogsCrForm.getProductCode());
        entity.setProductName(demoProductLogsCrForm.getProductName());
        entity.setExpireTime(DateUtil.dateAddMinutes((Date)new Date(), (int)30));
        entity.setEnabledMark(EnabledMarkEnum.NOT_ENABLE.getCode().toString());
        this.save(entity);
        this.sendDemoProductLogsMessage(entity);
    }

    @Override
    public List<DemoProductLogsAnaly> userAnalysis(DemoProductLogsAnaly demoProductLogsAnaly) {
        if (ObjectUtil.isEmpty(demoProductLogsAnaly.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            demoProductLogsAnaly.setCreatorTime(creatorTime);
        }
        PageHelper.startPage((int)((int)demoProductLogsAnaly.getCurrentPage()), (int)((int)demoProductLogsAnaly.getPageSize()));
        List<DemoProductLogsAnaly> demoProductLogsAnalyReturn = this.demoProductLogsMapper.userAnalysis(demoProductLogsAnaly);
        PageInfo pageInfo = new PageInfo(demoProductLogsAnalyReturn);
        return demoProductLogsAnaly.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public Integer getProductCount(DemoProductLogsAnaly demoProductLogsAnaly) {
        List<DemoProductLogsAnaly> demoProductLogsAnalyReturn;
        if (ObjectUtil.isEmpty(demoProductLogsAnaly.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            demoProductLogsAnaly.setCreatorTime(creatorTime);
        }
        return ObjectUtil.isEmpty(demoProductLogsAnalyReturn = this.demoProductLogsMapper.getProductCount(demoProductLogsAnaly)) ? 0 : demoProductLogsAnalyReturn.size();
    }

    @Override
    public List<DemoProductLogsAnaly> productAnalysis(DemoProductLogsAnaly demoProductLogsAnaly) {
        if (ObjectUtil.isEmpty(demoProductLogsAnaly.getCreatorTime())) {
            ArrayList<String> creatorTime = new ArrayList<String>();
            creatorTime.add(DateUtil.daFormat((Date)DateUtil.getBeginDayOfWeek()));
            creatorTime.add(DateUtil.getmmNow());
            demoProductLogsAnaly.setCreatorTime(creatorTime);
        }
        PageHelper.startPage((int)((int)demoProductLogsAnaly.getCurrentPage()), (int)((int)demoProductLogsAnaly.getPageSize()));
        List<DemoProductLogsAnaly> demoProductLogsAnalyReturn = this.demoProductLogsMapper.productAnalysis(demoProductLogsAnaly);
        PageInfo pageInfo = new PageInfo(demoProductLogsAnalyReturn);
        return demoProductLogsAnaly.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    @DSTransactional
    public void delete(DemoProductLogsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

