/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.demo.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.demo.entity.DemoProductEntity;
import com.bringspring.demo.mapper.DemoProductMapper;
import com.bringspring.demo.model.demoproduct.DemoProductCrForm;
import com.bringspring.demo.model.demoproduct.DemoProductPagination;
import com.bringspring.demo.model.demoproduct.DemoProductUpForm;
import com.bringspring.demo.service.DemoProductService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemoProductServiceImpl
extends ServiceImpl<DemoProductMapper, DemoProductEntity>
implements DemoProductService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<DemoProductEntity> getList(DemoProductPagination demoProductPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int demoProductNum = 0;
        QueryWrapper demoProductQueryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object afterSalesQuestionObj = this.authorizeService.getCondition(new AuthorizeConditionModel(demoProductQueryWrapper, demoProductPagination.getMenuId(), "demo_product"));
            demoProductQueryWrapper = (QueryWrapper)afterSalesQuestionObj;
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getParentId())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().like(DemoProductEntity::getParentId, (Object)demoProductPagination.getParentId());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getCompanyId())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getCompanyId, (Object)demoProductPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getProductCode())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().like(DemoProductEntity::getProductCode, (Object)demoProductPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getName())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().like(DemoProductEntity::getName, (Object)demoProductPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getType())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getType, (Object)demoProductPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getEnabledMark())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getEnabledMark, (Object)demoProductPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            demoProductQueryWrapper.lambda().in(DemoProductEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)demoProductPagination.getSidx())) {
            demoProductQueryWrapper.lambda().orderByAsc(DemoProductEntity::getSortCode);
        } else {
            try {
                String sidx = demoProductPagination.getSidx();
                DemoProductEntity demoProductEntity = new DemoProductEntity();
                Field declaredField = demoProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                demoProductQueryWrapper = "asc".equals(demoProductPagination.getSort().toLowerCase()) ? (QueryWrapper)demoProductQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)demoProductQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(demoProductPagination.getCurrentPage(), demoProductPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)demoProductQueryWrapper);
            return demoProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return demoProductPagination.setData(list, list.size());
    }

    @Override
    public List<DemoProductEntity> getTypeList(DemoProductPagination demoProductPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int demoProductNum = 0;
        QueryWrapper demoProductQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)demoProductPagination.getCompanyId())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getCompanyId, (Object)demoProductPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getProductCode())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().like(DemoProductEntity::getProductCode, (Object)demoProductPagination.getProductCode());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getName())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().like(DemoProductEntity::getName, (Object)demoProductPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getType())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getType, (Object)demoProductPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)demoProductPagination.getEnabledMark())) {
            ++demoProductNum;
            demoProductQueryWrapper.lambda().eq(DemoProductEntity::getEnabledMark, (Object)demoProductPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            demoProductQueryWrapper.lambda().in(DemoProductEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)demoProductPagination.getSidx())) {
            demoProductQueryWrapper.lambda().orderByAsc(DemoProductEntity::getSortCode);
        } else {
            try {
                String sidx = demoProductPagination.getSidx();
                DemoProductEntity demoProductEntity = new DemoProductEntity();
                Field declaredField = demoProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                demoProductQueryWrapper = "asc".equals(demoProductPagination.getSort().toLowerCase()) ? (QueryWrapper)demoProductQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)demoProductQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(demoProductPagination.getCurrentPage(), demoProductPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)demoProductQueryWrapper);
                return demoProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return demoProductPagination.setData(list, list.size());
        }
        return this.list((Wrapper)demoProductQueryWrapper);
    }

    @Override
    public DemoProductEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DemoProductEntity::getId, (Object)id);
        return (DemoProductEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public DemoProductEntity getProductByCode(String productCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DemoProductEntity::getProductCode, (Object)productCode);
        return (DemoProductEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(DemoProductCrForm demoProductCrForm) {
        String mainId = RandomUtil.uuId();
        DemoProductEntity entity = (DemoProductEntity)JsonUtil.getJsonToBean((Object)demoProductCrForm, DemoProductEntity.class);
        String organizeId = this.userProvider.get().getOrganizeId();
        entity.setCompanyId(organizeId);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, DemoProductUpForm demoProductUpForm) {
        UserInfo userInfo = this.userProvider.get();
        DemoProductEntity entity = this.getInfo(id);
        if (entity != null) {
            DemoProductEntity subentity = (DemoProductEntity)JsonUtil.getJsonToBean((Object)demoProductUpForm, DemoProductEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(DemoProductEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

