/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.mc.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.mc.entity.McVersionMsgEntity;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgCrForm;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgInfoVO;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgListVO;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgPagination;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgPaginationExportModel;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgUpForm;
import com.bringspring.mc.service.McVersionMsgService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7cfb\u7edf\u7248\u672c\u5347\u7ea7\u901a\u77e5"}, value="mc")
@RequestMapping(value={"/api/mc/McVersionMsg"})
public class McVersionMsgController {
    private static final Logger log = LoggerFactory.getLogger(McVersionMsgController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McVersionMsgService mcVersionMsgService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McVersionMsgPagination mcVersionMsgPagination) throws IOException {
        List<McVersionMsgEntity> list = this.mcVersionMsgService.getList(mcVersionMsgPagination);
        List<McVersionMsgListVO> listVO = this.appendListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcVersionMsgPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<McVersionMsgListVO> appendListVo(List<McVersionMsgEntity> list) {
        List listVO = JsonUtil.getJsonToList(list, McVersionMsgListVO.class);
        for (McVersionMsgListVO vo : listVO) {
            vo.setSendUserName(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
            vo.setEnabledMarkName(this.baseDataUtil.getDictName(vo.getEnabledMark(), "versionMsgEnabledMark"));
        }
        return listVO;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid McVersionMsgCrForm mcVersionMsgCrForm) throws DataException {
        this.mcVersionMsgService.insertInfo(mcVersionMsgCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(McVersionMsgPaginationExportModel mcVersionMsgPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mcVersionMsgPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        McVersionMsgPagination mcVersionMsgPagination = (McVersionMsgPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mcVersionMsgPaginationExportModel), McVersionMsgPagination.class));
        List<McVersionMsgEntity> list = this.mcVersionMsgService.getTypeList(mcVersionMsgPagination, mcVersionMsgPaginationExportModel.getDataType());
        List<McVersionMsgListVO> listVO = this.appendListVo(list);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mcVersionMsgPaginationExportModel.getSelectKey()) ? mcVersionMsgPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "version": {
                        entity = new ExcelExportEntity("\u7248\u672c", (Object)"version");
                        entitys.add(entity);
                        continue block24;
                    }
                    case "content": {
                        entity = new ExcelExportEntity("\u66f4\u65b0\u5185\u5bb9", (Object)"content");
                        entity.setWidth(50.0);
                        entitys.add(entity);
                        continue block24;
                    }
                    case "creatorTime": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block24;
                    }
                    case "sendUserName": {
                        entity = new ExcelExportEntity("\u53d1\u9001\u4eba", (Object)"sendUserName");
                        entitys.add(entity);
                        continue block24;
                    }
                    case "sendTime": {
                        entity = new ExcelExportEntity("\u53d1\u9001\u65f6\u95f4", (Object)"sendTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block24;
                    }
                    case "enabledMarkName": {
                        entity = new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMarkName");
                        entitys.add(entity);
                        continue block24;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McVersionMsgInfoVO> info(@PathVariable(value="id") String id) {
        McVersionMsgInfoVO vo = this.mcVersionMsgService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McVersionMsgInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McVersionMsgInfoVO vo = this.mcVersionMsgService.detailInfo(id);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McVersionMsgUpForm mcVersionMsgUpForm) throws DataException {
        McVersionMsgEntity entity = this.mcVersionMsgService.getInfo(id);
        if (null != entity) {
            this.mcVersionMsgService.editInfo(mcVersionMsgUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        McVersionMsgEntity entity = this.mcVersionMsgService.getInfo(id);
        if (entity != null) {
            this.mcVersionMsgService.removeInfo(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/send/{id}"})
    @DSTransactional
    public ActionResult send(@PathVariable(value="id") String id) {
        McVersionMsgEntity entity = this.mcVersionMsgService.getInfo(id);
        if (entity != null) {
            this.mcVersionMsgService.send(entity);
            return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
        }
        return ActionResult.fail((String)"\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

