/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.mc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.crm.config.OpportunityPushConfig;
import com.bringspring.mc.constant.VersionMsgEnabledMarkEnum;
import com.bringspring.mc.entity.McVersionMsgEntity;
import com.bringspring.mc.mapper.McVersionMsgMapper;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgCrForm;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgInfoVO;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgPagination;
import com.bringspring.mc.model.mcversionmsg.McVersionMsgUpForm;
import com.bringspring.mc.service.McVersionMsgService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.utils.MessageUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McVersionMsgServiceImpl
extends ServiceImpl<McVersionMsgMapper, McVersionMsgEntity>
implements McVersionMsgService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private OpportunityPushConfig opportunityPushConfig;

    @Override
    public List<McVersionMsgEntity> getList(McVersionMsgPagination mcVersionMsgPagination) {
        QueryWrapper<McVersionMsgEntity> mcVersionMsgQueryWrapper = this.appendWrapper(mcVersionMsgPagination);
        Page page = new Page(mcVersionMsgPagination.getCurrentPage(), mcVersionMsgPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)mcVersionMsgQueryWrapper);
        return mcVersionMsgPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<McVersionMsgEntity> appendWrapper(McVersionMsgPagination mcVersionMsgPagination) {
        Long sec;
        Long fir;
        QueryWrapper mcVersionMsgQueryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object mcVersionMsgObj = this.authorizeService.getCondition(new AuthorizeConditionModel(mcVersionMsgQueryWrapper, mcVersionMsgPagination.getMenuId(), "mc_version_msg"));
            if (ObjectUtil.isEmpty((Object)mcVersionMsgObj)) {
                mcVersionMsgQueryWrapper.lambda().eq(McVersionMsgEntity::getCreatorUserId, (Object)userId);
            } else {
                mcVersionMsgQueryWrapper = (QueryWrapper)mcVersionMsgObj;
            }
        }
        mcVersionMsgQueryWrapper.lambda().eq(McVersionMsgEntity::getDeleteFlag, (Object)0);
        if (StringUtils.isNotEmpty((String)mcVersionMsgPagination.getVersion())) {
            mcVersionMsgQueryWrapper.lambda().like(McVersionMsgEntity::getVersion, (Object)mcVersionMsgPagination.getVersion());
        }
        if (StringUtils.isNotEmpty((String)mcVersionMsgPagination.getContent())) {
            mcVersionMsgQueryWrapper.lambda().like(McVersionMsgEntity::getContent, (Object)mcVersionMsgPagination.getContent());
        }
        if (StringUtils.isNotEmpty((String)mcVersionMsgPagination.getEnabledMark())) {
            mcVersionMsgQueryWrapper.lambda().eq(McVersionMsgEntity::getEnabledMark, (Object)mcVersionMsgPagination.getEnabledMark());
        }
        if (CollectionUtil.isNotEmpty(mcVersionMsgPagination.getCreatorTime())) {
            List<String> creatorTimeList = mcVersionMsgPagination.getCreatorTime();
            fir = Long.valueOf(creatorTimeList.get(0));
            sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)mcVersionMsgQueryWrapper.lambda().ge(McVersionMsgEntity::getCreatorTime, (Object)new Date(fir))).le(McVersionMsgEntity::getCreatorTime, (Object)com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(mcVersionMsgPagination.getSendTime())) {
            List<String> sendTimeList = mcVersionMsgPagination.getSendTime();
            fir = Long.valueOf(sendTimeList.get(0));
            sec = Long.valueOf(sendTimeList.get(1));
            ((LambdaQueryWrapper)mcVersionMsgQueryWrapper.lambda().ge(McVersionMsgEntity::getSendTime, (Object)new Date(fir))).le(McVersionMsgEntity::getSendTime, (Object)com.bringspring.common.util.DateUtil.stringToDate((String)(com.bringspring.common.util.DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isEmpty((String)mcVersionMsgPagination.getSidx())) {
            mcVersionMsgQueryWrapper.lambda().orderByDesc(McVersionMsgEntity::getId);
        } else {
            try {
                String sidx = mcVersionMsgPagination.getSidx();
                McVersionMsgEntity mcVersionMsgEntity = new McVersionMsgEntity();
                Field declaredField = mcVersionMsgEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                mcVersionMsgQueryWrapper = "asc".equals(mcVersionMsgPagination.getSort().toLowerCase()) ? (QueryWrapper)mcVersionMsgQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)mcVersionMsgQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return mcVersionMsgQueryWrapper;
    }

    @Override
    public List<McVersionMsgEntity> getTypeList(McVersionMsgPagination mcVersionMsgPagination, String dataType) {
        QueryWrapper<McVersionMsgEntity> mcVersionMsgQueryWrapper = this.appendWrapper(mcVersionMsgPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(mcVersionMsgPagination.getCurrentPage(), mcVersionMsgPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)mcVersionMsgQueryWrapper);
            return mcVersionMsgPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)mcVersionMsgQueryWrapper);
    }

    @Override
    public McVersionMsgEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McVersionMsgEntity::getId, (Object)id);
        return (McVersionMsgEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(McVersionMsgEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void insertInfo(McVersionMsgCrForm mcVersionMsgCrForm) {
        McVersionMsgEntity entity = (McVersionMsgEntity)JsonUtil.getJsonToBean((Object)((Object)mcVersionMsgCrForm), McVersionMsgEntity.class);
        entity.setId(RandomUtil.uuId());
        UserInfo userInfo = this.userProvider.get();
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDeleteFlag(0);
        entity.setCreatorDeptId(userInfo.getDepartmentId());
        entity.setEnabledMark(VersionMsgEnabledMarkEnum.TO_BE_SEND.getStatus());
        this.save(entity);
    }

    @Override
    public void editInfo(McVersionMsgUpForm mcVersionMsgUpForm) {
        McVersionMsgEntity entity = (McVersionMsgEntity)JsonUtil.getJsonToBean((Object)((Object)mcVersionMsgUpForm), McVersionMsgEntity.class);
        this.updateById(entity);
    }

    @Override
    public void removeInfo(McVersionMsgEntity entity) {
        entity.setDeleteFlag(1);
        entity.setDeleteUserId(this.userProvider.get().getUserId());
        entity.setDeleteTime(com.bringspring.common.util.DateUtil.getNowDate());
        this.updateById(entity);
    }

    @Override
    public McVersionMsgInfoVO queryInfo(String id) {
        McVersionMsgEntity entity = this.getInfo(id);
        if (null != entity) {
            McVersionMsgInfoVO vo = (McVersionMsgInfoVO)JsonUtil.getJsonToBean((Object)entity, McVersionMsgInfoVO.class);
            this.appendVo(vo);
            return vo;
        }
        return null;
    }

    private void appendVo(McVersionMsgInfoVO vo) {
    }

    @Override
    public McVersionMsgInfoVO detailInfo(String id) {
        McVersionMsgEntity entity = this.getInfo(id);
        if (null != entity) {
            McVersionMsgInfoVO vo = (McVersionMsgInfoVO)JsonUtil.getJsonToBean((Object)entity, McVersionMsgInfoVO.class);
            this.appendVo(vo);
            return vo;
        }
        return null;
    }

    @Override
    public void send(McVersionMsgEntity entity) {
        entity.setEnabledMark(VersionMsgEnabledMarkEnum.SEND.getStatus());
        entity.setSendTime(com.bringspring.common.util.DateUtil.getNowDate());
        entity.setSendUserId(this.userProvider.get().getUserId());
        String taskCode = MessageTypeEnum.SYSTEM_VERSION_SEND.getMessage();
        String sendCode = MessageTypeEnum.SYSTEM_VERSION_SEND.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", "\u7cfb\u7edf\u7248\u672c\u5347\u7ea7\u901a\u77e5");
        keys.put("header", "\u667a\u884c\u5e73\u53f0\u4ea7\u54c1\u66f4\u65b0\u65e5\u5fd7");
        keys.put("tip", "\uff08\u7248\u672c\uff1aV" + entity.getVersion() + "\uff09");
        keys.put("content", "\u66f4\u65b0\u5185\u5bb9\uff1a\n" + entity.getContent());
        keys.put("tag", "\u66f4\u65b0\u65e5\u671f\uff1a" + DateUtil.today());
        keys.put("sendUser", entity.getSendUserId());
        keys.put("sendTime", com.bringspring.common.util.DateUtil.getNow());
        keys.put("isNewDialog", "1");
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            Object[] split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        } else {
            toUserIds = this.userService.getListId();
        }
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, null, null, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), TermTypeEnum.TERM_APP_PC.getCode(), null);
        this.updateById(entity);
    }
}

