/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingGroupEntity;
import com.bringspring.meeting.entity.OtMeetingGroupLogEntity;
import com.bringspring.meeting.entity.OtMeetingGroupRecordEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupCrForm;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupInfoVO;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupListVO;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupPagination;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupPaginationExportModel;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupUpForm;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogPagination;
import com.bringspring.meeting.model.otmeetingstatisticsdepartment.OtMeetingStatisticsDepartmentPagination;
import com.bringspring.meeting.service.OtMeetingGroupLogService;
import com.bringspring.meeting.service.OtMeetingGroupService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.BussinessMeetingEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65b0\u7248 \u96c6\u56e2\u4f8b\u4f1a\u7ba1\u7406"}, value="meeting")
@RequestMapping(value={"/api/meeting/OtMeetingGroup"})
public class OtMeetingGroupController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingGroupController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingGroupService otMeetingGroupService;
    @Autowired
    private OtMeetingGroupLogService otMeetingGroupLogService;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        List<OtMeetingGroupListVO> listVO = this.otMeetingGroupService.getParentChildList(otMeetingGroupPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getMonthMeetingList"})
    public ActionResult getMonthMeetingList(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        HashMap<String, Object> monthMeetingList = this.otMeetingGroupService.getMonthMeetingList(otMeetingGroupPagination);
        return ActionResult.success(monthMeetingList);
    }

    @PostMapping(value={"/getTreeList"})
    public ActionResult getTreeList(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        List<OtMeetingGroupEntity> list = this.otMeetingGroupService.getList(otMeetingGroupPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupListVO.class);
        for (OtMeetingGroupListVO otMeetingGroupListVO : listVO) {
            otMeetingGroupListVO.setResponsibleDepartmentName(this.baseDataUtil.comSelectValues(otMeetingGroupListVO.getResponsibleDepartment()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getLogList"})
    public ActionResult getLogList(@RequestBody OtMeetingGroupLogPagination otMeetingGroupPagination) throws IOException {
        List<OtMeetingGroupLogEntity> logList = this.otMeetingGroupService.getLogList(otMeetingGroupPagination);
        List otMeetingGroupListVOS = JsonUtil.getJsonToList(logList, OtMeetingGroupListVO.class);
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        for (OtMeetingGroupListVO otMeetingGroupListVO : otMeetingGroupListVOS) {
            List entities = departmentEntities.stream().filter(i -> StringUtils.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupListVO.getResponsibleDepartment())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(entities)) {
                otMeetingGroupListVO.setResponsibleDepartmentName(((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName());
                continue;
            }
            otMeetingGroupListVO.setResponsibleDepartmentName(otMeetingGroupListVO.getResponsibleDepartment());
        }
        PageListVO vo = new PageListVO();
        vo.setList(otMeetingGroupListVOS);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countWorkAmoumt"})
    public ActionResult countWorkAmoumt(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        HashMap<String, Object> hashMap = this.otMeetingGroupService.countWorkAmoumt(otMeetingGroupPagination);
        return ActionResult.success(hashMap);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OtMeetingGroupCrForm otMeetingGroupCrForm) throws DataException {
        this.otMeetingGroupService.create(otMeetingGroupCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @RequestMapping(value={"batchCreate"})
    @PostMapping
    public ActionResult batchCreate(@RequestBody @Valid HashMap map) throws DataException {
        this.otMeetingGroupService.batchCreate(map);
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PostMapping(value={"/cancelReport"})
    public ActionResult<OtMeetingGroupInfoVO> cancelReport(@RequestBody HashMap<String, String> map) {
        String reportDate;
        String reportType;
        if (ObjectUtil.isEmpty(map)) {
            return ActionResult.fail((String)"\u53c2\u6570\u9519\u8bef");
        }
        String id = map.get("workId");
        Boolean cancelReport = this.otMeetingGroupService.cancelReport(id, reportType = map.get("reportType"), reportDate = map.get("reportDate"));
        if (cancelReport.booleanValue()) {
            return ActionResult.success((String)"\u53d6\u6d88\u6c47\u62a5\u6210\u529f\uff01");
        }
        return ActionResult.fail((String)"\u53d6\u6d88\u6c47\u62a5\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingGroupPaginationExportModel otMeetingGroupPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)otMeetingGroupPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO downloadVO = this.otMeetingGroupService.exportMeetingGroupData(otMeetingGroupPaginationExportModel);
        return ActionResult.success((Object)downloadVO);
    }

    @PostMapping(value={"/getListByParentId"})
    public ActionResult getListByParentId(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) {
        PageHelper.startPage((int)((int)otMeetingGroupPagination.getCurrentPage()), (int)((int)otMeetingGroupPagination.getPageSize()));
        List<OtMeetingGroupListVO> listVO = this.otMeetingGroupService.getPlanListByParentId(otMeetingGroupPagination.getParentId(), 1, otMeetingGroupPagination);
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        for (OtMeetingGroupListVO otMeetingGroupListVO : listVO) {
            List entities = departmentEntities.stream().filter(i -> StringUtils.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupListVO.getResponsibleDepartment())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(entities)) {
                otMeetingGroupListVO.setResponsibleDepartmentName(((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName());
                continue;
            }
            otMeetingGroupListVO.setResponsibleDepartmentName(otMeetingGroupListVO.getResponsibleDepartment());
        }
        PageInfo pageInfo = new PageInfo(listVO);
        otMeetingGroupPagination.setData(pageInfo.getList(), pageInfo.getTotal());
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingGroupInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingGroupEntity entity = this.otMeetingGroupService.getInfo(id);
        OtMeetingGroupInfoVO vo = (OtMeetingGroupInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getChildRecords"})
    public ActionResult getChildRecords(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) {
        PageHelper.startPage((int)((int)otMeetingGroupPagination.getCurrentPage()), (int)((int)otMeetingGroupPagination.getPageSize()));
        List<OtMeetingGroupEntity> childRecords = this.otMeetingGroupService.getChildRecords(otMeetingGroupPagination.getParentId());
        List planListByParentId = JsonUtil.getJsonToList(childRecords, OtMeetingGroupListVO.class);
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        for (OtMeetingGroupListVO otMeetingGroupListVO : planListByParentId) {
            List entities = departmentEntities.stream().filter(i -> StringUtils.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupListVO.getResponsibleDepartment())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(entities)) {
                otMeetingGroupListVO.setResponsibleDepartmentName(((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName());
                continue;
            }
            otMeetingGroupListVO.setResponsibleDepartmentName(otMeetingGroupListVO.getResponsibleDepartment());
        }
        PageInfo pageInfo = new PageInfo(planListByParentId);
        otMeetingGroupPagination.setData(pageInfo.getList(), pageInfo.getTotal());
        PageListVO vo = new PageListVO();
        vo.setList(planListByParentId);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getLogPlanListById/{workId}"})
    public ActionResult<List<OtMeetingGroupLogEntity>> getLogPlanListById(@PathVariable(value="workId") String workId) {
        List<OtMeetingGroupLogEntity> listByWorkId = this.otMeetingGroupLogService.getListByWorkId(workId);
        if (ObjectUtil.isNotEmpty(listByWorkId)) {
            List collect = listByWorkId.stream().filter(i -> !StrUtil.isBlank((CharSequence)i.getReportVar())).collect(Collectors.toList());
            return ActionResult.success(collect);
        }
        return ActionResult.success(listByWorkId);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingGroupInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingGroupEntity entity = this.otMeetingGroupService.getInfo(id);
        OtMeetingGroupInfoVO vo = (OtMeetingGroupInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupInfoVO.class);
        vo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(vo.getResponsibleDepartment()));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "502508957907246725"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingGroupUpForm otMeetingGroupUpForm) throws DataException {
        this.otMeetingGroupService.update(id, otMeetingGroupUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingGroupEntity entity = this.otMeetingGroupService.getInfo(id);
        if (entity != null) {
            this.otMeetingGroupService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getDepartmentList"})
    public ActionResult getDepartmentList(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        OtMeetingStatisticsDepartmentPagination otMeetingStatisticsDepartmentPagination = (OtMeetingStatisticsDepartmentPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), OtMeetingStatisticsDepartmentPagination.class));
        List<OtMeetingStatisticsDepartmentEntity> departmentEntities = this.otMeetingStatisticsDepartmentService.getList(otMeetingStatisticsDepartmentPagination);
        PageListVO vo = new PageListVO();
        vo.setList(departmentEntities);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countPlanNumber"})
    public ActionResult countPlanNumber(@RequestBody OtMeetingGroupPagination otMeetingGroupPagination) throws IOException {
        if (ObjectUtil.isEmpty(otMeetingGroupPagination.getSelectByReportTime())) {
            // empty if block
        }
        HashMap<String, Object> hashMap = this.otMeetingGroupService.countPlanNumber(otMeetingGroupPagination);
        return ActionResult.success(hashMap);
    }

    @GetMapping(value={"/getSubmitDateByWorkId/{workid}/{reportType}"})
    public ActionResult<List<String>> getSubmitDateByWorkId(@PathVariable(value="workid") String workid, @PathVariable(value="reportType") String reportType) {
        OtMeetingGroupEntity info = this.otMeetingGroupService.getInfo(workid);
        List<OtMeetingGroupRecordEntity> workId = this.otMeetingGroupService.getSubmitDateByWorkId(workid, reportType);
        List stringList = workId.stream().map(i -> i.getReportTimeVar()).distinct().collect(Collectors.toList());
        if (StrUtil.equals((CharSequence)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType(), (CharSequence)reportType)) {
            if (!StrUtil.isBlank((CharSequence)info.getReportJingyingTimeVar())) {
                stringList.add(info.getReportJingyingTimeVar());
            }
        } else if (!StrUtil.isBlank((CharSequence)info.getReportMonthTimeVar())) {
            stringList.add(info.getReportMonthTimeVar());
        }
        stringList = stringList.stream().distinct().collect(Collectors.toList());
        return ActionResult.success(stringList);
    }
}

