/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.entity.OtMeetingGroupLogEntity;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogCrForm;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogInfoVO;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogListVO;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogPagination;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogPaginationExportModel;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogUpForm;
import com.bringspring.meeting.service.OtMeetingGroupLogService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65b0\u7248\u96c6\u56e2\u4f8b\u4f1a\u7ba1\u7406 \u5de5\u4f5c\u8fdb\u5ea6\u65e5\u5fd7\u8868"}, value="meeting")
@RequestMapping(value={"/api/meeting/OtMeetingGroupLog"})
public class OtMeetingGroupLogController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingGroupLogController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingGroupLogService otMeetingGroupLogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingGroupLogPagination otMeetingGroupLogPagination) throws IOException {
        List<OtMeetingGroupLogEntity> list = this.otMeetingGroupLogService.getList(otMeetingGroupLogPagination);
        for (OtMeetingGroupLogEntity otMeetingGroupLogEntity : list) {
            otMeetingGroupLogEntity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(otMeetingGroupLogEntity.getResponsibleDepartment()));
            otMeetingGroupLogEntity.setEnabledMark(this.baseDataUtil.getDictName(otMeetingGroupLogEntity.getEnabledMark(), "502508957907246725"));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupLogListVO.class);
        for (OtMeetingGroupLogListVO otMeetingGroupLogListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupLogPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OtMeetingGroupLogCrForm otMeetingGroupLogCrForm) throws DataException {
        this.otMeetingGroupLogService.create(otMeetingGroupLogCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingGroupLogPaginationExportModel otMeetingGroupLogPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)otMeetingGroupLogPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OtMeetingGroupLogPagination otMeetingGroupLogPagination = (OtMeetingGroupLogPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupLogPaginationExportModel), OtMeetingGroupLogPagination.class));
        List<OtMeetingGroupLogEntity> list = this.otMeetingGroupLogService.getTypeList(otMeetingGroupLogPagination, otMeetingGroupLogPaginationExportModel.getDataType());
        for (OtMeetingGroupLogEntity otMeetingGroupLogEntity : list) {
            otMeetingGroupLogEntity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(otMeetingGroupLogEntity.getResponsibleDepartment()));
            otMeetingGroupLogEntity.setEnabledMark(this.baseDataUtil.getDictName(otMeetingGroupLogEntity.getEnabledMark(), "502508957907246725"));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupLogListVO.class);
        for (OtMeetingGroupLogListVO otMeetingGroupLogListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)otMeetingGroupLogPaginationExportModel.getSelectKey()) ? otMeetingGroupLogPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u7236\u7ea7id", (Object)"parentId"));
                        continue block36;
                    }
                    case "dubanId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u9886\u5bfc\u7763\u529e", (Object)"dubanId"));
                        continue block36;
                    }
                    case "responsibleDepartment": {
                        entitys.add(new ExcelExportEntity("\u8d23\u4efb\u90e8\u95e8", (Object)"responsibleDepartment"));
                        continue block36;
                    }
                    case "workItem": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u4e8b\u9879", (Object)"workItem"));
                        continue block36;
                    }
                    case "planContent": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5185\u5bb9", (Object)"planContent"));
                        continue block36;
                    }
                    case "workProgress": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u8fdb\u5c55", (Object)"workProgress"));
                        continue block36;
                    }
                    case "isImportant": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u91cd\u70b9\u5de5\u4f5c", (Object)"isImportant"));
                        continue block36;
                    }
                    case "planMonth": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (Object)"planMonth"));
                        continue block36;
                    }
                    case "planEndtime": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (Object)"planEndtime"));
                        continue block36;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block36;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u675f\u65e5\u671f", (Object)"endTime"));
                        continue block36;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65e5\u671f", (Object)"startTime"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingGroupLogInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingGroupLogEntity entity = this.otMeetingGroupLogService.getInfo(id);
        OtMeetingGroupLogInfoVO vo = (OtMeetingGroupLogInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupLogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingGroupLogInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingGroupLogEntity entity = this.otMeetingGroupLogService.getInfo(id);
        OtMeetingGroupLogInfoVO vo = (OtMeetingGroupLogInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupLogInfoVO.class);
        vo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(vo.getResponsibleDepartment()));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "502508957907246725"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingGroupLogUpForm otMeetingGroupLogUpForm) throws DataException {
        this.otMeetingGroupLogService.update(id, otMeetingGroupLogUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingGroupLogEntity entity = this.otMeetingGroupLogService.getInfo(id);
        if (entity != null) {
            this.otMeetingGroupLogService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

