/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingGroupRecordEntity;
import com.bringspring.meeting.model.otmeetinggrouprecord.OtMeetingGroupRecordCrForm;
import com.bringspring.meeting.model.otmeetinggrouprecord.OtMeetingGroupRecordInfoVO;
import com.bringspring.meeting.model.otmeetinggrouprecord.OtMeetingGroupRecordListVO;
import com.bringspring.meeting.model.otmeetinggrouprecord.OtMeetingGroupRecordPagination;
import com.bringspring.meeting.model.otmeetinggrouprecord.OtMeetingGroupRecordUpForm;
import com.bringspring.meeting.service.OtMeetingGroupRecordService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u96c6\u56e2\u4f8b\u4f1a\u5de5\u4f5c\u9879\u63d0\u4ea4\u8bb0\u5f55"}, value="meeting")
@RequestMapping(value={"/api/meeting/OtMeetingGroupRecord"})
public class OtMeetingGroupRecordController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingGroupRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingGroupRecordService otMeetingGroupRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingGroupRecordPagination otMeetingGroupRecordPagination) throws IOException {
        List<OtMeetingGroupRecordEntity> list = this.otMeetingGroupRecordService.getList(otMeetingGroupRecordPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupRecordListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OtMeetingGroupRecordCrForm otMeetingGroupRecordCrForm) throws DataException {
        this.otMeetingGroupRecordService.create(otMeetingGroupRecordCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingGroupRecordInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingGroupRecordEntity entity = this.otMeetingGroupRecordService.getInfo(id);
        OtMeetingGroupRecordInfoVO vo = (OtMeetingGroupRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingGroupRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingGroupRecordEntity entity = this.otMeetingGroupRecordService.getInfo(id);
        OtMeetingGroupRecordInfoVO vo = (OtMeetingGroupRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingGroupRecordUpForm otMeetingGroupRecordUpForm) throws DataException {
        this.otMeetingGroupRecordService.update(id, otMeetingGroupRecordUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingGroupRecordEntity entity = this.otMeetingGroupRecordService.getInfo(id);
        if (entity != null) {
            this.otMeetingGroupRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

