/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionEntity;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionVoteEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionCrForm;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionInfoVO;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionListVO;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionPagination;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionPaginationExportModel;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionUpForm;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionService;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionVoteService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.BussinessMeetingEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f8b\u4f1a \u95ee\u9898\u5efa\u8bae\u8868"}, value="meeting")
@RequestMapping(value={"/api/meeting/OtMeetingGroupSuggestion"})
public class OtMeetingGroupSuggestionController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingGroupSuggestionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingGroupSuggestionService otMeetingGroupSuggestionService;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;
    @Autowired
    private OtMeetingGroupSuggestionVoteService otMeetingGroupSuggestionVoteService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination) throws IOException {
        List<OtMeetingGroupSuggestionEntity> list = this.otMeetingGroupSuggestionService.getList(otMeetingGroupSuggestionPagination);
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupSuggestionListVO.class);
        for (OtMeetingGroupSuggestionListVO otMeetingGroupSuggestionListVO : listVO) {
            otMeetingGroupSuggestionListVO.setCreateDepartmentCode(otMeetingGroupSuggestionListVO.getCreateDepartment());
            List entities = departmentEntities.stream().filter(i -> StrUtil.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupSuggestionListVO.getCreateDepartment())).collect(Collectors.toList());
            otMeetingGroupSuggestionListVO.setCreateDepartment(ObjectUtil.isNotEmpty(entities) ? ((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName() : otMeetingGroupSuggestionListVO.getCreateDepartment());
            otMeetingGroupSuggestionListVO.setCreatorUserId(this.baseDataUtil.userSelectValue(otMeetingGroupSuggestionListVO.getCreatorUserId()));
            List<OtMeetingGroupSuggestionVoteEntity> suggestVoteList = this.otMeetingGroupSuggestionService.getSuggestVoteList(otMeetingGroupSuggestionListVO.getId());
            List collect = suggestVoteList.stream().filter(x -> StrUtil.equals((CharSequence)x.getVoterUserId(), (CharSequence)this.userProvider.get().getUserId())).collect(Collectors.toList());
            otMeetingGroupSuggestionListVO.setVoteCount(suggestVoteList.size());
            otMeetingGroupSuggestionListVO.setVoteEntityList(suggestVoteList);
            otMeetingGroupSuggestionListVO.setVoteState(collect.size() > 0);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupSuggestionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OtMeetingGroupSuggestionCrForm otMeetingGroupSuggestionCrForm) throws DataException {
        this.otMeetingGroupSuggestionService.create(otMeetingGroupSuggestionCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countNotSubmittedDepartment"})
    public ActionResult countNotSubmittedDepartment(@RequestBody OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination) throws IOException {
        String depStr = this.otMeetingGroupSuggestionService.countNotSubmittedDepartment(otMeetingGroupSuggestionPagination);
        return ActionResult.success((String)depStr);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingGroupSuggestionPaginationExportModel otMeetingGroupSuggestionPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)otMeetingGroupSuggestionPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination = (OtMeetingGroupSuggestionPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupSuggestionPaginationExportModel), OtMeetingGroupSuggestionPagination.class));
        List<OtMeetingGroupSuggestionEntity> list = this.otMeetingGroupSuggestionService.getTypeList(otMeetingGroupSuggestionPagination, otMeetingGroupSuggestionPaginationExportModel.getDataType());
        for (OtMeetingGroupSuggestionEntity otMeetingGroupSuggestionEntity : list) {
            otMeetingGroupSuggestionEntity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(otMeetingGroupSuggestionEntity.getResponsibleDepartment()));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupSuggestionListVO.class);
        for (OtMeetingGroupSuggestionListVO otMeetingGroupSuggestionListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)otMeetingGroupSuggestionPaginationExportModel.getSelectKey()) ? otMeetingGroupSuggestionPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block22: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "suggestContent": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u5efa\u8bae", (Object)"suggestContent"));
                        continue block22;
                    }
                    case "responsibleDepartment": {
                        entitys.add(new ExcelExportEntity("\u8d23\u4efb\u90e8\u95e8", (Object)"responsibleDepartment"));
                        continue block22;
                    }
                    case "completeDate": {
                        entitys.add(new ExcelExportEntity("\u5b8c\u6210\u65e5\u671f", (Object)"completeDate"));
                        continue block22;
                    }
                    case "suggestMonth": {
                        entitys.add(new ExcelExportEntity("\u5efa\u8bae\u6708\u4efd", (Object)"suggestMonth"));
                        continue block22;
                    }
                    case "isGreat": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4f18\u79c0\u5efa\u8bae", (Object)"isGreat"));
                        continue block22;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingGroupSuggestionInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingGroupSuggestionEntity entity = this.otMeetingGroupSuggestionService.getInfo(id);
        OtMeetingGroupSuggestionInfoVO vo = (OtMeetingGroupSuggestionInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupSuggestionInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingGroupSuggestionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingGroupSuggestionEntity entity = this.otMeetingGroupSuggestionService.getInfo(id);
        OtMeetingGroupSuggestionInfoVO vo = (OtMeetingGroupSuggestionInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupSuggestionInfoVO.class);
        vo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(vo.getResponsibleDepartment()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingGroupSuggestionUpForm otMeetingGroupSuggestionUpForm) throws DataException {
        this.otMeetingGroupSuggestionService.update(id, otMeetingGroupSuggestionUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingGroupSuggestionEntity entity = this.otMeetingGroupSuggestionService.getInfo(id);
        if (entity != null) {
            this.otMeetingGroupSuggestionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"batchCreate"})
    @PostMapping
    public ActionResult batchCreate(@RequestBody @Valid HashMap map) throws DataException {
        this.otMeetingGroupSuggestionService.batchCreate(map);
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PostMapping(value={"/handleVote"})
    public ActionResult handleVote(@RequestBody OtMeetingGroupSuggestionUpForm voteType) throws DataException {
        Boolean handleVoteRule = this.otMeetingGroupSuggestionVoteService.handleVoteRule(voteType.getId(), voteType.getVoteType());
        String msg = "";
        msg = handleVoteRule.booleanValue() ? (StrUtil.equals((CharSequence)voteType.getVoteType(), (CharSequence)BussinessMeetingEnum.VOTE_APPROVE.getType()) ? "\u6295\u7968\u6210\u529f" : "\u5df2\u53d6\u6d88\u6295\u7968\uff01") : "\u64cd\u4f5c\u5931\u8d25\uff01";
        return ActionResult.success((String)msg);
    }

    @PostMapping(value={"/getNotVoteDepartmentByDate"})
    public ActionResult getNotVoteDepartmentByDate(@RequestBody OtMeetingGroupSuggestionPagination pagination) throws DataException {
        if (ObjectUtil.isEmpty(pagination.getSelectTimeList())) {
            return ActionResult.success(new ArrayList());
        }
        Date formatDate = DateUtil.daFormatDate((Long)Long.valueOf(pagination.getSelectTimeList().get(0)));
        List<String> notVoteDepartmentByDate = this.otMeetingGroupSuggestionService.getNotVoteDepartmentByDate(formatDate);
        return ActionResult.success(notVoteDepartmentByDate);
    }
}

