/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.entity.OtMeetingGroupEntity;
import com.bringspring.meeting.entity.OtMeetingImportantWorkEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkCrForm;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkEveryTypeList;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkInfoVO;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkListVO;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkOrganizeNumber;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkPagination;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkPaginationExportModel;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkUpForm;
import com.bringspring.meeting.model.otmeetingstatisticsdepartment.OtMeetingStatisticsDepartmentPagination;
import com.bringspring.meeting.service.OtMeetingGroupService;
import com.bringspring.meeting.service.OtMeetingImportantWorkMonthService;
import com.bringspring.meeting.service.OtMeetingImportantWorkService;
import com.bringspring.meeting.service.OtMeetingRoomReservationService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.MeetingConstants;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91cd\u8981\u5de5\u4f5c\u9879"}, value="visit")
@RequestMapping(value={"/api/visit/OtMeetingImportantWork"})
public class OtMeetingImportantWorkController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingImportantWorkController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingImportantWorkService otMeetingImportantWorkService;
    @Autowired
    private OtMeetingImportantWorkMonthService otMeetingImportantWorkMonthService;
    @Autowired
    private UserService userService;
    @Autowired
    private OtMeetingRoomReservationService otMeetingRoomReservationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OtMeetingGroupService otMeetingGroupService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingImportantWorkPagination otMeetingImportantWorkPagination) throws IOException {
        otMeetingImportantWorkPagination.setThisWeek(otMeetingImportantWorkPagination.getWorkType());
        List<OtMeetingImportantWorkEntity> list = this.otMeetingImportantWorkService.getList(otMeetingImportantWorkPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingImportantWorkListVO.class);
        for (OtMeetingImportantWorkListVO entity : listVO) {
            entity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(entity.getResponsibleDepartment()));
            entity.setBusinessType(this.baseDataUtil.getDictName(entity.getBusinessType(), "busnessWorkType"));
            entity.setWorkType(this.baseDataUtil.getDictName(entity.getWorkType(), "departmentWorkType"));
            entity.setWorkStateName(this.baseDataUtil.getDictName(entity.getWorkState(), "workState"));
            entity.setCooperateDepartment(this.baseDataUtil.comSelectValues(entity.getCooperateDepartment()));
            entity.setSubmitUser(this.baseDataUtil.userSelectValue(entity.getSubmitUser()));
            if (ObjectUtil.isEmpty((Object)entity.getMeetingId())) continue;
            entity.setMeetingName(this.otMeetingRoomReservationService.getInfo(entity.getMeetingId()).getMeetingTitle());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingImportantWorkPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByType"})
    public ActionResult listByType(@RequestBody OtMeetingImportantWorkPagination otMeetingImportantWorkPagination) throws IOException {
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.DEPARTMENT_PLAN);
        List<OtMeetingImportantWorkEntity> planNum = this.otMeetingImportantWorkService.getList(otMeetingImportantWorkPagination);
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.LEADER_ARRANGEMENT);
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.LEADER_ARRANGEMENT);
        List<OtMeetingImportantWorkEntity> leaderArrangementList = this.otMeetingImportantWorkService.getList(otMeetingImportantWorkPagination);
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.RAISE_ISSUES);
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.RAISE_ISSUES);
        List<OtMeetingImportantWorkEntity> raiseIssues = this.otMeetingImportantWorkService.getList(otMeetingImportantWorkPagination);
        OtMeetingImportantWorkEveryTypeList workEveryTypeList = new OtMeetingImportantWorkEveryTypeList();
        workEveryTypeList.setRaiseIssuesNumber(raiseIssues.size());
        workEveryTypeList.setLeaderArrangementNumber(leaderArrangementList.size());
        workEveryTypeList.setPlanNumber(planNum.size());
        return ActionResult.success((Object)workEveryTypeList);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OtMeetingImportantWorkCrForm otMeetingImportantWorkCrForm) throws Exception {
        String seqWeek;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OtMeetingImportantWorkEntity entity = (OtMeetingImportantWorkEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkCrForm, OtMeetingImportantWorkEntity.class);
        entity.setId(mainId);
        if (!entity.getWorkType().equals(MeetingConstants.LEADER_ARRANGEMENT)) {
            seqWeek = DateUtil.getSeqWeek();
            entity.setWeeks(seqWeek);
        } else {
            seqWeek = DateUtil.getSeqWeek();
            entity.setWeeks(seqWeek);
        }
        String departmentStr = otMeetingImportantWorkCrForm.getResponsibleDepartment().replaceAll("\"", "").replace("[", "").replace("]", "");
        entity.setResponsibleDepartment(departmentStr);
        ArrayList<OtMeetingImportantWorkEntity> entities = new ArrayList<OtMeetingImportantWorkEntity>();
        ArrayList<OtMeetingGroupEntity> otMeetingGroupEntityList = new ArrayList<OtMeetingGroupEntity>();
        if (otMeetingImportantWorkCrForm.getSplitFlag().booleanValue()) {
            List<String> departmentList = Arrays.asList(departmentStr.split(","));
            entity.setObjectType("parent");
            entities.add(entity);
            for (String s : departmentList) {
                OtMeetingImportantWorkEntity newEntity = new OtMeetingImportantWorkEntity();
                BeanUtils.copyProperties((Object)entity, (Object)newEntity);
                newEntity.setId(RandomUtil.uuId());
                newEntity.setObjectType("chilren");
                newEntity.setResponsibleDepartment(s);
                newEntity.setParentId(mainId);
                entities.add(newEntity);
                OtMeetingGroupEntity otMeetingGroupEntity = new OtMeetingGroupEntity();
                otMeetingGroupEntity.setId(RandomUtil.uuId());
                otMeetingGroupEntity.setWorkItem(otMeetingImportantWorkCrForm.getWorkItem());
                otMeetingGroupEntity.setPlanContent(otMeetingImportantWorkCrForm.getWorkProgress());
                otMeetingGroupEntity.setResponsibleDepartment(s);
                otMeetingGroupEntity.setWorkType("leaderArrangement");
                otMeetingGroupEntity.setPlanMonth(new Date());
                otMeetingGroupEntity.setIsImportant("1");
                otMeetingGroupEntity.setDubanId(mainId);
                otMeetingGroupEntity.setEnabledMark("normal");
                otMeetingGroupEntity.setDeleteMark("0");
                otMeetingGroupEntityList.add(otMeetingGroupEntity);
            }
            this.otMeetingImportantWorkService.saveBatch(entities);
            this.otMeetingGroupService.saveBatch(otMeetingGroupEntityList);
        } else {
            this.otMeetingImportantWorkService.save(entity);
            OtMeetingGroupEntity otMeetingGroupEntity = new OtMeetingGroupEntity();
            otMeetingGroupEntity.setId(RandomUtil.uuId());
            otMeetingGroupEntity.setWorkItem(otMeetingImportantWorkCrForm.getWorkItem());
            otMeetingGroupEntity.setPlanContent(otMeetingImportantWorkCrForm.getWorkProgress());
            otMeetingGroupEntity.setResponsibleDepartment(entity.getResponsibleDepartment());
            otMeetingGroupEntity.setWorkType("leaderArrangement");
            otMeetingGroupEntity.setPlanMonth(new Date());
            otMeetingGroupEntity.setIsImportant("1");
            otMeetingGroupEntity.setDubanId(entity.getId());
            otMeetingGroupEntity.setEnabledMark("normal");
            otMeetingGroupEntity.setDeleteMark("0");
            otMeetingGroupEntity.setWriteDate(new Date());
            otMeetingGroupEntity.setIsMonthReport(0);
            this.otMeetingGroupService.save(otMeetingGroupEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingImportantWorkInfoVO> info(@PathVariable(value="id") String id) throws JsonProcessingException {
        OtMeetingImportantWorkEntity entity = this.otMeetingImportantWorkService.getInfo(id);
        if (entity.getWorkType().equals(MeetingConstants.LEADER_ARRANGEMENT)) {
            if (entity.getResponsibleDepartment().contains(",")) {
                List<String> list = Arrays.asList(entity.getResponsibleDepartment().split(","));
                ObjectMapper objectMapper = new ObjectMapper();
                String listStr = objectMapper.writeValueAsString(list);
                entity.setResponsibleDepartment(listStr);
            } else {
                entity.setResponsibleDepartment("[\"" + entity.getResponsibleDepartment() + "\"]");
            }
        }
        OtMeetingImportantWorkInfoVO vo = (OtMeetingImportantWorkInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingImportantWorkInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkEntity entity = this.otMeetingImportantWorkService.getInfo(id);
        OtMeetingImportantWorkInfoVO vo = (OtMeetingImportantWorkInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkInfoVO.class);
        vo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(vo.getResponsibleDepartment()));
        vo.setBusinessType(this.baseDataUtil.getDictName(vo.getBusinessType(), "busnessWorkType"));
        vo.setWorkTypeName(this.baseDataUtil.getDictName(vo.getWorkType(), "departmentWorkType"));
        vo.setWorkStateName(this.baseDataUtil.getDictName(vo.getWorkState(), "workState"));
        vo.setCooperateDepartment(this.baseDataUtil.comSelectValues(vo.getCooperateDepartment()));
        if (!ObjectUtil.isEmpty((Object)vo.getMeetingId())) {
            vo.setMeetingId(this.otMeetingRoomReservationService.getInfo(vo.getMeetingId()).getMeetingTitle());
        }
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingImportantWorkUpForm otMeetingImportantWorkUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingImportantWorkEntity entity = this.otMeetingImportantWorkService.getInfo(id);
        if (entity != null) {
            OtMeetingImportantWorkEntity subentity = (OtMeetingImportantWorkEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkUpForm, OtMeetingImportantWorkEntity.class);
            subentity.setResponsibleDepartment(entity.getResponsibleDepartment());
            Map<String, String> compare = ObjectComparator.compare(entity, subentity);
            Boolean endTimeFlag = false;
            Boolean workProgressFlag = false;
            Boolean workStateFlag = false;
            for (Map.Entry<String, String> entry : compare.entrySet()) {
                System.out.println(entry.getKey() + "\uff1a" + entry.getValue());
                if (entry.getKey().equals("endTime")) {
                    endTimeFlag = true;
                }
                if (entry.getKey().equals("workProgress")) {
                    workProgressFlag = true;
                }
                if (!entry.getKey().equals("workStateFlag")) continue;
                workStateFlag = true;
            }
            if (workProgressFlag.booleanValue() || workStateFlag.booleanValue()) {
                subentity.setReportingTime(new Date());
            }
            if (!entity.getWorkType().equals(MeetingConstants.LEADER_ARRANGEMENT) && entity.getWorkState().equals("delay") && endTimeFlag.booleanValue()) {
                String str = entity.getDelayDescription() == null ? "" : entity.getDelayDescription();
                String delayReason = otMeetingImportantWorkUpForm.getDelayReason() == null ? "" : otMeetingImportantWorkUpForm.getDelayReason();
                subentity.setDelayDescription(str + "<p> \u5ef6\u8fdf\u65f6\u95f4\uff1a" + DateUtil.daFormat((Date)subentity.getEndTime()) + "<p/><p> \u5ef6\u8fdf\u539f\u56e0\uff1a" + delayReason + "<p/>");
                subentity.setWorkState("normal");
            }
            if (ObjectUtil.isNotEmpty((Object)entity.getObjectType())) {
                this.otMeetingImportantWorkService.updateAssociationData(subentity);
            }
            this.otMeetingImportantWorkService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u90e8\u95e8\u6811\u72b6\u5217\u8868")
    @GetMapping(value={"/DepartmentByCompany/Selector/{id}"})
    public ActionResult<List<OtMeetingImportantWorkOrganizeNumber>> DepartmentByCompany(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingStatisticsDepartmentPagination otMeetingStatisticsDepartmentPagination = new OtMeetingStatisticsDepartmentPagination();
        otMeetingStatisticsDepartmentPagination.setCurrentPage(1L);
        otMeetingStatisticsDepartmentPagination.setPageSize(200L);
        List<OtMeetingStatisticsDepartmentEntity> allDepartmentList = this.otMeetingStatisticsDepartmentService.getList(otMeetingStatisticsDepartmentPagination);
        List models = JsonUtil.getJsonToList(allDepartmentList, OrganizeModel.class);
        List organizeNumbers = JsonUtil.getJsonToList((Object)models, OtMeetingImportantWorkOrganizeNumber.class);
        return ActionResult.success((Object)organizeNumbers);
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkEntity entity = this.otMeetingImportantWorkService.getInfo(id);
        if (entity != null) {
            if (entity.getWorkType().equals(MeetingConstants.LEADER_ARRANGEMENT) && entity.getObjectType().equals("parent")) {
                List<OtMeetingImportantWorkEntity> childrenListByParentid = this.otMeetingImportantWorkService.getChildrenListByParentid(entity.getId());
                this.otMeetingImportantWorkService.removeBatchByIds(childrenListByParentid);
            }
            this.otMeetingImportantWorkService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @NotCheckLogin
    @GetMapping(value={"/test/{id}"})
    public ActionResult test(@PathVariable(value="id") String id) throws Exception {
        this.otMeetingImportantWorkService.statisticEveryDepartmentPlan();
        return ActionResult.success((String)"success");
    }

    @NotCheckLogin
    @GetMapping(value={"/reminderAll"})
    public ActionResult reminderAll() throws Exception {
        this.otMeetingImportantWorkService.scheduledRemindeSubmitPlanAll();
        return ActionResult.success((String)"success");
    }

    @GetMapping(value={"/statisticsNotSubmittedDepartment"})
    public ActionResult statisticsNotSubmittedDepartment() throws Exception {
        this.otMeetingImportantWorkService.scheduledRemindeSubmitPlan();
        return ActionResult.success((String)"success");
    }

    @GetMapping(value={"/statisticsWorkProgress"})
    public ActionResult statisticsWorkProgress() throws Exception {
        this.otMeetingImportantWorkService.statisticEveryDepartmentPlan();
        return ActionResult.success((String)"success");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingImportantWorkPaginationExportModel otMeetingImportantWorkPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)otMeetingImportantWorkPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OtMeetingImportantWorkPagination otMeetingImportantWorkPagination = (OtMeetingImportantWorkPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingImportantWorkPaginationExportModel), OtMeetingImportantWorkPagination.class));
        List<OtMeetingImportantWorkEntity> list = this.otMeetingImportantWorkService.getTypeList(otMeetingImportantWorkPagination, otMeetingImportantWorkPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OtMeetingImportantWorkListVO.class);
        for (OtMeetingImportantWorkListVO entity : listVO) {
            entity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(entity.getResponsibleDepartment()));
            entity.setBusinessType(this.baseDataUtil.getDictName(entity.getBusinessType(), "busnessWorkType"));
            entity.setWorkType(this.baseDataUtil.getDictName(entity.getWorkType(), "departmentWorkType"));
            entity.setWorkStateName(this.baseDataUtil.getDictName(entity.getWorkState(), "workState"));
            entity.setCooperateDepartment(this.baseDataUtil.comSelectValues(entity.getCooperateDepartment()));
            entity.setSubmitUser(this.baseDataUtil.userSelectValue(entity.getSubmitUser()));
            entity.setNeedCooperate(StringUtils.isNotEmpty((String)entity.getNeedCooperate()) && entity.getNeedCooperate().equals("0") ? "\u662f" : "\u5426");
            if (ObjectUtil.isEmpty((Object)entity.getMeetingId())) continue;
            entity.setMeetingName(this.otMeetingRoomReservationService.getInfo(entity.getMeetingId()).getMeetingTitle());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)otMeetingImportantWorkPaginationExportModel.getSelectKey()) ? otMeetingImportantWorkPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "responsibleDepartment": {
                        entitys.add(new ExcelExportEntity("\u8d23\u4efb\u90e8\u95e8", (Object)"responsibleDepartment"));
                        continue block38;
                    }
                    case "workItem": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u4e8b\u9879", (Object)"workItem"));
                        continue block38;
                    }
                    case "businessType": {
                        entitys.add(new ExcelExportEntity("\u4e8b\u9879\u7c7b\u522b", (Object)"businessType"));
                        continue block38;
                    }
                    case "workType": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u7c7b\u522b", (Object)"workType"));
                        continue block38;
                    }
                    case "startTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startTime"));
                        continue block38;
                    }
                    case "endTime": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"endTime"));
                        continue block38;
                    }
                    case "overallProgress": {
                        entitys.add(new ExcelExportEntity("\u603b\u4f53\u8fdb\u5ea6", (Object)"overallProgress"));
                        continue block38;
                    }
                    case "workStateName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"workStateName"));
                        continue block38;
                    }
                    case "needCooperate": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9700\u8981\u914d\u5408", (Object)"needCooperate"));
                        continue block38;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8\u4e8b\u9879", (Object)"description"));
                        continue block38;
                    }
                    case "reportingTime": {
                        entitys.add(new ExcelExportEntity("\u6c47\u62a5\u65f6\u95f4", (Object)"reportingTime"));
                        continue block38;
                    }
                    case "workProgress": {
                        entitys.add(new ExcelExportEntity("\u672c\u5468\u8fdb\u5ea6", (Object)"workProgress"));
                        continue block38;
                    }
                    case "cooperateDepartment": {
                        entitys.add(new ExcelExportEntity("\u914d\u5408\u90e8\u95e8", (Object)"cooperateDepartment"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

