/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingImportantWorkFileEntity;
import com.bringspring.meeting.model.otmeetingimportantworkfile.OtMeetingImportantWorkFileCrForm;
import com.bringspring.meeting.model.otmeetingimportantworkfile.OtMeetingImportantWorkFileInfoVO;
import com.bringspring.meeting.model.otmeetingimportantworkfile.OtMeetingImportantWorkFileListVO;
import com.bringspring.meeting.model.otmeetingimportantworkfile.OtMeetingImportantWorkFilePagination;
import com.bringspring.meeting.model.otmeetingimportantworkfile.OtMeetingImportantWorkFileUpForm;
import com.bringspring.meeting.service.OtMeetingImportantWorkFileService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u96c6\u56e2\u4f8b\u4f1a\u4f1a\u8bae\u7eaa\u8981"}, value="meetingFile")
@RequestMapping(value={"/api/meetingFile/OtMeetingImportantWorkFile"})
public class OtMeetingImportantWorkFileController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingImportantWorkFileController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingImportantWorkFileService otMeetingImportantWorkFileService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingImportantWorkFilePagination otMeetingImportantWorkFilePagination) throws IOException {
        List<OtMeetingImportantWorkFileEntity> list = this.otMeetingImportantWorkFileService.getList(otMeetingImportantWorkFilePagination);
        for (OtMeetingImportantWorkFileEntity entity : list) {
            entity.setFileUrl(this.baseDataUtil.getFileNameInJson(entity.getFileUrl()));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingImportantWorkFileListVO.class);
        List otMeetingImportantWorkFileListVOS = new ArrayList();
        if (listVO.size() > 10) {
            otMeetingImportantWorkFileListVOS = listVO.subList(0, Math.min(list.size(), 10));
        } else {
            otMeetingImportantWorkFileListVOS.addAll(listVO);
        }
        PageListVO vo = new PageListVO();
        vo.setList(otMeetingImportantWorkFileListVOS);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingImportantWorkFilePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OtMeetingImportantWorkFileCrForm otMeetingImportantWorkFileCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OtMeetingImportantWorkFileEntity entity = (OtMeetingImportantWorkFileEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkFileCrForm, OtMeetingImportantWorkFileEntity.class);
        entity.setId(mainId);
        entity.setUploadTime(new Date());
        entity.setUploadYear(String.valueOf(Calendar.getInstance().get(1)));
        String week = Integer.toString(Calendar.getInstance(Locale.CHINA).get(3));
        if (week.length() == 1) {
            week = "0" + week;
        }
        entity.setUploadWeeek(week);
        OtMeetingImportantWorkFilePagination otMeetingImportantWorkFilePagination = new OtMeetingImportantWorkFilePagination();
        otMeetingImportantWorkFilePagination.setUploadYear(String.valueOf(Calendar.getInstance().get(1)));
        otMeetingImportantWorkFilePagination.setUploadWeeek(week);
        List<OtMeetingImportantWorkFileEntity> list = this.otMeetingImportantWorkFileService.getList(otMeetingImportantWorkFilePagination);
        if (ObjectUtil.isNotEmpty(list)) {
            return ActionResult.success((String)"duplication");
        }
        this.otMeetingImportantWorkFileService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingImportantWorkFileInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkFileEntity entity = this.otMeetingImportantWorkFileService.getInfo(id);
        OtMeetingImportantWorkFileInfoVO vo = (OtMeetingImportantWorkFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkFileInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingImportantWorkFileInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkFileEntity entity = this.otMeetingImportantWorkFileService.getInfo(id);
        OtMeetingImportantWorkFileInfoVO vo = (OtMeetingImportantWorkFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkFileInfoVO.class);
        vo.setFileUrl(this.baseDataUtil.getFileNameInJson(vo.getFileUrl()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingImportantWorkFileUpForm otMeetingImportantWorkFileUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingImportantWorkFileEntity entity = this.otMeetingImportantWorkFileService.getInfo(id);
        if (entity != null) {
            OtMeetingImportantWorkFileEntity subentity = (OtMeetingImportantWorkFileEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkFileUpForm, OtMeetingImportantWorkFileEntity.class);
            this.otMeetingImportantWorkFileService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkFileEntity entity = this.otMeetingImportantWorkFileService.getInfo(id);
        if (entity != null) {
            this.otMeetingImportantWorkFileService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

