/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.meeting.entity.OtMeetingImportantWorkMonthEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkEveryTypeList;
import com.bringspring.meeting.model.otmeetingimportantwork.OtMeetingImportantWorkOrganizeNumber;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthCrForm;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthInfoVO;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthListVO;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthPagination;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthPaginationExportModel;
import com.bringspring.meeting.model.otmeetingimportantworkmonth.OtMeetingImportantWorkMonthUpForm;
import com.bringspring.meeting.model.otmeetingstatisticsdepartment.OtMeetingStatisticsDepartmentPagination;
import com.bringspring.meeting.service.OtMeetingImportantWorkMonthService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.MeetingConstants;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u90e8\u95e8\u6708\u8ba1\u5212"}, value="meeting")
@RequestMapping(value={"/api/meeting/OtMeetingImportantWorkMonth"})
public class OtMeetingImportantWorkMonthController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingImportantWorkMonthController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingImportantWorkMonthService otMeetingImportantWorkMonthService;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingImportantWorkMonthPagination otMeetingImportantWorkMonthPagination) throws IOException {
        List<OtMeetingImportantWorkMonthEntity> list = this.otMeetingImportantWorkMonthService.getList(otMeetingImportantWorkMonthPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingImportantWorkMonthListVO.class);
        for (OtMeetingImportantWorkMonthListVO entity : listVO) {
            entity.setSubmitUser(this.baseDataUtil.userSelectValues(entity.getSubmitUser()));
            entity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(entity.getResponsibleDepartment()));
            entity.setWorkType(this.baseDataUtil.getDictName(entity.getWorkType(), "departmentMonthWorkType"));
            entity.setWorkStateName(this.baseDataUtil.getDictName(entity.getWorkState(), "workState"));
            entity.setBusinessType(this.baseDataUtil.getDictName(entity.getBusinessType(), "busnessWorkType"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingImportantWorkMonthPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByType"})
    public ActionResult listByType(@RequestBody OtMeetingImportantWorkMonthPagination otMeetingImportantWorkPagination) throws IOException {
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.MONTH_PLAN);
        List<OtMeetingImportantWorkMonthEntity> planNum = this.otMeetingImportantWorkMonthService.getList(otMeetingImportantWorkPagination);
        otMeetingImportantWorkPagination.setWorkType(MeetingConstants.LEADER_MONTH_ARRANGEMENT);
        List<OtMeetingImportantWorkMonthEntity> leaderArrangementList = this.otMeetingImportantWorkMonthService.getList(otMeetingImportantWorkPagination);
        OtMeetingImportantWorkEveryTypeList workEveryTypeList = new OtMeetingImportantWorkEveryTypeList();
        workEveryTypeList.setLeaderArrangementNumber(leaderArrangementList.size());
        workEveryTypeList.setPlanNumber(planNum.size());
        return ActionResult.success((Object)workEveryTypeList);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u90e8\u95e8\u6811\u72b6\u5217\u8868")
    @GetMapping(value={"/DepartmentByCompany/Selector/{id}"})
    public ActionResult<List<OtMeetingImportantWorkOrganizeNumber>> DepartmentByCompany(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingStatisticsDepartmentPagination otMeetingStatisticsDepartmentPagination = new OtMeetingStatisticsDepartmentPagination();
        otMeetingStatisticsDepartmentPagination.setCurrentPage(1L);
        otMeetingStatisticsDepartmentPagination.setPageSize(200L);
        otMeetingStatisticsDepartmentPagination.setSort("asc");
        otMeetingStatisticsDepartmentPagination.setSidx("sortcode");
        List<OtMeetingStatisticsDepartmentEntity> allDepartmentList = this.otMeetingStatisticsDepartmentService.getList(otMeetingStatisticsDepartmentPagination);
        List models = JsonUtil.getJsonToList(allDepartmentList, OrganizeModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List collect = models.stream().filter(i -> i.getHasChildren() == false).collect(Collectors.toList());
        List organizeNumbers = JsonUtil.getJsonToList(collect, OtMeetingImportantWorkOrganizeNumber.class);
        ArrayList<String> workStateList = new ArrayList<String>();
        workStateList.add("termination");
        workStateList.add("draft");
        workStateList.add("checkAndAccept");
        for (OtMeetingImportantWorkOrganizeNumber number : organizeNumbers) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingImportantWorkMonthEntity::getResponsibleDepartment, (Object)number.getId())).notIn(OtMeetingImportantWorkMonthEntity::getWorkState, workStateList);
            List list = this.otMeetingImportantWorkMonthService.list((Wrapper)queryWrapper);
            if (ObjectUtil.isEmpty((Object)list)) {
                number.setNumber(0);
                continue;
            }
            number.setNumber(list.size());
        }
        return ActionResult.success((Object)organizeNumbers);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OtMeetingImportantWorkMonthCrForm otMeetingImportantWorkMonthCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        Long month = Long.valueOf(otMeetingImportantWorkMonthCrForm.getMonth());
        Date dateMonth = DateUtil.daFormatDate((Long)month);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        otMeetingImportantWorkMonthCrForm.setMonth(sdf.format(dateMonth));
        OtMeetingImportantWorkMonthEntity entity = (OtMeetingImportantWorkMonthEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkMonthCrForm, OtMeetingImportantWorkMonthEntity.class);
        entity.setId(mainId);
        OtMeetingImportantWorkMonthEntity newEntity = new OtMeetingImportantWorkMonthEntity();
        this.otMeetingImportantWorkMonthService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingImportantWorkMonthInfoVO> info(@PathVariable(value="id") String id) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        OtMeetingImportantWorkMonthEntity entity = this.otMeetingImportantWorkMonthService.getInfo(id);
        OtMeetingImportantWorkMonthInfoVO vo = (OtMeetingImportantWorkMonthInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkMonthInfoVO.class);
        Date date = formatter.parse(vo.getMonth());
        if (ObjectUtil.isNotEmpty((Object)date)) {
            vo.setMonthDate(date);
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingImportantWorkMonthInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkMonthEntity entity = this.otMeetingImportantWorkMonthService.getInfo(id);
        OtMeetingImportantWorkMonthInfoVO vo = (OtMeetingImportantWorkMonthInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingImportantWorkMonthInfoVO.class);
        vo.setSubmitUser(this.baseDataUtil.userSelectValues(vo.getSubmitUser()));
        vo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(vo.getResponsibleDepartment()));
        vo.setWorkTypeName(this.baseDataUtil.getDictName(vo.getWorkType(), "departmentMonthWorkType"));
        vo.setWorkStateName(this.baseDataUtil.getDictName(entity.getWorkState(), "workState"));
        vo.setBusinessTypeName(this.baseDataUtil.getDictName(entity.getBusinessType(), "busnessWorkType"));
        OtMeetingImportantWorkMonthEntity childOfThisPlan = this.otMeetingImportantWorkMonthService.getChildOfThisPlan(id);
        OtMeetingImportantWorkMonthInfoVO childOfThisPlanInfo = (OtMeetingImportantWorkMonthInfoVO)JsonUtil.getJsonToBean((Object)childOfThisPlan, OtMeetingImportantWorkMonthInfoVO.class);
        OtMeetingImportantWorkMonthEntity parentOfThisPlan = this.otMeetingImportantWorkMonthService.getParentOfThisPlan(entity.getParentId());
        OtMeetingImportantWorkMonthInfoVO parentOfThisPlanInfo = (OtMeetingImportantWorkMonthInfoVO)JsonUtil.getJsonToBean((Object)parentOfThisPlan, OtMeetingImportantWorkMonthInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)childOfThisPlanInfo)) {
            childOfThisPlanInfo.setSubmitUser(this.baseDataUtil.userSelectValues(childOfThisPlanInfo.getSubmitUser()));
            childOfThisPlanInfo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(childOfThisPlanInfo.getResponsibleDepartment()));
            childOfThisPlanInfo.setWorkTypeName(this.baseDataUtil.getDictName(childOfThisPlanInfo.getWorkType(), "departmentMonthWorkType"));
            childOfThisPlanInfo.setWorkStateName(this.baseDataUtil.getDictName(childOfThisPlanInfo.getWorkState(), "workState"));
            childOfThisPlanInfo.setBusinessTypeName(this.baseDataUtil.getDictName(childOfThisPlanInfo.getBusinessType(), "busnessWorkType"));
            vo.setChildPlan(childOfThisPlanInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)parentOfThisPlanInfo)) {
            parentOfThisPlanInfo.setSubmitUser(this.baseDataUtil.userSelectValues(parentOfThisPlanInfo.getSubmitUser()));
            parentOfThisPlanInfo.setResponsibleDepartment(this.baseDataUtil.comSelectValues(parentOfThisPlanInfo.getResponsibleDepartment()));
            parentOfThisPlanInfo.setWorkTypeName(this.baseDataUtil.getDictName(parentOfThisPlanInfo.getWorkType(), "departmentMonthWorkType"));
            parentOfThisPlanInfo.setWorkStateName(this.baseDataUtil.getDictName(parentOfThisPlanInfo.getWorkState(), "workState"));
            parentOfThisPlanInfo.setBusinessTypeName(this.baseDataUtil.getDictName(parentOfThisPlanInfo.getBusinessType(), "busnessWorkType"));
            vo.setParentPlan(parentOfThisPlanInfo);
        }
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingImportantWorkMonthUpForm otMeetingImportantWorkMonthUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        Long month = Long.valueOf(otMeetingImportantWorkMonthUpForm.getMonth());
        Date dateMonth = DateUtil.daFormatDate((Long)month);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        otMeetingImportantWorkMonthUpForm.setMonth(sdf.format(dateMonth));
        OtMeetingImportantWorkMonthEntity entity = this.otMeetingImportantWorkMonthService.getInfo(id);
        if (entity != null) {
            OtMeetingImportantWorkMonthEntity subentity = (OtMeetingImportantWorkMonthEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkMonthUpForm, OtMeetingImportantWorkMonthEntity.class);
            Boolean flag = false;
            if (entity.getWorkState().equals(MeetingConstants.DRAFT) && subentity.getWorkState().equals(MeetingConstants.NORMAL)) {
                flag = true;
            }
            if (!(ObjectUtil.isNotEmpty((Object)entity.getNextMonthPlan()) && otMeetingImportantWorkMonthUpForm.getWorkState().equals(MeetingConstants.NORMAL) && flag.booleanValue())) {
                Map<String, String> compare = ObjectComparator.compare(entity, subentity);
                ArrayList keyList = new ArrayList();
                compare.keySet().stream().forEach(key -> keyList.add(key));
                boolean disjoint = Collections.disjoint(keyList, MeetingConstants.DEPARTMENT_MONTH_PLAN);
                if (!disjoint) {
                    subentity.setReportTime(new Date());
                }
            }
            this.otMeetingImportantWorkMonthService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingImportantWorkMonthEntity entity = this.otMeetingImportantWorkMonthService.getInfo(id);
        if (entity != null) {
            this.otMeetingImportantWorkMonthService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/updateEnabledMark/{id}"})
    @Transactional
    public ActionResult updateEnabledMark(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingImportantWorkMonthUpForm otMeetingImportantWorkMonthUpForm) throws DataException {
        OtMeetingImportantWorkMonthEntity oldEntity = (OtMeetingImportantWorkMonthEntity)JsonUtil.getJsonToBean((Object)otMeetingImportantWorkMonthUpForm, OtMeetingImportantWorkMonthEntity.class);
        if (otMeetingImportantWorkMonthUpForm.getWorkState().equals("delay")) {
            OtMeetingImportantWorkMonthEntity childOfThisPlan = this.otMeetingImportantWorkMonthService.getChildOfThisPlan(id);
            if (ObjectUtil.isNotEmpty((Object)childOfThisPlan)) {
                return ActionResult.success((String)"repeated");
            }
            OtMeetingImportantWorkMonthEntity newEntity = new OtMeetingImportantWorkMonthEntity();
            String month = otMeetingImportantWorkMonthUpForm.getMonth() + "-01 00:00:00";
            Date dateMonth = DateUtil.stringToDate((String)month);
            BeanUtils.copyProperties((Object)oldEntity, (Object)newEntity);
            newEntity.setId(RandomUtil.uuId());
            LocalDateTime localDateTime = dateMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(1L);
            Date newDate = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            int dayOfYear = calendar.get(1);
            int dayOfMonth = calendar.get(2) + 1;
            String strTime = "";
            strTime = dayOfMonth < 10 ? dayOfYear + "-0" + dayOfMonth : dayOfYear + dayOfMonth + "";
            newEntity.setMonth(strTime);
            newEntity.setWorkState(MeetingConstants.NORMAL);
            newEntity.setParentId(oldEntity.getId());
            this.otMeetingImportantWorkMonthService.save(newEntity);
        }
        this.otMeetingImportantWorkMonthService.update(id, oldEntity);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/statisticsNotSubmittedDepartmentMonth"})
    public ActionResult statisticsNotSubmittedDepartmentMonth() throws Exception {
        this.otMeetingImportantWorkMonthService.scheduledRemindeSubmitPlan();
        return ActionResult.success((String)"success");
    }

    @GetMapping(value={"/statisticsWorkProgressMonth"})
    public ActionResult statisticsWorkProgressMonth() throws Exception {
        this.otMeetingImportantWorkMonthService.statisticEveryDepartmentPlan();
        return ActionResult.success((String)"success");
    }

    @GetMapping(value={"/reminderAll"})
    public ActionResult reminderAll() throws Exception {
        this.otMeetingImportantWorkMonthService.scheduledRemindeSubmitPlanAll();
        return ActionResult.success((String)"success");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingImportantWorkMonthPaginationExportModel otMeetingImportantWorkMonthPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)otMeetingImportantWorkMonthPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OtMeetingImportantWorkMonthPagination otMeetingImportantWorkMonthPagination = (OtMeetingImportantWorkMonthPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingImportantWorkMonthPaginationExportModel), OtMeetingImportantWorkMonthPagination.class));
        List<OtMeetingImportantWorkMonthEntity> list = this.otMeetingImportantWorkMonthService.getTypeList(otMeetingImportantWorkMonthPagination, otMeetingImportantWorkMonthPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OtMeetingImportantWorkMonthListVO.class);
        for (OtMeetingImportantWorkMonthListVO entity : listVO) {
            entity.setSubmitUser(this.baseDataUtil.userSelectValues(entity.getSubmitUser()));
            entity.setResponsibleDepartment(this.baseDataUtil.comSelectValues(entity.getResponsibleDepartment()));
            entity.setWorkType(this.baseDataUtil.getDictName(entity.getWorkType(), "departmentMonthWorkType"));
            entity.setWorkStateName(this.baseDataUtil.getDictName(entity.getWorkState(), "workState"));
            entity.setBusinessType(this.baseDataUtil.getDictName(entity.getBusinessType(), "busnessWorkType"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)otMeetingImportantWorkMonthPaginationExportModel.getSelectKey()) ? otMeetingImportantWorkMonthPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "workItem": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u4e8b\u9879", (Object)"workItem"));
                        continue block34;
                    }
                    case "month": {
                        entitys.add(new ExcelExportEntity("\u6708\u4efd", (Object)"month"));
                        continue block34;
                    }
                    case "workType": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u7c7b\u522b", (Object)"workType"));
                        continue block34;
                    }
                    case "workStateName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"workStateName"));
                        continue block34;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block34;
                    }
                    case "responsibleDepartment": {
                        entitys.add(new ExcelExportEntity("\u8d23\u4efb\u90e8\u95e8", (Object)"responsibleDepartment"));
                        continue block34;
                    }
                    case "businessType": {
                        entitys.add(new ExcelExportEntity("\u4e8b\u9879\u7c7b\u522b", (Object)"businessType"));
                        continue block34;
                    }
                    case "workProgress": {
                        entitys.add(new ExcelExportEntity("\u672c\u6708\u8ba1\u5212", (Object)"workProgress"));
                        continue block34;
                    }
                    case "nextMonthPlan": {
                        entitys.add(new ExcelExportEntity("\u672c\u6708\u8ba1\u5212\u5b8c\u6210\u60c5\u51b5", (Object)"nextMonthPlan"));
                        continue block34;
                    }
                    case "submitUser": {
                        entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba", (Object)"submitUser"));
                        continue block34;
                    }
                    case "submitTime": {
                        entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u65f6\u95f4", (Object)"submitTime"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

