/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.meeting.entity.OtMeetingRoomEntity;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomCrForm;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomInfoVO;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomListVO;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomPagination;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomUpForm;
import com.bringspring.meeting.service.OtMeetingRoomReservationService;
import com.bringspring.meeting.service.OtMeetingRoomService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f1a\u8bae\u5ba4\u4fe1\u606f"}, value="meetingroom")
@RequestMapping(value={"/api/meetingroom/OtMeetingRoom"})
public class OtMeetingRoomController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingRoomController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private OtMeetingRoomService otMeetingRoomService;
    @Autowired
    private OtMeetingRoomReservationService otMeetingRoomReservationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingRoomPagination otMeetingRoomPagination) throws IOException {
        List<OtMeetingRoomEntity> list = this.otMeetingRoomService.getList(otMeetingRoomPagination);
        for (OtMeetingRoomEntity otMeetingRoomEntity : list) {
            otMeetingRoomEntity.setResponsibleUserId(this.baseDataUtil.userSelectValues(otMeetingRoomEntity.getResponsibleUserId()));
            otMeetingRoomEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(otMeetingRoomEntity.getCreatorUserId()));
            otMeetingRoomEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(otMeetingRoomEntity.getLastModifyUserId()));
            otMeetingRoomEntity.setRoomAddress(this.selectValues.areaSelectValues(otMeetingRoomEntity.getRoomAddress()));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomListVO.class);
        for (OtMeetingRoomListVO otMeetingRoomVO : listVO) {
            otMeetingRoomVO.setEnabledMark(this.baseDataUtil.getDictName(otMeetingRoomVO.getEnabledMark(), "meetingRoomEnabledMark"));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getDeviceList"})
    public ActionResult getDeviceList(@RequestBody OtMeetingRoomPagination otMeetingRoomPagination) throws IOException {
        List<OtMeetingRoomEntity> list = this.otMeetingRoomService.getList(otMeetingRoomPagination);
        ArrayList<String> listDevice = new ArrayList<String>();
        for (OtMeetingRoomEntity entity : list) {
            if (!ObjectUtil.isNotEmpty((Object)entity.getDevices()) || "[]".equals(entity.getDevices())) continue;
            String devices = entity.getDevices().replaceAll("[\\[\\]\"]", "");
            String[] feilds = devices.split(",");
            listDevice.addAll(Arrays.asList(feilds));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listDevice);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OtMeetingRoomCrForm otMeetingRoomCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        otMeetingRoomCrForm.setCreatorUserId(userInfo.getUserId());
        otMeetingRoomCrForm.setCreatorTime(DateUtil.getNow());
        OtMeetingRoomEntity entity = (OtMeetingRoomEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomCrForm, OtMeetingRoomEntity.class);
        entity.setId(mainId);
        entity.setResponsibleUserId(CollectionUtil.join(otMeetingRoomCrForm.getResponsibleUserId(), (CharSequence)","));
        entity.setDeleteMark(0);
        this.otMeetingRoomService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingRoomInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingRoomEntity entity = this.otMeetingRoomService.getInfo(id);
        OtMeetingRoomInfoVO vo = (OtMeetingRoomInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getInfoByDeviceId/{deviceId}"})
    public ActionResult<OtMeetingRoomInfoVO> getInfoByDeviceId(@PathVariable(value="deviceId") String deviceId) {
        OtMeetingRoomEntity entity = this.otMeetingRoomService.getInfoByDeviceId(deviceId);
        OtMeetingRoomInfoVO vo = (OtMeetingRoomInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomInfoVO.class);
        vo.setRoomAddress(this.selectValues.areaSelectValues(vo.getRoomAddress()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingRoomInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingRoomEntity entity = this.otMeetingRoomService.getInfo(id);
        OtMeetingRoomInfoVO vo = (OtMeetingRoomInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomInfoVO.class);
        vo.setResponsibleUserId(this.baseDataUtil.userSelectValues(vo.getResponsibleUserId()));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "meetingRoomEnabledMark"));
        vo.setDevices(this.baseDataUtil.getDictName(vo.getDevices(), "meetingDevice"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setRoomAddress(this.selectValues.areaSelectValues(vo.getRoomAddress()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingRoomUpForm otMeetingRoomUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingRoomEntity entity = this.otMeetingRoomService.getInfo(id);
        if (entity != null) {
            otMeetingRoomUpForm.setLastModifyUserId(userInfo.getUserId());
            otMeetingRoomUpForm.setLastModifyTime(DateUtil.getNow());
            OtMeetingRoomEntity subentity = (OtMeetingRoomEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomUpForm, OtMeetingRoomEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setResponsibleUserId(CollectionUtil.join(otMeetingRoomUpForm.getResponsibleUserId(), (CharSequence)","));
            this.otMeetingRoomService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingRoomEntity entity = this.otMeetingRoomService.getInfo(id);
        if (entity != null) {
            entity.setDeleteMark(1);
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            this.otMeetingRoomService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

