/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingRoomEntity;
import com.bringspring.meeting.entity.OtMeetingRoomReservationEntity;
import com.bringspring.meeting.entity.OtMeetingSignEntity;
import com.bringspring.meeting.model.otmeetingroom.OtMeetingRoomModel;
import com.bringspring.meeting.model.otmeetingroomreservation.AppOtMeetingData;
import com.bringspring.meeting.model.otmeetingroomreservation.AppOtMeetingRoomList;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationCrForm;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationInfoVO;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationListVO;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationPagination;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationPaginationExportModel;
import com.bringspring.meeting.model.otmeetingroomreservation.OtMeetingRoomReservationUpForm;
import com.bringspring.meeting.service.OtMeetingRoomReservationService;
import com.bringspring.meeting.service.OtMeetingRoomService;
import com.bringspring.meeting.service.OtMeetingSignService;
import com.bringspring.meeting.utils.DateUtils;
import com.bringspring.meeting.utils.MeetingConstants;
import com.bringspring.meeting.utils.SendMessageUtil;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f1a\u8bae\u5ba4\u9884\u5b9a\u4fe1\u606f"}, value="OtMeetingRoom")
@RequestMapping(value={"/api/OtMeetingRoom/OtMeetingRoomReservation"})
public class OtMeetingRoomReservationController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingRoomReservationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OtMeetingSignService otMeetingSignService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingRoomReservationService otMeetingRoomReservationService;
    @Autowired
    private OtMeetingRoomService otMeetingRoomService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        if (ObjectUtil.isEmpty(list)) {
            return ActionResult.success(new ArrayList());
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        List userListByRoleId = this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE).stream().map(UserEntity::getId).collect(Collectors.toList());
        userListByRoleId.addAll(this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE_MJ).stream().map(UserEntity::getId).collect(Collectors.toList()));
        userListByRoleId.addAll(this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE_JC).stream().map(UserEntity::getId).collect(Collectors.toList()));
        userListByRoleId.addAll(this.userService.getUserListByRoleId(MeetingConstants.MEET_APPROVE_SH).stream().map(UserEntity::getId).collect(Collectors.toList()));
        for (OtMeetingRoomReservationListVO entity : listVO) {
            if (entity.getEnabledMark().equals("10") && entity.getContactsUserId().equals(userInfo.getUserId())) {
                entity.setEditAuth(true);
                entity.setDeleteAuth(true);
            }
            if (userListByRoleId.contains(userInfo.getUserId()) && (entity.getEnabledMark().equals("30") || entity.getEnabledMark().equals("40"))) {
                entity.setEditAuth(true);
                entity.setCancelAuth(true);
            }
            entity.setMeetingType(this.baseDataUtil.getDictName(entity.getMeetingType(), "meetingType"));
            entity.setHostingUserId(this.baseDataUtil.userSelectValues(entity.getHostingUserId()));
            entity.setHostingDepartment(this.baseDataUtil.comSelectValues(entity.getHostingDepartment()));
            entity.setContactsUserId(this.baseDataUtil.userSelectValues(entity.getContactsUserId()));
            entity.setParticipantsUserIds(this.baseDataUtil.userSelectValues(entity.getParticipantsUserIds()));
            entity.setRepetitiveMode(this.baseDataUtil.getDictName(entity.getRepetitiveMode(), "repeatModule"));
            entity.setResourcePreparation(this.baseDataUtil.getDictName(entity.getResourcePreparation(), "meetingDevice"));
            entity.setFilesPath(this.baseDataUtil.getFileNameInJson(entity.getFilesPath()));
            List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId());
            if (ObjectUtil.isNotEmpty(infoByIdList)) {
                String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                entity.setMeetingRoomName(meetingRoomName);
            }
            if ((entity.getEnabledMark().equals(MeetingConstants.PASS_ENABLEDMARK) || entity.getEnabledMark().equals(MeetingConstants.EXPIRE_ENABLEDMARK)) && entity.getMeetingMinutesOfficer().equals(userInfo.getUserId()) && entity.getFilesPath().length() < 5) {
                entity.setUpload("true");
            }
            entity.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(entity.getMeetingMinutesOfficer()));
            entity.setMeetingModeName(this.baseDataUtil.getDictName(entity.getMeetingMode(), "conference"));
            entity.setEnabledMarkName(this.baseDataUtil.getDictName(entity.getEnabledMark(), "meetingEnabledMark"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getCalendarList"})
    public ActionResult getCalendarList(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        List<String> myselfMeetingList;
        ArrayList<String> idsList = new ArrayList<String>();
        Date fir = new Date();
        Date sec = new Date();
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped())) {
            fir = DateUtil.stringToDate((String)otMeetingRoomReservationPagination.getAllDateScoped().get(0));
            sec = DateUtil.stringToDate((String)otMeetingRoomReservationPagination.getAllDateScoped().get(1));
            ArrayList<String> time = new ArrayList<String>();
            time.add(String.valueOf(fir.getTime()));
            time.add(String.valueOf(sec.getTime()));
            List<String> regularMeetingByTime = this.otMeetingRoomReservationService.getRegularMeetingByTime(time, "some");
            if (ObjectUtil.isNotEmpty(regularMeetingByTime)) {
                idsList.addAll(regularMeetingByTime);
            } else {
                return ActionResult.success();
            }
        }
        if ("2".equals(otMeetingRoomReservationPagination.getShowMeetingType()) && ObjectUtil.isNotEmpty(myselfMeetingList = this.otMeetingRoomReservationService.getMyselfMeetingList())) {
            idsList.addAll(myselfMeetingList);
        }
        otMeetingRoomReservationPagination.setRegularMeetingIdList(idsList);
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        if (ObjectUtil.isEmpty(list)) {
            return ActionResult.success(new ArrayList());
        }
        ArrayList<OtMeetingRoomReservationEntity> extreList = new ArrayList<OtMeetingRoomReservationEntity>();
        for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : list) {
            List<Date> regularMeetingTimeList;
            otMeetingRoomReservationEntity.setMeetingType(this.baseDataUtil.getDictName(otMeetingRoomReservationEntity.getMeetingType(), "meetingType"));
            otMeetingRoomReservationEntity.setHostingUserId(this.baseDataUtil.userSelectValues(otMeetingRoomReservationEntity.getHostingUserId()));
            otMeetingRoomReservationEntity.setHostingDepartment(this.baseDataUtil.comSelectValues(otMeetingRoomReservationEntity.getHostingDepartment()));
            otMeetingRoomReservationEntity.setContactsUserId(this.baseDataUtil.userSelectValues(otMeetingRoomReservationEntity.getContactsUserId()));
            otMeetingRoomReservationEntity.setParticipantsUserIds(this.baseDataUtil.userSelectValues(otMeetingRoomReservationEntity.getParticipantsUserIds()));
            otMeetingRoomReservationEntity.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(otMeetingRoomReservationEntity.getMeetingMinutesOfficer()));
            otMeetingRoomReservationEntity.setResourcePreparation(this.baseDataUtil.getDictName(otMeetingRoomReservationEntity.getResourcePreparation(), "meetingDevice"));
            otMeetingRoomReservationEntity.setFilesPath(this.baseDataUtil.getFileNameInJson(otMeetingRoomReservationEntity.getFilesPath()));
            otMeetingRoomReservationEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(otMeetingRoomReservationEntity.getCreatorUserId()));
            otMeetingRoomReservationEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(otMeetingRoomReservationEntity.getLastModifyUserId()));
            if (!otMeetingRoomReservationEntity.getMeetingMode().equals(MeetingConstants.MEETING_MODE) || (regularMeetingTimeList = this.otMeetingRoomReservationService.getRegularMeetingTimeList(otMeetingRoomReservationEntity)).size() <= 0) continue;
            for (Date date : regularMeetingTimeList) {
                OtMeetingRoomReservationEntity reservationEntity = new OtMeetingRoomReservationEntity();
                reservationEntity.setId(otMeetingRoomReservationEntity.getId());
                reservationEntity.setMeetingTitle(otMeetingRoomReservationEntity.getMeetingTitle());
                reservationEntity.setRepetitiveMode(otMeetingRoomReservationEntity.getRepetitiveMode());
                reservationEntity.setEnabledMark(otMeetingRoomReservationEntity.getEnabledMark());
                reservationEntity.setStartTime(DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + otMeetingRoomReservationEntity.getRepetitiveStartTime())));
                reservationEntity.setEndTime(DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + otMeetingRoomReservationEntity.getRepetitiveEndTime())));
                reservationEntity.setMeetingRoomId(otMeetingRoomReservationEntity.getMeetingRoomId());
                if (!reservationEntity.getStartTime().after(fir) || !reservationEntity.getStartTime().before(sec)) continue;
                extreList.add(reservationEntity);
            }
        }
        list.addAll(extreList);
        list.removeIf(i -> ObjectUtil.isNotEmpty((Object)i.getRepetitiveInterval()));
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        if (!listVO.isEmpty()) {
            for (OtMeetingRoomReservationListVO roomReservationListVO : listVO) {
                List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(roomReservationListVO.getMeetingRoomId());
                if (ObjectUtil.isNotEmpty(infoByIdList)) {
                    String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                    roomReservationListVO.setMeetingRoomName(meetingRoomName);
                }
                roomReservationListVO.setMeetingModeName(this.baseDataUtil.getDictName(roomReservationListVO.getMeetingMode(), "conference"));
            }
        }
        ArrayList arrayList = listVO.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OtMeetingRoomReservationListVO>(Comparator.comparing(OtMeetingRoomReservationListVO::getStartTime))), ArrayList::new));
        PageListVO vo = new PageListVO();
        vo.setList((List)arrayList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAppList"})
    public ActionResult getAppList(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        PaginationVO page;
        ArrayList<String> idsList = new ArrayList<String>();
        Boolean flag = false;
        if (ObjectUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped())) {
            List<String> regularMeetingByTime = this.otMeetingRoomReservationService.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped(), "some");
            if (ObjectUtil.isNotEmpty(regularMeetingByTime)) {
                idsList.addAll(regularMeetingByTime);
            } else {
                flag = true;
            }
        }
        otMeetingRoomReservationPagination.setRegularMeetingIdList(idsList);
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        for (OtMeetingRoomReservationEntity entity : list) {
            entity.setMeetingType(this.baseDataUtil.getDictName(entity.getMeetingType(), "meetingType"));
            entity.setHostingUserId(this.baseDataUtil.userSelectValues(entity.getHostingUserId()));
            entity.setHostingDepartment(this.baseDataUtil.comSelectValues(entity.getHostingDepartment()));
            entity.setContactsUserId(this.baseDataUtil.userSelectValues(entity.getContactsUserId()));
            entity.setParticipantsUserIds(this.baseDataUtil.userSelectValues(entity.getParticipantsUserIds()));
            entity.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(entity.getMeetingMinutesOfficer()));
            entity.setRepetitiveMode(this.baseDataUtil.getDictName(entity.getRepetitiveMode(), "repeatModule"));
            entity.setResourcePreparation(this.baseDataUtil.getDictName(entity.getResourcePreparation(), "meetingDevice"));
            entity.setFilesPath(this.baseDataUtil.getFileNameInJson(entity.getFilesPath()));
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        ArrayList<Object> appOtMeetingData = new ArrayList<Object>();
        for (OtMeetingRoomReservationListVO roomReservationListVO : listVO) {
            List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(roomReservationListVO.getMeetingRoomId());
            if (ObjectUtil.isNotEmpty(infoByIdList)) {
                String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                roomReservationListVO.setMeetingRoomName(meetingRoomName);
            }
            roomReservationListVO.setMeetingModeName(this.baseDataUtil.getDictName(roomReservationListVO.getMeetingMode(), "conference"));
            roomReservationListVO.setEnabledMarkName(this.baseDataUtil.getDictName(roomReservationListVO.getEnabledMark(), "meetingEnabledMark"));
            if (MeetingConstants.ORIGINARY_MEETING.equals(roomReservationListVO.getMeetingMode())) {
                roomReservationListVO.setStartTime(DateUtil.dateFormat((Date)DateUtils.daFormatDate(Long.valueOf(roomReservationListVO.getStartTime()))));
                roomReservationListVO.setEndTime(DateUtil.dateFormat((Date)DateUtils.daFormatDate(Long.valueOf(roomReservationListVO.getEndTime()))));
            } else {
                roomReservationListVO.setStartTime(otMeetingRoomReservationPagination.getAllDateScoped().get(0).substring(0, 10) + " " + roomReservationListVO.getRepetitiveStartTime());
                roomReservationListVO.setEndTime(otMeetingRoomReservationPagination.getAllDateScoped().get(1).substring(0, 10) + " " + roomReservationListVO.getRepetitiveEndTime());
            }
            appOtMeetingData.add(JsonUtil.getJsonToBean((Object)roomReservationListVO, AppOtMeetingData.class));
        }
        Map groupByCourse = appOtMeetingData.stream().collect(Collectors.groupingBy(AppOtMeetingData::getMeetingRoomName, Collectors.toList()));
        ArrayList<AppOtMeetingRoomList> appOtMeetingRoomLists = new ArrayList<AppOtMeetingRoomList>();
        ArrayList<AppOtMeetingRoomList> flagOtMeetingRoomList = new ArrayList<AppOtMeetingRoomList>();
        for (String string : groupByCourse.keySet()) {
            AppOtMeetingRoomList appOtMeetingRoomList = new AppOtMeetingRoomList();
            System.out.println("Key = " + string);
            appOtMeetingRoomList.setName(string);
            appOtMeetingRoomList.setMeetingRoomId(((AppOtMeetingData)groupByCourse.get(string).get(0)).getMeetingRoomId());
            appOtMeetingRoomList.setSchedule(groupByCourse.get(string));
            appOtMeetingRoomLists.add(appOtMeetingRoomList);
        }
        List list1 = this.otMeetingRoomService.list();
        for (OtMeetingRoomEntity otMeetingRoomEntity : list1) {
            AppOtMeetingRoomList appOtMeetingRoomList = new AppOtMeetingRoomList();
            appOtMeetingRoomList.setName(otMeetingRoomEntity.getName());
            appOtMeetingRoomList.setMeetingRoomId(otMeetingRoomEntity.getId());
            appOtMeetingRoomLists.add(appOtMeetingRoomList);
            flagOtMeetingRoomList.add(appOtMeetingRoomList);
        }
        List list2 = appOtMeetingRoomLists.stream().filter(OtMeetingRoomReservationController.distinctByProperty(AppOtMeetingRoomList::getMeetingRoomId)).collect(Collectors.toList());
        PageListVO vo = new PageListVO();
        if (flag.booleanValue()) {
            vo.setList(flagOtMeetingRoomList);
            page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
            vo.setPagination(page);
            return ActionResult.success((Object)vo);
        }
        vo.setList(list2);
        page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getMeetingScreenList"})
    public ActionResult getMeetingScreenList(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        otMeetingRoomReservationPagination.setShowMeetingType("1");
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        for (OtMeetingRoomReservationListVO entity : listVO) {
            entity.setParticipantsUserEntity(this.otMeetingRoomReservationService.getSignListByMeetingId(entity.getId()));
            entity.setMeetingType(this.baseDataUtil.getDictName(entity.getMeetingType(), "meetingType"));
            entity.setHostingUserId(this.baseDataUtil.userSelectValues(entity.getHostingUserId()));
            entity.setHostingDepartment(this.baseDataUtil.comSelectValues(entity.getHostingDepartment()));
            entity.setContactsUserId(this.baseDataUtil.userSelectValues(entity.getContactsUserId()));
            entity.setParticipantsUserIds(this.baseDataUtil.userSelectValues(entity.getParticipantsUserIds()));
            entity.setRepetitiveMode(this.baseDataUtil.getDictName(entity.getRepetitiveMode(), "repeatModule"));
            entity.setResourcePreparation(this.baseDataUtil.getDictName(entity.getResourcePreparation(), "meetingDevice"));
            entity.setFilesPath(this.baseDataUtil.getFileNameInJson(entity.getFilesPath()));
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
            List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId());
            if (ObjectUtil.isNotEmpty(infoByIdList)) {
                String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                entity.setMeetingRoomName(meetingRoomName);
            }
            entity.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(entity.getMeetingMinutesOfficer()));
            entity.setMeetingModeName(this.baseDataUtil.getDictName(entity.getMeetingMode(), "conference"));
            entity.setEnabledMarkName(this.baseDataUtil.getDictName(entity.getEnabledMark(), "meetingEnabledMark"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public synchronized ActionResult create(@RequestBody @Valid OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) throws DataException {
        Boolean aBoolean = this.otMeetingRoomReservationService.creatHandle(otMeetingRoomReservationCrForm);
        if (aBoolean.booleanValue()) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f\uff01");
        }
        return ActionResult.success((String)MeetingConstants.DUPLICATION);
    }

    @NotCheckLogin
    @PostMapping(value={"/meetingCreate"})
    @DSTransactional
    public synchronized ActionResult meetingCreate(@RequestBody @Valid OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) throws DataException {
        OtMeetingRoomReservationEntity otMeetingRoomReservationEntity = this.otMeetingRoomReservationService.meetingCreate(otMeetingRoomReservationCrForm);
        if (ObjectUtil.isNotEmpty((Object)otMeetingRoomReservationEntity)) {
            return ActionResult.success((Object)otMeetingRoomReservationEntity);
        }
        return ActionResult.fail((String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingRoomReservationInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        OtMeetingRoomReservationInfoVO vo = (OtMeetingRoomReservationInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        if (StringUtils.isNotEmpty((String)vo.getMeetingRoomId())) {
            List<String> list = Arrays.asList(vo.getMeetingRoomId().split(","));
            ArrayList<String> newList = new ArrayList<String>();
            for (String s : list) {
                s = "\"" + s + "\"";
                newList.add(s);
            }
            vo.setMeetingRoomIdList(((Object)newList).toString().replaceAll(" ", ""));
        }
        QueryWrapper queryWrapperOtMeetingRoom = new QueryWrapper();
        queryWrapperOtMeetingRoom.lambda().eq(OtMeetingRoomEntity::getId, (Object)entity.getMeetingRoomId());
        OtMeetingRoomEntity meetingRoomEntity = (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapperOtMeetingRoom);
        vo.setOt_meeting_room((OtMeetingRoomModel)JsonUtil.getJsonToBean((Object)meetingRoomEntity, OtMeetingRoomModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingRoomReservationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        OtMeetingRoomReservationInfoVO vo = (OtMeetingRoomReservationInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)vo.getRepetitiveMode())) {
            if (vo.getRepetitiveMode().equals("W")) {
                vo.setRepetitiveInterval("\u6bcf\u5468" + vo.getRepetitiveInterval());
            } else if (vo.getRepetitiveMode().equals("M")) {
                vo.setRepetitiveInterval("\u6bcf\u6708" + vo.getRepetitiveInterval() + "\u53f7");
            } else {
                vo.setRepetitiveInterval("\u6bcf\u9694" + vo.getRepetitiveInterval() + "\u5929");
            }
        }
        vo.setMeetingType(this.baseDataUtil.getDictName(vo.getMeetingType(), "meetingType"));
        vo.setHostingUserId(this.baseDataUtil.userSelectValues(vo.getHostingUserId()));
        vo.setHostingDepartment(this.baseDataUtil.comSelectValues(vo.getHostingDepartment()));
        vo.setContactsUserId(this.baseDataUtil.userSelectValues(vo.getContactsUserId()));
        vo.setParticipantsUserIds(this.baseDataUtil.userSelectValues(vo.getParticipantsUserIds()));
        vo.setMeetingMinutesOfficer(this.baseDataUtil.userSelectValues(vo.getMeetingMinutesOfficer()));
        vo.setMeetingMode(this.baseDataUtil.getDictName(vo.getMeetingMode(), "conference"));
        vo.setRepetitiveMode(this.baseDataUtil.getDictName(vo.getRepetitiveMode(), "repeatModule"));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "meetingEnabledMark"));
        vo.setRemindTime(this.baseDataUtil.getDictName(vo.getRemindTime(), "reminderInAdvance"));
        vo.setFilesPath(this.baseDataUtil.getFileNameInJson(vo.getFilesPath()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setResourcePreparation(this.baseDataUtil.getDictName(vo.getResourcePreparation(), "meetingDevice"));
        List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(vo.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdList)) {
            String meetingRoomName = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
            vo.setMeetingRoomId(meetingRoomName);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        if (entity != null) {
            Boolean aBoolean = this.otMeetingRoomReservationService.updateHandle(id, otMeetingRoomReservationUpForm);
            if (aBoolean.booleanValue()) {
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.success((String)MeetingConstants.DUPLICATION);
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/upload"})
    public ActionResult upload(@RequestBody OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws IOException {
        OtMeetingRoomReservationEntity info = this.otMeetingRoomReservationService.getInfo(otMeetingRoomReservationUpForm.getId());
        info.setFilesPath(otMeetingRoomReservationUpForm.getFilesPath());
        this.otMeetingRoomReservationService.update(info.getId(), info);
        return ActionResult.success((String)"\u4e0a\u4f20\u6210\u529f\uff01");
    }

    @PutMapping(value={"/acceptOrRejectApplications"})
    public ActionResult acceptOrRejectApplications(@RequestBody OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingRoomReservationEntity reservationEntity = this.otMeetingRoomReservationService.approveMeeting(otMeetingRoomReservationUpForm);
        String url = MeetingConstants.APP_MEETING_MY + reservationEntity.getId();
        String createUrl = MeetingConstants.APP_MEETING_CREATE + reservationEntity.getId();
        String arrangeMentUrl = MeetingConstants.APP_MEETING_ARRANGEMENT + reservationEntity.getId();
        String PCurl = MeetingConstants.PC_MEETING_MY + reservationEntity.getId();
        String PCcreateUrl = MeetingConstants.PC_MEETING_CREATE + reservationEntity.getId();
        String PCarrangeMentUrl = MeetingConstants.PC_MEETING_ARRANGEMENT + reservationEntity.getId();
        if (otMeetingRoomReservationUpForm.getEnabledMark().equals(MeetingConstants.REJECT_ENABLEDMARK)) {
            reservationEntity.setVerifyOpinion(otMeetingRoomReservationUpForm.getVerifyOpinion());
        }
        this.otMeetingRoomReservationService.update(reservationEntity.getId(), reservationEntity);
        ArrayList<String> list = new ArrayList<String>();
        list.add(reservationEntity.getContactsUserId());
        List<String> notifyUserByMeetingRoomId = this.otMeetingRoomReservationService.getNotifyUserByMeetingRoomId(Arrays.asList(otMeetingRoomReservationUpForm.getMeetingRoomId().split(",")));
        String title = "";
        String content = "";
        String meetSpot = "";
        List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(reservationEntity.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdList)) {
            meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
        }
        List<String> userList = this.otMeetingRoomReservationService.strToList(reservationEntity.getParticipantsUserIds());
        if (reservationEntity.getEnabledMark() == Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK)) {
            title = "\u60a8\u7533\u8bf7\u7684" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + "\u5f00\u59cb\u7684\u4f1a\u8bae\u5df2\u901a\u8fc7\u5ba1\u6838\uff01";
            content = "\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationEntity.getMeetingTitle() + "\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)reservationEntity.getEndTime(), (String)"HH:mm") + "\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot;
            SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, content, createUrl, PCcreateUrl, list, TermTypeEnum.TERM_APP_PC.getCode(), "");
            if (new Date().before(reservationEntity.getStartTime())) {
                userList.remove(reservationEntity.getContactsUserId());
                String titleUser = "\u60a8\u6709\u4f1a\u8bae\u9700\u8981\u53c2\u52a0\uff0c\u8bf7\u67e5\u770b\uff01";
                String contentUser = "\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationEntity.getMeetingTitle() + "\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)reservationEntity.getEndTime(), (String)"HH:mm") + "\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot + "\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(reservationEntity.getContactsUserId());
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, titleUser, contentUser, url, PCurl, userList, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            return ActionResult.success((String)"\u5ba1\u6838\u901a\u8fc7\uff01");
        }
        if (reservationEntity.getEnabledMark() == Integer.valueOf(MeetingConstants.REJECT_ENABLEDMARK)) {
            title = "\u60a8\u7533\u8bf7\u7684" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + "\u5f00\u59cb\u7684\u4f1a\u8bae\u88ab\u9a73\u56de\uff01";
            content = "\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + "-" + DateUtil.format((Date)reservationEntity.getEndTime(), (String)"MM-dd HH:mm");
            SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, content, createUrl, PCcreateUrl, list, TermTypeEnum.TERM_APP_PC.getCode(), "");
            return ActionResult.success((String)"\u5df2\u62d2\u7edd\u8be5\u4f1a\u8bae\u7533\u8bf7\uff01");
        }
        if (reservationEntity.getEnabledMark() == Integer.valueOf(MeetingConstants.WITHDRAW_ENABLEDMARK)) {
            title = "\u6709\u4f1a\u8bae\u88ab\u64a4\u56de\uff0c\u8bf7\u67e5\u770b\uff01";
            content = "\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationEntity.getMeetingTitle() + "\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)reservationEntity.getEndTime(), (String)"HH:mm") + "\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot;
            if (ObjectUtils.isNotEmpty(notifyUserByMeetingRoomId)) {
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, content, arrangeMentUrl, PCarrangeMentUrl, notifyUserByMeetingRoomId, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            return ActionResult.success((String)"\u5df2\u64a4\u56de\u8be5\u4f1a\u8bae\uff01");
        }
        title = "\u6709\u4f1a\u8bae\u6682\u65f6\u53d6\u6d88\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + reservationEntity.getMeetingTitle());
        stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)reservationEntity.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)reservationEntity.getEndTime(), (String)"HH:mm"));
        stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
        stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(reservationEntity.getContactsUserId()));
        url = MeetingConstants.APP_MEETING_ARRANGEMENT + reservationEntity.getId();
        PCurl = MeetingConstants.PC_MEETING_ARRANGEMENT + reservationEntity.getId();
        SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), url, PCurl, userList, TermTypeEnum.TERM_APP_PC.getCode(), "");
        return ActionResult.success((String)"\u5df2\u53d6\u6d88\u8be5\u4f1a\u8bae\uff01");
    }

    @PutMapping(value={"/earlyTermination"})
    public ActionResult earlyTermination(@RequestBody OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws IOException {
        OtMeetingRoomReservationEntity info = this.otMeetingRoomReservationService.getInfo(otMeetingRoomReservationUpForm.getId());
        info.setEnabledMark(Integer.valueOf(MeetingConstants.EXPIRE_ENABLEDMARK));
        this.otMeetingRoomReservationService.update(otMeetingRoomReservationUpForm.getId(), info);
        List<String> notifyUserByMeetingRoomId = this.otMeetingRoomReservationService.getNotifyUserByMeetingRoomId(Arrays.asList(otMeetingRoomReservationUpForm.getMeetingRoomId().split(",")));
        String meetSpot = "";
        List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(info.getMeetingRoomId());
        if (ObjectUtil.isNotEmpty(infoByIdList)) {
            meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
        }
        String title = "\u6709\u4f1a\u8bae\u63d0\u524d\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + info.getMeetingTitle());
        stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)info.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)info.getEndTime(), (String)"HH:mm"));
        stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
        stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(info.getContactsUserId()));
        String url = MeetingConstants.APP_MEETING_ARRANGEMENT + otMeetingRoomReservationUpForm.getId();
        SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), url, url, notifyUserByMeetingRoomId, TermTypeEnum.TERM_APP_PC.getCode(), "");
        return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OtMeetingRoomReservationPaginationExportModel otMeetingRoomReservationPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)otMeetingRoomReservationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.otMeetingRoomReservationService.exportData(otMeetingRoomReservationPaginationExportModel);
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws Exception {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == Integer.valueOf(MeetingConstants.PASS_ENABLEDMARK)) {
                List<String> userList = this.otMeetingRoomReservationService.strToList(entity.getParticipantsUserIds());
                String meetSpot = "";
                List<OtMeetingRoomEntity> infoByIdList = this.otMeetingRoomService.getInfoByIdList(entity.getMeetingRoomId());
                if (ObjectUtil.isNotEmpty(infoByIdList)) {
                    meetSpot = infoByIdList.stream().map(OtMeetingRoomEntity::getName).collect(Collectors.joining(","));
                }
                String title = "\u6709\u4f1a\u8bae\u6682\u65f6\u53d6\u6d88\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u4f1a\u8bae\u4e3b\u9898\uff1a" + entity.getMeetingTitle());
                stringBuffer.append("\n\u4f1a\u8bae\u65f6\u95f4\uff1a" + DateUtil.format((Date)entity.getStartTime(), (String)"MM-dd HH:mm") + " - " + DateUtil.format((Date)entity.getEndTime(), (String)"HH:mm"));
                stringBuffer.append("\n\u4f1a\u8bae\u5730\u70b9\uff1a" + meetSpot);
                stringBuffer.append("\n\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\uff1a" + this.baseDataUtil.userSelectValue(entity.getContactsUserId()));
                String url = MeetingConstants.APP_MEETING_ARRANGEMENT + entity.getId();
                SendMessageUtil.newSendMessage("\u4f1a\u8bae\u7533\u8bf7", MeetingConstants.NEW_MEETMSG_CODE, title, stringBuffer.toString(), url, url, userList, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            this.otMeetingRoomReservationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/meetingSign"})
    @DSTransactional
    public ActionResult meetingSign(@RequestBody OtMeetingSignEntity entity) {
        Boolean aBoolean = this.otMeetingRoomReservationService.updateSignStatus(entity);
        if (aBoolean.booleanValue()) {
            return ActionResult.success((String)"\u7b7e\u5230\u6210\u529f!");
        }
        return ActionResult.success((String)"\u7b7e\u5230\u5931\u8d25!");
    }

    public List<String> getParticipantsUserIds(String ids) {
        ArrayList<String> userIds = new ArrayList<String>();
        ids = ids.replaceAll("\"", "").replace("[", "").replace("]", "");
        String[] split = ids.split(",");
        List jsonToList = JsonUtil.getJsonToList((Object)split, String.class);
        userIds.addAll(jsonToList);
        return userIds;
    }

    public static <T> Predicate<T> distinctByProperty(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @PostMapping(value={"/meetingDelay"})
    public ActionResult meetingDelay(@RequestBody OtMeetingRoomReservationUpForm entity) throws Exception {
        this.otMeetingRoomReservationService.meetingDelayHandle(entity);
        return ActionResult.success((String)"\u5ef6\u8fdf\u6210\u529f\uff01");
    }

    @PostMapping(value={"/getMeetingListByparticipantsUserIds"})
    @DSTransactional
    public ActionResult getMeetingListByparticipantsUserIds(@RequestBody @Valid OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) throws DataException {
        List<String> meetingListByparticipantsUserIds = this.otMeetingRoomReservationService.getMeetingListByparticipantsUserIds(otMeetingRoomReservationCrForm);
        ArrayList<String> userList = new ArrayList<String>();
        for (String meetingListByparticipantsUserId : meetingListByparticipantsUserIds) {
            String s = this.baseDataUtil.userSelectValue(meetingListByparticipantsUserId);
            userList.add(s);
        }
        if (ObjectUtil.isNotEmpty(userList)) {
            return ActionResult.success((String)"duplication", userList);
        }
        return ActionResult.success((String)"success");
    }
}

