/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.meeting.entity.OtMeetingGroupEntity;
import com.bringspring.meeting.entity.OtMeetingGroupLogEntity;
import com.bringspring.meeting.entity.OtMeetingGroupRecordEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.mapper.OtMeetingGroupMapper;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupCrForm;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupListVO;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupPagination;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupPaginationExportModel;
import com.bringspring.meeting.model.otMeetingGroup.OtMeetingGroupUpForm;
import com.bringspring.meeting.model.otmeetinggrouplog.OtMeetingGroupLogPagination;
import com.bringspring.meeting.service.OtMeetingGroupLogService;
import com.bringspring.meeting.service.OtMeetingGroupRecordService;
import com.bringspring.meeting.service.OtMeetingGroupService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.BussinessMeetingEnum;
import com.bringspring.meeting.utils.DateUtils;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingGroupServiceImpl
extends ServiceImpl<OtMeetingGroupMapper, OtMeetingGroupEntity>
implements OtMeetingGroupService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OtMeetingGroupLogService otMeetingGroupLogService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OtMeetingGroupRecordService otMeetingGroupRecordService;

    @Override
    public List<OtMeetingGroupEntity> getList(OtMeetingGroupPagination otMeetingGroupPagination) {
        QueryWrapper<OtMeetingGroupEntity> otMeetingGroupEntityQueryWrapper = this.appendWrapper(otMeetingGroupPagination);
        Page page = new Page(otMeetingGroupPagination.getCurrentPage(), otMeetingGroupPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupEntityQueryWrapper);
        return otMeetingGroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<OtMeetingGroupListVO> getParentChildList(OtMeetingGroupPagination otMeetingGroupPagination) {
        List<OtMeetingGroupEntity> list = this.getList(otMeetingGroupPagination);
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupListVO.class);
        Date beginDayOfWeek = DateUtil.getBeginDayOfWeek();
        Date endDayOfWeek = DateUtil.getEndDayOfWeek();
        if (ObjectUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime())) {
            Date formatDate = DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0));
            HashMap<String, Date> weekStartAndEnd = DateUtils.getWeekStartAndEnd(DateUtil.dateAddDays((Date)formatDate, (int)-7));
            beginDayOfWeek = weekStartAndEnd.get("startOfWeek");
            endDayOfWeek = weekStartAndEnd.get("endOfWeek");
        }
        List<OtMeetingGroupRecordEntity> submitRecord = this.getCommitWorkListByType("submitRecord");
        for (OtMeetingGroupListVO otMeetingGroupListVO : listVO) {
            otMeetingGroupListVO.setDataLevel(1);
            this.updateListVoEntity(otMeetingGroupListVO, beginDayOfWeek, endDayOfWeek, submitRecord);
            List<OtMeetingGroupListVO> planListByParentId = this.getPlanListByParentId(otMeetingGroupListVO.getId(), 1, otMeetingGroupPagination);
            List childList = JsonUtil.getJsonToList(planListByParentId, OtMeetingGroupListVO.class);
            if (!ObjectUtil.isNotEmpty((Object)childList)) continue;
            for (OtMeetingGroupListVO infoVO : childList) {
                infoVO.setDataLevel(2);
                this.updateListVoEntity(infoVO, beginDayOfWeek, endDayOfWeek, submitRecord);
                if (CollectionUtil.isNotEmpty(infoVO.getChildren())) {
                    Date finalBeginDayOfWeek = beginDayOfWeek;
                    Date finalEndDayOfWeek = endDayOfWeek;
                    infoVO.getChildren().stream().forEach(i -> {
                        i.setIsChild(true);
                        i.setDataLevel(3);
                        this.updateListVoEntity((OtMeetingGroupListVO)i, finalBeginDayOfWeek, finalEndDayOfWeek, submitRecord);
                    });
                    continue;
                }
                infoVO.setIsChild(true);
            }
            otMeetingGroupListVO.setChildren(childList);
            if (childList.size() <= 1) continue;
            otMeetingGroupListVO.setDisplayHistory(true);
        }
        return listVO;
    }

    @Override
    public HashMap<String, Object> countWorkAmoumt(OtMeetingGroupPagination otMeetingGroupPagination) {
        QueryWrapper<OtMeetingGroupEntity> otMeetingGroupEntityQueryWrapper = this.appendWrapper(otMeetingGroupPagination);
        List list = this.list((Wrapper)otMeetingGroupEntityQueryWrapper);
        Integer totalAmount = 0;
        Integer delayAmount = 0;
        Integer importantAmount = 0;
        Integer dubanAmount = 0;
        if (ObjectUtil.isNotEmpty((Object)list)) {
            totalAmount = list.size();
            delayAmount = list.stream().filter(i -> StrUtil.equals((CharSequence)i.getEnabledMark(), (CharSequence)"delay")).collect(Collectors.toList()).size();
            importantAmount = list.stream().filter(i -> StrUtil.equals((CharSequence)i.getIsImportant(), (CharSequence)"1")).collect(Collectors.toList()).size();
            dubanAmount = list.stream().filter(i -> StrUtil.equals((CharSequence)i.getWorkType(), (CharSequence)BussinessMeetingEnum.LEADER_ARRANGEMENT_PLAN.getType())).collect(Collectors.toList()).size();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("totalAmount", totalAmount);
        hashMap.put("delayAmount", delayAmount);
        hashMap.put("importantAmount", importantAmount);
        hashMap.put("dubanAmount", dubanAmount);
        return hashMap;
    }

    @Override
    public List<OtMeetingGroupEntity> getTypeList(OtMeetingGroupPagination otMeetingGroupPagination, String dataType) {
        QueryWrapper<OtMeetingGroupEntity> otMeetingGroupEntityQueryWrapper = this.appendWrapper(otMeetingGroupPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(otMeetingGroupPagination.getCurrentPage(), otMeetingGroupPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupEntityQueryWrapper);
            return otMeetingGroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)otMeetingGroupEntityQueryWrapper);
    }

    @Override
    public DownloadVO exportMeetingGroupData(OtMeetingGroupPaginationExportModel otMeetingGroupPaginationExportModel) {
        OtMeetingGroupPagination otMeetingGroupPagination = (OtMeetingGroupPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPaginationExportModel), OtMeetingGroupPagination.class));
        List<OtMeetingGroupEntity> list = this.getTypeList(otMeetingGroupPagination, otMeetingGroupPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OtMeetingGroupListVO.class);
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        for (OtMeetingGroupListVO otMeetingGroupListVO : listVO) {
            List entities = departmentEntities.stream().filter(i -> StrUtil.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupListVO.getResponsibleDepartment())).collect(Collectors.toList());
            otMeetingGroupListVO.setResponsibleDepartment(ObjectUtil.isNotEmpty(entities) ? ((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName() : otMeetingGroupListVO.getResponsibleDepartment());
            otMeetingGroupListVO.setEnabledMark(this.baseDataUtil.getDictName(otMeetingGroupListVO.getEnabledMark(), "workState"));
            otMeetingGroupListVO.setPlanMonthStr(DateUtil.daFormat((Date)otMeetingGroupListVO.getPlanMonth()));
            otMeetingGroupListVO.setPlanEndtimeStr(ObjectUtil.isNotEmpty((Object)otMeetingGroupListVO.getPlanEndtime()) ? DateUtil.daFormat((Date)otMeetingGroupListVO.getPlanEndtime()) : "");
            if (StrUtil.isBlank((CharSequence)otMeetingGroupListVO.getIsImportant())) continue;
            otMeetingGroupListVO.setIsImportant(StrUtil.equals((CharSequence)otMeetingGroupListVO.getIsImportant(), (CharSequence)"1") ? "\u662f" : "\u5426");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)otMeetingGroupPaginationExportModel.getSelectKey()) ? otMeetingGroupPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    @Override
    public OtMeetingGroupEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingGroupEntity::getId, (Object)id);
        return (OtMeetingGroupEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OtMeetingGroupCrForm otMeetingGroupCrForm) {
        String mainId = RandomUtil.uuId();
        OtMeetingGroupEntity entity = (OtMeetingGroupEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupCrForm, OtMeetingGroupEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void batchCreate(HashMap map) {
        List crMeetingGroup;
        UserInfo userInfo = this.userProvider.get();
        Object data = map.get("dataList");
        Object type = map.get("type");
        String string = JsonUtil.getObjectToString(type).replaceAll("\"", "");
        List meetingGroupEntities = JsonUtil.getJsonToList(data, OtMeetingGroupUpForm.class);
        List otMeetingGroupCrForms = meetingGroupEntities.stream().filter(i -> StrUtil.isBlank((CharSequence)i.getId())).collect(Collectors.toList());
        List otMeetingGroupUpForms = meetingGroupEntities.stream().filter(i -> !StrUtil.isBlank((CharSequence)i.getId())).collect(Collectors.toList());
        ArrayList groupEntityList = new ArrayList();
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        if (ObjectUtil.isNotEmpty(otMeetingGroupCrForms)) {
            crMeetingGroup = JsonUtil.getJsonToList(otMeetingGroupCrForms, OtMeetingGroupEntity.class);
            ArrayList<OtMeetingGroupLogEntity> logEntityList = new ArrayList<OtMeetingGroupLogEntity>();
            for (OtMeetingGroupEntity groupEntity : crMeetingGroup) {
                List department;
                if (StrUtil.equals((CharSequence)groupEntity.getWorkType(), (CharSequence)BussinessMeetingEnum.MONTH_PLAN.getType())) {
                    if (StrUtil.isBlank((CharSequence)groupEntity.getPlanContent()) && !StrUtil.isBlank((CharSequence)groupEntity.getWorkProgress())) {
                        groupEntity.setPlanContent(groupEntity.getWorkProgress());
                    }
                    if (!StrUtil.isBlank((CharSequence)groupEntity.getPlanContent()) && StrUtil.isBlank((CharSequence)groupEntity.getWorkProgress())) {
                        groupEntity.setWorkProgress(groupEntity.getPlanContent());
                    }
                }
                if (StrUtil.isBlank((CharSequence)groupEntity.getPlanContent()) && !StrUtil.isBlank((CharSequence)groupEntity.getWorkProgress())) {
                    groupEntity.setPlanContent(groupEntity.getWorkProgress());
                }
                String mainId = RandomUtil.uuId();
                groupEntity.setId(mainId);
                if (StrUtil.isBlank((CharSequence)groupEntity.getParentId())) {
                    groupEntity.setParentId(mainId);
                }
                groupEntity.setPlanMonth(ObjectUtil.isNotEmpty((Object)groupEntity.getPlanMonth()) ? groupEntity.getPlanMonth() : new Date());
                groupEntity.setWriteDate(DateUtil.getNowDate());
                groupEntity.setDeleteMark("0");
                groupEntity.setCompanyId(userInfo.getOrganizeId());
                if (StrUtil.equals((CharSequence)groupEntity.getEnabledMark(), (CharSequence)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())) {
                    groupEntity.setActualEndtime(new Date());
                }
                if (!StrUtil.isBlank((CharSequence)groupEntity.getResponsibleDepartment()) && ObjectUtil.isNotEmpty(department = departmentEntities.stream().filter(i -> i.getId().equals(groupEntity.getResponsibleDepartment())).collect(Collectors.toList()))) {
                    groupEntity.setContactPerson(StrUtil.isBlank((CharSequence)((OtMeetingStatisticsDepartmentEntity)department.get(0)).getPropertyjson()) ? "" : ((OtMeetingStatisticsDepartmentEntity)department.get(0)).getPropertyjson());
                    groupEntity.setResponsibleLeader(StrUtil.isBlank((CharSequence)((OtMeetingStatisticsDepartmentEntity)department.get(0)).getDescription()) ? "" : ((OtMeetingStatisticsDepartmentEntity)department.get(0)).getDescription());
                }
                this.commitToHistory((OtMeetingGroupUpForm)JsonUtil.getJsonToBean((Object)groupEntity, OtMeetingGroupUpForm.class));
                OtMeetingGroupLogEntity logEntity = (OtMeetingGroupLogEntity)JsonUtil.getJsonToBean((Object)groupEntity, OtMeetingGroupLogEntity.class);
                String uuId = RandomUtil.uuId();
                logEntity.setWorkId(uuId);
                String reportVar = "";
                if (!StrUtil.isBlank((CharSequence)logEntity.getReportJingyingTimeVar())) {
                    reportVar = "\u5df2\u63d0\u4ea4\u81f3\u3010" + logEntity.getReportJingyingTimeVar() + "\u3011\u7ecf\u8425\u4f1a\u6c47\u62a5";
                }
                if (!StrUtil.isBlank((CharSequence)logEntity.getReportMonthTimeVar())) {
                    reportVar = "\u5df2\u63d0\u4ea4\u81f3\u3010" + logEntity.getReportMonthTimeVar() + "\u3011\u6708\u4f1a\u6c47\u62a5";
                }
                logEntity.setReportVar(StrUtil.isBlank((CharSequence)reportVar) ? null : reportVar);
                logEntityList.add(logEntity);
            }
            this.saveBatch(crMeetingGroup);
            this.otMeetingGroupLogService.saveBatch(logEntityList);
        }
        if (ObjectUtil.isNotEmpty(otMeetingGroupUpForms)) {
            crMeetingGroup = JsonUtil.getJsonToList(otMeetingGroupUpForms, OtMeetingGroupEntity.class);
            ArrayList<OtMeetingGroupEntity> updateGroupList = new ArrayList<OtMeetingGroupEntity>();
            if (ObjectUtil.isNotEmpty((Object)crMeetingGroup)) {
                ArrayList<String> updatedId = new ArrayList<String>();
                ArrayList selectTimeList = new ArrayList();
                ArrayList<OtMeetingGroupLogEntity> logEntityList = new ArrayList<OtMeetingGroupLogEntity>();
                for (OtMeetingGroupEntity otMeetingGroupEntity : crMeetingGroup) {
                    OtMeetingGroupLogEntity logEntity = (OtMeetingGroupLogEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupEntity, OtMeetingGroupLogEntity.class);
                    String uuId = RandomUtil.uuId();
                    OtMeetingGroupEntity entity = this.getInfo(otMeetingGroupEntity.getId());
                    if (ObjectUtil.isEmpty((Object)entity)) continue;
                    Map<String, String> compare = ObjectComparator.compare(entity, otMeetingGroupEntity);
                    ArrayList keyList = new ArrayList();
                    if (ObjectUtil.isNotEmpty(compare)) {
                        compare.keySet().stream().forEach(key -> keyList.add(key));
                    }
                    if (!ObjectUtil.isNotEmpty(keyList)) continue;
                    if (keyList.contains("enabledMark")) {
                        OtMeetingGroupEntity info = this.getInfo(otMeetingGroupEntity.getId());
                        if (StrUtil.equals((CharSequence)otMeetingGroupEntity.getEnabledMark(), (CharSequence)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())) {
                            otMeetingGroupEntity.setActualEndtime(new Date());
                        }
                        if (StrUtil.equals((CharSequence)info.getEnabledMark(), (CharSequence)BussinessMeetingEnum.PLAN_ENABLEDMARK.getType()) && StrUtil.equals((CharSequence)otMeetingGroupEntity.getEnabledMark(), (CharSequence)BussinessMeetingEnum.NORMAL_ENABLEDMARK.getType())) {
                            this.updateChildStatus(otMeetingGroupEntity);
                        }
                    }
                    otMeetingGroupEntity.setWriteDate(new Date());
                    updateGroupList.add(otMeetingGroupEntity);
                    updatedId.add(otMeetingGroupEntity.getId());
                    logEntity.setId(uuId);
                    logEntity.setWorkId(otMeetingGroupEntity.getId());
                    String reportType = "";
                    if (keyList.contains("reportJingyingTime") && !StrUtil.isBlank((CharSequence)logEntity.getReportJingyingTimeVar())) {
                        logEntity.setReportVar("\u5df2\u63d0\u4ea4\u81f3\u3010" + logEntity.getReportJingyingTimeVar() + "\u3011\u7ecf\u8425\u4f1a\u6c47\u62a5");
                        reportType = BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType();
                    }
                    if (keyList.contains("reportMonthTime") && !StrUtil.isBlank((CharSequence)logEntity.getReportMonthTimeVar())) {
                        logEntity.setReportVar("\u5df2\u63d0\u4ea4\u81f3\u3010" + logEntity.getReportMonthTimeVar() + "\u3011\u6708\u4f1a\u6c47\u62a5");
                        reportType = BussinessMeetingEnum.REPORT_TYPE_MONTH.getType();
                    }
                    String reportMonthTypeTem = otMeetingGroupEntity.getReportMonthType() + "";
                    OtMeetingGroupUpForm groupUpForm = (OtMeetingGroupUpForm)JsonUtil.getJsonToBean((Object)otMeetingGroupEntity, OtMeetingGroupUpForm.class);
                    if (keyList.contains("reportMonthType")) {
                        if (!StrUtil.isBlank((CharSequence)entity.getReportMonthType())) {
                            ArrayList<String> strings = new ArrayList<String>(Arrays.asList(entity.getReportMonthType().split(",")));
                            if (!strings.contains(otMeetingGroupEntity.getReportMonthType())) {
                                strings.add(otMeetingGroupEntity.getReportMonthType());
                            }
                            otMeetingGroupEntity.setReportMonthType(CollectionUtil.join(strings, (CharSequence)","));
                        }
                        reportType = BussinessMeetingEnum.REPORT_TYPE_MONTH.getType();
                        groupUpForm.setReportMonthType(reportMonthTypeTem);
                    }
                    logEntityList.add(logEntity);
                    if (StrUtil.isBlank((CharSequence)reportType)) continue;
                    groupUpForm.setReportType(reportType);
                    this.commitToHistory(groupUpForm);
                }
                if (ObjectUtil.isNotEmpty(logEntityList)) {
                    this.otMeetingGroupLogService.saveBatch(logEntityList);
                }
            }
            if (ObjectUtil.isNotEmpty(updateGroupList)) {
                this.updateBatchById(updateGroupList);
            }
            if (ObjectUtil.isNotEmpty(groupEntityList)) {
                this.saveBatch(groupEntityList);
            }
        }
    }

    @Override
    @DSTransactional
    public void update(String id, OtMeetingGroupUpForm otMeetingGroupUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingGroupEntity entity = this.getInfo(id);
        if (entity != null) {
            OtMeetingGroupEntity subentity = (OtMeetingGroupEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupUpForm, OtMeetingGroupEntity.class);
            subentity.setParentId(DateUtil.getNow());
            subentity.setDubanId(DateUtil.getNow());
            subentity.setResponsibleDepartment(DateUtil.getNow());
            subentity.setWorkItem(DateUtil.getNow());
            subentity.setPlanContent(DateUtil.getNow());
            subentity.setWorkProgress(DateUtil.getNow());
            subentity.setIsImportant(DateUtil.getNow());
            this.updateById(subentity);
        }
    }

    @Override
    public List<OtMeetingGroupLogEntity> getLogList(OtMeetingGroupLogPagination otMeetingGroupPagination) {
        OtMeetingGroupPagination jsonToBean = (OtMeetingGroupPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)otMeetingGroupPagination), OtMeetingGroupPagination.class));
        QueryWrapper<OtMeetingGroupEntity> otMeetingGroupEntityQueryWrapper = this.appendWrapper(jsonToBean);
        List list = this.list((Wrapper)otMeetingGroupEntityQueryWrapper);
        List stringList = list.stream().map(OtMeetingGroupEntity::getId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(stringList)) {
            return new ArrayList<OtMeetingGroupLogEntity>();
        }
        QueryWrapper otMeetingGroupLogQueryWrapper = new QueryWrapper();
        otMeetingGroupLogQueryWrapper.lambda().in(OtMeetingGroupLogEntity::getWorkId, stringList);
        if (StringUtils.isNotEmpty(otMeetingGroupPagination.getSelectTimeList())) {
            List<String> PlanMonthList = otMeetingGroupPagination.getSelectTimeList();
            Long fir = Long.valueOf(PlanMonthList.get(0));
            Long sec = Long.valueOf(PlanMonthList.get(1));
            ((LambdaQueryWrapper)otMeetingGroupLogQueryWrapper.lambda().ge(OtMeetingGroupLogEntity::getCreatorTime, (Object)new Date(fir))).le(OtMeetingGroupLogEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        ((LambdaQueryWrapper)otMeetingGroupLogQueryWrapper.lambda().orderBy(true, false, OtMeetingGroupLogEntity::getWorkId)).orderBy(true, false, OtMeetingGroupLogEntity::getCreatorTime);
        Page page = new Page(otMeetingGroupPagination.getCurrentPage(), otMeetingGroupPagination.getPageSize());
        IPage userIPage = this.otMeetingGroupLogService.page((IPage)page, (Wrapper)otMeetingGroupLogQueryWrapper);
        return otMeetingGroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<OtMeetingGroupListVO> getPlanListByParentId(String parentId, Integer index, OtMeetingGroupPagination otMeetingGroupPagination) {
        QueryWrapper otMeetingGroupQueryWrapper = new QueryWrapper();
        otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getParentId, (Object)parentId);
        if (otMeetingGroupPagination != null) {
            List<OtMeetingGroupRecordEntity> reportListByTypeAndDate;
            ArrayList recordList;
            if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType()) && StrUtil.equals((CharSequence)otMeetingGroupPagination.getSwitchType(), (CharSequence)"2")) {
                recordList = new ArrayList();
                if (CollectionUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime()) && otMeetingGroupPagination.getSelectByReportTime().size() > 0) {
                    reportListByTypeAndDate = this.getReportListByTypeAndDate(BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType(), DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0)), DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(1)), null);
                    recordList.addAll(reportListByTypeAndDate.stream().map(i -> i.getWorkId()).collect(Collectors.toList()));
                } else {
                    reportListByTypeAndDate = this.getReportListByTypeAndDate(BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType(), null, null, null);
                    recordList.addAll(reportListByTypeAndDate.stream().map(i -> i.getWorkId()).collect(Collectors.toList()));
                }
                ((LambdaQueryWrapper)otMeetingGroupQueryWrapper.lambda().in(OtMeetingGroupEntity::getId, recordList)).ne(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.LEADER_ARRANGEMENT_PLAN.getType());
            }
            if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_MONTH.getType())) {
                recordList = new ArrayList();
                if (CollectionUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime()) && otMeetingGroupPagination.getSelectByReportTime().size() > 0) {
                    reportListByTypeAndDate = this.getReportListByTypeAndDate(BussinessMeetingEnum.REPORT_TYPE_MONTH.getType(), DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0)), DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(1)), otMeetingGroupPagination.getPlanType());
                    recordList.addAll(reportListByTypeAndDate.stream().map(i -> i.getWorkId()).collect(Collectors.toList()));
                } else {
                    reportListByTypeAndDate = this.getReportListByTypeAndDate(BussinessMeetingEnum.REPORT_TYPE_MONTH.getType(), null, null, otMeetingGroupPagination.getPlanType());
                    recordList.addAll(reportListByTypeAndDate.stream().map(i -> i.getWorkId()).collect(Collectors.toList()));
                }
                otMeetingGroupQueryWrapper.lambda().and(wrapper -> wrapper.in(OtMeetingGroupEntity::getId, (Collection)recordList));
            }
        }
        Date beginDayOfWeek = DateUtil.getBeginDayOfWeek();
        Date endDayOfWeek = DateUtil.getEndDayOfWeek();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(BussinessMeetingEnum.DELAY_ENABLEDMARK.getType());
        arrayList.add(BussinessMeetingEnum.NORMAL_ENABLEDMARK.getType());
        arrayList.add(BussinessMeetingEnum.PLAN_ENABLEDMARK.getType());
        if (index == 2) {
            otMeetingGroupQueryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.between(OtMeetingGroupEntity::getPlanMonth, (Object)beginDayOfWeek, (Object)endDayOfWeek)).or(wq1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wq1.between(OtMeetingGroupEntity::getPlanEndtime, (Object)beginDayOfWeek, (Object)endDayOfWeek);
                })).or(wq1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wq1.between(OtMeetingGroupEntity::getActualEndtime, (Object)beginDayOfWeek, (Object)endDayOfWeek);
                })).or(wq1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wq1.le(OtMeetingGroupEntity::getPlanMonth, (Object)beginDayOfWeek)).ge(OtMeetingGroupEntity::getPlanEndtime, (Object)endDayOfWeek);
                })).or(wq1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wq1.in(OtMeetingGroupEntity::getEnabledMark, (Collection)arrayList);
                });
            });
        }
        this.applyCustomSorting((QueryWrapper<OtMeetingGroupEntity>)otMeetingGroupQueryWrapper, "2");
        List planList = this.list((Wrapper)otMeetingGroupQueryWrapper);
        List listVOS = JsonUtil.getJsonToList((Object)planList, OtMeetingGroupListVO.class);
        Integer n = index;
        Integer n2 = index = Integer.valueOf(index + 1);
        for (OtMeetingGroupListVO plan : listVOS) {
            if (index > 2) continue;
            List<OtMeetingGroupListVO> children = this.getPlanListByParentId(plan.getId(), index, otMeetingGroupPagination);
            if (!children.isEmpty()) {
                plan.setChildren(children);
                continue;
            }
            plan.setIsChild(true);
        }
        return listVOS;
    }

    private void applyCustomSorting(QueryWrapper<OtMeetingGroupEntity> queryWrapper, String switchType) {
        QueryWrapper departmentEntityQueryWrapper = new QueryWrapper();
        if (StrUtil.equals((CharSequence)switchType, (CharSequence)"1")) {
            departmentEntityQueryWrapper.lambda().orderByAsc(OtMeetingStatisticsDepartmentEntity::getDupanSort);
        } else {
            departmentEntityQueryWrapper.lambda().orderByAsc(OtMeetingStatisticsDepartmentEntity::getImportantSort);
        }
        List list = this.otMeetingStatisticsDepartmentService.list((Wrapper)departmentEntityQueryWrapper);
        String depList = list.stream().map(OtMeetingStatisticsDepartmentEntity::getId).collect(Collectors.joining(","));
        String fullSortSql = "";
        String dubanEnabledMarkSort = " CASE  WHEN enabled_mark = 'delay' THEN 1  WHEN enabled_mark = 'delayComplete' THEN 2  WHEN enabled_mark = 'completed' THEN 3  WHEN enabled_mark = 'normal' THEN 4  WHEN enabled_mark = 'plan' THEN 5  WHEN enabled_mark = 'checkAndAccept' THEN 6  WHEN enabled_mark = 'discontinue' THEN 7  WHEN enabled_mark = 'termination' THEN 8  WHEN enabled_mark = 'reject' THEN 9  ELSE 10  END, ";
        if (StrUtil.equals((CharSequence)switchType, (CharSequence)"3")) {
            fullSortSql = "order by FIELD(responsible_department, " + depList + "),  CASE  WHEN enabled_mark IN ('delay', 'normal', 'plan') THEN 0  WHEN enabled_mark = 'discontinue' THEN 1  WHEN enabled_mark = 'delayComplete' THEN 2  WHEN enabled_mark = 'completed' THEN 3  WHEN enabled_mark = 'checkAndAccept' THEN 4  WHEN enabled_mark = 'termination' THEN 5  else 6  end ,  CASE WHEN enabled_mark IN ('delay', 'normal', 'plan') THEN   CASE work_type WHEN 'leaderArrangement' THEN 0  WHEN 'weekPlan' THEN 1  ELSE 2  END  WHEN enabled_mark IN ('delayComplete', 'completed') THEN  -UNIX_TIMESTAMP(actual_endtime)  WHEN enabled_mark IN ('checkAndAccept', 'discontinue', 'termination') THEN -UNIX_TIMESTAMP(last_modify_time)  ELSE 0  END,  CASE WHEN enabled_mark IN ('delay', 'normal', 'plan') THEN  CASE enabled_mark  WHEN 'delay' THEN 0  WHEN 'normal' THEN 1  WHEN 'plan' THEN 2  ELSE 3  END  ELSE 0  END,  CASE WHEN enabled_mark = 'delay' THEN plan_endtime ELSE NULL END,  CASE WHEN enabled_mark = 'normal' THEN plan_month ELSE NULL END DESC,  CASE WHEN enabled_mark = 'plan' THEN plan_month ELSE NULL END";
        } else if (StrUtil.equals((CharSequence)switchType, (CharSequence)"1")) {
            fullSortSql = "order by" + dubanEnabledMarkSort + " FIELD(responsible_department, " + depList + "), CASE WHEN enabled_mark = 'delay' THEN plan_endtime ELSE NULL END ASC, CASE WHEN enabled_mark = 'delayComplete' THEN actual_endtime ELSE NULL END DESC, CASE WHEN enabled_mark = 'normal' THEN plan_month ELSE NULL END DESC, CASE WHEN enabled_mark = 'plan' THEN plan_month ELSE NULL END ASC, CASE WHEN enabled_mark = 'completed' THEN actual_endtime ELSE NULL END ASC, CASE WHEN enabled_mark = 'checkAndAccept' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'discontinue' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'termination' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'reject' THEN last_modify_time ELSE NULL END DESC, creator_time DESC";
        } else if (StrUtil.equals((CharSequence)switchType, (CharSequence)"2")) {
            fullSortSql = "order by FIELD(responsible_department, " + depList + "), " + dubanEnabledMarkSort + "CASE WHEN enabled_mark = 'delay' THEN plan_endtime ELSE NULL END ASC, CASE WHEN enabled_mark = 'delayComplete' THEN actual_endtime ELSE NULL END DESC, CASE WHEN enabled_mark = 'completed' THEN actual_endtime ELSE NULL END ASC, CASE WHEN enabled_mark = 'normal' THEN plan_month ELSE NULL END DESC, CASE WHEN enabled_mark = 'plan' THEN plan_month ELSE NULL END ASC, CASE WHEN enabled_mark = 'checkAndAccept' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'discontinue' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'termination' THEN last_modify_time ELSE NULL END DESC, CASE WHEN enabled_mark = 'reject' THEN last_modify_time ELSE NULL END DESC, creator_time DESC";
        }
        if (!StrUtil.isBlank((CharSequence)fullSortSql)) {
            queryWrapper.last(fullSortSql);
        }
        String sqlSegment = queryWrapper.getSqlSegment();
        System.out.println("SQL\u6761\u4ef6\u90e8\u5206: " + sqlSegment);
    }

    private String getEnabledMarkSort(String switchType) {
        String dubanEnabledMarkSort = "order by CASE  WHEN enabled_mark = 'delay' THEN 1  WHEN enabled_mark = 'delayComplete' THEN 2  WHEN enabled_mark = 'normal' THEN 3  WHEN enabled_mark = 'plan' THEN 4  WHEN enabled_mark = 'completed' THEN 5  WHEN enabled_mark = 'checkAndAccept' THEN 6  WHEN enabled_mark = 'discontinue' THEN 7  WHEN enabled_mark = 'termination' THEN 8  WHEN enabled_mark = 'reject' THEN 9  ELSE 10  END, ";
        String planEnabledMarkSort = "order by CASE  WHEN enabled_mark = 'delay' THEN 1  WHEN enabled_mark = 'normal' THEN 2  WHEN enabled_mark = 'plan' THEN 3  WHEN enabled_mark = 'delayComplete' THEN 4  WHEN enabled_mark = 'completed' THEN 5  WHEN enabled_mark = 'checkAndAccept' THEN 6  WHEN enabled_mark = 'discontinue' THEN 7  WHEN enabled_mark = 'termination' THEN 8  WHEN enabled_mark = 'reject' THEN 9  ELSE 10  END, ";
        return StrUtil.equals((CharSequence)switchType, (CharSequence)"3") ? planEnabledMarkSort : dubanEnabledMarkSort;
    }

    @Override
    public void cancelReport(String id, String reportType) {
        OtMeetingGroupEntity entity = this.getInfo(id);
        String cancelVar = "";
        if (StrUtil.equals((CharSequence)reportType, (CharSequence)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType())) {
            cancelVar = "\u53d6\u6d88\u3010" + entity.getReportJingyingTimeVar() + "\u3011\u7ecf\u8425\u4f1a\u6c47\u62a5";
            entity.setReportJingying(null);
            entity.setReportJingyingTime(null);
            entity.setReportJingyingTimeVar(null);
        } else {
            cancelVar = "\u53d6\u6d88\u3010" + entity.getReportMonthTimeVar() + "\u3011\u6708\u4f1a\u6c47\u62a5";
            entity.setIsMonthReport(0);
            entity.setReportMonthTime(null);
            entity.setReportMonthTimeVar(null);
        }
        OtMeetingGroupLogEntity logEntity = (OtMeetingGroupLogEntity)JsonUtil.getJsonToBean((Object)entity, OtMeetingGroupLogEntity.class);
        logEntity.setId(RandomUtil.uuId());
        logEntity.setWorkId(entity.getId());
        logEntity.setReportVar(cancelVar);
        this.updateById(entity);
        this.otMeetingGroupLogService.save(logEntity);
    }

    @Override
    public List<OtMeetingGroupEntity> getLogPlanListById(String workId) {
        List<OtMeetingGroupLogEntity> listByWorkId = this.otMeetingGroupLogService.getListByWorkId(workId);
        ArrayList<OtMeetingGroupEntity> meetingGroupEntityList = new ArrayList<OtMeetingGroupEntity>();
        if (ObjectUtil.isNotEmpty(listByWorkId)) {
            meetingGroupEntityList.addAll(JsonUtil.getJsonToList(listByWorkId, OtMeetingGroupEntity.class));
        }
        return meetingGroupEntityList;
    }

    @Override
    public HashMap<String, Object> countPlanNumber(OtMeetingGroupPagination otMeetingGroupPagination) {
        otMeetingGroupPagination.setSelectTimeList(new ArrayList<String>());
        otMeetingGroupPagination.setSwitchType("1");
        List<OtMeetingGroupEntity> dubanEntites = this.getList(otMeetingGroupPagination);
        otMeetingGroupPagination.setSwitchType("2");
        List<OtMeetingGroupEntity> zhongdianEntites = this.getList(otMeetingGroupPagination);
        Date beginDayOfLastWeek = DateUtil.getBeginDayOfLastWeek();
        Date endDayOfLastWeek = DateUtil.getEndDayOfLastWeek();
        HashMap<String, Object> dubanMap = new HashMap<String, Object>();
        List tuijinList = dubanEntites.stream().filter(i -> i.getWriteDate().after(beginDayOfLastWeek) && i.getWriteDate().before(endDayOfLastWeek)).collect(Collectors.toList());
        Integer noAdvanceItem = 0;
        if (ObjectUtil.isNotEmpty(tuijinList)) {
            noAdvanceItem = dubanEntites.size() - tuijinList.size();
        }
        List wanchengList = dubanEntites.stream().filter(i -> StrUtil.equals((CharSequence)i.getEnabledMark(), (CharSequence)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())).collect(Collectors.toList());
        List delayList = dubanEntites.stream().filter(i -> StrUtil.equals((CharSequence)i.getEnabledMark(), (CharSequence)BussinessMeetingEnum.DELAY_ENABLEDMARK.getType())).collect(Collectors.toList());
        Integer delayItem = 0;
        if (ObjectUtil.isNotEmpty(delayList)) {
            delayItem = delayList.size();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f53\u524d\u4e8b\u9879" + dubanEntites.size() + "\u9879\uff0c\u4e0a\u5468\u63a8\u8fdb" + tuijinList.size() + "\u9879, \u672a\u63a8\u8fdb" + noAdvanceItem + "\u9879\uff0c\u5b8c\u6210" + wanchengList.size() + "\u9879\uff0c\u672a\u5b8c\u6210" + (dubanEntites.size() - wanchengList.size()) + "\u9879, \u5ef6\u8fdf" + delayItem + "\u9879\u3002");
        dubanMap.put("duban", stringBuffer.toString());
        List wanchengListDuban = zhongdianEntites.stream().filter(i -> StrUtil.equals((CharSequence)i.getEnabledMark(), (CharSequence)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())).collect(Collectors.toList());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\u5f53\u524d\u4e8b\u9879" + zhongdianEntites.size() + "\u9879\uff0c\u4e0a\u5468\u63a8\u8fdb" + zhongdianEntites.size() + "\u9879\uff0c\u5b8c\u6210" + wanchengListDuban.size() + "\u9879\uff0c\u672a\u5b8c\u6210" + (zhongdianEntites.size() - wanchengListDuban.size()) + "\u9879\u3002");
        dubanMap.put("zhongdian", stringBuffer2.toString());
        return dubanMap;
    }

    @Override
    public void scheduledUpdatePlanMark() {
        QueryWrapper otMeetingGroupQueryWrapper = new QueryWrapper();
        otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.NORMAL_ENABLEDMARK.getType());
        List groupEntityList = this.list((Wrapper)otMeetingGroupQueryWrapper);
        Date endDayOfYesterday = DateUtil.getEndDayOfYesterday();
        ArrayList<OtMeetingGroupEntity> updategroupEntityList = new ArrayList<OtMeetingGroupEntity>();
        ArrayList<OtMeetingGroupLogEntity> logEntityList = new ArrayList<OtMeetingGroupLogEntity>();
        for (OtMeetingGroupEntity groupEntity : groupEntityList) {
            if (!ObjectUtil.isNotEmpty((Object)groupEntity.getPlanEndtime()) || !groupEntity.getPlanEndtime().before(endDayOfYesterday)) continue;
            groupEntity.setEnabledMark(BussinessMeetingEnum.DELAY_ENABLEDMARK.getType());
            groupEntity.setLastModifyTime(new Date());
            updategroupEntityList.add(groupEntity);
            OtMeetingGroupLogEntity logEntity = (OtMeetingGroupLogEntity)JsonUtil.getJsonToBean((Object)groupEntity, OtMeetingGroupLogEntity.class);
            logEntity.setId(RandomUtil.uuId());
            logEntity.setWorkId(groupEntity.getId());
            logEntity.setDescription("\u5b9a\u65f6\u4efb\u52a1\u66f4\u65b0\u4e3a\u5ef6\u671f\u72b6\u6001");
            logEntityList.add(logEntity);
        }
        this.updateBatchById(updategroupEntityList);
        this.otMeetingGroupLogService.saveBatch(logEntityList);
    }

    @Override
    public List<OtMeetingGroupEntity> coordinationTransferDuban(OtMeetingGroupUpForm entity) {
        return null;
    }

    @Override
    public void updateChildStatus(OtMeetingGroupEntity meetingGroupUpForm) {
        OtMeetingGroupEntity info;
        ArrayList<OtMeetingGroupEntity> list = new ArrayList<OtMeetingGroupEntity>();
        if (!StrUtil.isBlank((CharSequence)meetingGroupUpForm.getParentId()) && !StrUtil.equals((CharSequence)meetingGroupUpForm.getParentId(), (CharSequence)"-1") && (info = this.getInfo(meetingGroupUpForm.getParentId())) != null && StrUtil.equals((CharSequence)info.getEnabledMark(), (CharSequence)BussinessMeetingEnum.PLAN_ENABLEDMARK.getType())) {
            OtMeetingGroupEntity info2;
            info.setEnabledMark(meetingGroupUpForm.getEnabledMark());
            list.add(info);
            if (!StrUtil.isBlank((CharSequence)info.getParentId()) && !StrUtil.equals((CharSequence)info.getParentId(), (CharSequence)"-1") && (info2 = this.getInfo(info.getParentId())) != null && StrUtil.equals((CharSequence)info2.getEnabledMark(), (CharSequence)BussinessMeetingEnum.PLAN_ENABLEDMARK.getType())) {
                info2.setEnabledMark(meetingGroupUpForm.getEnabledMark());
                list.add(info2);
            }
        }
        if (list.size() > 0) {
            this.updateBatchById(list);
        }
    }

    @Override
    public List<OtMeetingGroupEntity> getChildRecords(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date beginDayOfWeek = DateUtil.getBeginDayOfWeek();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupEntity::getParentId, (Object)parentId)).le(OtMeetingGroupEntity::getPlanEndtime, (Object)beginDayOfWeek)).notIn(OtMeetingGroupEntity::getEnabledMark, new Object[]{BussinessMeetingEnum.PLAN_ENABLEDMARK.getType(), BussinessMeetingEnum.NORMAL_ENABLEDMARK.getType(), BussinessMeetingEnum.DELAY_ENABLEDMARK.getType()});
        queryWrapper.lambda().orderByAsc(OtMeetingGroupEntity::getPlanMonth);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void commitToHistory(OtMeetingGroupUpForm otMeetingGroup) {
        if (ObjectUtil.isEmpty((Object)otMeetingGroup)) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)otMeetingGroup.getReportJingying()) && otMeetingGroup.getIsMonthReport() == null || StrUtil.isBlank((CharSequence)otMeetingGroup.getReportJingying()) && otMeetingGroup.getIsMonthReport() == 0) {
            return;
        }
        OtMeetingGroupRecordEntity recordEntity = new OtMeetingGroupRecordEntity();
        recordEntity.setId(RandomUtil.uuId());
        recordEntity.setWorkId(otMeetingGroup.getId());
        if (StrUtil.equals((CharSequence)otMeetingGroup.getReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_MONTH.getType()) || otMeetingGroup.getIsMonthReport() == 1) {
            recordEntity.setReportType(BussinessMeetingEnum.REPORT_TYPE_MONTH.getType());
            recordEntity.setReportTime(DateUtil.daFormatDate((Long)otMeetingGroup.getReportMonthTime()));
            recordEntity.setReportTimeVar(otMeetingGroup.getReportMonthTimeVar());
            recordEntity.setReportMonthType(otMeetingGroup.getReportMonthType());
        } else {
            recordEntity.setReportType(BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType());
            recordEntity.setReportTime(DateUtil.daFormatDate((Long)otMeetingGroup.getReportJingyingTime()));
            recordEntity.setReportTimeVar(otMeetingGroup.getReportJingyingTimeVar());
        }
        recordEntity.setOperateType(BussinessMeetingEnum.RECORD_SUBMIT_TYPE.getType());
        recordEntity.setDeleteMark("0");
        recordEntity.setCompanyId(String.valueOf(this.userProvider.get().getOrganizeId()));
        this.otMeetingGroupRecordService.save(recordEntity);
    }

    @Override
    public List<OtMeetingGroupRecordEntity> getCommitWorkList(OtMeetingGroupPagination otMeetingGroupPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getReportType, (Object)otMeetingGroupPagination.getReportType());
        if (!StrUtil.isBlank((CharSequence)otMeetingGroupPagination.getPlanType())) {
            queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getReportMonthType, (Object)otMeetingGroupPagination.getPlanType());
        }
        if (otMeetingGroupPagination.getSelectByReportTime() != null && otMeetingGroupPagination.getSelectByReportTime().size() > 0) {
            Date begin = DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0));
            Date end = DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(1));
            queryWrapper.lambda().between(OtMeetingGroupRecordEntity::getReportTime, (Object)begin, (Object)end);
        }
        return this.otMeetingGroupRecordService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingGroupRecordEntity> getCommitWorkListByType(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getOperateType, (Object)type)).eq(OtMeetingGroupRecordEntity::getDeleteMark, (Object)0);
        return this.otMeetingGroupRecordService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OtMeetingGroupRecordEntity> getSubmitDateByWorkId(String workid, String reportType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getOperateType, (Object)"submitRecord")).eq(OtMeetingGroupRecordEntity::getReportType, (Object)reportType)).eq(OtMeetingGroupRecordEntity::getDeleteMark, (Object)0)).eq(OtMeetingGroupRecordEntity::getWorkId, (Object)workid);
        return this.otMeetingGroupRecordService.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean cancelReport(String id, String reportType, String cancelDate) {
        List<String> stringList = Arrays.asList(cancelDate.split(","));
        if (stringList.size() <= 0) {
            return false;
        }
        OtMeetingGroupEntity otMeetingGroupEntity = this.getInfo(id);
        if (otMeetingGroupEntity == null) {
            return false;
        }
        if (StrUtil.equals((CharSequence)reportType, (CharSequence)BussinessMeetingEnum.REPORT_TYPE_MONTH.getType())) {
            if (stringList.contains(otMeetingGroupEntity.getReportMonthTimeVar())) {
                otMeetingGroupEntity.setReportMonthTimeVar(null);
                otMeetingGroupEntity.setReportMonthTime(null);
                otMeetingGroupEntity.setIsMonthReport(0);
                otMeetingGroupEntity.setReportMonthType(null);
                this.updateById(otMeetingGroupEntity);
            }
        } else if (stringList.contains(otMeetingGroupEntity.getReportJingyingTimeVar())) {
            otMeetingGroupEntity.setReportJingying(null);
            otMeetingGroupEntity.setReportJingyingTimeVar(null);
            otMeetingGroupEntity.setReportJingying(null);
            this.updateById(otMeetingGroupEntity);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getWorkId, (Object)id)).eq(OtMeetingGroupRecordEntity::getReportType, (Object)reportType)).in(OtMeetingGroupRecordEntity::getReportTimeVar, stringList);
        this.otMeetingGroupRecordService.remove((Wrapper)queryWrapper);
        return true;
    }

    @Override
    public List<OtMeetingGroupRecordEntity> getReportListByTypeAndDate(String reportType, Date begin, Date end, String planType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getReportType, (Object)reportType);
        if (begin != null && end != null) {
            queryWrapper.lambda().between(OtMeetingGroupRecordEntity::getReportTime, (Object)begin, (Object)end);
        }
        if (!StrUtil.isBlank((CharSequence)planType)) {
            queryWrapper.lambda().eq(OtMeetingGroupRecordEntity::getReportMonthType, (Object)planType);
        }
        return this.otMeetingGroupRecordService.list((Wrapper)queryWrapper);
    }

    @Override
    public HashMap<String, Object> getMonthMeetingList(OtMeetingGroupPagination otMeetingGroupPagination) {
        otMeetingGroupPagination.setPlanType("workProgress");
        List<OtMeetingGroupListVO> workProgressList = this.getParentChildList(otMeetingGroupPagination);
        otMeetingGroupPagination.setPlanType("plan");
        otMeetingGroupPagination.setReportType(BussinessMeetingEnum.MONTH_MEETING_PAGE.getType());
        List<OtMeetingGroupListVO> planList = this.getParentChildList(otMeetingGroupPagination);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workProgressList", workProgressList);
        map.put("planList", planList);
        return map;
    }

    @Override
    @DSTransactional
    public void delete(OtMeetingGroupEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public QueryWrapper<OtMeetingGroupEntity> appendWrapper(OtMeetingGroupPagination otMeetingGroupPagination) {
        Date secDate;
        Date firDate;
        Long sec;
        Long fir;
        List<String> PlanMonthList;
        QueryWrapper otMeetingGroupQueryWrapper = new QueryWrapper();
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        boolean total = false;
        int otMeetingGroupNum = 0;
        boolean permission = true;
        if (0 == otMeetingGroupPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object otMeetingGroup = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingGroupQueryWrapper, otMeetingGroupPagination.getMenuId(), "ot_meeting_group"));
            if (ObjectUtil.isEmpty((Object)otMeetingGroup)) {
                otMeetingGroupQueryWrapper.and(this.defaultWrapper());
            } else {
                otMeetingGroupQueryWrapper = (QueryWrapper)otMeetingGroup;
            }
        }
        if (otMeetingGroupPagination.getSelectParent().booleanValue()) {
            otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getParentId, (Object)"-1");
        } else {
            otMeetingGroupQueryWrapper.lambda().isNotNull(OtMeetingGroupEntity::getParentId);
        }
        if (StringUtils.isNotEmpty(otMeetingGroupPagination.getCompleteTimeList())) {
            ++otMeetingGroupNum;
            PlanMonthList = otMeetingGroupPagination.getCompleteTimeList();
            fir = Long.valueOf(PlanMonthList.get(0));
            sec = Long.valueOf(PlanMonthList.get(1));
            ((LambdaQueryWrapper)otMeetingGroupQueryWrapper.lambda().ge(OtMeetingGroupEntity::getPlanEndtime, (Object)new Date(fir))).le(OtMeetingGroupEntity::getPlanEndtime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(otMeetingGroupPagination.getPlanMonth())) {
            ++otMeetingGroupNum;
            PlanMonthList = otMeetingGroupPagination.getPlanMonth();
            fir = Long.valueOf(PlanMonthList.get(0));
            sec = Long.valueOf(PlanMonthList.get(1));
            firDate = DateUtil.daFormatDate((Long)fir);
            secDate = DateUtil.daFormatDate((Long)sec);
            otMeetingGroupQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.between(OtMeetingGroupEntity::getPlanMonth, (Object)firDate, (Object)secDate)).or(wq1 -> wq1.between(OtMeetingGroupEntity::getPlanEndtime, (Object)firDate, (Object)secDate))).or(wq2 -> ((LambdaQueryWrapper)wq2.ge(OtMeetingGroupEntity::getPlanEndtime, (Object)secDate)).le(OtMeetingGroupEntity::getPlanMonth, (Object)firDate)));
        }
        if (StringUtils.isNotEmpty(otMeetingGroupPagination.getSelectTimeList())) {
            ++otMeetingGroupNum;
            PlanMonthList = otMeetingGroupPagination.getSelectTimeList();
            fir = Long.valueOf(PlanMonthList.get(0));
            sec = Long.valueOf(PlanMonthList.get(1));
            firDate = DateUtil.daFormatDate((Long)fir);
            secDate = DateUtil.daFormatDate((Long)sec);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(BussinessMeetingEnum.DELAY_ENABLEDMARK.getType());
            arrayList.add(BussinessMeetingEnum.NORMAL_ENABLEDMARK.getType());
            arrayList.add(BussinessMeetingEnum.PLAN_ENABLEDMARK.getType());
            otMeetingGroupQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.between(OtMeetingGroupEntity::getPlanMonth, (Object)firDate, (Object)secDate)).or(wq1 -> wq1.between(OtMeetingGroupEntity::getPlanEndtime, (Object)firDate, (Object)secDate))).or(wq2 -> ((LambdaQueryWrapper)wq2.ge(OtMeetingGroupEntity::getPlanEndtime, (Object)secDate)).le(OtMeetingGroupEntity::getPlanMonth, (Object)firDate))).or(wq3 -> wq3.in(OtMeetingGroupEntity::getEnabledMark, (Collection)arrayList)));
        }
        if (StringUtils.isNotEmpty(otMeetingGroupPagination.getCreatorTimeList())) {
            ++otMeetingGroupNum;
            PlanMonthList = otMeetingGroupPagination.getCreatorTimeList();
            fir = Long.valueOf(PlanMonthList.get(0));
            sec = Long.valueOf(PlanMonthList.get(1));
            firDate = DateUtil.daFormatDate((Long)fir);
            secDate = DateUtil.daFormatDate((Long)sec);
            otMeetingGroupQueryWrapper.lambda().between(OtMeetingGroupEntity::getCreatorTime, (Object)firDate, (Object)secDate);
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getWorkItem())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().like(OtMeetingGroupEntity::getWorkItem, (Object)otMeetingGroupPagination.getWorkItem());
        }
        if (!StrUtil.isBlank((CharSequence)otMeetingGroupPagination.getCommitReportType()) && !StrUtil.equals((CharSequence)otMeetingGroupPagination.getCommitReportType(), (CharSequence)"all")) {
            ++otMeetingGroupNum;
            if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getCommitReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType())) {
                otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getReportJingying, (Object)otMeetingGroupPagination.getCommitReportType());
            } else if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getCommitReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_MONTH.getType())) {
                otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getIsMonthReport, (Object)1);
            } else {
                ((LambdaQueryWrapper)otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getIsMonthReport, (Object)0)).isNull(OtMeetingGroupEntity::getReportJingying);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)otMeetingGroupPagination.getIsMonthReport())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getIsMonthReport, (Object)otMeetingGroupPagination.getIsMonthReport());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getEnabledMark())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getEnabledMark, (Object)otMeetingGroupPagination.getEnabledMark());
        }
        if (ObjectUtil.isNotEmpty(otMeetingGroupPagination.getEnabledMarkList())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().in(OtMeetingGroupEntity::getEnabledMark, otMeetingGroupPagination.getEnabledMarkList());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getIsImportant())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getIsImportant, (Object)otMeetingGroupPagination.getIsImportant());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getWorkType())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getWorkType, (Object)otMeetingGroupPagination.getWorkType());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getResponsibleDepartment())) {
            ++otMeetingGroupNum;
            if (!StrUtil.equals((CharSequence)otMeetingGroupPagination.getResponsibleDepartment(), (CharSequence)"all")) {
                otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getResponsibleDepartment, (Object)otMeetingGroupPagination.getResponsibleDepartment());
            }
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupPagination.getUpdatedIds())) {
            ++otMeetingGroupNum;
            otMeetingGroupQueryWrapper.lambda().in(OtMeetingGroupEntity::getId, (Object[])otMeetingGroupPagination.getUpdatedIds().split(","));
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getPageType(), (CharSequence)BussinessMeetingEnum.JINGYING_PAGE.getType())) {
            ArrayList<Date> weekStartAndEnd = new ArrayList<Date>();
            ArrayList<Date> lastweekStartAndEnd = new ArrayList<Date>();
            if (ObjectUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime())) {
                weekStartAndEnd.addAll(this.getWeekStartAndEnd(DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0))));
                lastweekStartAndEnd.addAll(this.getWeekStartAndEnd(DateUtil.dateAddDays((Date)DateUtil.daFormatDate((Long)otMeetingGroupPagination.getSelectByReportTime().get(0)), (int)-7)));
            }
            AtomicBoolean isJingying = new AtomicBoolean(true);
            if (!StrUtil.isBlank((CharSequence)otMeetingGroupPagination.getSwitchType())) {
                if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getSwitchType(), (CharSequence)"1")) {
                    otMeetingGroupQueryWrapper.lambda().and(x -> x.and(l -> {
                        l.eq(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.LEADER_ARRANGEMENT_PLAN.getType());
                        l.ne(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.TERMINATION_ENABLEDMARK.getType());
                        l.ne(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.DISCONTINUE_ENABLEDMARK.getType());
                        l.ne(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.REJECT_ENABLEDMARK.getType());
                        if (ObjectUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime())) {
                            l.and(j -> {
                                j.ne(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType());
                                if (ObjectUtil.isNotEmpty(otMeetingGroupPagination.getSelectByReportTime())) {
                                    j.or(m -> ((LambdaQueryWrapper)m.eq(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())).between(OtMeetingGroupEntity::getActualEndtime, lastweekStartAndEnd.get(0), lastweekStartAndEnd.get(1)));
                                }
                            });
                        }
                    }));
                } else {
                    otMeetingGroupPagination.setReportType(BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType());
                    List<OtMeetingGroupRecordEntity> commitWorkList = this.getCommitWorkList(otMeetingGroupPagination);
                    if (CollectionUtil.isEmpty(commitWorkList)) {
                        otMeetingGroupQueryWrapper.lambda().isNull(OtMeetingGroupEntity::getId);
                        return otMeetingGroupQueryWrapper;
                    }
                    otMeetingGroupQueryWrapper.lambda().and(x -> x.and(l -> {
                        List stringList = commitWorkList.stream().map(i -> i.getWorkId()).collect(Collectors.toList());
                        l.in(OtMeetingGroupEntity::getId, stringList);
                        ((LambdaQueryWrapper)l.eq(OtMeetingGroupEntity::getReportJingying, (Object)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType())).ne(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.LEADER_ARRANGEMENT_PLAN.getType());
                    }));
                }
            }
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getPageType(), (CharSequence)BussinessMeetingEnum.MONTH_MEETING_PAGE.getType())) {
            otMeetingGroupPagination.setReportType(BussinessMeetingEnum.REPORT_TYPE_MONTH.getType());
            List<OtMeetingGroupRecordEntity> commitWorkList = this.getCommitWorkList(otMeetingGroupPagination);
            if (CollectionUtil.isEmpty(commitWorkList)) {
                otMeetingGroupQueryWrapper.lambda().isNull(OtMeetingGroupEntity::getId);
                return otMeetingGroupQueryWrapper;
            }
            List stringList = commitWorkList.stream().map(i -> i.getWorkId()).collect(Collectors.toList());
            otMeetingGroupQueryWrapper.lambda().and(wrapper -> wrapper.in(OtMeetingGroupEntity::getId, (Collection)stringList));
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getPageType(), (CharSequence)BussinessMeetingEnum.WEEKPROGRESS_PAGE.getType())) {
            otMeetingGroupQueryWrapper.lambda().ne(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.MONTH_REPORT_PLAN.getType());
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getPageType(), (CharSequence)BussinessMeetingEnum.MONTHPLAN_PAGE.getType())) {
            otMeetingGroupQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.eq(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.MONTH_PLAN.getType())).or(w -> ((LambdaQueryWrapper)w.eq(OtMeetingGroupEntity::getWorkType, (Object)BussinessMeetingEnum.LEADER_ARRANGEMENT_PLAN.getType())).ne(OtMeetingGroupEntity::getEnabledMark, (Object)BussinessMeetingEnum.COMPLETED_ENABLEDMARK.getType())));
        }
        if (AllIdList.size() > 0) {
            otMeetingGroupQueryWrapper.lambda().in(OtMeetingGroupEntity::getId, AllIdList);
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupPagination.getPageType(), (CharSequence)BussinessMeetingEnum.JINGYING_PAGE.getType())) {
            this.applyCustomSorting((QueryWrapper<OtMeetingGroupEntity>)otMeetingGroupQueryWrapper, otMeetingGroupPagination.getSwitchType());
        } else {
            this.applyCustomSorting((QueryWrapper<OtMeetingGroupEntity>)otMeetingGroupQueryWrapper, "3");
        }
        return otMeetingGroupQueryWrapper;
    }

    private Consumer<QueryWrapper<OtMeetingGroupEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<OtMeetingGroupEntity>>(){

            @Override
            public void accept(QueryWrapper<OtMeetingGroupEntity> otMeetingGroupQueryWrapper) {
                otMeetingGroupQueryWrapper.lambda().eq(OtMeetingGroupEntity::getCreatorUserId, (Object)userId);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block32: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u7236\u7ea7id", (Object)"parentId"));
                        continue block32;
                    }
                    case "dubanId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u9886\u5bfc\u7763\u529e", (Object)"dubanId"));
                        continue block32;
                    }
                    case "responsibleDepartment": {
                        entitys.add(new ExcelExportEntity("\u8d23\u4efb\u90e8\u95e8", (Object)"responsibleDepartment"));
                        continue block32;
                    }
                    case "workItem": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u4e8b\u9879", (Object)"workItem"));
                        continue block32;
                    }
                    case "planContent": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5185\u5bb9", (Object)"planContent"));
                        continue block32;
                    }
                    case "workProgress": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u8fdb\u5c55", (Object)"workProgress"));
                        continue block32;
                    }
                    case "isImportant": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u91cd\u70b9\u5de5\u4f5c", (Object)"isImportant"));
                        continue block32;
                    }
                    case "planMonth": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u65f6\u95f4", (Object)"planMonthStr"));
                        continue block32;
                    }
                    case "planEndtime": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (Object)"planEndtimeStr"));
                        continue block32;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block32;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
            e.printStackTrace();
        }
        return vo;
    }

    public List<Date> getBeginAndEndByDate(Long startTime) {
        String firDate = DateUtil.daFormatYmd((Long)startTime);
        Date startDate = DateUtil.stringToDate((String)(firDate.substring(0, 7) + "-01 00:00:00"));
        Calendar calendar = Calendar.getInstance();
        int lastDay = 30;
        calendar.setTime(startDate);
        lastDay = calendar.getActualMaximum(5);
        Date endDate = DateUtil.stringToDate((String)(firDate.substring(0, 7) + "-" + lastDay + " 23:59:59"));
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(0, startDate);
        dateList.add(1, endDate);
        return dateList;
    }

    public List<Date> getWeekStartAndEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, 2);
        Date startOfWeek = calendar.getTime();
        calendar.set(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 59);
        Date endOfWeek = calendar.getTime();
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(startOfWeek);
        dateList.add(endOfWeek);
        return dateList;
    }

    @Override
    public void updateListVoEntity(OtMeetingGroupListVO otMeetingGroupListVO, Date beginDayOfWeek, Date endDayOfWeek, List<OtMeetingGroupRecordEntity> recordEntityList) {
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list();
        List entities = departmentEntities.stream().filter(i -> StringUtils.equals((CharSequence)i.getId(), (CharSequence)otMeetingGroupListVO.getResponsibleDepartment())).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(entities)) {
            otMeetingGroupListVO.setResponsibleDepartmentName(((OtMeetingStatisticsDepartmentEntity)entities.get(0)).getFullName());
        } else {
            otMeetingGroupListVO.setResponsibleDepartmentName(otMeetingGroupListVO.getResponsibleDepartment());
        }
        String jingyingStr = recordEntityList.stream().filter(i -> StrUtil.equals((CharSequence)i.getWorkId(), (CharSequence)otMeetingGroupListVO.getId()) && StrUtil.equals((CharSequence)i.getReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_JINGYING.getType())).map(i -> i.getReportTimeVar()).distinct().collect(Collectors.joining(","));
        List monthStr = recordEntityList.stream().filter(Objects::nonNull).filter(i -> StrUtil.equals((CharSequence)i.getWorkId(), (CharSequence)otMeetingGroupListVO.getId())).filter(i -> StrUtil.equals((CharSequence)i.getReportType(), (CharSequence)BussinessMeetingEnum.REPORT_TYPE_MONTH.getType())).map(i -> i.getReportTimeVar()).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        otMeetingGroupListVO.setReportMonthTimeVar(StrUtil.isBlank((CharSequence)CollectionUtil.join(monthStr, (CharSequence)",")) ? "" : CollectionUtil.join(monthStr, (CharSequence)","));
        otMeetingGroupListVO.setReportJingyingTimeVar(StrUtil.isBlank((CharSequence)jingyingStr) ? "" : jingyingStr);
        if (otMeetingGroupListVO.getWriteDate() > beginDayOfWeek.getTime() && otMeetingGroupListVO.getWriteDate() < endDayOfWeek.getTime()) {
            otMeetingGroupListVO.setWriteDateName("1");
        } else {
            otMeetingGroupListVO.setWriteDateName("2");
        }
    }
}

