/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meeting.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionEntity;
import com.bringspring.meeting.entity.OtMeetingGroupSuggestionVoteEntity;
import com.bringspring.meeting.entity.OtMeetingStatisticsDepartmentEntity;
import com.bringspring.meeting.mapper.OtMeetingGroupSuggestionMapper;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionCrForm;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionPagination;
import com.bringspring.meeting.model.otmeetinggroupsuggestion.OtMeetingGroupSuggestionUpForm;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionService;
import com.bringspring.meeting.service.OtMeetingGroupSuggestionVoteService;
import com.bringspring.meeting.service.OtMeetingStatisticsDepartmentService;
import com.bringspring.meeting.utils.BussinessMeetingEnum;
import com.bringspring.meeting.utils.DateUtils;
import com.bringspring.meeting.utils.MeetingConstants;
import com.bringspring.meeting.utils.SendMessageUtil;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtMeetingGroupSuggestionServiceImpl
extends ServiceImpl<OtMeetingGroupSuggestionMapper, OtMeetingGroupSuggestionEntity>
implements OtMeetingGroupSuggestionService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OtMeetingStatisticsDepartmentService otMeetingStatisticsDepartmentService;
    @Autowired
    private OtMeetingGroupSuggestionVoteService otMeetingGroupSuggestionVoteService;
    @Autowired
    private UserService userService;

    @Override
    public List<OtMeetingGroupSuggestionEntity> getList(OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination) {
        Object otMeetingStatisticsDepartmentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingGroupSuggestionNum = 0;
        QueryWrapper otMeetingGroupSuggestionQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (otMeetingGroupSuggestionPagination.getIsAuth() != 1) {
            pcPermission = false;
            appPermission = false;
        }
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            otMeetingStatisticsDepartmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingGroupSuggestionQueryWrapper, otMeetingGroupSuggestionPagination.getMenuId(), "ot_meeting_group_suggestion"));
            if (ObjectUtil.isEmpty((Object)otMeetingStatisticsDepartmentObj)) {
                return new ArrayList<OtMeetingGroupSuggestionEntity>();
            }
            otMeetingGroupSuggestionQueryWrapper = (QueryWrapper)otMeetingStatisticsDepartmentObj;
            ++otMeetingGroupSuggestionNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            otMeetingStatisticsDepartmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(otMeetingGroupSuggestionQueryWrapper, otMeetingGroupSuggestionPagination.getMenuId(), "ot_meeting_group_suggestion"));
            if (ObjectUtil.isEmpty((Object)otMeetingStatisticsDepartmentObj)) {
                return new ArrayList<OtMeetingGroupSuggestionEntity>();
            }
            otMeetingGroupSuggestionQueryWrapper = (QueryWrapper)otMeetingStatisticsDepartmentObj;
            ++otMeetingGroupSuggestionNum;
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getSuggestContent())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().like(OtMeetingGroupSuggestionEntity::getSuggestContent, (Object)otMeetingGroupSuggestionPagination.getSuggestContent());
        }
        if (ObjectUtil.isNotEmpty(otMeetingGroupSuggestionPagination.getSelectTimeList())) {
            ++otMeetingGroupSuggestionNum;
            List<String> PlanMonthList = otMeetingGroupSuggestionPagination.getSelectTimeList();
            Long fir = Long.valueOf(PlanMonthList.get(0));
            Long sec = Long.valueOf(PlanMonthList.get(1));
            ((LambdaQueryWrapper)otMeetingGroupSuggestionQueryWrapper.lambda().ge(OtMeetingGroupSuggestionEntity::getSuggestMonth, (Object)DateUtil.daFormatDate((Long)fir))).le(OtMeetingGroupSuggestionEntity::getSuggestMonth, (Object)DateUtil.daFormatDate((Long)sec));
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getResponsibleDepartment())) {
            ++otMeetingGroupSuggestionNum;
            if (!StrUtil.equals((CharSequence)otMeetingGroupSuggestionPagination.getResponsibleDepartment(), (CharSequence)"all")) {
                otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getCreateDepartment, (Object)otMeetingGroupSuggestionPagination.getResponsibleDepartment());
            }
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getCompleteDate())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getCompleteDate, (Object)otMeetingGroupSuggestionPagination.getCompleteDate());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getCreateDepartment())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getCreateDepartment, (Object)otMeetingGroupSuggestionPagination.getCreateDepartment());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getIsGreat())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getIsGreat, (Object)otMeetingGroupSuggestionPagination.getIsGreat());
        }
        if (StrUtil.equals((CharSequence)otMeetingGroupSuggestionPagination.getReportType(), (CharSequence)BussinessMeetingEnum.JINGYING_PAGE.getType())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getIsDisplay, (Object)1);
        }
        if (AllIdList.size() > 0) {
            otMeetingGroupSuggestionQueryWrapper.lambda().in(OtMeetingGroupSuggestionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)otMeetingGroupSuggestionPagination.getSidx())) {
            otMeetingGroupSuggestionQueryWrapper.lambda().orderBy(true, true, OtMeetingGroupSuggestionEntity::getCreateDepartment);
        } else {
            try {
                String sidx = otMeetingGroupSuggestionPagination.getSidx();
                OtMeetingGroupSuggestionEntity otMeetingGroupSuggestionEntity = new OtMeetingGroupSuggestionEntity();
                Field declaredField = otMeetingGroupSuggestionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingGroupSuggestionQueryWrapper = "asc".equals(otMeetingGroupSuggestionPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingGroupSuggestionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingGroupSuggestionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(otMeetingGroupSuggestionPagination.getCurrentPage(), otMeetingGroupSuggestionPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupSuggestionQueryWrapper);
            return otMeetingGroupSuggestionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return otMeetingGroupSuggestionPagination.setData(list, list.size());
    }

    @Override
    public List<OtMeetingGroupSuggestionEntity> getTypeList(OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int otMeetingGroupSuggestionNum = 0;
        QueryWrapper otMeetingGroupSuggestionQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getSuggestContent())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().like(OtMeetingGroupSuggestionEntity::getSuggestContent, (Object)otMeetingGroupSuggestionPagination.getSuggestContent());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getResponsibleDepartment())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().like(OtMeetingGroupSuggestionEntity::getResponsibleDepartment, (Object)otMeetingGroupSuggestionPagination.getResponsibleDepartment());
        }
        if (StringUtils.isNotEmpty((String)otMeetingGroupSuggestionPagination.getCompleteDate())) {
            ++otMeetingGroupSuggestionNum;
            otMeetingGroupSuggestionQueryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getCompleteDate, (Object)otMeetingGroupSuggestionPagination.getCompleteDate());
        }
        if (AllIdList.size() > 0) {
            otMeetingGroupSuggestionQueryWrapper.lambda().in(OtMeetingGroupSuggestionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)otMeetingGroupSuggestionPagination.getSidx())) {
            otMeetingGroupSuggestionQueryWrapper.lambda().orderByDesc(OtMeetingGroupSuggestionEntity::getId);
        } else {
            try {
                String sidx = otMeetingGroupSuggestionPagination.getSidx();
                OtMeetingGroupSuggestionEntity otMeetingGroupSuggestionEntity = new OtMeetingGroupSuggestionEntity();
                Field declaredField = otMeetingGroupSuggestionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                otMeetingGroupSuggestionQueryWrapper = "asc".equals(otMeetingGroupSuggestionPagination.getSort().toLowerCase()) ? (QueryWrapper)otMeetingGroupSuggestionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)otMeetingGroupSuggestionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(otMeetingGroupSuggestionPagination.getCurrentPage(), otMeetingGroupSuggestionPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)otMeetingGroupSuggestionQueryWrapper);
                return otMeetingGroupSuggestionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return otMeetingGroupSuggestionPagination.setData(list, list.size());
        }
        return this.list((Wrapper)otMeetingGroupSuggestionQueryWrapper);
    }

    @Override
    public OtMeetingGroupSuggestionEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OtMeetingGroupSuggestionEntity::getId, (Object)id);
        return (OtMeetingGroupSuggestionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OtMeetingGroupSuggestionCrForm otMeetingGroupSuggestionCrForm) {
        String mainId = RandomUtil.uuId();
        OtMeetingGroupSuggestionEntity entity = (OtMeetingGroupSuggestionEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupSuggestionCrForm, OtMeetingGroupSuggestionEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void batchCreate(HashMap map) {
        List crMeetingGroup;
        Object data = map.get("dataList");
        List meetingGroupEntities = JsonUtil.getJsonToList(data, OtMeetingGroupSuggestionUpForm.class);
        List otMeetingGroupCrForms = meetingGroupEntities.stream().filter(i -> StrUtil.isBlank((CharSequence)i.getId())).collect(Collectors.toList());
        List OtMeetingGroupSuggestionUpForms = meetingGroupEntities.stream().filter(i -> !StrUtil.isBlank((CharSequence)i.getId())).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(otMeetingGroupCrForms)) {
            crMeetingGroup = JsonUtil.getJsonToList(otMeetingGroupCrForms, OtMeetingGroupSuggestionEntity.class);
            for (OtMeetingGroupSuggestionEntity groupEntity : crMeetingGroup) {
                groupEntity.setId(RandomUtil.uuId());
                groupEntity.setSuggestMonth(DateUtil.getNowDate());
                groupEntity.setCompanyId(this.userProvider.get().getOrganizeId());
                groupEntity.setDeleteMark("0");
                groupEntity.setSuggestWeek(DateUtil.getBeginDayOfWeek());
                groupEntity.setVoteCount(0);
            }
            this.saveBatch(crMeetingGroup);
        }
        if (ObjectUtil.isNotEmpty(OtMeetingGroupSuggestionUpForms)) {
            crMeetingGroup = JsonUtil.getJsonToList(OtMeetingGroupSuggestionUpForms, OtMeetingGroupSuggestionEntity.class);
            this.updateBatchById(crMeetingGroup);
        }
    }

    @Override
    @DSTransactional
    public void update(String id, OtMeetingGroupSuggestionUpForm otMeetingGroupSuggestionUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingGroupSuggestionEntity entity = this.getInfo(id);
        if (entity != null) {
            OtMeetingGroupSuggestionEntity subentity = (OtMeetingGroupSuggestionEntity)JsonUtil.getJsonToBean((Object)otMeetingGroupSuggestionUpForm, OtMeetingGroupSuggestionEntity.class);
            subentity.setSuggestContent(DateUtil.getNow());
            subentity.setResponsibleDepartment(DateUtil.getNow());
            subentity.setIsGreat(DateUtil.getNow());
            this.updateById(subentity);
        }
    }

    @Override
    public String countNotSubmittedDepartment(OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isNotEmpty(otMeetingGroupSuggestionPagination.getSelectTimeListCount())) {
            Date dateAddDays = DateUtil.dateAddDays((Date)DateUtil.daFormatDate((Long)Long.valueOf(otMeetingGroupSuggestionPagination.getSelectTimeListCount().get(0))), (int)-7);
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(String.valueOf(dateAddDays.getTime()));
            stringList.add(otMeetingGroupSuggestionPagination.getSelectTimeListCount().get(1));
            otMeetingGroupSuggestionPagination.getSelectTimeList().clear();
            otMeetingGroupSuggestionPagination.setSelectTimeList(stringList);
        }
        List<OtMeetingGroupSuggestionEntity> list = this.getList(otMeetingGroupSuggestionPagination);
        List depList = list.stream().map(i -> i.getCreateDepartment()).distinct().collect(Collectors.toList());
        List<OtMeetingStatisticsDepartmentEntity> departmentEntities = this.getDepListByCompanyId(userInfo.getOrganizeId());
        String depNameList = departmentEntities.stream().filter(i -> !depList.contains(i.getId())).map(j -> j.getFullName()).collect(Collectors.joining(","));
        if (StrUtil.isBlank((CharSequence)depNameList)) {
            return "\u65e0";
        }
        return depNameList;
    }

    @Override
    public String countNotVoteDepartment(OtMeetingGroupSuggestionPagination otMeetingGroupSuggestionPagination) {
        if (ObjectUtil.isEmpty(otMeetingGroupSuggestionPagination.getSelectTimeList())) {
            return null;
        }
        Date lastWeekBegin = DateUtil.daFormatDate((Long)Long.valueOf(otMeetingGroupSuggestionPagination.getSelectTimeList().get(0)));
        return null;
    }

    @Override
    public List<OtMeetingGroupSuggestionVoteEntity> getSuggestVoteList(String suggestId) {
        if (StrUtil.isNotBlank((CharSequence)suggestId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(OtMeetingGroupSuggestionVoteEntity::getSuggestionId, (Object)suggestId);
            List voteEntities = this.otMeetingGroupSuggestionVoteService.list((Wrapper)queryWrapper);
            return voteEntities;
        }
        return new ArrayList<OtMeetingGroupSuggestionVoteEntity>();
    }

    @Override
    @DSTransactional
    public void delete(OtMeetingGroupSuggestionEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void scheduledRemindNoVoteDepartment() {
        int adjustedDayOfWeek;
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        int n = adjustedDayOfWeek = dayOfWeek == 1 ? 7 : dayOfWeek - 1;
        if (adjustedDayOfWeek != 1) {
            return;
        }
        Date beginDayOfWeek = DateUtil.getBeginDayOfWeek();
        Date endDayOfWeek = DateUtil.getEndDayOfWeek();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupSuggestionVoteEntity::getVoteType, (Object)BussinessMeetingEnum.VOTE_APPROVE.getType())).between(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)beginDayOfWeek, (Object)endDayOfWeek);
        List voteEntities = this.otMeetingGroupSuggestionVoteService.list((Wrapper)queryWrapper);
        List depList = voteEntities.stream().distinct().map(i -> i.getDepartmentId()).collect(Collectors.toList());
        List<OtMeetingStatisticsDepartmentEntity> listByCompanyId = this.getDepListByCompanyId("2");
        List departmentEntities = listByCompanyId.stream().filter(i -> !depList.contains(i.getId())).map(i -> i.getId()).collect(Collectors.toList());
        ArrayList userDepList = new ArrayList();
        for (String departmentEntity : departmentEntities) {
            List userEntityList = this.userService.getListByOrganizeId(departmentEntity, "");
            userEntityList.stream().forEach(i -> userDepList.add(i.getId()));
        }
        ArrayList userRoleList = new ArrayList();
        List userListByRoleId = this.userService.getUserListByRoleId(MeetingConstants.WRITE_DEPARTMENT_ROLE_ID);
        userListByRoleId.stream().forEach(i -> userRoleList.add(i.getId()));
        List<String> noVoteUserList = userDepList.stream().filter(userRoleList::contains).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(noVoteUserList)) {
            String title = "\u6e29\u99a8\u63d0\u793a\uff1a\u8bf7\u53ca\u65f6\u5b8c\u6210\u672c\u5468\u610f\u89c1\u5efa\u8bae\u6295\u7968";
            String content = "\u5404\u4f4d\u9886\u5bfc\uff1a\n        \u672c\u5468\u610f\u89c1\u5efa\u8bae\u6295\u7968\u901a\u9053\u5df2\u5f00\u653e\uff0c\u5c06\u4e8e\u4eca\u65e513:00\u5173\u95ed\uff0c\u7279\u6b64\u63d0\u793a\uff1a\n        \u8bf7\u53ca\u65f6\u8fdb\u5165\u3010\u610f\u89c1\u5efa\u8bae\u6295\u7968\u3011\u4e13\u680f\uff08\u5e94\u7528\u4e2d\u5fc3-\u610f\u89c1\u5efa\u8bae-\u6295\u7968\uff09\u5b8c\u6210\u6295\u7968\uff0c\u6295\u7968\u7ed3\u679c\u5c06\u5f71\u54cd\u672c\u5468\u4f18\u79c0\u5efa\u8bae\u8bc4\u9009\uff0c\u611f\u8c22\u60a8\u4e3a\u56e2\u961f\u5efa\u8bbe\u8d21\u732e\u667a\u6167\u3002";
            try {
                SendMessageUtil.newSendMessage("\u65b0\u7248\u96c6\u56e2\u4f8b\u4f1a\u6d88\u606f\u63d0\u9192", MeetingConstants.NEW_MEETING_GROUP, title, content, MeetingConstants.APP_NEWMEETING_SUGGESTION, MeetingConstants.PC_NEWMEETING_SUGGESTION, noVoteUserList, TermTypeEnum.TERM_APP_PC.getCode(), "");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<OtMeetingStatisticsDepartmentEntity> getDepListByCompanyId(String companyId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.equals((CharSequence)companyId, (CharSequence)"2")) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingStatisticsDepartmentEntity::getCompanyid, (Object)companyId)).or()).eq(OtMeetingStatisticsDepartmentEntity::getCompanyid, (Object)"766");
        } else {
            queryWrapper.lambda().eq(OtMeetingStatisticsDepartmentEntity::getCompanyid, (Object)companyId);
        }
        List departmentEntities = this.otMeetingStatisticsDepartmentService.list((Wrapper)queryWrapper);
        return departmentEntities;
    }

    @Override
    public List<String> getNotVoteDepartmentByDate(Date beginWeek) {
        Date dateAddDays = DateUtil.dateAddDays((Date)beginWeek, (int)7);
        HashMap<String, Date> weekStartAndEnd = DateUtils.getWeekStartAndEnd(dateAddDays);
        Date startOfWeek = weekStartAndEnd.get("startOfWeek");
        Date endOfWeek = weekStartAndEnd.get("endOfWeek");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OtMeetingGroupSuggestionVoteEntity::getVoteType, (Object)BussinessMeetingEnum.VOTE_APPROVE.getType())).between(OtMeetingGroupSuggestionVoteEntity::getVoteTime, (Object)startOfWeek, (Object)endOfWeek);
        List voteEntities = this.otMeetingGroupSuggestionVoteService.list((Wrapper)queryWrapper);
        List depList = voteEntities.stream().distinct().map(i -> i.getDepartmentId()).collect(Collectors.toList());
        List<OtMeetingStatisticsDepartmentEntity> listByCompanyId = this.getDepListByCompanyId(this.userProvider.get().getOrganizeId());
        List<String> departmentEntities = listByCompanyId.stream().filter(i -> !depList.contains(i.getId())).map(i -> i.getFullName()).collect(Collectors.toList());
        return departmentEntities;
    }
}

